/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.memory;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.List;
import javax.management.NotificationEmitter;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.memory.IMemoryManageable;
import net.lecousin.framework.mutable.MutableLong;
import net.lecousin.framework.text.StringUtil;

public class MemoryManager {
    private static Logger logger;
    private static long[] lastGC;
    private static long[] lastGCUsedMemory;
    private static long[] lastGCAllocatedMemory;
    private static GarbageCollectorMXBean[] lastGCCollector;
    private static long gcForced;
    private static ArrayList<IMemoryManageable> managed;

    private MemoryManager() {
    }

    public static void init() {
        logger = LCCore.get().getMemoryLogger();
        if (logger.debug()) {
            MemoryManager.logMemory(Logger.Level.DEBUG);
        }
        Task cleanExpiredData = Task.cpu("Free memory for expired cached data", Task.Priority.BACKGROUND, t -> {
            if (logger.debug()) {
                logger.debug("Free expired cached data");
            }
            MemoryManager.freeMemory(IMemoryManageable.FreeMemoryLevel.EXPIRED_ONLY);
            if (logger.debug()) {
                MemoryManager.logManageableContent();
            }
            return null;
        });
        cleanExpiredData.executeEvery(300000L, 900000L);
        cleanExpiredData.start();
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            logger.debug("Garbage collector: " + gc.getName());
            MutableLong lastHeavyGCAlert = new MutableLong(0L);
            ((NotificationEmitter)((Object)gc)).addNotificationListener((notification, handback) -> {
                GarbageCollectorMXBean gcBean;
                long now = System.currentTimeMillis();
                if (now - gcForced < 100L) {
                    return;
                }
                if (now - lastGC[4] < 60000L && now - lastHeavyGCAlert.get() > 30000L) {
                    logger.debug("5 garbage collections in less than 1 minute");
                    lastHeavyGCAlert.set(now);
                }
                System.arraycopy(lastGC, 0, lastGC, 1, 9);
                System.arraycopy(lastGCAllocatedMemory, 0, lastGCAllocatedMemory, 1, 9);
                System.arraycopy(lastGCUsedMemory, 0, lastGCUsedMemory, 1, 9);
                System.arraycopy(lastGCCollector, 0, lastGCCollector, 1, 9);
                MemoryManager.lastGC[0] = now;
                MemoryManager.lastGCAllocatedMemory[0] = Runtime.getRuntime().totalMemory();
                MemoryManager.lastGCUsedMemory[0] = lastGCAllocatedMemory[0] - Runtime.getRuntime().freeMemory();
                MemoryManager.lastGCCollector[0] = gcBean = (GarbageCollectorMXBean)handback;
            }, null, gc);
        }
        Task checkMemory = Task.cpu("Check memory", Task.Priority.BACKGROUND, t -> MemoryManager.checkMemory());
        checkMemory.executeEvery(60000L, 120000L);
        checkMemory.start();
        MemoryManager.monitorThresholds();
    }

    private static void monitorThresholds() {
        long max;
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        ((NotificationEmitter)((Object)memoryBean)).addNotificationListener((notification, handback) -> {
            if (!notification.getType().equals("java.management.memory.collection.threshold.exceeded")) {
                return;
            }
            if (logger.info()) {
                logger.info("Memory threshold reached, try to free all possible cached data to free memory");
            }
            MemoryManager.freeMemory(IMemoryManageable.FreeMemoryLevel.URGENT);
        }, null, null);
        boolean oldGenFound = false;
        int nbHeap = 0;
        for (MemoryPoolMXBean m : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!m.getType().equals((Object)MemoryType.HEAP)) continue;
            ++nbHeap;
            if (!m.getName().contains("Tenured Gen") && !m.getName().contains("Old Gen")) continue;
            max = m.getUsage().getMax();
            if (logger.info()) {
                logger.info("Monitoring memory usage: maximum = " + StringUtil.size(max));
            }
            m.setCollectionUsageThreshold(max - max / 10L);
            oldGenFound = true;
        }
        if (!oldGenFound) {
            if (nbHeap == 1) {
                for (MemoryPoolMXBean m : ManagementFactory.getMemoryPoolMXBeans()) {
                    if (!m.getType().equals((Object)MemoryType.HEAP)) continue;
                    max = m.getUsage().getMax();
                    if (logger.info()) {
                        logger.info("Monitoring memory usage: maximum = " + StringUtil.size(max));
                    }
                    m.setCollectionUsageThreshold(max - max / 10L);
                }
            } else if (logger.warn()) {
                logger.warn("Unable to monitor memory usage threshold");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(IMemoryManageable manageable) {
        ArrayList<IMemoryManageable> arrayList = managed;
        synchronized (arrayList) {
            managed.add(manageable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(IMemoryManageable manageable) {
        ArrayList<IMemoryManageable> arrayList = managed;
        synchronized (arrayList) {
            managed.remove(manageable);
        }
    }

    private static Void checkMemory() {
        if (logger.debug()) {
            MemoryManager.logManageableContent();
        }
        if (System.currentTimeMillis() - lastGC[0] > 120000L) {
            MemoryManager.freeMemoryBasedOnLastGarbageTime();
            if (System.currentTimeMillis() - lastGC[0] > 1500000L) {
                long free;
                long total = Runtime.getRuntime().totalMemory();
                long allocate = total / 50L;
                if (allocate > (free = Runtime.getRuntime().freeMemory()) / 10L) {
                    allocate = free / 10L;
                }
                if (allocate > 0x100000L) {
                    allocate = 0x100000L;
                }
                if (logger.debug() && allocate > 0L) {
                    logger.debug("No garbage collection since 25 minutes => make some garbage to induce a collection sooner = " + StringUtil.size(allocate));
                }
                while (allocate > 0L) {
                    int len = allocate > 4096L ? 4096 : (int)allocate;
                    byte[] tmp = new byte[len];
                    tmp[0] = 51;
                    allocate -= (long)len;
                }
            }
            if (logger.debug()) {
                MemoryManager.logMemory(Logger.Level.DEBUG);
            }
        }
        return null;
    }

    private static void freeMemoryBasedOnLastGarbageTime() {
        if ((System.currentTimeMillis() - lastGC[0]) / 60000L % 5L == 0L) {
            if (System.currentTimeMillis() - lastGC[4] > 1200000L) {
                if (logger.debug()) {
                    logger.debug("Less than 5 garbage collections since more than 20 minutes => free a maximum of memory to try to shrink the memory used by the JVM");
                }
                MemoryManager.freeMemory(IMemoryManageable.FreeMemoryLevel.URGENT);
            } else {
                if (logger.debug()) {
                    logger.debug("No garbage collection since 5 minutes => free most of cached data memory to try to shrink the memory used by the JVM");
                }
                MemoryManager.freeMemory(IMemoryManageable.FreeMemoryLevel.MEDIUM);
            }
        } else {
            if (logger.debug()) {
                logger.debug("No garbage collection since 2 minutes => free some cached data to try to shrink the memory used by the JVM");
            }
            MemoryManager.freeMemory(IMemoryManageable.FreeMemoryLevel.LOW);
        }
    }

    public static void logMemory(long interval, Logger.Level level) {
        Task task = Task.cpu("Logging memory", Task.Priority.BACKGROUND, t -> {
            MemoryManager.logMemory(level);
            return null;
        });
        task.executeEvery(interval, interval);
        task.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logManageableContent() {
        ArrayList<IMemoryManageable> arrayList = managed;
        synchronized (arrayList) {
            logger.debug("Memory managed:");
            for (IMemoryManageable m : managed) {
                logger.debug(" - " + m.getDescription());
                List<String> list = m.getItemsDescription();
                if (list == null) continue;
                for (String s : list) {
                    logger.debug("    - " + s);
                }
            }
        }
    }

    public static void logMemory(Logger.Level level) {
        StringBuilder s = new StringBuilder(2048);
        MemoryManager.logMemory(s);
        logger.log(level, s.toString());
    }

    public static void logMemory(StringBuilder s) {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long used = total - free;
        s.append("Memory usage: ").append(StringUtil.size(used)).append('/').append(StringUtil.size(total)).append(" (").append(StringUtil.size(free)).append(" free), max=").append(StringUtil.size(Runtime.getRuntime().maxMemory())).append('\n');
        for (MemoryPoolMXBean m : ManagementFactory.getMemoryPoolMXBeans()) {
            s.append(" - Pool: ").append(m.getName()).append(" (").append(m.getType().name()).append("): used=").append(StringUtil.size(m.getUsage().getUsed())).append(", allocated=").append(StringUtil.size(m.getUsage().getCommitted())).append('/').append(StringUtil.size(m.getUsage().getMax())).append(", init=").append(StringUtil.size(m.getUsage().getInit())).append('\n');
        }
        s.append("Last 10 garbage collections:\n");
        for (int i = 0; i < 10 && lastGC[i] != 0L; ++i) {
            s.append(" - ").append(System.currentTimeMillis() - lastGC[i]).append("ms ago = ").append(StringUtil.size(lastGCUsedMemory[i])).append(" / ").append(StringUtil.size(lastGCAllocatedMemory[i])).append(" [").append(lastGCCollector[i].getName()).append(':');
            String[] pools = lastGCCollector[i].getMemoryPoolNames();
            for (int j = 0; j < pools.length; ++j) {
                if (j > 0) {
                    s.append(',');
                }
                s.append(pools[j]);
            }
            s.append("]\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeMemory(IMemoryManageable.FreeMemoryLevel level) {
        ArrayList<IMemoryManageable> list;
        ArrayList<IMemoryManageable> arrayList = managed;
        synchronized (arrayList) {
            list = new ArrayList<IMemoryManageable>(managed);
        }
        for (IMemoryManageable m : list) {
            if (logger.debug()) {
                logger.debug("Free memory level " + level.name() + " on " + m.getDescription());
            }
            try {
                m.freeMemory(level);
            }
            catch (Exception t) {
                logger.error("Error freeing memory from " + m.getDescription(), t);
            }
        }
    }

    static {
        lastGC = new long[10];
        lastGCUsedMemory = new long[10];
        lastGCAllocatedMemory = new long[10];
        lastGCCollector = new GarbageCollectorMXBean[10];
        gcForced = 0L;
        managed = new ArrayList();
    }
}

