/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.lecousin.framework.text.ArrayString;
import net.lecousin.framework.text.IString;

public abstract class ArrayStringBuffer<T extends ArrayString, ME extends ArrayStringBuffer<T, ME>>
implements IString {
    protected T[] strings;
    protected int lastUsed;
    protected int newArrayStringCapacity = 64;

    public ArrayStringBuffer() {
        this.strings = null;
        this.lastUsed = 0;
    }

    public ArrayStringBuffer(T string) {
        this.strings = this.allocateArray(8);
        this.strings[0] = string;
        this.lastUsed = 0;
    }

    public ArrayStringBuffer(Collection<T> strings) {
        this.strings = this.allocateArray(strings.size() + 8);
        int i = 0;
        for (ArrayString s : strings) {
            this.strings[i++] = s;
        }
        this.lastUsed = i - 1;
    }

    public void setNewArrayStringCapacity(int capacity) {
        this.newArrayStringCapacity = capacity;
    }

    protected abstract T[] allocateArray(int var1);

    protected abstract T createString(int var1);

    protected abstract T createString(CharSequence var1);

    protected abstract T createString(CharSequence var1, int var2, int var3);

    protected abstract T createString(char var1);

    protected abstract T createString(char[] var1);

    protected abstract ME createBuffer();

    protected abstract ME createBuffer(T var1);

    protected abstract ME createBuffer(List<T> var1);

    protected abstract Class<T> getArrayType();

    public void reset() {
        this.strings = null;
        this.lastUsed = 0;
    }

    @Override
    public int length() {
        if (this.strings == null) {
            return 0;
        }
        int len = 0;
        for (int i = this.lastUsed; i >= 0; --i) {
            len += ((ArrayString)this.strings[i]).length();
        }
        return len;
    }

    @Override
    public boolean isEmpty() {
        if (this.strings == null) {
            return true;
        }
        for (int i = this.lastUsed; i >= 0; --i) {
            if (((ArrayString)this.strings[i]).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public char charAt(int index) {
        if (this.strings == null) {
            return '\u0000';
        }
        for (int i = 0; i <= this.lastUsed; ++i) {
            int l = ((ArrayString)this.strings[i]).length();
            if (index < l) {
                return this.strings[i].charAt(index);
            }
            index -= l;
        }
        return '\u0000';
    }

    @Override
    public void setCharAt(int index, char c) {
        if (this.strings == null) {
            throw new IllegalArgumentException("String is empty");
        }
        for (int i = 0; i <= this.lastUsed; ++i) {
            int l = ((ArrayString)this.strings[i]).length();
            if (index < l) {
                this.strings[i].setCharAt(index, c);
                return;
            }
            index -= l;
        }
        throw new IllegalArgumentException("String is smaller than the given index");
    }

    public ME append(char c) {
        if (this.strings == null) {
            this.strings = this.allocateArray(8);
            this.strings[0] = this.createString(this.newArrayStringCapacity);
            this.strings[0].append(c);
            this.lastUsed = 0;
            return (ME)this;
        }
        if (((ArrayString)this.strings[this.lastUsed]).appendNoEnlarge(c)) {
            return (ME)this;
        }
        if (this.lastUsed < this.strings.length - 1) {
            this.strings[++this.lastUsed] = this.createString(this.newArrayStringCapacity);
            this.strings[this.lastUsed].append(c);
            return (ME)this;
        }
        ArrayString[] a = this.allocateArray(++this.lastUsed + 8);
        System.arraycopy(this.strings, 0, a, 0, this.lastUsed);
        a[this.lastUsed] = this.createString(this.newArrayStringCapacity);
        a[this.lastUsed].append(c);
        this.strings = a;
        return (ME)this;
    }

    public ME append(char[] chars, int offset, int len) {
        if (this.strings == null) {
            this.strings = this.allocateArray(8);
            this.strings[0] = this.createString(len + this.newArrayStringCapacity);
            this.strings[0].append(chars, offset, len);
            this.lastUsed = 0;
            return (ME)this;
        }
        int l = ((ArrayString)this.strings[this.lastUsed]).canAppendWithoutEnlarging();
        if (l > 0) {
            if (l > len) {
                l = len;
            }
            this.strings[this.lastUsed].append(chars, offset, l);
            if ((len -= l) == 0) {
                return (ME)this;
            }
            offset += l;
        }
        if (this.lastUsed < this.strings.length - 1) {
            this.strings[++this.lastUsed] = this.createString(len + this.newArrayStringCapacity);
            this.strings[this.lastUsed].append(chars, offset, len);
            return (ME)this;
        }
        ArrayString[] a = this.allocateArray(this.lastUsed + 1 + 8);
        System.arraycopy(this.strings, 0, a, 0, this.lastUsed + 1);
        a[++this.lastUsed] = this.createString(len + this.newArrayStringCapacity);
        a[this.lastUsed].append(chars, offset, len);
        this.strings = a;
        return (ME)this;
    }

    public ME append(CharSequence s) {
        ArrayString us;
        if (s == null) {
            s = "null";
        }
        if (s instanceof ArrayStringBuffer && ((ArrayStringBuffer)s).getArrayType().equals(this.getArrayType())) {
            ArrayStringBuffer us2 = (ArrayStringBuffer)s;
            if (us2.strings == null) {
                return (ME)this;
            }
            if (this.strings == null) {
                this.strings = this.allocateArray(us2.strings.length);
                System.arraycopy(us2.strings, 0, this.strings, 0, this.strings.length);
                this.lastUsed = us2.lastUsed;
                return (ME)this;
            }
            int i = 0;
            while (this.lastUsed < this.strings.length - 1 && i <= us2.lastUsed) {
                this.strings[++this.lastUsed] = us2.strings[i++];
            }
            if (i > us2.lastUsed) {
                return (ME)this;
            }
            ArrayString[] a = this.allocateArray(this.strings.length + (us2.lastUsed - i + 1) + 8);
            System.arraycopy(this.strings, 0, a, 0, this.strings.length);
            System.arraycopy(us2.strings, i, a, this.strings.length, us2.lastUsed - i + 1);
            this.lastUsed = this.strings.length + (us2.lastUsed - i + 1) - 1;
            this.strings = a;
            return (ME)this;
        }
        if (!s.getClass().equals(this.getArrayType())) {
            int remaining;
            int len = s.length();
            if (this.strings != null && len <= (remaining = ((ArrayString)this.strings[this.lastUsed]).canAppendWithoutEnlarging())) {
                this.strings[this.lastUsed].append(s);
                return (ME)this;
            }
            if (len < this.newArrayStringCapacity) {
                us = this.createString(this.newArrayStringCapacity);
                us.append(s);
            } else {
                us = this.createString(s);
            }
        } else {
            us = (ArrayString)s;
        }
        if (this.strings == null) {
            this.strings = this.allocateArray(8);
            this.strings[0] = us;
            this.lastUsed = 0;
            return (ME)this;
        }
        if (this.lastUsed < this.strings.length - 1) {
            this.strings[++this.lastUsed] = us;
            return (ME)this;
        }
        ArrayString[] a = this.allocateArray(this.strings.length + 8);
        System.arraycopy(this.strings, 0, a, 0, this.strings.length);
        a[this.strings.length] = us;
        ++this.lastUsed;
        this.strings = a;
        return (ME)this;
    }

    public ME append(CharSequence s, int startPos, int endPos) {
        if (s == null) {
            return (ME)this.append("null");
        }
        if (s instanceof IString) {
            return (ME)this.append(((IString)s).substring(startPos, endPos));
        }
        return (ME)this.append((CharSequence)this.createString(s, startPos, endPos));
    }

    public ME addFirst(CharSequence s) {
        return this.addFirst(this.createString(s));
    }

    public ME addFirst(T s) {
        if (this.strings == null) {
            this.strings = this.allocateArray(8);
            this.strings[0] = s;
            this.lastUsed = 0;
            return (ME)this;
        }
        if (this.lastUsed < this.strings.length - 1) {
            System.arraycopy(this.strings, 0, this.strings, 1, this.lastUsed + 1);
            this.strings[0] = s;
            ++this.lastUsed;
            return (ME)this;
        }
        ArrayString[] ns = this.allocateArray(this.lastUsed + 8);
        System.arraycopy(this.strings, 0, ns, 1, this.lastUsed + 1);
        ns[0] = s;
        this.strings = ns;
        ++this.lastUsed;
        return (ME)this;
    }

    public ME addFirst(char c) {
        return this.addFirst((T)this.createString(this.newArrayStringCapacity).append(c));
    }

    @Override
    public int indexOf(char c, int start) {
        if (this.strings == null) {
            return -1;
        }
        int pos = 0;
        for (int i = 0; i <= this.lastUsed; ++i) {
            int l = ((ArrayString)this.strings[i]).length();
            if (pos + l <= start) {
                pos += l;
                continue;
            }
            int j = pos < start ? this.strings[i].indexOf(c, start - pos) : this.strings[i].indexOf(c);
            if (j >= 0) {
                return j + pos;
            }
            pos += l;
        }
        return -1;
    }

    @Override
    public int indexOf(CharSequence s, int start) {
        int sl = s.length();
        if (sl == 0 || this.strings == null) {
            return -1;
        }
        char first = s.charAt(0);
        int pos = 0;
        for (int i = 0; i <= this.lastUsed; ++i) {
            int j;
            int l = ((ArrayString)this.strings[i]).length();
            if (pos + l <= start) {
                pos += l;
                continue;
            }
            int n = j = pos < start ? start - pos : 0;
            while (j < l) {
                if (this.strings[i].charAt(j) == first) {
                    int k;
                    int jj = j;
                    int ii = i;
                    int ll = l;
                    for (k = 1; k < sl; ++k) {
                        if (++jj == ll) {
                            if (++ii == this.lastUsed + 1) {
                                return -1;
                            }
                            jj = 0;
                            ll = ((ArrayString)this.strings[ii]).length();
                        }
                        if (this.strings[ii].charAt(jj) != s.charAt(k)) break;
                    }
                    if (k == sl) {
                        return pos + j;
                    }
                }
                ++j;
            }
            pos += l;
        }
        return -1;
    }

    @Override
    public StringBuilder subSequence(int start, int end) {
        StringBuilder s = new StringBuilder();
        if (this.strings == null) {
            return s;
        }
        int pos = 0;
        for (int i = 0; i <= this.lastUsed; ++i) {
            int l = ((ArrayString)this.strings[i]).length();
            if (start < pos + l) {
                int j = end - pos;
                if (j > l) {
                    j = l;
                }
                s.append(this.strings[i].subSequence(start - pos, j));
                start = pos + j;
                if (start >= end) break;
            }
            pos += l;
        }
        return s;
    }

    public ME substring(int start) {
        if (this.strings == null) {
            return (ME)this;
        }
        int pos = 0;
        LinkedList<ArrayString> list = new LinkedList<ArrayString>();
        for (int i = 0; i <= this.lastUsed; ++i) {
            int l = ((ArrayString)this.strings[i]).length();
            if (start < pos + l) {
                list.add((ArrayString)this.strings[i].substring(start - pos, l));
                start = pos + l;
            }
            pos += l;
        }
        return this.createBuffer((List<T>)list);
    }

    public ME substring(int start, int end) {
        if (this.strings == null) {
            return (ME)this;
        }
        int pos = 0;
        LinkedList<ArrayString> list = new LinkedList<ArrayString>();
        for (int i = 0; i <= this.lastUsed; ++i) {
            int l = ((ArrayString)this.strings[i]).length();
            if (start < pos + l) {
                int j = end - pos;
                if (j > l) {
                    j = l;
                }
                list.add((ArrayString)this.strings[i].substring(start - pos, j));
                start = pos + j;
                if (start >= end) break;
            }
            pos += l;
        }
        return this.createBuffer((List<T>)list);
    }

    public boolean equals(ME s) {
        if (this.length() != ((ArrayStringBuffer)s).length()) {
            return false;
        }
        if (this.strings == null) {
            return true;
        }
        int s1 = 0;
        int s2 = 0;
        int i1 = 0;
        int i2 = 0;
        int l1 = ((ArrayString)this.strings[0]).length();
        int l2 = ((ArrayString)((ArrayStringBuffer)s).strings[0]).length();
        while (true) {
            if (i1 == l1) {
                if (++s1 > this.lastUsed) {
                    return true;
                }
                i1 = 0;
                l1 = ((ArrayString)this.strings[s1]).length();
                continue;
            }
            while (i2 == l2) {
                i2 = 0;
                l2 = ((ArrayString)((ArrayStringBuffer)s).strings[++s2]).length();
            }
            if (this.strings[s1].charAt(i1++) != ((ArrayStringBuffer)s).strings[s2].charAt(i2++)) break;
        }
        return false;
    }

    @Override
    public int fill(char[] chars, int start) {
        if (this.strings == null) {
            return 0;
        }
        int pos = 0;
        for (int i = 0; i <= this.lastUsed; ++i) {
            pos += this.strings[i].fill(chars, start + pos);
        }
        return pos;
    }

    @Override
    public int fillIso8859Bytes(byte[] bytes, int start) {
        if (this.strings == null) {
            return 0;
        }
        int pos = 0;
        for (int i = 0; i <= this.lastUsed; ++i) {
            pos += this.strings[i].fillIso8859Bytes(bytes, start + pos);
        }
        return pos;
    }

    public ME trimBeginning() {
        if (this.strings != null) {
            ((ArrayString)this.strings[0]).trimBeginning();
        }
        return (ME)this;
    }

    public ME trimEnd() {
        if (this.strings != null) {
            ((ArrayString)this.strings[this.lastUsed]).trimEnd();
        }
        return (ME)this;
    }

    public ME removeStartChars(int nb) {
        while (this.strings != null) {
            int l = ((ArrayString)this.strings[0]).length();
            if (nb < l) {
                ((ArrayString)this.strings[0]).removeStartChars(nb);
                return (ME)this;
            }
            if (this.lastUsed == 0) {
                this.strings = null;
                return (ME)this;
            }
            System.arraycopy(this.strings, 1, this.strings, 0, this.lastUsed);
            this.strings[this.lastUsed] = null;
            --this.lastUsed;
            nb -= l;
        }
        return (ME)this;
    }

    public ME removeEndChars(int nb) {
        while (this.strings != null) {
            int l = ((ArrayString)this.strings[this.lastUsed]).length();
            if (nb < l) {
                ((ArrayString)this.strings[this.lastUsed]).removeEndChars(nb);
                return (ME)this;
            }
            if (this.lastUsed == 0) {
                this.strings = null;
                return (ME)this;
            }
            this.strings[this.lastUsed] = null;
            --this.lastUsed;
            nb -= l;
        }
        return (ME)this;
    }

    public LinkedList<ME> split(char sep) {
        LinkedList<ME> list = new LinkedList<ME>();
        if (this.strings == null) {
            return list;
        }
        ME current = this.createBuffer();
        block0: for (int index = 0; index <= this.lastUsed; ++index) {
            int i;
            int pos = 0;
            do {
                if ((i = this.strings[index].indexOf(sep, pos)) < 0) {
                    ((ArrayStringBuffer)current).append(this.strings[index].substring(pos, ((ArrayString)this.strings[index]).length()));
                    continue block0;
                }
                if (((ArrayStringBuffer)current).isEmpty()) {
                    list.add(this.createBuffer((ArrayString)this.strings[index].substring(pos, i)));
                    continue;
                }
                ((ArrayStringBuffer)current).append(this.strings[index].substring(pos, i));
                list.add(current);
                current = this.createBuffer();
            } while ((pos = i + 1) < ((ArrayString)this.strings[index]).length());
        }
        if (((ArrayStringBuffer)current).length() > 0) {
            list.add(current);
        }
        return list;
    }

    private ME subBuffer(int startBuffer, int startBufferIndex, int endBuffer, int endBufferIndex) {
        ME result = this.createBuffer();
        ((ArrayStringBuffer)result).strings = this.allocateArray(endBuffer - startBuffer + 1);
        ((ArrayStringBuffer)result).lastUsed = ((ArrayStringBuffer)result).strings.length - 1;
        for (int buffer = startBuffer; buffer <= endBuffer; ++buffer) {
            int start = buffer == startBuffer ? startBufferIndex : 0;
            int end = buffer == endBuffer ? endBufferIndex : ((ArrayString)this.strings[buffer]).length();
            ((ArrayStringBuffer)result).strings[buffer - startBuffer] = (ArrayString)this.strings[buffer].substring(start, end);
        }
        return result;
    }

    private void replace(int startBuffer, int startBufferIndex, int endBuffer, int endBufferIndex, ME replace) {
        int i;
        ArrayList<Object> list = new ArrayList<Object>(startBuffer + 1 + ((ArrayStringBuffer)replace).lastUsed + 1 + this.lastUsed - endBuffer + 1);
        for (i = 0; i < startBuffer; ++i) {
            list.add(this.strings[i]);
        }
        if (startBufferIndex > 0) {
            list.add((ArrayString)this.strings[startBuffer].substring(0, startBufferIndex));
        }
        if (((ArrayStringBuffer)replace).strings != null) {
            for (i = 0; i <= ((ArrayStringBuffer)replace).lastUsed; ++i) {
                list.add(((ArrayStringBuffer)replace).strings[i]);
            }
        }
        if (endBufferIndex < ((ArrayString)this.strings[endBuffer]).length() - 1) {
            list.add((ArrayString)this.strings[endBuffer].substring(endBufferIndex + 1));
        }
        for (i = endBuffer + 1; i <= this.lastUsed; ++i) {
            list.add(this.strings[i]);
        }
        this.strings = list.toArray(this.allocateArray(list.size()));
        this.lastUsed = this.strings.length - 1;
    }

    public ME replace(CharSequence search, T replace) {
        int pos = 0;
        while ((pos = this.indexOf(search, pos)) >= 0) {
            this.replace(pos, pos + search.length() - 1, (ME)replace);
            pos += ((ArrayString)replace).length();
        }
        return (ME)this;
    }

    public ME replace(CharSequence search, CharSequence replace) {
        return this.replace(search, this.createString(replace));
    }

    public ME replace(char oldChar, char newChar) {
        if (this.strings != null) {
            for (int i = 0; i <= this.lastUsed; ++i) {
                this.strings[i].replace(oldChar, newChar);
            }
        }
        return (ME)this;
    }

    public ME replace(char oldChar, CharSequence replaceValue) {
        return this.replace(oldChar, this.createString(replaceValue));
    }

    public ME replace(CharSequence search, char replace) {
        return this.replace(search, this.createString(replace));
    }

    public ME replace(char oldChar, char[] replace) {
        return this.replace(oldChar, this.createString(replace));
    }

    public ME replace(CharSequence search, char[] replace) {
        return this.replace(search, this.createString(replace));
    }

    public ME replace(int start, int end, char replace) {
        return (ME)this.replace(start, end, (ME)this.createString(replace));
    }

    public ME replace(int start, int end, char[] replace) {
        return (ME)this.replace(start, end, (ME)this.createString(replace));
    }

    public ME replace(char oldChar, T replaceValue) {
        if (((ArrayString)replaceValue).length() == 1) {
            return (ME)this.replace(oldChar, replaceValue.charAt(0));
        }
        if (this.strings == null) {
            return (ME)this;
        }
        int pos = 0;
        while ((pos = this.indexOf(oldChar, pos)) >= 0) {
            this.replace(pos, pos, (ME)replaceValue);
            pos += ((ArrayString)replaceValue).length();
        }
        return (ME)this;
    }

    public ME replace(int start, int end, CharSequence s) {
        if (s.getClass().equals(this.getArrayType())) {
            this.replace(start, end, (ME)((ArrayString)s));
        } else if (s.getClass().equals(this.getClass())) {
            this.replace(start, end, (ME)((ArrayStringBuffer)s));
        } else {
            this.replace(start, end, (ME)this.createString(s));
        }
        return (ME)this;
    }

    public ME replace(int start, int end, T s) {
        int firstBufferLen;
        if (this.strings == null) {
            return (ME)this;
        }
        if (end < start) {
            return (ME)this;
        }
        int firstBufferIndex = 0;
        int firstBufferPos = 0;
        while (start >= firstBufferPos + (firstBufferLen = ((ArrayString)this.strings[firstBufferIndex]).length())) {
            firstBufferPos += firstBufferLen;
            if (++firstBufferIndex <= this.lastUsed) continue;
            return (ME)this;
        }
        int lastBufferIndex = firstBufferIndex;
        int lastBufferPos = firstBufferPos;
        int lastBufferLen = firstBufferLen;
        while (end >= lastBufferPos + lastBufferLen) {
            if (++lastBufferIndex > this.lastUsed) {
                --lastBufferIndex;
                end = lastBufferPos + lastBufferLen - 1;
                break;
            }
            lastBufferPos += lastBufferLen;
            lastBufferLen = ((ArrayString)this.strings[lastBufferIndex]).length();
        }
        this.replaceStrings(firstBufferIndex, lastBufferIndex, start == firstBufferPos ? null : (ArrayString)this.strings[firstBufferIndex].substring(0, start - firstBufferPos), end == lastBufferPos + lastBufferLen - 1 ? null : (ArrayString)this.strings[lastBufferIndex].substring(end - lastBufferPos + 1), 1, new ArrayString[]{s});
        return (ME)this;
    }

    public ME replace(int start, int end, ME s) {
        int firstBufferLen;
        if (this.strings == null) {
            return (ME)this;
        }
        if (end < start) {
            return (ME)this;
        }
        int firstBufferIndex = 0;
        int firstBufferPos = 0;
        while (start >= firstBufferPos + (firstBufferLen = ((ArrayString)this.strings[firstBufferIndex]).length())) {
            firstBufferPos += firstBufferLen;
            if (++firstBufferIndex <= this.lastUsed) continue;
            return (ME)this;
        }
        int lastBufferIndex = firstBufferIndex;
        int lastBufferPos = firstBufferPos;
        int lastBufferLen = firstBufferLen;
        while (end >= lastBufferPos + lastBufferLen) {
            if (++lastBufferIndex > this.lastUsed) {
                --lastBufferIndex;
                end = lastBufferPos + lastBufferLen - 1;
                break;
            }
            lastBufferPos += lastBufferLen;
            lastBufferLen = ((ArrayString)this.strings[lastBufferIndex]).length();
        }
        this.replaceStrings(firstBufferIndex, lastBufferIndex, start == firstBufferPos ? null : (ArrayString)this.strings[firstBufferIndex].substring(0, start - firstBufferPos), end == lastBufferPos + lastBufferLen - 1 ? null : (ArrayString)this.strings[lastBufferIndex].substring(end - lastBufferPos + 1), ((ArrayStringBuffer)s).strings == null ? 0 : ((ArrayStringBuffer)s).lastUsed + 1, (ArrayString[])((ArrayStringBuffer)s).strings);
        return (ME)this;
    }

    @SafeVarargs
    private final void replaceStrings(int startIndex, int endIndex, T first, T last, int nbMiddle, T ... middle) {
        int nb = startIndex + (this.lastUsed - endIndex) + (first != null ? 1 : 0) + (last != null ? 1 : 0) + nbMiddle;
        if (nb <= this.strings.length) {
            int i;
            int pos;
            if (endIndex < this.lastUsed) {
                System.arraycopy(this.strings, endIndex + 1, this.strings, nb - (this.lastUsed - endIndex), this.lastUsed - endIndex);
                pos = nb - (this.lastUsed - endIndex) - 1;
            } else {
                pos = nb - 1;
            }
            if (last != null) {
                this.strings[pos--] = last;
            }
            for (i = nbMiddle - 1; i >= 0; --i) {
                this.strings[pos--] = middle[i];
            }
            if (first != null) {
                this.strings[pos] = first;
            }
            for (i = nb; i <= this.lastUsed; ++i) {
                this.strings[i] = null;
            }
            this.lastUsed = nb - 1;
            return;
        }
        ArrayString[] list = this.allocateArray(nb + 3);
        int pos = 0;
        if (startIndex > 0) {
            System.arraycopy(this.strings, 0, list, 0, startIndex);
            pos = startIndex;
        }
        if (first != null) {
            list[pos++] = first;
        }
        for (int i = 0; i < nbMiddle; ++i) {
            list[pos++] = middle[i];
        }
        if (last != null) {
            list[pos++] = last;
        }
        if (endIndex < this.lastUsed) {
            System.arraycopy(this.strings, endIndex + 1, list, pos, this.lastUsed - endIndex);
        }
        this.strings = list;
        this.lastUsed = nb - 1;
    }

    public void searchAndReplace(CharSequence start, CharSequence end, UnaryOperator<ME> valueProvider) {
        if (this.strings == null) {
            return;
        }
        int buffer = 0;
        int bufferIndex = 0;
        int startIndex = 0;
        char startChar = start.charAt(0);
        int startOfStartBuffer = 0;
        int startOfStartBufferIndex = 0;
        block0: while (buffer <= this.lastUsed) {
            if (bufferIndex >= ((ArrayString)this.strings[buffer]).length()) {
                ++buffer;
                bufferIndex = 0;
                continue;
            }
            char c = this.strings[buffer].charAt(bufferIndex);
            if (c != startChar) {
                if (startIndex > 0) {
                    startIndex = 0;
                    startChar = start.charAt(0);
                }
                ++bufferIndex;
                continue;
            }
            if (startIndex == 0) {
                startOfStartBuffer = buffer;
                startOfStartBufferIndex = bufferIndex;
            }
            if (startIndex == start.length() - 1) {
                startIndex = 0;
                startChar = start.charAt(0);
                int endIndex = 0;
                char endChar = end.charAt(0);
                int endOfStartBuffer = buffer;
                int endOfStartBufferIndex = bufferIndex++;
                while (buffer <= this.lastUsed) {
                    if (bufferIndex >= ((ArrayString)this.strings[buffer]).length()) {
                        ++buffer;
                        bufferIndex = 0;
                        continue;
                    }
                    c = this.strings[buffer].charAt(bufferIndex);
                    if (c != endChar) {
                        if (endIndex > 0) {
                            endIndex = 0;
                            endChar = end.charAt(0);
                        }
                        ++bufferIndex;
                        continue;
                    }
                    if (endIndex == end.length() - 1) {
                        int i;
                        if (++endOfStartBufferIndex == ((ArrayString)this.strings[endOfStartBuffer]).length()) {
                            ++endOfStartBuffer;
                            endOfStartBufferIndex = 0;
                        }
                        int b = buffer;
                        for (i = bufferIndex - end.length() + 1; i < 0; i += ((ArrayString)this.strings[--b]).length()) {
                        }
                        ME variable = this.subBuffer(endOfStartBuffer, endOfStartBufferIndex, b, i);
                        ArrayStringBuffer value = (ArrayStringBuffer)valueProvider.apply(variable);
                        this.replace(startOfStartBuffer, startOfStartBufferIndex, buffer, bufferIndex, value);
                        ++bufferIndex;
                        bufferIndex -= start.length() + end.length() + ((ArrayStringBuffer)variable).length();
                        bufferIndex += value.length();
                        while (bufferIndex < 0) {
                            bufferIndex += ((ArrayString)this.strings[--buffer]).length();
                        }
                        while (buffer <= this.lastUsed && bufferIndex >= ((ArrayString)this.strings[buffer]).length()) {
                            bufferIndex -= ((ArrayString)this.strings[buffer]).length();
                            ++buffer;
                        }
                        continue block0;
                    }
                    endChar = end.charAt(++endIndex);
                    ++bufferIndex;
                }
                continue;
            }
            startChar = start.charAt(++startIndex);
            ++bufferIndex;
        }
    }

    public ME toLowerCase() {
        if (this.strings != null) {
            for (int i = 0; i <= this.lastUsed; ++i) {
                this.strings[i].toLowerCase();
            }
        }
        return (ME)this;
    }

    public ME toUpperCase() {
        if (this.strings != null) {
            for (int i = 0; i <= this.lastUsed; ++i) {
                this.strings[i].toUpperCase();
            }
        }
        return (ME)this;
    }

    @Override
    public boolean startsWith(CharSequence start) {
        if (this.strings == null) {
            return start.length() == 0;
        }
        int l = start.length();
        int stringIndex = 0;
        int stringPos = 0;
        int stringLen = ((ArrayString)this.strings[0]).length();
        for (int i = 0; i < l; ++i) {
            if (this.strings[stringIndex].charAt(stringPos) != start.charAt(i)) {
                return false;
            }
            if (i == l - 1) {
                return true;
            }
            if (++stringPos != stringLen) continue;
            if (++stringIndex > this.lastUsed) {
                return false;
            }
            stringPos = 0;
            stringLen = ((ArrayString)this.strings[stringIndex]).length();
        }
        return true;
    }

    @Override
    public boolean endsWith(CharSequence end) {
        if (this.strings == null) {
            return end.length() == 0;
        }
        int stringIndex = this.lastUsed;
        int stringPos = ((ArrayString)this.strings[stringIndex]).length() - 1;
        for (int i = end.length() - 1; i >= 0; --i) {
            if (this.strings[stringIndex].charAt(stringPos) != end.charAt(i)) {
                return false;
            }
            if (i == 0) {
                return true;
            }
            if (--stringPos >= 0) continue;
            if (--stringIndex < 0) {
                return false;
            }
            stringPos = ((ArrayString)this.strings[stringIndex]).length() - 1;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.strings == null) {
            return "";
        }
        if (this.lastUsed == 0) {
            return this.strings[0].toString();
        }
        char[] chars = new char[this.length()];
        this.fill(chars, 0);
        return new String(chars);
    }

    @Override
    public char[][] asCharacters() {
        if (this.strings == null) {
            return new char[0][];
        }
        char[][] chars = new char[this.lastUsed + 1][];
        for (int i = 0; i <= this.lastUsed; ++i) {
            chars[i] = new char[((ArrayString)this.strings[i]).length()];
            this.strings[i].fill(chars[i]);
        }
        return chars;
    }
}

