/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.text;

import java.util.List;
import net.lecousin.framework.io.data.CharArray;
import net.lecousin.framework.text.CharArrayString;
import net.lecousin.framework.text.CharArrayStringBuffer;
import net.lecousin.framework.text.IString;

public class CappedString
implements IString {
    private int size = 0;
    private int maxSize;
    private CharArrayStringBuffer buffer = new CharArrayStringBuffer();

    public CappedString(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int length() {
        return this.size;
    }

    @Override
    public char charAt(int index) {
        return this.buffer.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.buffer.subSequence(start, end);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void setCharAt(int index, char c) {
        this.buffer.setCharAt(index, c);
    }

    @Override
    public CappedString append(char c) {
        if (this.size == this.maxSize) {
            return this;
        }
        this.buffer.append(c);
        ++this.size;
        return this;
    }

    @Override
    public CappedString append(char[] chars, int offset, int len) {
        if ((len = Math.min(this.maxSize - this.size, len)) == 0) {
            return this;
        }
        this.buffer.append(chars, offset, len);
        this.size += len;
        return this;
    }

    @Override
    public CappedString append(CharSequence s) {
        return this.append(s, 0, s.length());
    }

    @Override
    public CappedString append(CharSequence s, int start, int end) {
        int len = Math.min(this.maxSize - this.size, end - start);
        if (len == 0) {
            return this;
        }
        this.buffer.append(s, start, start + len);
        this.size += len;
        return this;
    }

    public CappedString addFirst(CharSequence s) {
        this.buffer.addFirst(s);
        this.size += s.length();
        if (this.size > this.maxSize) {
            this.buffer.removeEndChars(this.size - this.maxSize);
            this.size = this.maxSize;
        }
        return this;
    }

    @Override
    public int indexOf(char c, int start) {
        return this.buffer.indexOf(c, start);
    }

    @Override
    public int indexOf(CharSequence s, int start) {
        return this.buffer.indexOf(s, start);
    }

    @Override
    public CharArrayStringBuffer substring(int start) {
        return (CharArrayStringBuffer)this.buffer.substring(start);
    }

    @Override
    public CharArrayStringBuffer substring(int start, int end) {
        return (CharArrayStringBuffer)this.buffer.substring(start, end);
    }

    @Override
    public int fill(char[] chars, int start) {
        return this.buffer.fill(chars, start);
    }

    @Override
    public int fillIso8859Bytes(byte[] bytes, int start) {
        return this.buffer.fillIso8859Bytes(bytes, start);
    }

    @Override
    public CappedString trimBeginning() {
        this.buffer.trimBeginning();
        this.size = this.buffer.length();
        return this;
    }

    @Override
    public CappedString trimEnd() {
        this.buffer.trimEnd();
        this.size = this.buffer.length();
        return this;
    }

    @Override
    public CappedString replace(char oldChar, char newChar) {
        this.buffer.replace(oldChar, newChar);
        return this;
    }

    @Override
    public CappedString replace(CharSequence search, CharSequence replace) {
        this.buffer.replace(search, replace);
        this.size = this.buffer.length();
        if (this.size > this.maxSize) {
            this.buffer = (CharArrayStringBuffer)this.buffer.substring(0, this.maxSize);
            this.size = this.maxSize;
        }
        return this;
    }

    @Override
    public CappedString replace(int start, int end, CharSequence replace) {
        this.buffer.replace(start, end, replace);
        this.size = this.buffer.length();
        if (this.size > this.maxSize) {
            this.buffer = (CharArrayStringBuffer)this.buffer.substring(0, this.maxSize);
            this.size = this.maxSize;
        }
        return this;
    }

    @Override
    public CappedString replace(char oldChar, CharSequence replace) {
        return this.replace((CharSequence)new CharArrayString(oldChar), replace);
    }

    @Override
    public CappedString replace(char oldChar, char[] replace) {
        return this.replace((CharSequence)new CharArrayString(oldChar), (CharSequence)new CharArrayString(replace));
    }

    @Override
    public CappedString replace(CharSequence search, char replace) {
        return this.replace(search, (CharSequence)new CharArrayString(replace));
    }

    @Override
    public CappedString replace(CharSequence search, char[] replace) {
        return this.replace(search, (CharSequence)new CharArrayString(replace));
    }

    @Override
    public CappedString replace(int start, int end, char replace) {
        return this.replace(start, end, new CharArrayString(replace));
    }

    @Override
    public CappedString replace(int start, int end, char[] replace) {
        return this.replace(start, end, new CharArrayString(replace));
    }

    @Override
    public CappedString removeEndChars(int nb) {
        this.buffer.removeEndChars(nb);
        this.size = this.buffer.length();
        return this;
    }

    @Override
    public CappedString removeStartChars(int nb) {
        this.buffer.removeStartChars(nb);
        this.size = this.buffer.length();
        return this;
    }

    @Override
    public CappedString toLowerCase() {
        this.buffer.toLowerCase();
        return this;
    }

    @Override
    public CappedString toUpperCase() {
        this.buffer.toUpperCase();
        return this;
    }

    public List<CharArrayStringBuffer> split(char sep) {
        return this.buffer.split(sep);
    }

    @Override
    public CappedString copy() {
        CappedString copy = new CappedString(this.maxSize);
        copy.buffer = new CharArrayStringBuffer(this.buffer.copy());
        copy.size = this.size;
        return copy;
    }

    @Override
    public boolean startsWith(CharSequence start) {
        return this.buffer.startsWith(start);
    }

    @Override
    public boolean endsWith(CharSequence end) {
        return this.buffer.endsWith(end);
    }

    @Override
    public CharArray[] asCharBuffers() {
        return this.buffer.asCharBuffers();
    }

    @Override
    public String toString() {
        return this.buffer.toString();
    }
}

