/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.text;

import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.io.data.CharArray;
import net.lecousin.framework.text.ArrayString;
import net.lecousin.framework.text.IString;

public class CharArrayString
extends ArrayString {
    private char[] chars;

    public CharArrayString(int initialCapacity) {
        this.chars = new char[initialCapacity];
        this.start = 0;
        this.end = -1;
        this.usableEnd = initialCapacity - 1;
    }

    public CharArrayString(char singleChar) {
        this.chars = new char[]{singleChar};
        this.start = 0;
        this.end = 0;
        this.usableEnd = 0;
    }

    public CharArrayString(char[] chars, int offset, int len, int usableLength) {
        this.chars = chars;
        this.start = offset;
        this.end = offset + len - 1;
        this.usableEnd = offset + usableLength - 1;
    }

    public CharArrayString(char[] chars) {
        this(chars, 0, chars.length, chars.length);
    }

    public CharArrayString(String s) {
        this.chars = s.toCharArray();
        this.start = 0;
        this.usableEnd = this.end = this.chars.length - 1;
    }

    public CharArrayString(String s, int startPos, int endPos) {
        this.chars = s.toCharArray();
        this.start = startPos;
        this.usableEnd = this.end = this.start + endPos - startPos - 1;
    }

    public CharArrayString(IString s) {
        this.chars = new char[s.length()];
        s.fill(this.chars);
        this.start = 0;
        this.usableEnd = this.end = this.chars.length - 1;
    }

    public CharArrayString(CharSequence s) {
        this(s.toString());
    }

    public CharArrayString(CharSequence s, int startPos, int endPos) {
        this(s.toString(), startPos, endPos);
    }

    @Override
    public char charAt(int index) {
        return this.chars[this.start + index];
    }

    @Override
    public void setCharAt(int index, char c) {
        if (index < 0 || index > this.end - this.start) {
            throw new IllegalArgumentException("Character index " + index + " does not exist");
        }
        this.chars[this.start + index] = c;
    }

    @Override
    public int firstChar() {
        if (this.end >= this.start) {
            return this.chars[this.start];
        }
        return -1;
    }

    @Override
    public int lastChar() {
        if (this.end >= this.start) {
            return this.chars[this.end];
        }
        return -1;
    }

    private void enlarge(int add) {
        char[] a = new char[this.chars.length + add];
        System.arraycopy(this.chars, this.start, a, 0, this.end - this.start + 1);
        this.end -= this.start;
        this.start = 0;
        this.usableEnd = a.length - 1;
        this.chars = a;
    }

    @Override
    public void trimToSize() {
        char[] a = new char[this.end - this.start + 1];
        System.arraycopy(this.chars, this.start, a, 0, a.length);
        this.chars = a;
        this.start = 0;
        this.end = a.length - 1;
        this.usableEnd = 0;
    }

    @Override
    public boolean appendNoEnlarge(char c) {
        if (this.end == this.usableEnd) {
            return false;
        }
        this.chars[++this.end] = c;
        return true;
    }

    @Override
    public CharArrayString append(char c) {
        if (this.end == this.usableEnd) {
            this.enlarge(this.chars.length < 128 ? 64 : this.chars.length >> 1);
        }
        this.chars[++this.end] = c;
        return this;
    }

    @Override
    public CharArrayString append(char[] chars, int offset, int len) {
        if (this.usableEnd - this.end < len) {
            int l;
            int n = l = chars.length < 128 ? 64 : chars.length >> 1;
            if (l < len + 16) {
                l = len + 16;
            }
            this.enlarge(l);
        }
        System.arraycopy(chars, offset, this.chars, this.end + 1, len);
        this.end += len;
        return this;
    }

    @Override
    public CharArrayString append(CharSequence s) {
        int l;
        if (s == null) {
            s = "null";
        }
        if ((l = s.length()) == 0) {
            return this;
        }
        if (l >= this.usableEnd - this.end) {
            this.enlarge(l + 16);
        }
        if (s instanceof IString) {
            ((IString)s).fill(this.chars, this.end + 1);
            this.end += l;
            return this;
        }
        for (int i = 0; i < l; ++i) {
            this.chars[++this.end] = s.charAt(i);
        }
        return this;
    }

    @Override
    public CharArrayString append(CharSequence s, int startPos, int endPos) {
        if (s == null) {
            return this.append("null");
        }
        int l = endPos - startPos;
        if (l == 0) {
            return this;
        }
        if (l >= this.usableEnd - this.end) {
            this.enlarge(l + 16);
        }
        if (s instanceof IString) {
            ((IString)s).substring(startPos, endPos).fill(this.chars, this.end + 1);
            this.end += l;
            return this;
        }
        for (int i = 0; i < l; ++i) {
            this.chars[++this.end] = s.charAt(i + startPos);
        }
        return this;
    }

    @Override
    public int indexOf(char c, int pos) {
        for (int i = this.start + pos; i <= this.end; ++i) {
            if (this.chars[i] != c) continue;
            return i - this.start;
        }
        return -1;
    }

    @Override
    public int indexOf(CharSequence s, int pos) {
        int l = s.length();
        if (this.start + pos + l - 1 > this.end) {
            return -1;
        }
        char first = s.charAt(0);
        for (int i = this.start + pos; i <= this.end - l + 1; ++i) {
            int j;
            if (this.chars[i] != first) continue;
            for (j = 1; j < l && s.charAt(j) == this.chars[i + j]; ++j) {
            }
            if (j != l) continue;
            return i - this.start;
        }
        return -1;
    }

    @Override
    public String subSequence(int start, int end) {
        if (end <= start) {
            return "";
        }
        return new String(this.chars, this.start + start, end - start);
    }

    @Override
    public CharArrayString substring(int start, int end) {
        if (this.start + end > this.end) {
            end = this.end - this.start + 1;
        }
        if (end <= start) {
            return new CharArrayString(0);
        }
        return new CharArrayString(this.chars, this.start + start, end - start, end - start);
    }

    @Override
    public CharArrayString substring(int start) {
        if (this.start + start > this.end) {
            return new CharArrayString(0);
        }
        return new CharArrayString(this.chars, this.start + start, this.end - (this.start + start) + 1, this.end - (this.start + start) + 1);
    }

    @Override
    public CharArrayString replace(char oldChar, char newChar) {
        for (int i = this.start; i <= this.end; ++i) {
            if (this.chars[i] != oldChar) continue;
            this.chars[i] = newChar;
        }
        return this;
    }

    @Override
    public CharArrayString replace(CharSequence search, CharSequence replace) {
        int i;
        int rl;
        int sl = search.length();
        if (sl == (rl = replace.length())) {
            int i2;
            int pos = 0;
            while ((i2 = this.indexOf(search, pos)) >= 0) {
                this.replace(i2, i2 + sl - 1, replace);
                pos = i2 + sl;
            }
            return this;
        }
        if (sl > rl) {
            int i3;
            int pos = 0;
            int diff = 0;
            while ((i3 = this.indexOf(search, pos)) >= 0) {
                if (diff > 0) {
                    System.arraycopy(this.chars, this.start + pos, this.chars, this.start + pos - diff, i3 - pos);
                }
                this.overwrite(this.start + i3 - diff, replace);
                diff += sl - rl;
                pos = i3 + sl;
            }
            if (diff > 0) {
                System.arraycopy(this.chars, this.start + pos, this.chars, this.start + pos - diff, this.end + 1 - pos - this.start);
                this.end -= diff;
            }
            return this;
        }
        LinkedArrayList<Integer> found = new LinkedArrayList<Integer>(10);
        int pos = 0;
        while ((i = this.indexOf(search, pos)) >= 0) {
            found.add(i);
            pos = i + sl;
        }
        if (found.isEmpty()) {
            return this;
        }
        int diff = (rl - sl) * found.size();
        if (this.usableEnd - this.end < diff) {
            this.enlarge(Math.min(diff, 16));
        }
        pos = this.end + 1;
        i = found.size() - 1;
        while (i >= 0) {
            int index = (Integer)found.get(i--);
            System.arraycopy(this.chars, this.start + index + sl, this.chars, this.start + index + rl + (rl - sl) * (i + 1), pos - index - sl - this.start);
            this.end += rl - sl;
            this.overwrite(this.start + index + (rl - sl) * (i + 1), replace);
            pos = this.start + index;
        }
        return this;
    }

    @Override
    public CharArrayString replace(int start, int end, CharSequence replace) {
        int l2;
        int l = replace.length();
        if (l == (l2 = end - start + 1)) {
            this.overwrite(this.start + start, replace);
            return this;
        }
        if (l < l2) {
            this.overwrite(this.start + start, replace);
            System.arraycopy(this.chars, this.start + start + l2, this.chars, this.start + start + l, this.end - this.start - end);
            this.end -= l2 - l;
            return this;
        }
        this.enlarge(Math.min(l - l2, 16));
        System.arraycopy(this.chars, this.start + start + l2, this.chars, this.start + start + l, this.end - this.start - end);
        this.overwrite(this.start + start, replace);
        this.end += l - l2;
        return this;
    }

    @Override
    public CharArrayString replace(char oldChar, CharSequence replace) {
        return this.replace((CharSequence)new CharArrayString(oldChar), replace);
    }

    @Override
    public CharArrayString replace(char oldChar, char[] replace) {
        return this.replace((CharSequence)new CharArrayString(oldChar), (CharSequence)new CharArrayString(replace));
    }

    @Override
    public CharArrayString replace(CharSequence search, char replace) {
        return this.replace(search, (CharSequence)new CharArrayString(replace));
    }

    @Override
    public CharArrayString replace(CharSequence search, char[] replace) {
        return this.replace(search, (CharSequence)new CharArrayString(replace));
    }

    @Override
    public CharArrayString replace(int start, int end, char replace) {
        return this.replace(start, end, new CharArrayString(replace));
    }

    @Override
    public CharArrayString replace(int start, int end, char[] replace) {
        return this.replace(start, end, new CharArrayString(replace));
    }

    private void overwrite(int start, CharSequence s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            this.chars[start + i] = s.charAt(i);
        }
    }

    @Override
    public int fill(char[] chars, int start) {
        int len = this.end - this.start + 1;
        System.arraycopy(this.chars, this.start, chars, start, len);
        return len;
    }

    @Override
    public int fillIso8859Bytes(byte[] bytes, int start) {
        int pos = 0;
        for (int i = this.start; i <= this.end; ++i) {
            bytes[start + pos++] = (byte)this.chars[i];
        }
        return pos;
    }

    public List<CharArrayString> split(char sep) {
        LinkedList<CharArrayString> list = new LinkedList<CharArrayString>();
        int pos = this.start;
        while (pos <= this.end) {
            int found;
            for (found = pos; found <= this.end && this.chars[found] != sep; ++found) {
            }
            list.add(this.substring(pos - this.start, found - this.start));
            pos = found + 1;
        }
        return list;
    }

    @Override
    public CharArrayString toLowerCase() {
        for (int i = this.start; i <= this.end; ++i) {
            this.chars[i] = Character.toLowerCase(this.chars[i]);
        }
        return this;
    }

    @Override
    public CharArrayString toUpperCase() {
        for (int i = this.start; i <= this.end; ++i) {
            this.chars[i] = Character.toUpperCase(this.chars[i]);
        }
        return this;
    }

    @Override
    public boolean startsWith(CharSequence start) {
        int l = start.length();
        if (this.end - this.start + 1 < l) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (this.chars[this.start + i] == start.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(CharSequence end) {
        int l = end.length();
        if (this.end - this.start + 1 < l) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (this.chars[this.end - i] == end.charAt(l - 1 - i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.end < this.start) {
            return "";
        }
        return new String(this.chars, this.start, this.end - this.start + 1);
    }

    public CharArray asCharBuffer() {
        return new CharArray(this.chars, this.start, this.end - this.start + 1);
    }

    @Override
    public CharArray[] asCharBuffers() {
        return new CharArray[]{this.asCharBuffer()};
    }

    public char[] charArray() {
        return this.chars;
    }

    @Override
    public CharArrayString copy() {
        char[] copy = new char[this.end - this.start + 1];
        System.arraycopy(this.chars, this.start, copy, 0, this.end - this.start + 1);
        return new CharArrayString(copy);
    }

    @Override
    public int countChar(char c) {
        int count = 0;
        for (int i = this.start; i <= this.end; ++i) {
            if (this.chars[i] != c) continue;
            ++count;
        }
        return count;
    }
}

