/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.text;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.data.CharArray;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.text.ArrayStringBuffer;
import net.lecousin.framework.text.CharArrayString;
import net.lecousin.framework.text.IString;
import net.lecousin.framework.util.ConcurrentCloseable;

public class CharArrayStringBuffer
extends ArrayStringBuffer<CharArrayString, CharArrayStringBuffer> {
    public CharArrayStringBuffer() {
    }

    public CharArrayStringBuffer(CharArrayString string) {
        super(string);
    }

    public CharArrayStringBuffer(Collection<CharArrayString> strings) {
        super(strings);
    }

    public CharArrayStringBuffer(String s) {
        this.strings = new CharArrayString[1];
        this.lastUsed = 0;
        ((CharArrayString[])this.strings)[0] = new CharArrayString(s);
    }

    public CharArrayStringBuffer(CharSequence s) {
        this.strings = new CharArrayString[1];
        this.lastUsed = 0;
        ((CharArrayString[])this.strings)[0] = new CharArrayString(s);
    }

    public CharArrayStringBuffer(IString s) {
        this.strings = new CharArrayString[1];
        this.lastUsed = 0;
        ((CharArrayString[])this.strings)[0] = new CharArrayString(s);
    }

    protected CharArrayString[] allocateArray(int arraySize) {
        return new CharArrayString[arraySize];
    }

    @Override
    protected CharArrayString createString(int initialCapacity) {
        return new CharArrayString(initialCapacity);
    }

    @Override
    protected CharArrayString createString(CharSequence s) {
        return new CharArrayString(s);
    }

    @Override
    protected CharArrayString createString(CharSequence s, int startPos, int endPos) {
        return new CharArrayString(s, startPos, endPos);
    }

    @Override
    protected CharArrayString createString(char singleChar) {
        return new CharArrayString(singleChar);
    }

    @Override
    protected CharArrayString createString(char[] chars) {
        return new CharArrayString(chars);
    }

    @Override
    protected CharArrayStringBuffer createBuffer() {
        return new CharArrayStringBuffer();
    }

    @Override
    protected CharArrayStringBuffer createBuffer(CharArrayString s) {
        return new CharArrayStringBuffer(s);
    }

    @Override
    protected CharArrayStringBuffer createBuffer(List<CharArrayString> list) {
        return new CharArrayStringBuffer((Collection<CharArrayString>)list);
    }

    @Override
    protected Class<CharArrayString> getArrayType() {
        return CharArrayString.class;
    }

    @Override
    public CharArrayString copy() {
        char[] copy = new char[this.length()];
        this.fill(copy, 0);
        return new CharArrayString(copy);
    }

    @Override
    public CharArray[] asCharBuffers() {
        if (this.strings == null) {
            return new CharArray[0];
        }
        CharArray[] chars = new CharArray[this.lastUsed + 1];
        for (int i = 0; i <= this.lastUsed; ++i) {
            chars[i] = ((CharArrayString[])this.strings)[i].asCharBuffer();
        }
        return chars;
    }

    public ICharacterStream.Readable.Buffered asCharacterStream() {
        return new CS();
    }

    public ICharacterStream.Writable.Buffered asWritableCharacterStream() {
        return new WCS();
    }

    public Async<IOException> encode(Charset charset, IO.Writable output, Task.Priority priority) {
        if (this.strings == null) {
            return new Async<boolean>(true);
        }
        Async<IOException> result = new Async<IOException>();
        CharsetEncoder encoder = charset.newEncoder();
        this.encode(0, encoder, output, priority, null, result);
        return result;
    }

    private void encode(int index, CharsetEncoder encoder, IO.Writable output, Task.Priority priority, IAsync<IOException> prevWrite, Async<IOException> result) {
        Task.cpu("Encode string into bytes", priority, t -> {
            try {
                ByteBuffer bytes = encoder.encode(((CharArrayString[])this.strings)[index].asCharBuffer().toCharBuffer());
                if (prevWrite == null || prevWrite.isDone()) {
                    if (prevWrite != null && prevWrite.hasError()) {
                        result.error((IOException)prevWrite.getError());
                        return null;
                    }
                    AsyncSupplier<Integer, IOException> write = output.writeAsync(bytes);
                    if (index == this.lastUsed) {
                        write.onDone(result);
                        return null;
                    }
                    this.encode(index + 1, encoder, output, priority, write, result);
                    return null;
                }
                prevWrite.onDone(() -> {
                    AsyncSupplier<Integer, IOException> write = output.writeAsync(bytes);
                    if (index == this.lastUsed) {
                        write.onDone(result);
                        return;
                    }
                    this.encode(index + 1, encoder, output, priority, write, result);
                }, result);
            }
            catch (IOException e) {
                result.error(e);
            }
            return null;
        }).start();
    }

    protected class WCS
    extends AbstractCS
    implements ICharacterStream.Writable.Buffered {
        protected WCS() {
        }

        @Override
        public void writeSync(char[] c, int offset, int length) {
            CharArrayStringBuffer.this.append(c, offset, length);
        }

        @Override
        public void writeSync(char c) throws IOException {
            CharArrayStringBuffer.this.append(c);
        }

        @Override
        public IAsync<IOException> writeAsync(char[] c, int offset, int length) {
            return Task.cpu("UnprotectedStringBuffer.writeAsync", this.priority, t -> {
                CharArrayStringBuffer.this.append(c, offset, length);
                return null;
            }).start().getOutput();
        }

        @Override
        public IAsync<IOException> writeAsync(char c) {
            CharArrayStringBuffer.this.append(c);
            return new Async<boolean>(true);
        }

        @Override
        public IAsync<IOException> flush() {
            return new Async<boolean>(true);
        }
    }

    protected class CS
    extends AbstractCS
    implements ICharacterStream.Readable.Buffered {
        private int buffer;
        private int bufferIndex;
        private int back;

        protected CS() {
            this.buffer = 0;
            this.bufferIndex = 0;
            this.back = -1;
        }

        @Override
        public char read() throws EOFException {
            if (this.back != -1) {
                char c = (char)this.back;
                this.back = -1;
                return c;
            }
            if (CharArrayStringBuffer.this.strings == null) {
                throw new EOFException();
            }
            while (this.buffer <= CharArrayStringBuffer.this.lastUsed && this.bufferIndex == ((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].length()) {
                ++this.buffer;
                this.bufferIndex = 0;
            }
            if (this.buffer > CharArrayStringBuffer.this.lastUsed) {
                throw new EOFException();
            }
            return ((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].charAt(this.bufferIndex++);
        }

        @Override
        public int readSync(char[] buf, int offset, int length) {
            if (length <= 0) {
                return 0;
            }
            int done = 0;
            if (this.back != -1) {
                buf[offset++] = (char)this.back;
                this.back = -1;
                if (--length <= 0) {
                    return 1;
                }
                if (CharArrayStringBuffer.this.strings == null) {
                    return 1;
                }
                done = 1;
            } else if (CharArrayStringBuffer.this.strings == null) {
                return -1;
            }
            while (true) {
                if (this.buffer <= CharArrayStringBuffer.this.lastUsed && this.bufferIndex == ((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].length()) {
                    ++this.buffer;
                    this.bufferIndex = 0;
                    continue;
                }
                if (this.buffer > CharArrayStringBuffer.this.lastUsed) {
                    return done > 0 ? done : -1;
                }
                int len = ((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].length() - this.bufferIndex;
                if (len > length) {
                    len = length;
                }
                System.arraycopy(((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].charArray(), ((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].arrayStart() + this.bufferIndex, buf, offset, len);
                this.bufferIndex += len;
                offset += len;
                done += len;
                if ((length -= len) == 0) break;
            }
            return done;
        }

        @Override
        public int readAsync() {
            if (this.back != -1) {
                char c = (char)this.back;
                this.back = -1;
                return c;
            }
            if (CharArrayStringBuffer.this.strings == null) {
                return -1;
            }
            while (this.buffer <= CharArrayStringBuffer.this.lastUsed && this.bufferIndex == ((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].length()) {
                ++this.buffer;
                this.bufferIndex = 0;
            }
            if (this.buffer > CharArrayStringBuffer.this.lastUsed) {
                return -1;
            }
            return ((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].charAt(this.bufferIndex++);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readAsync(char[] buf, int offset, int length) {
            return Task.cpu("UnprotectedStringBuffer.readAsync", this.priority, t -> this.readSync(buf, offset, length)).start().getOutput();
        }

        @Override
        public AsyncSupplier<Chars.Readable, IOException> readNextBufferAsync() {
            return new AsyncSupplier<Chars.Readable, Object>(this.readNextBuffer(), null);
        }

        @Override
        public Chars.Readable readNextBuffer() {
            if (this.back != -1) {
                CharArray s = new CharArray(new char[]{(char)this.back});
                this.back = -1;
                return s;
            }
            if (CharArrayStringBuffer.this.strings == null) {
                return null;
            }
            while (this.buffer <= CharArrayStringBuffer.this.lastUsed && this.bufferIndex == ((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].length()) {
                ++this.buffer;
                this.bufferIndex = 0;
            }
            if (this.buffer > CharArrayStringBuffer.this.lastUsed) {
                return null;
            }
            CharArrayString str = ((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].substring(this.bufferIndex);
            ++this.buffer;
            this.bufferIndex = 0;
            return str.asCharBuffer();
        }

        @Override
        public boolean readUntil(char endChar, IString string) throws IOException {
            if (this.back != -1) {
                char c = (char)this.back;
                this.back = -1;
                if (c == endChar) {
                    return true;
                }
                string.append(c);
            }
            if (CharArrayStringBuffer.this.strings == null) {
                return false;
            }
            while (true) {
                if (this.buffer <= CharArrayStringBuffer.this.lastUsed && this.bufferIndex == ((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].length()) {
                    ++this.buffer;
                    this.bufferIndex = 0;
                    continue;
                }
                if (this.buffer > CharArrayStringBuffer.this.lastUsed) {
                    return false;
                }
                int pos = ((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].indexOf(endChar, this.bufferIndex);
                if (pos >= 0) {
                    if (pos > 0) {
                        string.append(((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].substring(this.bufferIndex, pos));
                    }
                    this.bufferIndex = pos + 1;
                    return true;
                }
                if (this.bufferIndex == 0) {
                    string.append(((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer]);
                } else {
                    string.append(((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].substring(this.bufferIndex, ((CharArrayString[])CharArrayStringBuffer.this.strings)[this.buffer].length()));
                }
                ++this.buffer;
                this.bufferIndex = 0;
            }
        }

        @Override
        public AsyncSupplier<Boolean, IOException> readUntilAsync(char endChar, IString string) {
            AsyncSupplier<Boolean, IOException> result = new AsyncSupplier<Boolean, IOException>();
            Task.cpu("UnprotectedStringBuffer.readUntilAsync", this.getPriority(), t -> {
                try {
                    result.unblockSuccess(this.readUntil(endChar, string));
                }
                catch (IOException e) {
                    result.error(e);
                }
                return null;
            }).start();
            return result;
        }

        @Override
        public void back(char c) {
            this.back = c;
        }

        @Override
        public boolean endReached() {
            return this.back == -1 && (CharArrayStringBuffer.this.strings == null || this.buffer > CharArrayStringBuffer.this.lastUsed);
        }

        @Override
        public IAsync<IOException> canStartReading() {
            return new Async<boolean>(true);
        }
    }

    protected abstract class AbstractCS
    extends ConcurrentCloseable<IOException>
    implements ICharacterStream {
        protected Task.Priority priority = Task.getCurrentPriority();

        protected AbstractCS() {
        }

        @Override
        protected IAsync<IOException> closeUnderlyingResources() {
            return null;
        }

        @Override
        protected void closeResources(Async<IOException> ondone) {
            ondone.unblock();
        }

        @Override
        public Task.Priority getPriority() {
            return this.priority;
        }

        @Override
        public void setPriority(Task.Priority priority) {
            this.priority = priority;
        }

        @Override
        public String getDescription() {
            return "UnprotectedStringBuffer";
        }

        @Override
        public Charset getEncoding() {
            return StandardCharsets.UTF_16;
        }
    }
}

