/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import net.lecousin.framework.encoding.EncodingException;
import net.lecousin.framework.encoding.StringEncoding;
import net.lecousin.framework.util.IDManagerLong;
import net.lecousin.framework.util.IDManagerString;

public class IDManagerStringFromLong
implements IDManagerString {
    protected IDManagerLong manager;
    protected StringEncoding<Long> encoder;

    public IDManagerStringFromLong(IDManagerLong manager, StringEncoding<Long> encoder) {
        this.manager = manager;
        this.encoder = encoder;
    }

    public IDManagerStringFromLong(IDManagerLong manager) {
        this(manager, new StringEncoding.SimpleLong());
    }

    @Override
    public String allocate() {
        try {
            return this.encoder.encode(this.manager.allocate());
        }
        catch (EncodingException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }

    @Override
    public void free(String id) {
        try {
            this.manager.free(this.encoder.decode(id));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void used(String id) {
        try {
            this.manager.used(this.encoder.decode(id));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

