/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application;

import com.sun.management.OperatingSystemMXBean;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.application.libraries.LibrariesManager;
import net.lecousin.framework.concurrent.DrivesTaskManager;
import net.lecousin.framework.concurrent.StandaloneTaskPriorityManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.memory.MemoryManager;
import net.lecousin.framework.util.AsyncCloseable;
import net.lecousin.framework.util.DebugUtil;
import net.lecousin.framework.util.Pair;

public class StandaloneLCCore
implements LCCore.Environment {
    private Application app = null;
    private long startTime;
    private boolean closing;
    private List<Thread> threadsBeforeInit = new LinkedList<Thread>();
    private ArrayList<Closeable> toCloseSync = new ArrayList();
    private ArrayList<AsyncCloseable<?>> toCloseAsync = new ArrayList();
    private int nbCPUThreads = -1;
    private int nbUnmanagedThreads = -1;
    private DrivesTaskManager.DrivesProvider drivesProvider = null;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static long logThreadingInterval = 30000L;

    public StandaloneLCCore() {
        System.out.println("net.lecousin.framework 0.9.11");
        this.startTime = System.nanoTime();
        this.closing = false;
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> thread : threads.entrySet()) {
            this.threadsBeforeInit.add(thread.getKey());
        }
        threads = null;
    }

    @Override
    public void add(Application app) {
        if (this.app != null) {
            throw new IllegalStateException("Cannot add several application on a standalone LCCore environment");
        }
        this.app = app;
    }

    public void setCPUThreads(int nbThreads) {
        if (Threading.isInitialized()) {
            throw new IllegalStateException("Threading has been already initialized.");
        }
        this.nbCPUThreads = nbThreads;
    }

    public void setUnmanagedThreads(int nbThreads) {
        if (Threading.isInitialized()) {
            throw new IllegalStateException("Threading has been already initialized.");
        }
        this.nbUnmanagedThreads = nbThreads;
    }

    public void setDrivesProvider(DrivesTaskManager.DrivesProvider provider) {
        if (Threading.isInitialized()) {
            throw new IllegalStateException("Threading has been already initialized.");
        }
        this.drivesProvider = provider;
    }

    @Override
    public void start() {
        Logger logger;
        Threading.init(this.app.getThreadFactory(), StandaloneTaskPriorityManager.class, this.nbCPUThreads, this.drivesProvider, this.nbUnmanagedThreads);
        if (this.app.isDebugMode() && (logger = this.app.getLoggerFactory().getLogger("Threading Status")).debug()) {
            class ThreadingLogger
            extends Thread
            implements Closeable {
                private boolean closed;

                ThreadingLogger() {
                    super("Threading logger");
                    this.closed = false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    do {
                        ThreadingLogger threadingLogger = this;
                        synchronized (threadingLogger) {
                            try {
                                this.wait(logThreadingInterval);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        if (this.closed) {
                            return;
                        }
                        logger.debug("\n" + Threading.debug());
                    } while (!this.closed);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    ThreadingLogger threadingLogger = this;
                    synchronized (threadingLogger) {
                        this.closed = true;
                        this.notify();
                    }
                }
            }
            ThreadingLogger t = new ThreadingLogger();
            t.start();
            this.app.toClose(t);
        }
    }

    @Override
    public Application getApplication() {
        return this.app;
    }

    @Override
    public Logger getSystemLogger(String name) {
        return this.app.getLoggerFactory().getLogger(name);
    }

    @Override
    public LibrariesManager getSystemLibraries() {
        return this.app.getLibrariesManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toClose(Closeable c) {
        ArrayList<Closeable> arrayList = this.toCloseSync;
        synchronized (arrayList) {
            this.toCloseSync.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toClose(AsyncCloseable<?> c) {
        ArrayList<AsyncCloseable<?>> arrayList = this.toCloseAsync;
        synchronized (arrayList) {
            this.toCloseAsync.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed(Closeable c) {
        ArrayList<Closeable> arrayList = this.toCloseSync;
        synchronized (arrayList) {
            this.toCloseSync.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed(AsyncCloseable<?> c) {
        ArrayList<AsyncCloseable<?>> arrayList = this.toCloseAsync;
        synchronized (arrayList) {
            this.toCloseAsync.remove(c);
        }
    }

    @Override
    public boolean isStopping() {
        return this.closing;
    }

    @Override
    public void stop() {
        block19: {
            this.closing = true;
            if (!this.app.isStopping()) {
                this.app.stop();
            }
            System.out.println(" * Closing resources");
            for (Closeable closeable : new ArrayList<Closeable>(this.toCloseSync)) {
                System.out.println("     - " + closeable);
                try {
                    closeable.close();
                }
                catch (Throwable throwable) {
                    System.err.println("Error closing resource " + closeable);
                    throwable.printStackTrace(System.err);
                }
            }
            LinkedList closing = new LinkedList();
            for (AsyncCloseable<?> asyncCloseable : new ArrayList(this.toCloseAsync)) {
                System.out.println(" * Closing " + asyncCloseable);
                closing.add(new Pair(asyncCloseable, asyncCloseable.closeAsync()));
            }
            this.toCloseAsync.clear();
            long l = System.currentTimeMillis();
            do {
                Iterator it = closing.iterator();
                while (it.hasNext()) {
                    Pair s = (Pair)it.next();
                    if (!((ISynchronizationPoint)s.getValue2()).isUnblocked()) continue;
                    System.out.println(" * Closed: " + s.getValue1());
                    it.remove();
                }
                if (closing.isEmpty()) break block19;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break block19;
                }
            } while (System.currentTimeMillis() - l <= 10000L);
            System.out.println("Ressources are still closing, but we don't wait more than 10 seconds.");
        }
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        int count = 0;
        do {
            int nb = 0;
            if (count % 10 == 0) {
                System.out.println("Threads still running:");
            }
            for (Map.Entry<Thread, StackTraceElement[]> thread : threads.entrySet()) {
                ThreadGroup g;
                if (thread.getKey() == Thread.currentThread() || (g = thread.getKey().getThreadGroup()) == null || "system".equals(g.getName()) || thread.getKey().getName().startsWith("AWT-") || thread.getKey().getName().equals("DestroyJavaVM")) continue;
                if (this.threadsBeforeInit.contains(thread.getKey())) {
                    if (count % 10 != 0) continue;
                    System.out.println("Thread ignored because started before: " + thread.getKey());
                    continue;
                }
                ++nb;
                if (count % 10 != 0) continue;
                System.out.println("Thread: " + thread.getKey());
                System.out.println(DebugUtil.createStackTrace(new StringBuilder(), thread.getValue()).toString());
            }
            if (nb == 0) break;
            if (count % 10 == 0) {
                System.out.println("Waiting for threads to stop");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        } while (++count < 50);
        long end = System.nanoTime();
        StringBuilder s = new StringBuilder(2048);
        MemoryManager.logMemory(s);
        System.out.println(s.toString());
        java.lang.management.OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        try {
            ClassLoader.getSystemClassLoader().loadClass("com.sun.management.OperatingSystemMXBean");
            if (!(os instanceof OperatingSystemMXBean)) {
                throw new Exception();
            }
            long cpuUsage = ((OperatingSystemMXBean)os).getProcessCpuTime();
            System.out.println("JVM used " + String.format("%.5f", new Double((double)cpuUsage * 1.0 / 1.0E9)) + "s. of CPU, while running " + String.format("%.5f", new Double((double)(end - this.startTime) * 1.0 / 1.0E9)) + "s. with " + os.getAvailableProcessors() + " processors (" + String.format("%.2f", new Double((double)cpuUsage * 100.0 / (double)((end - this.startTime) * (long)os.getAvailableProcessors()))) + "%)");
        }
        catch (Throwable t) {
            System.out.println("JVM has run during " + String.format("%.5f", new Double((double)(end - this.startTime) * 1.0 / 1.0E9)) + "s.");
        }
    }
}

