/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.ApplicationClassLoader;
import net.lecousin.framework.application.VersionSpecification;
import net.lecousin.framework.application.libraries.DefaultApplicationClassLoader;
import net.lecousin.framework.application.libraries.LibrariesManager;
import net.lecousin.framework.application.libraries.Library;
import net.lecousin.framework.application.libraries.LoadLibraryExtensionPointsFile;
import net.lecousin.framework.application.libraries.LoadLibraryPluginsFile;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOFromInputStream;
import net.lecousin.framework.io.provider.IOProviderFromName;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.plugins.CustomExtensionPoint;
import net.lecousin.framework.plugins.ExtensionPoints;
import net.lecousin.framework.progress.WorkProgress;

public class DefaultLibrariesManager
implements LibrariesManager {
    private Application app;
    private ApplicationClassLoader acl;
    private SynchronizationPoint<Exception> started = new SynchronizationPoint();

    @Override
    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    public ApplicationClassLoader start(Application app) {
        this.app = app;
        this.acl = new DefaultApplicationClassLoader(app);
        new Start().start();
        return this.acl;
    }

    @Override
    public ISynchronizationPoint<Exception> onLibrariesLoaded() {
        return this.started;
    }

    @Override
    public boolean canLoadNewLibraries() {
        return false;
    }

    @Override
    public AsyncWork<Library, Exception> loadNewLibrary(String groupId, String artifactId, VersionSpecification version, boolean optional, byte priority, WorkProgress progress, long work) {
        return new AsyncWork<Object, Exception>(null, new Exception("DefaultLibrariesManager cannot load new libraries"));
    }

    @Override
    public IO.Readable getResourceFrom(ClassLoader cl, String path, byte priority) {
        InputStream in;
        if (cl instanceof IOProviderFromName.Readable) {
            try {
                return ((IOProviderFromName.Readable)((Object)cl)).provideReadableIO(path, priority);
            }
            catch (IOException e) {
                this.app.getDefaultLogger().info("Resource not found: " + path, e);
                return null;
            }
        }
        URL url = cl.getResource(path);
        if (url == null) {
            this.app.getDefaultLogger().info("Resource not found: " + path);
            return null;
        }
        try {
            in = url.openStream();
        }
        catch (Exception e) {
            this.app.getDefaultLogger().error("Unable to open resource " + path, e);
            return null;
        }
        TaskManager tm = null;
        if ("file".equals(url.getProtocol())) {
            tm = Threading.getDrivesTaskManager().getTaskManager(url.getFile());
        }
        if (tm == null) {
            tm = Threading.getUnmanagedTaskManager();
        }
        return new IOFromInputStream(in, path, tm, priority);
    }

    @Override
    public IO.Readable getResource(String groupId, String artifactId, String path, byte priority) {
        return this.getResourceFrom(this.getClass(), path, priority);
    }

    @Override
    public Library getLibrary(ClassLoader cl) {
        return null;
    }

    @Override
    public Library getLibrary(String groupId, String artifactId) {
        return null;
    }

    @Override
    public List<File> getLibrariesLocations() {
        String[] paths = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        ArrayList<File> list = new ArrayList<File>(paths.length);
        for (String path : paths) {
            File f;
            if ((path = path.trim()).length() == 0 || !(f = new File(path)).exists()) continue;
            list.add(f);
        }
        return list;
    }

    private class PluginsLoader
    extends Task.Cpu<Void, Exception> {
        public PluginsLoader() {
            super("Loading plugins files for libraries", (byte)4);
        }

        @Override
        public Void run() throws Exception {
            Enumeration<URL> urls = DefaultLibrariesManager.this.acl.getResources("META-INF/net.lecousin/plugins");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream input = url.openStream();
                IOFromInputStream io = new IOFromInputStream(input, url.toString(), Threading.getUnmanagedTaskManager(), 2);
                BufferedReadableCharacterStream stream = new BufferedReadableCharacterStream((IO.Readable)io, StandardCharsets.UTF_8, 256, 32);
                LoadLibraryPluginsFile load = new LoadLibraryPluginsFile(stream, DefaultLibrariesManager.this.acl);
                load.startOn(stream.canStartReading(), false);
                load.getOutput().blockThrow(0L);
            }
            return null;
        }
    }

    private class ExtensionPointsLoader
    extends Task.Cpu<Void, Exception> {
        public ExtensionPointsLoader() {
            super("Loading extensionpoints files for libraries", (byte)4);
        }

        @Override
        public Void run() throws Exception {
            Enumeration<URL> urls = DefaultLibrariesManager.this.acl.getResources("META-INF/net.lecousin/extensionpoints");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream input = url.openStream();
                IOFromInputStream io = new IOFromInputStream(input, url.toString(), Threading.getUnmanagedTaskManager(), 2);
                BufferedReadableCharacterStream stream = new BufferedReadableCharacterStream((IO.Readable)io, StandardCharsets.UTF_8, 256, 32);
                LoadLibraryExtensionPointsFile load = new LoadLibraryExtensionPointsFile(stream, DefaultLibrariesManager.this.acl);
                load.startOn(stream.canStartReading(), false);
                load.getOutput().blockThrow(0L);
            }
            return null;
        }
    }

    private class CustomExtensionPointLoader
    extends Task.Cpu<Void, Exception> {
        private CustomExtensionPoint ep;
        private String filePath;

        public CustomExtensionPointLoader(CustomExtensionPoint ep, String filePath) {
            super("Loading libraries' file " + filePath + " for extension point " + ep.getClass().getName(), (byte)4);
            this.ep = ep;
            this.filePath = filePath;
        }

        @Override
        public Void run() throws Exception {
            Enumeration<URL> urls = DefaultLibrariesManager.this.acl.getResources(this.filePath);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream input = url.openStream();
                IOFromInputStream io = new IOFromInputStream(input, url.toString(), Threading.getUnmanagedTaskManager(), 2);
                this.ep.loadPluginConfiguration(io, DefaultLibrariesManager.this.acl, new ISynchronizationPoint[0]).blockThrow(0L);
            }
            return null;
        }
    }

    private class Start
    extends Task.Cpu<Void, NoException> {
        private Start() {
            super("Start DefaultLibrariesManager", (byte)2);
        }

        @Override
        public Void run() {
            DefaultLibrariesManager.this.app.getDefaultLogger().info("Starting DefaultLibrariesManager with classpath = " + System.getProperty("java.class.path"));
            ExtensionPointsLoader extensionpoints = new ExtensionPointsLoader();
            extensionpoints.start();
            final LinkedList<Task.Output> tasks = new LinkedList<Task.Output>();
            tasks.add(extensionpoints.getOutput());
            for (CustomExtensionPoint custom : ExtensionPoints.getCustomExtensionPoints()) {
                String path = custom.getPluginConfigurationFilePath();
                if (path == null) continue;
                CustomExtensionPointLoader loader = new CustomExtensionPointLoader(custom, path);
                ((ISynchronizationPoint)tasks.getLast()).listenAsync(loader, false);
                tasks.add(loader.getOutput());
            }
            PluginsLoader plugins = new PluginsLoader();
            ((ISynchronizationPoint)tasks.getLast()).listenAsync(plugins, false);
            tasks.add(plugins.getOutput());
            ((ISynchronizationPoint)tasks.getLast()).listenAsync(new Task.Cpu<Void, NoException>("Finalize libraries loading", 4){

                @Override
                public Void run() {
                    for (ISynchronizationPoint task : tasks) {
                        if (task.isSuccessful()) continue;
                        DefaultLibrariesManager.this.started.error(task.getError());
                        return null;
                    }
                    ExtensionPoints.allPluginsLoaded();
                    DefaultLibrariesManager.this.started.unblock();
                    return null;
                }
            }, true);
            return null;
        }
    }
}

