/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries;

import java.io.IOException;
import net.lecousin.framework.application.ApplicationClassLoader;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.io.text.FullReadLines;
import net.lecousin.framework.plugins.ExtensionPoints;
import net.lecousin.framework.plugins.Plugin;
import net.lecousin.framework.util.UnprotectedStringBuffer;

public class LoadLibraryPluginsFile
extends FullReadLines<Void> {
    private ApplicationClassLoader classLoader;

    public LoadLibraryPluginsFile(BufferedReadableCharacterStream stream, ApplicationClassLoader classLoader) {
        super("Initializing plugins: " + stream.getDescription(), stream, (byte)2, IO.OperationType.ASYNCHRONOUS);
        this.classLoader = classLoader;
    }

    @Override
    protected void processLine(UnprotectedStringBuffer line) throws IOException {
        int i = line.indexOf(':');
        if (i < 0) {
            if (line.length() > 0 && this.classLoader.getApplication().getDefaultLogger().warn()) {
                this.classLoader.getApplication().getDefaultLogger().warn("Warning: plugins file " + this.getSourceDescription() + " contains an invalid line: " + line);
            }
            return;
        }
        UnprotectedStringBuffer s = line.substring(0, i);
        s.trim();
        String epName = s.asString();
        s = line.substring(i + 1);
        s.trim();
        String piName = s.asString();
        if (this.classLoader.getApplication().getDefaultLogger().debug()) {
            this.classLoader.getApplication().getDefaultLogger().debug("Plugin " + piName + " found for extension point " + epName);
        }
        try {
            Class<?> cl = Class.forName(piName, true, this.classLoader);
            if (!Plugin.class.isAssignableFrom(cl)) {
                throw new Exception("Invalid plugin class: " + line.asString() + " must extend Plugin");
            }
            Plugin pi = (Plugin)cl.newInstance();
            ExtensionPoints.add(epName, pi);
        }
        catch (Exception e) {
            throw new IOException("Error loading plugins of library: " + this.getSourceDescription(), e);
        }
    }

    @Override
    protected Void generateResult() {
        return null;
    }
}

