/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections.map;

import net.lecousin.framework.collections.map.IntegerMap;
import net.lecousin.framework.collections.sort.RedBlackTreeInteger;

public class IntegerMapRBT<T>
implements IntegerMap<T> {
    private RedBlackTreeInteger<T>[] buckets;
    private int size = 0;

    public IntegerMapRBT(int nbBuckets) {
        this.buckets = new RedBlackTreeInteger[nbBuckets];
    }

    protected int hash(int key) {
        int h = key % this.buckets.length;
        if (h < 0) {
            return -h;
        }
        return h;
    }

    @Override
    public T put(int key, T entry) {
        int h = this.hash(key);
        RedBlackTreeInteger<T> bucket = this.buckets[h];
        if (bucket == null) {
            bucket = new RedBlackTreeInteger();
            this.buckets[h] = bucket;
            bucket.add(key, entry);
            ++this.size;
            return null;
        }
        RedBlackTreeInteger.Node<T> node = bucket.get(key);
        if (node == null) {
            bucket.add(key, entry);
            ++this.size;
            return null;
        }
        T previous = node.getElement();
        node.setElement(entry);
        return previous;
    }

    @Override
    public T get(int key) {
        int h = this.hash(key);
        RedBlackTreeInteger<T> bucket = this.buckets[h];
        if (bucket == null) {
            return null;
        }
        RedBlackTreeInteger.Node<T> node = bucket.get(key);
        if (node == null) {
            return null;
        }
        return node.getElement();
    }

    @Override
    public T remove(int key) {
        int h = this.hash(key);
        RedBlackTreeInteger<T> bucket = this.buckets[h];
        if (bucket == null) {
            return null;
        }
        RedBlackTreeInteger.Node<T> node = bucket.get(key);
        if (node == null) {
            return null;
        }
        bucket.remove(node);
        --this.size;
        return node.getElement();
    }

    @Override
    public boolean containsKey(int key) {
        int h = this.hash(key);
        RedBlackTreeInteger<T> bucket = this.buckets[h];
        if (bucket == null) {
            return false;
        }
        return bucket.containsKey(key);
    }

    @Override
    public int size() {
        return this.size;
    }
}

