/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections.map;

import net.lecousin.framework.collections.map.LongMap;
import net.lecousin.framework.collections.sort.RedBlackTreeLong;

public class LongMapRBT<T>
implements LongMap<T> {
    private RedBlackTreeLong<T>[] buckets;
    private int size = 0;

    public LongMapRBT(int nbBuckets) {
        this.buckets = new RedBlackTreeLong[nbBuckets];
    }

    protected int hash(long key) {
        int h = (int)(key % (long)this.buckets.length);
        if (h < 0) {
            return -h;
        }
        return h;
    }

    @Override
    public T put(long key, T entry) {
        int h = this.hash(key);
        RedBlackTreeLong<T> bucket = this.buckets[h];
        if (bucket == null) {
            bucket = new RedBlackTreeLong();
            this.buckets[h] = bucket;
            bucket.add(key, entry);
            ++this.size;
            return null;
        }
        RedBlackTreeLong.Node<T> node = bucket.get(key);
        if (node == null) {
            bucket.add(key, entry);
            ++this.size;
            return null;
        }
        T previous = node.getElement();
        node.setElement(entry);
        return previous;
    }

    @Override
    public T get(long key) {
        int h = this.hash(key);
        RedBlackTreeLong<T> bucket = this.buckets[h];
        if (bucket == null) {
            return null;
        }
        RedBlackTreeLong.Node<T> node = bucket.get(key);
        if (node == null) {
            return null;
        }
        return node.getElement();
    }

    @Override
    public T remove(long key) {
        int h = this.hash(key);
        RedBlackTreeLong<T> bucket = this.buckets[h];
        if (bucket == null) {
            return null;
        }
        RedBlackTreeLong.Node<T> node = bucket.get(key);
        if (node == null) {
            return null;
        }
        bucket.remove(node);
        --this.size;
        return node.getElement();
    }

    @Override
    public boolean containsKey(long key) {
        int h = this.hash(key);
        RedBlackTreeLong<T> bucket = this.buckets[h];
        if (bucket == null) {
            return false;
        }
        return bucket.containsKey(key);
    }

    @Override
    public int size() {
        return this.size;
    }
}

