/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.collections.map.MapUtil;
import net.lecousin.framework.concurrent.MonoThreadTaskManager;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.TaskPriorityManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.util.Pair;

public class DrivesTaskManager {
    private ThreadFactory threadFactory;
    private Class<? extends TaskPriorityManager> taskPriorityManager;
    private Map<String, Object> rootResources;
    private Map<String, MonoThreadTaskManager> rootManagers;
    private Map<Object, MonoThreadTaskManager> managers;
    private DrivesProvider drivesProvider = null;

    public DrivesTaskManager(ThreadFactory threadFactory, Class<? extends TaskPriorityManager> taskPriorityManager, DrivesProvider drivesProvider) {
        this.threadFactory = threadFactory;
        this.taskPriorityManager = taskPriorityManager;
        this.rootResources = new HashMap<String, Object>();
        this.rootManagers = new HashMap<String, MonoThreadTaskManager>();
        this.managers = new HashMap<Object, MonoThreadTaskManager>();
        if (drivesProvider == null) {
            for (File root : File.listRoots()) {
                String path = root.getAbsolutePath();
                if (path.charAt(path.length() - 1) != File.separatorChar) {
                    path = path + File.separatorChar;
                }
                Object resource = new Object();
                MonoThreadTaskManager tm = new MonoThreadTaskManager("Drive " + path, resource, threadFactory, taskPriorityManager);
                tm.start();
                this.rootResources.put(path, resource);
                this.rootManagers.put(path, tm);
                this.managers.put(resource, tm);
                Threading.registerResource(resource, tm);
            }
        } else {
            this.setDrivesProvider(drivesProvider);
        }
    }

    public Object getResource(File file) {
        return this.getResource(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResource(String path) {
        Map<String, MonoThreadTaskManager> map = this.rootManagers;
        synchronized (map) {
            for (Map.Entry<String, Object> e : this.rootResources.entrySet()) {
                if (!path.startsWith(e.getKey())) continue;
                return e.getValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getResources() {
        Map<Object, MonoThreadTaskManager> map = this.managers;
        synchronized (map) {
            return new ArrayList<Object>(this.managers.keySet());
        }
    }

    public TaskManager getTaskManager(File file) {
        return this.getTaskManager(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskManager getTaskManager(String path) {
        Map<String, MonoThreadTaskManager> map = this.rootManagers;
        synchronized (map) {
            for (Map.Entry<String, MonoThreadTaskManager> e : this.rootManagers.entrySet()) {
                if (!path.startsWith(e.getKey())) continue;
                return e.getValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public void setDrivesProvider(DrivesProvider provider) throws IllegalStateException {
        DrivesTaskManager drivesTaskManager = this;
        synchronized (drivesTaskManager) {
            if (this.drivesProvider != null) {
                throw new IllegalStateException();
            }
            this.drivesProvider = provider;
        }
        this.drivesProvider.provide(d -> this.newDrive((Pair<Object, List<File>>)d), d -> this.driveRemoved((Pair<Object, List<File>>)d), p -> this.newPartition((Pair<Object, File>)p), p -> this.partitionRemoved((Pair<Object, File>)p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newDrive(Pair<Object, List<File>> driveAndPartitions) {
        Object drive = driveAndPartitions.getValue1();
        MonoThreadTaskManager tm = new MonoThreadTaskManager("Drive " + drive.toString(), drive, this.threadFactory, this.taskPriorityManager);
        tm.start();
        Map<Object, MonoThreadTaskManager> map = this.managers;
        synchronized (map) {
            this.managers.put(drive, tm);
        }
        Threading.registerResource(drive, tm);
        List<File> partitions = driveAndPartitions.getValue2();
        if (partitions == null || partitions.isEmpty()) {
            return;
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (File mount : partitions) {
            MonoThreadTaskManager previous;
            String path = mount.getAbsolutePath();
            if (path.charAt(path.length() - 1) != File.separatorChar) {
                path = path + File.separatorChar;
            }
            paths.add(path);
            Map<String, MonoThreadTaskManager> map2 = this.rootManagers;
            synchronized (map2) {
                previous = this.rootManagers.get(path);
                if (previous != null) {
                    Threading.unregisterResource(this.rootResources.get(path));
                    this.rootManagers.remove(path);
                    this.rootResources.remove(path);
                    this.rootManagers.put(path, tm);
                    this.rootResources.put(path, drive);
                } else {
                    this.rootManagers.put(path, tm);
                    this.rootResources.put(path, drive);
                }
            }
            if (previous == null) continue;
            previous.transferAndClose(tm);
        }
        StringBuilder name = new StringBuilder();
        name.append(tm.getName()).append(" (");
        for (int i = 0; i < paths.size(); ++i) {
            if (i > 0) {
                name.append(" + ");
            }
            name.append((String)paths.get(i));
        }
        name.append(')');
        tm.setName(name.toString());
        Threading.logger.info("Task manager added: " + name.toString());
        tm.started();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void driveRemoved(Pair<Object, List<File>> driveAndPartitions) {
        MonoThreadTaskManager tm;
        Object drive = driveAndPartitions.getValue1();
        Map<Object, MonoThreadTaskManager> map = this.managers;
        synchronized (map) {
            tm = this.managers.remove(drive);
        }
        if (tm != null) {
            Threading.unregisterResource(drive);
            map = this.rootManagers;
            synchronized (map) {
                MapUtil.removeValue(this.rootManagers, tm);
                MapUtil.removeValue(this.rootResources, drive);
            }
            tm.cancelAndStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newPartition(Pair<Object, File> driveAndPartition) {
        MonoThreadTaskManager previous;
        MonoThreadTaskManager tm;
        Object drive = driveAndPartition.getValue1();
        File mount = driveAndPartition.getValue2();
        String path = mount.getAbsolutePath();
        if (path.charAt(path.length() - 1) != File.separatorChar) {
            path = path + File.separatorChar;
        }
        Map<Object, MonoThreadTaskManager> map = this.managers;
        synchronized (map) {
            tm = this.managers.get(drive);
        }
        if (tm == null) {
            Threading.logger.error("Cannot handle partition " + mount.getAbsolutePath() + " because drive is unknown: " + drive);
            return;
        }
        Map<String, MonoThreadTaskManager> map2 = this.rootManagers;
        synchronized (map2) {
            previous = this.rootManagers.get(path);
            if (previous != null) {
                this.rootManagers.remove(path);
                this.rootResources.remove(path);
                this.rootManagers.put(path, tm);
                Object prevResource = this.rootResources.put(path, drive);
                if (!this.rootResources.containsValue(prevResource)) {
                    Threading.unregisterResource(prevResource);
                }
            } else {
                this.rootManagers.put(path, tm);
                this.rootResources.put(path, drive);
            }
        }
        if (previous != null && previous != tm) {
            previous.transferAndClose(tm);
        }
        Threading.logger.info("New partition added to DrivesTaskManager: " + mount.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partitionRemoved(Pair<Object, File> driveAndPartition) {
        String path = driveAndPartition.getValue2().getAbsolutePath();
        if (path.charAt(path.length() - 1) != File.separatorChar) {
            path = path + File.separatorChar;
        }
        Map<String, MonoThreadTaskManager> map = this.rootManagers;
        synchronized (map) {
            Threading.unregisterResource(this.rootResources.get(path));
            this.rootManagers.remove(path);
            this.rootResources.remove(path);
        }
    }

    public static interface DrivesProvider {
        public void provide(Listener<Pair<Object, List<File>>> var1, Listener<Pair<Object, List<File>>> var2, Listener<Pair<Object, File>> var3, Listener<Pair<Object, File>> var4);
    }
}

