/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.log.Logger;

public final class FileSystemWatcher {
    private FileSystemWatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Runnable watch(Path path, PathEventListener listener, WatchEvent.Kind<?> ... kinds) throws IOException {
        Class<FileSystemWatcher> clazz = FileSystemWatcher.class;
        synchronized (FileSystemWatcher.class) {
            Application app = LCCore.getApplication();
            Watcher watcher = app.getInstance(Watcher.class);
            if (watcher == null || watcher.stop) {
                watcher = new Watcher(app);
                app.setInstance(Watcher.class, watcher);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return watcher.watch(path, listener, kinds);
        }
    }

    public static Runnable watch(Path path, PathEventListener listener) throws IOException {
        return FileSystemWatcher.watch(path, listener, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    private static class Watcher
    extends Thread
    implements Closeable {
        private Application app;
        private WatchService service;
        private boolean stop = false;
        private Logger logger;
        private static HashMap<WatchKey, Listening> keys = new HashMap();

        public Watcher(Application app) throws IOException {
            super("FileSystem Watcher");
            this.logger = app.getLoggerFactory().getLogger(FileSystemWatcher.class);
            this.service = FileSystems.getDefault().newWatchService();
            this.app = app;
            this.start();
            app.toClose(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Runnable watch(Path path, PathEventListener listener, WatchEvent.Kind<?>[] kinds) throws IOException {
            WatchKey key;
            Listening listening = new Listening();
            listening.path = path;
            listening.listener = listener;
            HashMap<WatchKey, Listening> hashMap = keys;
            synchronized (hashMap) {
                key = path.register(this.service, kinds);
                keys.put(key, listening);
            }
            return new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    key.cancel();
                    Class<FileSystemWatcher> clazz = FileSystemWatcher.class;
                    synchronized (FileSystemWatcher.class) {
                        HashMap hashMap = keys;
                        synchronized (hashMap) {
                            keys.remove(key);
                            if (keys.isEmpty()) {
                                this.close();
                            }
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                Listening l;
                WatchKey key;
                try {
                    key = this.service.take();
                }
                catch (InterruptedException x) {
                    break;
                }
                catch (ClosedWatchServiceException x) {
                    break;
                }
                HashMap<WatchKey, Listening> hashMap = keys;
                synchronized (hashMap) {
                    l = keys.get(key);
                }
                if (l == null) continue;
                for (WatchEvent watchEvent : key.pollEvents()) {
                    WatchEvent.Kind kind = watchEvent.kind();
                    if (StandardWatchEventKinds.OVERFLOW.equals(kind)) continue;
                    WatchEvent ev = watchEvent;
                    Path name = (Path)ev.context();
                    if (StandardWatchEventKinds.ENTRY_CREATE.equals(kind)) {
                        if (this.logger.debug()) {
                            this.logger.debug("File " + name.toString() + " created into " + l.path.toString());
                        }
                        try {
                            l.listener.fileCreated(l.path, name.toString());
                        }
                        catch (Throwable t) {
                            if (!this.logger.error()) continue;
                            this.logger.error("Exception thrown by FileSystemWatcher listener " + l.listener, t);
                        }
                        continue;
                    }
                    if (StandardWatchEventKinds.ENTRY_DELETE.equals(kind)) {
                        if (this.logger.debug()) {
                            this.logger.debug("File " + name.toString() + " removed from " + l.path.toString());
                        }
                        try {
                            l.listener.fileRemoved(l.path, name.toString());
                        }
                        catch (Throwable t) {
                            if (!this.logger.error()) continue;
                            this.logger.error("Exception thrown by FileSystemWatcher listener " + l.listener, t);
                        }
                        continue;
                    }
                    if (!StandardWatchEventKinds.ENTRY_MODIFY.equals(kind)) continue;
                    if (this.logger.debug()) {
                        this.logger.debug("File " + name.toString() + " modified into " + l.path.toString());
                    }
                    try {
                        l.listener.fileModified(l.path, name.toString());
                    }
                    catch (Throwable t) {
                        if (!this.logger.error()) continue;
                        this.logger.error("Exception thrown by FileSystemWatcher listener " + l.listener, t);
                    }
                }
                boolean valid = key.reset();
                if (valid) continue;
                HashMap<WatchKey, Listening> hashMap2 = keys;
                synchronized (hashMap2) {
                    keys.remove(key);
                    if (keys.isEmpty()) {
                        this.close();
                    }
                }
            }
            this.app.closed(this);
            this.stop = true;
            try {
                this.service.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void close() {
            this.stop = true;
            try {
                this.service.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private static class Listening {
            public Path path;
            public PathEventListener listener;

            private Listening() {
            }
        }
    }

    public static interface PathEventListener {
        public void fileCreated(Path var1, String var2);

        public void fileRemoved(Path var1, String var2);

        public void fileModified(Path var1, String var2);
    }
}

