/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.concurrent.FixedThreadTaskManager;
import net.lecousin.framework.concurrent.TaskPriorityManager;
import net.lecousin.framework.concurrent.TaskWorker;

public class MultiThreadTaskManager
extends FixedThreadTaskManager {
    private TaskWorker[] workers;
    private int workerCount = 1;

    public MultiThreadTaskManager(String name, Object resource, int nbThreads, ThreadFactory threadFactory, Class<? extends TaskPriorityManager> taskPriorityManager) {
        super(name, resource, nbThreads, threadFactory, taskPriorityManager);
        this.workers = new TaskWorker[nbThreads];
        for (int i = 0; i < nbThreads; ++i) {
            this.workers[i] = new TaskWorker(name + " - Worker " + this.workerCount++, this);
        }
    }

    @Override
    public void start() {
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].thread.start();
        }
    }

    @Override
    protected TaskWorker[] getWorkers() {
        return this.workers;
    }

    @Override
    protected void forceStopWorkers() {
        for (int i = this.getNbThreads() - 1; i >= 0; --i) {
            this.workers[i].forceStop();
        }
    }

    @Override
    protected void finishAndStopWorkers() {
        for (int i = this.getNbThreads() - 1; i >= 0; --i) {
            this.workers[i].finishAndStop();
        }
    }

    @Override
    boolean isStopped() {
        for (int i = this.getNbThreads() - 1; i >= 0; --i) {
            if (!this.workers[i].thread.isAlive()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected TaskWorker createWorker() {
        return new TaskWorker(this.getName() + " - Worker " + this.workerCount++, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replaceWorkerBySpare(TaskWorker currentWorker, TaskWorker spareWorker) {
        TaskWorker[] taskWorkerArray = this.workers;
        synchronized (this.workers) {
            for (int i = this.getNbThreads() - 1; i >= 0; --i) {
                if (this.workers[i] != currentWorker) continue;
                this.workers[i] = spareWorker;
                break;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

