/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import net.lecousin.framework.concurrent.BlockedThreadHandler;
import net.lecousin.framework.concurrent.FixedThreadTaskManager;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.util.DebugUtil;

class TaskWorker
implements Runnable,
BlockedThreadHandler {
    boolean stop = false;
    boolean finish = false;
    FixedThreadTaskManager manager;
    Task<?, ?> currentTask = null;
    long currentTaskStart = -1L;
    long tasksDone = 0L;
    long workingTime = 0L;
    long waitingTime = 0L;
    long blockedTime = 0L;
    long lastUsed = -1L;
    Thread thread;
    boolean aside = false;
    boolean blocked = false;

    TaskWorker(String name, FixedThreadTaskManager manager) {
        this.manager = manager;
        this.thread = manager.newThread(this);
        this.thread.setName(name);
        Threading.registerBlockedThreadHandler(this, this.thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    void forceStop() {
        this.stop = true;
        TaskWorker taskWorker = this;
        synchronized (taskWorker) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    void finishAndStop() {
        this.finish = true;
        TaskWorker taskWorker = this;
        synchronized (taskWorker) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT", "ML_SYNC_ON_UPDATED_FIELD", "ML_SYNC_ON_FIELD_TO_GUARD_CHANGING_THAT_FIELD"})
    public void run() {
        ClassLoader initCL = this.thread.getContextClassLoader();
        while (!this.stop) {
            AsyncWork<TaskWorker, NoException> waitPause = this.manager.getPauseToDo();
            if (waitPause != null) {
                TaskWorker taskWorker = this;
                synchronized (taskWorker) {
                    waitPause.unblockSuccess(this);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            this.currentTaskStart = System.nanoTime();
            this.currentTask = this.manager.peekNextOrWait();
            if (this.currentTask == null) {
                this.waitingTime += System.nanoTime() - this.currentTaskStart;
                if (!this.finish) continue;
                this.stop = true;
                continue;
            }
            Task<?, ?> task = this.currentTask;
            synchronized (task) {
                this.currentTask.status = (byte)3;
                this.currentTask.nextExecution = 0L;
            }
            this.thread.setContextClassLoader(this.currentTask.getApplication().getClassLoader());
            long start = System.nanoTime();
            this.currentTask.execute();
            if (Threading.traceTaskTime) {
                Threading.logger.debug("Task done in " + (System.nanoTime() - start) + "ns: " + this.currentTask.description);
            }
            this.lastUsed = System.currentTimeMillis();
            this.thread.setContextClassLoader(initCL);
            Task<?, ?> t = this.currentTask;
            this.currentTask = null;
            ++this.tasksDone;
            t.rescheduleIfNeeded();
            this.workingTime += System.nanoTime() - start;
            if (!this.aside) continue;
            this.manager.asideWorkerDone(this);
            break;
        }
        Threading.unregisterBlockedThreadHandler(this.thread);
        StringBuilder s = new StringBuilder();
        this.printStats(s);
        System.out.print(s.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blocked(ISynchronizationPoint<?> blockPoint, long blockTimeout) {
        long start = System.nanoTime();
        this.manager.imBlocked(this);
        long start2 = System.nanoTime();
        ISynchronizationPoint<?> iSynchronizationPoint = blockPoint;
        synchronized (iSynchronizationPoint) {
            if (blockTimeout <= 0L) {
                while (!blockPoint.isUnblocked()) {
                    try {
                        blockPoint.wait(0L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            } else if (!blockPoint.isUnblocked()) {
                try {
                    blockPoint.wait(blockTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.blockedTime += System.nanoTime() - start2;
        this.manager.imUnblocked(this, start2);
        long end = System.nanoTime();
        this.workingTime -= end - start;
        this.waitingTime += end - start;
        if (end - start > 100000000L && Threading.logger.debug()) {
            StackTraceElement[] stack = this.thread.getStackTrace();
            ArrayList<String> blocking = new ArrayList<String>(stack.length - 2);
            for (int i = 2; i < stack.length; ++i) {
                StackTraceElement e = stack[i];
                String c = e.getClassName();
                blocking.add(e.getFileName() + ":" + c + "." + e.getMethodName() + ":" + e.getLineNumber());
            }
            StringBuilder s = new StringBuilder();
            s.append("Task ").append(this.currentTask.description).append(" has been blocked for ").append((end - start) / 1000000L).append("ms. consider to split it into several tasks: ");
            for (String b : blocking) {
                s.append("\r\n - ").append(b);
            }
            Threading.logger.debug(s.toString());
        }
    }

    public void debug(StringBuilder s, String type) {
        s.append(" - ").append(type).append(' ').append(this.thread.getName()).append(": ");
        Task<?, ?> c = this.currentTask;
        if (c == null) {
            s.append("waiting");
        } else {
            s.append("executing ").append(c.description).append(" (").append(c.getClass().getName()).append(")");
        }
        s.append("\r\n");
        if (c != null) {
            DebugUtil.createStackTrace(s, this.thread.getStackTrace());
            s.append("\r\n");
        }
    }

    public void printStats(StringBuilder s) {
        s.append(this.thread.getName());
        while (s.length() < 30) {
            s.append(' ');
        }
        s.append(": ");
        s.append(this.tasksDone);
        while (s.length() < 45) {
            s.append(' ');
        }
        s.append(" tasks done in ");
        s.append((double)this.workingTime / 1.0E9);
        while (s.length() < 80) {
            s.append(' ');
        }
        s.append(" waited ");
        s.append((double)this.waitingTime / 1.0E9);
        s.append(" blocked ");
        s.append((double)this.blockedTime / 1.0E9);
        s.append("\r\n");
    }
}

