/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.util.LinkedList;
import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.TaskPriorityManager;

public class ThreadPoolTaskManager
extends TaskManager {
    private int maxThreads;
    private LinkedList<Worker> activeThreads = new LinkedList();
    private long tasksDone = 0L;
    private long tasksTime = 0L;

    public ThreadPoolTaskManager(String name, Object resource, int maxThreads, ThreadFactory threadFactory, Class<? extends TaskPriorityManager> taskPriorityManager) {
        super(name, resource, threadFactory, taskPriorityManager);
        this.maxThreads = maxThreads > 0 ? maxThreads : 100;
    }

    @Override
    void start() {
    }

    @Override
    void started() {
    }

    @Override
    protected void finishAndStopThreads() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void forceStopThreads() {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            for (Worker w : this.activeThreads) {
                w.forceStop = true;
            }
            this.taskPriorityManager.notifyAll();
        }
    }

    @Override
    protected void finishTransfer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isStopped() {
        boolean stopped;
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            stopped = this.activeThreads.isEmpty();
        }
        if (stopped) {
            StringBuilder s = new StringBuilder();
            this.printStats(s);
            System.out.println(s.toString());
        }
        return stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void add(Task<?, ?> t) {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            if (this.activeThreads.size() < this.maxThreads) {
                this.activeThreads.add(new Worker(t));
            } else {
                this.taskPriorityManager.add(t);
            }
        }
    }

    @Override
    public void debug(StringBuilder s) {
        try {
            s.append("Thread pool ").append(this.getName()).append(": ").append(this.activeThreads.size()).append('/').append(this.maxThreads).append(" active threads\r\n");
            for (Worker w : this.activeThreads) {
                s.append(" - ").append(w.task != null ? w.task.getDescription() : "waiting").append("\r\n");
            }
        }
        catch (Throwable t) {
            s.append("\r\n...");
        }
    }

    @Override
    public void printStats(StringBuilder s) {
        s.append("Thread pool ").append(this.getName()).append(": ");
        s.append(this.tasksDone).append(" tasks done in ").append((double)this.tasksTime / 1.0E9).append("s.");
    }

    private class Worker
    implements Runnable {
        private Task<?, ?> task;
        private boolean forceStop = false;

        public Worker(Task<?, ?> task) {
            this.task = task;
            Thread t = ThreadPoolTaskManager.this.threadFactory.newThread(this);
            t.setUncaughtExceptionHandler(new UncaughtExceptionHandler(this));
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                long start = System.nanoTime();
                this.task.execute();
                this.task.rescheduleIfNeeded();
                TaskPriorityManager taskPriorityManager = ThreadPoolTaskManager.this.taskPriorityManager;
                synchronized (taskPriorityManager) {
                    ThreadPoolTaskManager.this.tasksDone++;
                    ThreadPoolTaskManager.this.tasksTime = ThreadPoolTaskManager.this.tasksTime + (System.nanoTime() - start);
                    this.task = this.forceStop ? null : ThreadPoolTaskManager.this.taskPriorityManager.peekNext();
                    if (this.task == null) {
                        ThreadPoolTaskManager.this.activeThreads.remove(this);
                        break;
                    }
                }
            }
        }
    }

    private class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private Worker worker;

        public UncaughtExceptionHandler(Worker worker) {
            this.worker = worker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (this.worker.task != null && !this.worker.task.isDone()) {
                CancelException reason;
                ((Worker)this.worker).task.cancelling = reason = new CancelException("Unexpected error in thread " + t.getName(), e);
                ((Worker)this.worker).task.result.cancelled(reason);
            }
            TaskPriorityManager taskPriorityManager = ThreadPoolTaskManager.this.taskPriorityManager;
            synchronized (taskPriorityManager) {
                ThreadPoolTaskManager.this.activeThreads.remove(this.worker);
                Task<?, ?> task = ThreadPoolTaskManager.this.taskPriorityManager.peekNext();
                if (task != null) {
                    ThreadPoolTaskManager.this.activeThreads.add(new Worker(task));
                }
            }
            LCCore.getApplication().getDefaultLogger().error("Error in Worker " + t.getName(), e);
        }
    }
}

