/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.synch;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.BlockedThreadHandler;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;

public class WaitingDataQueueSynchronizationPoint<DataType, TError extends Exception>
implements ISynchronizationPoint<TError> {
    private TurnArray<DataType> waitingData = new TurnArray();
    private TError error = null;
    private CancelException cancel = null;
    private boolean end = false;
    private ArrayList<Runnable> listeners = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataType waitForData(long timeout) {
        long start = System.currentTimeMillis();
        do {
            BlockedThreadHandler blockedHandler;
            WaitingDataQueueSynchronizationPoint waitingDataQueueSynchronizationPoint = this;
            synchronized (waitingDataQueueSynchronizationPoint) {
                if (this.cancel != null) {
                    return null;
                }
                if (this.error != null) {
                    return null;
                }
                if (!this.waitingData.isEmpty()) {
                    return this.waitingData.removeFirst();
                }
                if (this.end) {
                    return null;
                }
                Thread t = Thread.currentThread();
                blockedHandler = Threading.getBlockedThreadHandler(t);
                if (blockedHandler == null) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                }
            }
            if (blockedHandler == null) continue;
            blockedHandler.blocked(this, timeout);
        } while (timeout <= 0L || System.currentTimeMillis() - start < timeout);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void newDataReady(DataType data) {
        ArrayList<Runnable> list;
        Object object = this;
        synchronized (object) {
            if (this.end) {
                throw new IllegalStateException("method endOfData already called, method newDataReady is not allowed anymore");
            }
            this.waitingData.addLast(data);
            list = this.listeners;
            this.listeners = null;
        }
        if (list != null) {
            for (Runnable listener : list) {
                listener.run();
            }
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void endOfData() {
        ArrayList<Runnable> list = null;
        Object object = this;
        synchronized (object) {
            this.end = true;
            if (this.waitingData.isEmpty()) {
                list = this.listeners;
                this.listeners = null;
            }
        }
        if (list != null) {
            for (Runnable listener : list) {
                listener.run();
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    @Override
    public Collection<?> getAllListeners() {
        if (this.listeners == null) {
            return new ArrayList(0);
        }
        return new ArrayList<Runnable>(this.listeners);
    }

    @Override
    public boolean isUnblocked() {
        return !this.waitingData.isEmpty() || this.cancel != null || this.error != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void block(long timeout) {
        long start = System.currentTimeMillis();
        do {
            BlockedThreadHandler blockedHandler;
            WaitingDataQueueSynchronizationPoint waitingDataQueueSynchronizationPoint = this;
            synchronized (waitingDataQueueSynchronizationPoint) {
                if (this.cancel != null) {
                    return;
                }
                if (this.error != null) {
                    return;
                }
                if (!this.waitingData.isEmpty()) {
                    return;
                }
                Thread t = Thread.currentThread();
                blockedHandler = Threading.getBlockedThreadHandler(t);
                if (blockedHandler == null) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            if (blockedHandler == null) continue;
            blockedHandler.blocked(this, timeout);
        } while (timeout <= 0L || System.currentTimeMillis() - start < timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockPause(long logAfter) {
        WaitingDataQueueSynchronizationPoint waitingDataQueueSynchronizationPoint = this;
        synchronized (waitingDataQueueSynchronizationPoint) {
            if (this.waitingData.isEmpty()) {
                while (true) {
                    long start = System.currentTimeMillis();
                    try {
                        this.wait(logAfter + 1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    if (System.currentTimeMillis() - start <= logAfter) break;
                    System.err.println("Still blocked after " + logAfter / 1000L + "s.");
                    new Exception("").printStackTrace(System.err);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listenInline(Runnable listener) {
        WaitingDataQueueSynchronizationPoint waitingDataQueueSynchronizationPoint = this;
        synchronized (waitingDataQueueSynchronizationPoint) {
            if (this.waitingData.isEmpty()) {
                if (this.listeners == null) {
                    this.listeners = new ArrayList();
                }
                this.listeners.add(listener);
                return;
            }
        }
        listener.run();
    }

    @Override
    public boolean isCancelled() {
        return this.cancel != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(CancelException reason) {
        ArrayList<Runnable> list;
        this.cancel = reason;
        WaitingDataQueueSynchronizationPoint waitingDataQueueSynchronizationPoint = this;
        synchronized (waitingDataQueueSynchronizationPoint) {
            this.notify();
            list = this.listeners;
            this.listeners = null;
        }
        if (list != null) {
            for (Runnable listener : list) {
                listener.run();
            }
        }
    }

    @Override
    public CancelException getCancelEvent() {
        return this.cancel;
    }

    @Override
    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public TError getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(TError error) {
        ArrayList<Runnable> list;
        this.error = error;
        WaitingDataQueueSynchronizationPoint waitingDataQueueSynchronizationPoint = this;
        synchronized (waitingDataQueueSynchronizationPoint) {
            this.notify();
            list = this.listeners;
            this.listeners = null;
        }
        if (list != null) {
            for (Runnable listener : list) {
                listener.run();
            }
        }
    }
}

