/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.io.util.FileInfo;
import net.lecousin.framework.progress.WorkProgress;

public class DirectoryReader
extends Task.OnFile<Result, AccessDeniedException> {
    private File dir;
    private Request request;
    private WorkProgress progress;

    public DirectoryReader(File dir, byte priority, Request request, WorkProgress progress) {
        super(dir, "Reading directory " + dir.getAbsolutePath(), priority);
        this.dir = dir;
        this.request = request;
        this.progress = progress;
        if (progress != null) {
            WorkProgress.linkTo(progress, this);
        }
    }

    public DirectoryReader(File dir, byte priority, Request request) {
        this(dir, priority, request, null);
    }

    public File getDirectory() {
        return this.dir;
    }

    @Override
    public Result run() throws AccessDeniedException {
        File[] list = this.dir.listFiles();
        if (list == null) {
            throw new AccessDeniedException("Directory " + this.dir.getAbsolutePath());
        }
        if (this.progress != null) {
            this.progress.progress(this.progress.getRemainingWork() / 2L);
        }
        Result result = new Result();
        int len = list.length;
        if (len == 0) {
            result.files = new FileInfo[0];
            return result;
        }
        result.files = new FileInfo[list.length];
        long work = this.progress != null ? this.progress.getRemainingWork() : 0L;
        int nb = list.length;
        for (int i = 0; i < list.length; ++i) {
            BasicFileAttributes attr;
            FileInfo f;
            long step = work / (long)nb--;
            work -= step;
            result.files[i] = f = new FileInfo();
            f.file = list[i];
            f.path = f.file.toPath();
            try {
                attr = Files.readAttributes(f.path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException e) {
                if (this.progress != null) {
                    this.progress.progress(step);
                }
                this.getApplication().getDefaultLogger().error("Cannot get basic file attributes on " + f.file.getAbsolutePath(), e);
                continue;
            }
            if (attr.isDirectory()) {
                f.isDirectory = true;
                ++result.nbDirectories;
            } else {
                f.isDirectory = false;
                ++result.nbFiles;
                if (this.request != null && this.request.getSize) {
                    f.size = attr.size();
                }
            }
            if (this.request != null) {
                if (this.request.getLastModified) {
                    f.lastModified = attr.lastModifiedTime().toMillis();
                }
                if (this.request.getLastAccess) {
                    f.lastAccess = attr.lastAccessTime().toMillis();
                }
                if (this.request.getCreation) {
                    f.creation = attr.creationTime().toMillis();
                }
                if (this.request.getIsSymbolicLink) {
                    f.isSymbolicLink = attr.isSymbolicLink();
                }
            }
            if (this.progress == null) continue;
            this.progress.progress(step);
        }
        return result;
    }

    public static class ListSubDirectories
    extends Task.OnFile<ArrayList<File>, AccessDeniedException> {
        private File dir;

        public ListSubDirectories(File dir, byte priority) {
            super(dir, "Listing sub directories", priority);
            this.dir = dir;
        }

        @Override
        public ArrayList<File> run() throws AccessDeniedException {
            String[] names = this.dir.list();
            if (names == null) {
                throw new AccessDeniedException("Directory " + this.dir.getAbsolutePath());
            }
            ArrayList<File> result = new ArrayList<File>();
            for (int i = 0; i < names.length; ++i) {
                File f = new File(this.dir, names[i]);
                if (!f.isDirectory()) continue;
                result.add(f);
            }
            return result;
        }
    }

    public static class Result {
        public int nbDirectories = 0;
        public int nbFiles = 0;
        public FileInfo[] files;
    }

    public static class Request {
        public boolean getLastModified = false;
        public boolean getLastAccess = false;
        public boolean getCreation = false;
        public boolean getIsSymbolicLink = false;
        public boolean getSize = false;
    }
}

