/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.tasks.drives.CloseFileTask;
import net.lecousin.framework.concurrent.tasks.drives.OpenFileTask;
import net.lecousin.framework.concurrent.tasks.drives.ReadFileTask;
import net.lecousin.framework.concurrent.tasks.drives.SeekFileTask;
import net.lecousin.framework.concurrent.tasks.drives.SetFileSizeTask;
import net.lecousin.framework.concurrent.tasks.drives.WriteFileTask;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class FileAccess
implements AutoCloseable {
    RandomAccessFile f;
    FileChannel channel;
    File file;
    String path;
    byte priority;
    OpenFileTask openTask;
    long size;
    TaskManager manager;

    public FileAccess(File file, String mode, byte priority) {
        this.file = file;
        this.path = file.getAbsolutePath();
        this.priority = priority;
        this.manager = Threading.getDrivesTaskManager().getTaskManager(file);
        this.openTask = new OpenFileTask(this, mode, priority);
    }

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return this.file;
    }

    public Task<Void, IOException> getStartingTask() {
        return this.openTask;
    }

    public RandomAccessFile getDirectAccess() {
        return this.f;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public void open() throws IOException {
        this.openTask.getOutput().blockException(0L);
    }

    public Task<Void, IOException> closeAsync() {
        return new CloseFileTask(this);
    }

    @Override
    public void close() {
        this.closeAsync();
    }

    public long getPosition() throws IOException {
        if (!this.openTask.isDone()) {
            return 0L;
        }
        if (!this.openTask.isSuccessful()) {
            throw (IOException)this.openTask.getError();
        }
        return this.channel.position();
    }

    public long getSize() throws IOException {
        this.openTask.getOutput().blockException(0L);
        return this.size;
    }

    public void getSize(final AsyncWork<Long, IOException> sp) {
        Runnable ready = new Runnable(){

            @Override
            public void run() {
                if (FileAccess.this.openTask.isSuccessful()) {
                    sp.unblockSuccess(FileAccess.this.size);
                } else {
                    sp.unblockError(FileAccess.this.openTask.getError());
                }
            }
        };
        this.openTask.getOutput().listenInline(ready);
    }

    public void setSize(long newSize) throws IOException {
        SetFileSizeTask t = new SetFileSizeTask(this, newSize, this.priority);
        t.getOutput().blockException(0L);
    }

    public Task<Void, IOException> setSizeAsync(long newSize) {
        return new SetFileSizeTask(this, newSize, this.priority);
    }

    public int read(long pos, ByteBuffer buffer) throws IOException {
        ReadFileTask task = new ReadFileTask(this, pos, buffer, false, this.priority, null);
        task.getOutput().blockException(0L);
        return task.getCurrentNbRead();
    }

    public Task<Integer, IOException> readAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return new ReadFileTask(this, pos, buffer, false, this.priority, ondone);
    }

    public int readFully(long pos, ByteBuffer buffer) throws IOException {
        ReadFileTask task = new ReadFileTask(this, pos, buffer, true, this.priority, null);
        task.getOutput().blockException(0L);
        return task.getCurrentNbRead();
    }

    public Task<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return new ReadFileTask(this, pos, buffer, true, this.priority, ondone);
    }

    public long seek(IO.Seekable.SeekType type, long move, boolean allowAfterEnd) throws IOException {
        SeekFileTask task = new SeekFileTask(this, type, move, allowAfterEnd, true, this.priority, null);
        task.getOutput().blockException(0L);
        return (Long)task.getResult();
    }

    public Task<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, boolean allowAfterEnd, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        return new SeekFileTask(this, type, move, allowAfterEnd, true, this.priority, ondone);
    }

    public long skip(long move) throws IOException {
        SeekFileTask task = new SeekFileTask(this, IO.Seekable.SeekType.FROM_CURRENT, move, false, false, this.priority, null);
        task.getOutput().blockException(0L);
        return (Long)task.getResult();
    }

    public Task<Long, IOException> skipAsync(long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        return new SeekFileTask(this, IO.Seekable.SeekType.FROM_CURRENT, move, false, false, this.priority, ondone);
    }

    public int write(long pos, ByteBuffer buffer) throws IOException {
        WriteFileTask task = new WriteFileTask(this, pos, buffer, this.priority, null);
        task.getOutput().blockException(0L);
        return (Integer)task.getResult();
    }

    public Task<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return new WriteFileTask(this, pos, buffer, this.priority, ondone);
    }
}

