/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.tasks.drives.RemoveDirectoryContentTask;
import net.lecousin.framework.progress.FakeWorkProgress;
import net.lecousin.framework.progress.WorkProgress;

public class RemoveDirectoryTask
extends Task.OnFile<Long, IOException> {
    private File dir;
    private WorkProgress progress;
    private long work;
    private String progressSubText;
    private boolean calculateSize;

    public RemoveDirectoryTask(File dir, WorkProgress progress, long work, String progressSubText, byte priority, boolean calculateSize) {
        super(dir, "Remove directory", priority);
        this.dir = dir;
        if (progress == null) {
            progress = new FakeWorkProgress();
        }
        this.progress = progress;
        this.work = work;
        if (progressSubText == null) {
            progressSubText = "";
        }
        this.progressSubText = progressSubText;
        this.calculateSize = calculateSize;
    }

    @Override
    public Long run() throws IOException {
        String prev;
        String string = prev = this.progress != null ? this.progress.getSubText() : null;
        if (this.progressSubText != null) {
            this.progress.setSubText(this.progressSubText);
        }
        long removedSize = RemoveDirectoryContentTask.deleteDirectory(this.dir, this.progress, this.work, this.calculateSize);
        if (this.progress != null) {
            this.progress.setSubText(prev);
        }
        return removedSize;
    }
}

