/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.concurrent.tasks.drives.FileAccess;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public abstract class FileIO
extends ConcurrentCloseable
implements IO.KnownSize {
    protected FileAccess file;

    protected FileIO(File file, String mode, byte priority) {
        this.file = new FileAccess(file, mode, priority);
        this.file.getStartingTask().start();
    }

    public ISynchronizationPoint<IOException> canStart() {
        return this.file.getStartingTask().getOutput();
    }

    public File getFile() {
        return this.file.getFile();
    }

    @Override
    public String getSourceDescription() {
        return this.file.getPath();
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public byte getPriority() {
        return this.file.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.file.setPriority(priority);
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getDrivesTaskManager().getTaskManager(this.file.getFile());
    }

    protected long getPosition() throws IOException {
        return this.file.getPosition();
    }

    protected long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
        return this.file.seek(type, move, false);
    }

    protected AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        return this.operation(this.file.seekAsync(type, move, false, ondone).getOutput());
    }

    protected long skipSync(long n) throws IOException {
        return this.file.skip(n);
    }

    protected AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        return this.operation(this.file.skipAsync(n, ondone).getOutput());
    }

    @Override
    public long getSizeSync() throws IOException {
        return this.file.getSize();
    }

    @Override
    public AsyncWork<Long, IOException> getSizeAsync() {
        AsyncWork<Long, IOException> sp = new AsyncWork<Long, IOException>();
        this.file.getSize(sp);
        return this.operation(sp);
    }

    protected void setSizeSync(long size) throws IOException {
        this.file.setSize(size);
    }

    protected AsyncWork<Void, IOException> setSizeAsync(long size) {
        return this.operation(this.file.setSizeAsync(size).getOutput());
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return null;
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.file.closeAsync().getOutput().listenInlineSP(ondone);
    }

    protected int readSync(ByteBuffer buffer) throws IOException {
        return this.file.read(-1L, buffer);
    }

    protected int readSync(long pos, ByteBuffer buffer) throws IOException {
        return this.file.read(pos, buffer);
    }

    protected AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(this.file.readAsync(-1L, buffer, ondone).getOutput());
    }

    protected AsyncWork<Integer, IOException> readAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(this.file.readAsync(pos, buffer, ondone).getOutput());
    }

    protected int readFullySync(ByteBuffer buffer) throws IOException {
        return this.file.readFully(-1L, buffer);
    }

    protected int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        return this.file.readFully(pos, buffer);
    }

    protected AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(this.file.readFullyAsync(-1L, buffer, ondone).getOutput());
    }

    protected AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(this.file.readFullyAsync(pos, buffer, ondone).getOutput());
    }

    protected int writeSync(ByteBuffer buffer) throws IOException {
        return this.file.write(-1L, buffer);
    }

    protected int writeSync(long pos, ByteBuffer buffer) throws IOException {
        return this.file.write(pos, buffer);
    }

    protected AsyncWork<Integer, IOException> writeAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(this.file.writeAsync(-1L, buffer, ondone).getOutput());
    }

    protected AsyncWork<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(this.file.writeAsync(pos, buffer, ondone).getOutput());
    }

    public static class ReadWrite
    extends FileIO
    implements IO.Readable.Seekable,
    IO.Writable.Seekable,
    IO.Resizable,
    IO.KnownSize {
        public ReadWrite(File file, byte priority) {
            super(file, "rw", priority);
        }

        @Override
        public ISynchronizationPoint<IOException> canStartReading() {
            return this.canStart();
        }

        @Override
        public ISynchronizationPoint<IOException> canStartWriting() {
            return this.canStart();
        }

        @Override
        public long getPosition() throws IOException {
            return super.getPosition();
        }

        @Override
        public long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
            return super.seekSync(type, move);
        }

        @Override
        public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            return super.seekAsync(type, move, ondone);
        }

        @Override
        public long skipSync(long n) throws IOException {
            return super.skipSync(n);
        }

        @Override
        public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            return super.skipAsync(n, ondone);
        }

        @Override
        public int readSync(ByteBuffer buffer) throws IOException {
            return super.readSync(buffer);
        }

        @Override
        public int readSync(long pos, ByteBuffer buffer) throws IOException {
            return super.readSync(pos, buffer);
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readAsync(buffer, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readAsync(pos, buffer, ondone);
        }

        @Override
        public int readFullySync(ByteBuffer buffer) throws IOException {
            return super.readFullySync(buffer);
        }

        @Override
        public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
            return super.readFullySync(pos, buffer);
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(buffer, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(pos, buffer, ondone);
        }

        @Override
        public int writeSync(ByteBuffer buffer) throws IOException {
            return super.writeSync(buffer);
        }

        @Override
        public int writeSync(long pos, ByteBuffer buffer) throws IOException {
            return super.writeSync(pos, buffer);
        }

        @Override
        public AsyncWork<Integer, IOException> writeAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(buffer, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(pos, buffer, ondone);
        }

        @Override
        public void setSizeSync(long newSize) throws IOException {
            super.setSizeSync(newSize);
        }

        @Override
        public AsyncWork<Void, IOException> setSizeAsync(long newSize) {
            return super.setSizeAsync(newSize);
        }
    }

    public static class WriteOnly
    extends FileIO
    implements IO.Writable.Seekable,
    IO.Resizable {
        public WriteOnly(File file, byte priority) {
            super(file, "rw", priority);
        }

        @Override
        public ISynchronizationPoint<IOException> canStartWriting() {
            return this.canStart();
        }

        @Override
        public long getPosition() throws IOException {
            return super.getPosition();
        }

        @Override
        public void setSizeSync(long size) throws IOException {
            super.setSizeSync(size);
        }

        @Override
        public AsyncWork<Void, IOException> setSizeAsync(long size) {
            return super.setSizeAsync(size);
        }

        @Override
        public long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
            return super.seekSync(type, move);
        }

        @Override
        public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            return super.seekAsync(type, move, ondone);
        }

        @Override
        public int writeSync(ByteBuffer buffer) throws IOException {
            return super.writeSync(buffer);
        }

        @Override
        public int writeSync(long pos, ByteBuffer buffer) throws IOException {
            return super.writeSync(pos, buffer);
        }

        @Override
        public AsyncWork<Integer, IOException> writeAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(buffer, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(pos, buffer, ondone);
        }
    }

    public static class ReadOnly
    extends FileIO
    implements IO.Readable.Seekable {
        public ReadOnly(File file, byte priority) {
            super(file, "r", priority);
        }

        @Override
        public ISynchronizationPoint<IOException> canStartReading() {
            return this.canStart();
        }

        @Override
        public long getPosition() throws IOException {
            return super.getPosition();
        }

        @Override
        public long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
            return super.seekSync(type, move);
        }

        @Override
        public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            return super.seekAsync(type, move, ondone);
        }

        @Override
        public long skipSync(long n) throws IOException {
            return super.skipSync(n);
        }

        @Override
        public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            return super.skipAsync(n, ondone);
        }

        @Override
        public int readSync(ByteBuffer buffer) throws IOException {
            return super.readSync(buffer);
        }

        @Override
        public int readSync(long pos, ByteBuffer buffer) throws IOException {
            return super.readSync(pos, buffer);
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readAsync(buffer, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readAsync(pos, buffer, ondone);
        }

        @Override
        public int readFullySync(ByteBuffer buffer) throws IOException {
            return super.readFullySync(buffer);
        }

        @Override
        public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
            return super.readFullySync(pos, buffer);
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(buffer, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(pos, buffer, ondone);
        }
    }
}

