/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public abstract class FragmentedSubIO
extends ConcurrentCloseable
implements IO.KnownSize,
IO.Seekable {
    protected IO.Seekable io;
    protected List<RangeLong> fragments;
    protected long pos = 0L;
    protected long size;
    protected boolean closeParentIOOnClose;
    protected String description;

    public FragmentedSubIO(IO.Seekable io, List<RangeLong> fragments, boolean closeParentIOOnClose, String description) {
        this.io = io;
        this.fragments = fragments;
        this.closeParentIOOnClose = closeParentIOOnClose;
        this.description = description;
        this.size = 0L;
        for (RangeLong r : fragments) {
            this.size += r.max - r.min + 1L;
        }
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        if (!this.closeParentIOOnClose) {
            return null;
        }
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.io = null;
        this.fragments = null;
        ondone.unblock();
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.io.getTaskManager();
    }

    @Override
    public byte getPriority() {
        return this.io.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.io.setPriority(priority);
    }

    @Override
    public String getSourceDescription() {
        return this.description + " in " + this.io.getSourceDescription();
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public long getSizeSync() {
        return this.size;
    }

    @Override
    public AsyncWork<Long, IOException> getSizeAsync() {
        AsyncWork<Long, IOException> sp = new AsyncWork<Long, IOException>();
        sp.unblockSuccess(this.getSizeSync());
        return sp;
    }

    protected AsyncWork<Integer, IOException> readAsync(final long pos, final ByteBuffer buffer, final RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        Iterator<RangeLong> it = this.fragments.iterator();
        long p = 0L;
        while (it.hasNext()) {
            RangeLong r = it.next();
            long s = r.max - r.min + 1L;
            if (pos >= p + s) {
                p += s;
                continue;
            }
            long start = pos - p;
            int len = buffer.remaining();
            if (start + (long)len > s) {
                final int prevLimit = buffer.limit();
                buffer.limit((int)((long)prevLimit - (start + (long)len - s)));
                return ((IO.Readable.Seekable)this.io).readAsync(r.min + start, buffer, new RunnableWithParameter<Pair<Integer, IOException>>(){

                    @Override
                    public void run(Pair<Integer, IOException> param) {
                        buffer.limit(prevLimit);
                        if (param.getValue1() != null) {
                            FragmentedSubIO.this.pos = pos + (long)param.getValue1().intValue();
                        }
                        if (ondone != null) {
                            ondone.run(param);
                        }
                    }
                });
            }
            return this.operation(((IO.Readable.Seekable)this.io).readAsync(r.min + start, buffer, new RunnableWithParameter<Pair<Integer, IOException>>(){

                @Override
                public void run(Pair<Integer, IOException> param) {
                    if (param.getValue1() != null) {
                        FragmentedSubIO.this.pos = pos + (long)param.getValue1().intValue();
                    }
                    if (ondone != null) {
                        ondone.run(param);
                    }
                }
            }));
        }
        AsyncWork<Integer, IOException> sp = new AsyncWork<Integer, IOException>();
        if (ondone != null) {
            ondone.run(new Pair<Integer, Object>(0, null));
        }
        sp.unblockSuccess(0);
        return sp;
    }

    protected int readSync(long pos, ByteBuffer buffer) throws IOException {
        Iterator<RangeLong> it = this.fragments.iterator();
        long p = 0L;
        while (it.hasNext()) {
            RangeLong r = it.next();
            long s = r.max - r.min + 1L;
            if (pos >= p + s) {
                p += s;
                continue;
            }
            long start = pos - p;
            int len = buffer.remaining();
            if (start + (long)len > s) {
                int prevLimit = buffer.limit();
                buffer.limit((int)((long)prevLimit - (start + (long)len - s)));
                len = ((IO.Readable.Seekable)this.io).readSync(r.min + start, buffer);
                buffer.limit(prevLimit);
            } else {
                len = ((IO.Readable.Seekable)this.io).readSync(r.min + start, buffer);
            }
            this.pos = pos + (long)len;
            return len;
        }
        return 0;
    }

    protected int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        Iterator<RangeLong> it = this.fragments.iterator();
        long p = 0L;
        int done = 0;
        while (it.hasNext()) {
            RangeLong r = it.next();
            long s = r.max - r.min + 1L;
            if (pos >= p + s) {
                p += s;
                continue;
            }
            long start = pos - p;
            int len = buffer.remaining();
            if (start + (long)len > s) {
                int prevLimit = buffer.limit();
                buffer.limit((int)((long)prevLimit - (start + (long)len - s)));
                len = ((IO.Readable.Seekable)this.io).readFullySync(r.min + start, buffer);
                buffer.limit(prevLimit);
            } else {
                len = ((IO.Readable.Seekable)this.io).readFullySync(r.min + start, buffer);
            }
            this.pos = pos + (long)len;
            done += len;
            if (!buffer.hasRemaining()) {
                return done;
            }
            pos += (long)len;
            p += s;
        }
        return done;
    }

    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) {
        switch (type) {
            case FROM_BEGINNING: {
                this.pos = move;
                break;
            }
            case FROM_END: {
                this.pos = this.size - move;
                break;
            }
            case FROM_CURRENT: {
                this.pos += move;
                break;
            }
        }
        if (this.pos > this.size) {
            this.pos = this.size;
        }
        if (this.pos < 0L) {
            this.pos = 0L;
        }
        return this.pos;
    }

    protected long skipSync(long n) {
        long size = this.getSizeSync();
        long prevPos = this.pos;
        this.pos += n;
        if (this.pos > size) {
            this.pos = size;
        }
        if (this.pos < 0L) {
            this.pos = 0L;
        }
        return this.pos - prevPos;
    }

    @Override
    public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        AsyncWork<Long, IOException> sp = new AsyncWork<Long, IOException>();
        this.seekSync(type, move);
        if (ondone != null) {
            ondone.run(new Pair<Long, Object>(this.pos, null));
        }
        sp.unblockSuccess(this.pos);
        return sp;
    }

    protected AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        AsyncWork<Long, IOException> sp = new AsyncWork<Long, IOException>();
        long skipped = this.skipSync(n);
        if (ondone != null) {
            ondone.run(new Pair<Long, Object>(skipped, null));
        }
        sp.unblockSuccess(skipped);
        return sp;
    }

    public static class Readable
    extends FragmentedSubIO
    implements IO.Readable.Seekable {
        public Readable(IO.Readable.Seekable io, List<RangeLong> fragments, boolean closeParentIOOnClose, String description) {
            super(io, fragments, closeParentIOOnClose, description);
        }

        @Override
        public ISynchronizationPoint<IOException> canStartReading() {
            return ((IO.Readable.Seekable)this.io).canStartReading();
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readAsync(this.pos, buffer, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readAsync(pos, buffer, ondone);
        }

        @Override
        public int readSync(ByteBuffer buffer) throws IOException {
            return super.readSync(this.pos, buffer);
        }

        @Override
        public int readSync(long pos, ByteBuffer buffer) throws IOException {
            return super.readSync(pos, buffer);
        }

        @Override
        public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
            return super.readFullySync(pos, buffer);
        }

        @Override
        public int readFullySync(ByteBuffer buffer) throws IOException {
            return super.readFullySync(this.pos, buffer);
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return this.readFullyAsync(this.pos, buffer, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return this.operation(IOUtil.readFullyAsync(this, pos, buffer, ondone));
        }

        @Override
        public long skipSync(long n) {
            return super.skipSync(n);
        }

        @Override
        public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            return super.skipAsync(n, ondone);
        }
    }
}

