/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.mutable.MutableLong;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public abstract class LinkedIO
extends ConcurrentCloseable
implements IO {
    protected String description;
    protected ArrayList<IO> ios;
    protected ArrayList<Long> sizes;
    protected int ioIndex = 0;
    protected long pos = 0L;
    protected long posInIO = 0L;

    protected LinkedIO(String description, Collection<IO> ios) {
        this.description = description;
        this.ios = new ArrayList<IO>(ios);
    }

    protected LinkedIO(String description, IO[] ios) {
        this.description = description;
        this.ios = new ArrayList(ios.length);
        this.sizes = new ArrayList(ios.length);
        for (int i = 0; i < ios.length; ++i) {
            this.ios.add(ios[i]);
            if (ios[i] instanceof IO.KnownSize) {
                try {
                    this.sizes.add(((IO.KnownSize)ios[i]).getSizeSync());
                }
                catch (IOException e) {
                    this.sizes.add(null);
                }
                continue;
            }
            this.sizes.add(null);
        }
    }

    @Override
    public byte getPriority() {
        return this.ios.isEmpty() ? (byte)4 : this.ios.get(0).getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        for (IO io : this.ios) {
            io.setPriority(priority);
        }
    }

    @Override
    public String getSourceDescription() {
        return this.description;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.ios.isEmpty() ? Threading.getCPUTaskManager() : this.ios.get(0).getTaskManager();
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        JoinPoint jp = new JoinPoint();
        for (IO io : this.ios) {
            jp.addToJoin(io.closeAsync());
        }
        jp.start();
        return jp;
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.ios = null;
        this.sizes = null;
        ondone.unblock();
    }

    protected abstract void nextIOSync() throws IOException;

    protected abstract void previousIOSync() throws IOException;

    protected abstract void nextIOAsync(Runnable var1, ISynchronizationPoint<IOException> var2, RunnableWithParameter var3);

    protected abstract void previousIOAsync(Runnable var1, ISynchronizationPoint<IOException> var2, RunnableWithParameter var3);

    protected void nextIOSyncStream() {
        ++this.ioIndex;
        this.posInIO = 0L;
    }

    protected void previousIOSyncStream() {
        --this.ioIndex;
        this.posInIO = this.sizes.get(this.ioIndex);
    }

    protected void nextIOAsyncStream(Runnable ondone) {
        ++this.ioIndex;
        this.posInIO = 0L;
        ondone.run();
    }

    protected void previousIOAsyncStream(Runnable ondone) {
        --this.ioIndex;
        this.posInIO = this.sizes.get(this.ioIndex);
        ondone.run();
    }

    protected void nextIOSyncSeekable() throws IOException {
        ++this.ioIndex;
        this.posInIO = 0L;
        if (this.ioIndex == this.ios.size()) {
            return;
        }
        ((IO.Readable.Seekable)this.ios.get(this.ioIndex)).seekSync(IO.Seekable.SeekType.FROM_BEGINNING, 0L);
    }

    protected void previousIOSyncSeekable() throws IOException {
        --this.ioIndex;
        this.posInIO = this.sizes.get(this.ioIndex);
        ((IO.Readable.Seekable)this.ios.get(this.ioIndex)).seekSync(IO.Seekable.SeekType.FROM_END, 0L);
    }

    protected void nextIOAsyncSeekable(Runnable ondone, ISynchronizationPoint<IOException> onerror, RunnableWithParameter rp) {
        ++this.ioIndex;
        this.posInIO = 0L;
        AsyncWork<Long, IOException> seek = ((IO.Readable.Seekable)this.ios.get(this.ioIndex)).seekAsync(IO.Seekable.SeekType.FROM_BEGINNING, 0L);
        seek.listenInline(() -> {
            if (seek.hasError()) {
                if (rp != null) {
                    rp.run(new Pair(null, seek.getError()));
                }
                onerror.error((IOException)seek.getError());
            } else {
                ondone.run();
            }
        });
        this.operation(seek);
    }

    protected void previousIOAsyncSeekable(Runnable ondone, ISynchronizationPoint<IOException> onerror, RunnableWithParameter rp) {
        --this.ioIndex;
        this.posInIO = this.sizes.get(this.ioIndex);
        AsyncWork<Long, IOException> seek = ((IO.Readable.Seekable)this.ios.get(this.ioIndex)).seekAsync(IO.Seekable.SeekType.FROM_END, 0L);
        seek.listenInline(() -> {
            if (seek.hasError()) {
                if (rp != null) {
                    rp.run(new Pair(null, seek.getError()));
                }
                onerror.error((IOException)seek.getError());
            } else {
                ondone.run();
            }
        });
        this.operation(seek);
    }

    protected int readSync(ByteBuffer buffer) throws IOException {
        if (this.ioIndex == this.ios.size()) {
            return -1;
        }
        IO.Readable io = (IO.Readable)this.ios.get(this.ioIndex);
        int nb = io.readSync(buffer);
        if (nb <= 0) {
            if (this.sizes.get(this.ioIndex) == null) {
                this.sizes.set(this.ioIndex, this.posInIO);
            }
            this.nextIOSync();
            return this.readSync(buffer);
        }
        this.posInIO += (long)nb;
        this.pos += (long)nb;
        return nb;
    }

    protected int readFullySync(ByteBuffer buffer) throws IOException {
        return IOUtil.readFully((IO.Readable)((Object)this), buffer);
    }

    protected int readAsync() throws IOException {
        if (this.ioIndex == this.ios.size()) {
            return -1;
        }
        IO.Readable.Buffered io = (IO.Readable.Buffered)this.ios.get(this.ioIndex);
        int i = io.readAsync();
        if (i == -1) {
            if (this.sizes.get(this.ioIndex) == null) {
                this.sizes.set(this.ioIndex, this.posInIO);
            }
            this.nextIOSync();
            return this.readAsync();
        }
        if (i == -2) {
            return -2;
        }
        ++this.posInIO;
        ++this.pos;
        return i;
    }

    protected AsyncWork<Integer, IOException> readAsync(final ByteBuffer buffer, final RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        if (this.ioIndex == this.ios.size()) {
            if (ondone != null) {
                ondone.run(new Pair<Integer, Object>(-1, null));
            }
            return new AsyncWork<Integer, Object>(-1, null);
        }
        final AsyncWork<Integer, IOException> result = new AsyncWork<Integer, IOException>();
        IO.Readable io = (IO.Readable)this.ios.get(this.ioIndex);
        AsyncWork<Integer, IOException> read = io.readAsync(buffer);
        this.operation(read).listenInline(new AsyncWork.AsyncWorkListener<Integer, IOException>(){

            @Override
            public void ready(Integer nb) {
                if (nb <= 0) {
                    if (LinkedIO.this.sizes.get(LinkedIO.this.ioIndex) == null) {
                        LinkedIO.this.sizes.set(LinkedIO.this.ioIndex, LinkedIO.this.posInIO);
                    }
                    if (LinkedIO.this.ioIndex == LinkedIO.this.ios.size() - 1) {
                        ++LinkedIO.this.ioIndex;
                        LinkedIO.this.posInIO = 0L;
                        if (ondone != null) {
                            ondone.run(new Pair<Integer, Object>(-1, null));
                        }
                        result.unblockSuccess(-1);
                        return;
                    }
                    LinkedIO.this.nextIOAsync(new Runnable(){

                        @Override
                        public void run() {
                            LinkedIO.this.readAsync(buffer, ondone).listenInline(result);
                        }
                    }, result, ondone);
                    return;
                }
                LinkedIO.this.posInIO += (long)nb.intValue();
                LinkedIO.this.pos += (long)nb.intValue();
                if (ondone != null) {
                    ondone.run(new Pair<Integer, Object>(nb, null));
                }
                result.unblockSuccess(nb);
            }

            @Override
            public void error(IOException error) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, IOException>(null, error));
                }
                result.unblockError(error);
            }

            @Override
            public void cancelled(CancelException event) {
                result.unblockCancel(event);
            }
        });
        return result;
    }

    protected AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return IOUtil.readFullyAsync((IO.Readable)((Object)this), buffer, ondone);
    }

    protected AsyncWork<ByteBuffer, IOException> readNextBufferAsync(final RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
        if (this.ioIndex == this.ios.size()) {
            if (ondone != null) {
                ondone.run(new Pair<Object, Object>(null, null));
            }
            return new AsyncWork<Object, Object>(null, null);
        }
        IO.Readable.Buffered io = (IO.Readable.Buffered)this.ios.get(this.ioIndex);
        final AsyncWork<ByteBuffer, IOException> result = new AsyncWork<ByteBuffer, IOException>();
        AsyncWork<ByteBuffer, IOException> read = io.readNextBufferAsync();
        this.operation(read).listenInline(new AsyncWork.AsyncWorkListener<ByteBuffer, IOException>(){

            @Override
            public void ready(ByteBuffer buf) {
                if (buf == null) {
                    if (LinkedIO.this.sizes.get(LinkedIO.this.ioIndex) == null) {
                        LinkedIO.this.sizes.set(LinkedIO.this.ioIndex, LinkedIO.this.posInIO);
                    }
                    if (LinkedIO.this.ioIndex == LinkedIO.this.ios.size() - 1) {
                        ++LinkedIO.this.ioIndex;
                        LinkedIO.this.posInIO = 0L;
                        if (ondone != null) {
                            ondone.run(new Pair<Object, Object>(null, null));
                        }
                        result.unblockSuccess(null);
                        return;
                    }
                    LinkedIO.this.nextIOAsync(new Runnable(){

                        @Override
                        public void run() {
                            LinkedIO.this.readNextBufferAsync(ondone).listenInline(result);
                        }
                    }, result, ondone);
                    return;
                }
                LinkedIO.this.posInIO += (long)buf.remaining();
                LinkedIO.this.pos += (long)buf.remaining();
                if (ondone != null) {
                    ondone.run(new Pair<ByteBuffer, Object>(buf, null));
                }
                result.unblockSuccess(buf);
            }

            @Override
            public void error(IOException error) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, IOException>(null, error));
                }
                result.unblockError(error);
            }

            @Override
            public void cancelled(CancelException event) {
                result.unblockCancel(event);
            }
        });
        return result;
    }

    protected long skipSync(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        if (n > 0L) {
            if (this.ioIndex == this.ios.size()) {
                return 0L;
            }
            IO.Readable io = (IO.Readable)this.ios.get(this.ioIndex);
            long nb = io.skipSync(n);
            this.posInIO += nb;
            this.pos += nb;
            if (nb == n) {
                return n;
            }
            if (this.sizes.get(this.ioIndex) == null) {
                this.sizes.set(this.ioIndex, this.posInIO);
            }
            this.nextIOSync();
            return nb + this.skipSync(n - nb);
        }
        if (!(this instanceof IO.Readable.Seekable)) {
            return 0L;
        }
        if (this.posInIO == 0L) {
            if (this.ioIndex == 0) {
                return 0L;
            }
            this.previousIOSync();
            return this.skipSync(n);
        }
        IO.Readable io = (IO.Readable)this.ios.get(this.ioIndex);
        long nb = io.skipSync(n);
        if (nb == 0L) {
            return 0L;
        }
        this.posInIO += nb;
        this.pos += nb;
        if (nb == n) {
            return n;
        }
        if (this.posInIO == 0L) {
            if (this.ioIndex == 0) {
                return nb;
            }
            this.previousIOSync();
        }
        return nb + this.skipSync(n - nb);
    }

    protected AsyncWork<Long, IOException> skipAsync(final long n, final RunnableWithParameter<Pair<Long, IOException>> ondone) {
        final AsyncWork<Long, IOException> result = new AsyncWork<Long, IOException>();
        if (n == 0L) {
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(0L, null));
            }
            result.unblockSuccess(0L);
            return result;
        }
        if (n > 0L) {
            if (this.ioIndex == this.ios.size()) {
                if (ondone != null) {
                    ondone.run(new Pair<Long, Object>(0L, null));
                }
                result.unblockSuccess(0L);
                return result;
            }
            IO.Readable io = (IO.Readable)this.ios.get(this.ioIndex);
            final MutableLong done = new MutableLong(0L);
            AsyncWork<Long, IOException> skip = io.skipAsync(n);
            this.operation(skip).listenInline(new AsyncWork.AsyncWorkListener<Long, IOException>(){

                @Override
                public void ready(Long nb) {
                    LinkedIO.this.posInIO += nb.longValue();
                    LinkedIO.this.pos += (long)nb.intValue();
                    done.add(nb);
                    if (done.get() == n) {
                        if (ondone != null) {
                            ondone.run(new Pair<Long, Object>(n, null));
                        }
                        result.unblockSuccess(n);
                        return;
                    }
                    if (LinkedIO.this.sizes.get(LinkedIO.this.ioIndex) == null) {
                        LinkedIO.this.sizes.set(LinkedIO.this.ioIndex, LinkedIO.this.posInIO);
                    }
                    final 3 l = this;
                    if (LinkedIO.this.ioIndex == LinkedIO.this.ios.size() - 1) {
                        ++LinkedIO.this.ioIndex;
                        LinkedIO.this.posInIO = 0L;
                        if (ondone != null) {
                            ondone.run(new Pair<Long, Object>(done.get(), null));
                        }
                        result.unblockSuccess(done.get());
                        return;
                    }
                    LinkedIO.this.nextIOAsync(new Runnable(){

                        @Override
                        public void run() {
                            ((AsyncWork)LinkedIO.this.operation(((IO.Readable)LinkedIO.this.ios.get(LinkedIO.this.ioIndex)).skipAsync(n - done.get(), null))).listenInline(l);
                        }
                    }, result, ondone);
                }

                @Override
                public void error(IOException error) {
                    if (ondone != null) {
                        ondone.run(new Pair<Object, IOException>(null, error));
                    }
                    result.unblockError(error);
                }

                @Override
                public void cancelled(CancelException event) {
                    result.unblockCancel(event);
                }
            });
            return result;
        }
        if (!(this instanceof IO.Readable.Seekable)) {
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(0L, null));
            }
            result.unblockSuccess(0L);
            return result;
        }
        if (this.posInIO == 0L) {
            if (this.ioIndex == 0) {
                if (ondone != null) {
                    ondone.run(new Pair<Long, Object>(0L, null));
                }
                result.unblockSuccess(0L);
                return result;
            }
            this.previousIOAsync(new Runnable(){

                @Override
                public void run() {
                    LinkedIO.this.skipAsync(n, ondone).listenInline(result);
                }
            }, result, ondone);
            return result;
        }
        IO.Readable io = (IO.Readable)this.ios.get(this.ioIndex);
        AsyncWork<Long, IOException> skip = io.skipAsync(n);
        final MutableLong done = new MutableLong(0L);
        this.operation(skip).listenInline(new AsyncWork.AsyncWorkListener<Long, IOException>(){

            @Override
            public void ready(Long nb) {
                LinkedIO.this.posInIO += nb.longValue();
                LinkedIO.this.pos += (long)nb.intValue();
                done.add(nb);
                if (done.get() == n) {
                    if (ondone != null) {
                        ondone.run(new Pair<Long, Object>(n, null));
                    }
                    result.unblockSuccess(n);
                    return;
                }
                if (LinkedIO.this.ioIndex == 0) {
                    if (ondone != null) {
                        ondone.run(new Pair<Long, Object>(done.get(), null));
                    }
                    result.unblockSuccess(done.get());
                    return;
                }
                final 5 l = this;
                LinkedIO.this.previousIOAsync(new Runnable(){

                    @Override
                    public void run() {
                        ((IO.Readable)LinkedIO.this.ios.get(LinkedIO.this.ioIndex)).skipAsync(n - done.get(), null).listenInline(l);
                    }
                }, result, ondone);
            }

            @Override
            public void error(IOException error) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, IOException>(null, error));
                }
                result.unblockError(error);
            }

            @Override
            public void cancelled(CancelException event) {
                result.unblockCancel(event);
            }
        });
        return result;
    }

    protected int read() throws IOException {
        if (this.ioIndex == this.ios.size()) {
            return -1;
        }
        IO.Readable.Buffered io = (IO.Readable.Buffered)this.ios.get(this.ioIndex);
        int i = io.read();
        if (i < 0) {
            if (this.sizes.get(this.ioIndex) == null) {
                this.sizes.set(this.ioIndex, this.posInIO);
            }
            this.nextIOSync();
            return this.read();
        }
        ++this.posInIO;
        ++this.pos;
        return i;
    }

    protected int read(byte[] buf, int off, int len) throws IOException {
        return this.readFullySync(ByteBuffer.wrap(buf, off, len));
    }

    protected int readFully(byte[] buffer) throws IOException {
        return this.readFullySync(ByteBuffer.wrap(buffer));
    }

    protected int skip(int n) throws IOException {
        return (int)this.skipSync(n);
    }

    protected ISynchronizationPoint<IOException> canStartReading() {
        if (this.ioIndex == this.ios.size()) {
            return new SynchronizationPoint<boolean>(true);
        }
        return ((IO.Readable)this.ios.get(this.ioIndex)).canStartReading();
    }

    protected ISynchronizationPoint<IOException> canStartWriting() {
        if (this.ioIndex == this.ios.size()) {
            return new SynchronizationPoint<boolean>(true);
        }
        return ((IO.Writable)this.ios.get(this.ioIndex)).canStartWriting();
    }

    protected long getSizeSync() throws IOException {
        long total = 0L;
        for (IO io : this.ios) {
            total += ((IO.KnownSize)io).getSizeSync();
        }
        return total;
    }

    protected AsyncWork<Long, IOException> getSizeAsync() {
        AsyncWork[] sizes = new AsyncWork[this.ios.size()];
        for (int i = 0; i < this.ios.size(); ++i) {
            sizes[i] = ((IO.KnownSize)this.ios.get(i)).getSizeAsync();
        }
        JoinPoint jp = JoinPoint.fromSynchronizationPointsSimilarError(sizes);
        AsyncWork<Long, IOException> result = new AsyncWork<Long, IOException>();
        this.operation(jp).listenInline(() -> {
            long total = 0L;
            for (int i = 0; i < sizes.length; ++i) {
                total += ((Long)sizes[i].getResult()).longValue();
            }
            result.unblockSuccess(total);
        }, result);
        return result;
    }

    protected long getPosition() {
        return this.pos;
    }

    protected long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
        switch (type) {
            case FROM_CURRENT: {
                move += this.pos;
                break;
            }
            case FROM_BEGINNING: {
                break;
            }
            case FROM_END: {
                long p = 0L;
                for (int i = 0; i < this.ios.size(); ++i) {
                    if (this.sizes.get(i) == null) {
                        IO.Readable.Seekable io = (IO.Readable.Seekable)this.ios.get(i);
                        this.sizes.set(this.ioIndex, io.seekSync(IO.Seekable.SeekType.FROM_END, 0L));
                    }
                    p += this.sizes.get(i).longValue();
                }
                move = p - move;
                break;
            }
        }
        if (move < 0L) {
            move = 0L;
        }
        this.pos = 0L;
        this.ioIndex = 0;
        this.posInIO = 0L;
        if (move == 0L) {
            if (!this.ios.isEmpty()) {
                ((IO.Readable.Seekable)this.ios.get(0)).seekSync(IO.Seekable.SeekType.FROM_BEGINNING, 0L);
            }
            return 0L;
        }
        while (this.ioIndex < this.ios.size()) {
            Long s = this.sizes.get(this.ioIndex);
            if (s == null) {
                IO.Readable.Seekable io = (IO.Readable.Seekable)this.ios.get(this.ioIndex);
                s = io.seekSync(IO.Seekable.SeekType.FROM_END, 0L);
                this.sizes.set(this.ioIndex, s);
            }
            if (this.pos + s > move) {
                this.posInIO = move - this.pos;
                this.pos = move;
                ((IO.Readable.Seekable)this.ios.get(this.ioIndex)).seekSync(IO.Seekable.SeekType.FROM_BEGINNING, this.posInIO);
                return move;
            }
            this.pos += s.longValue();
            ++this.ioIndex;
        }
        return this.pos;
    }

    protected AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        return this.operation(IOUtil.seekAsyncUsingSync((IO.Readable.Seekable)((Object)this), type, move, ondone).getOutput());
    }

    protected int readSync(long pos, ByteBuffer buffer) throws IOException {
        long p = 0L;
        for (int i = 0; i < this.ios.size(); ++i) {
            IO.Readable.Seekable io;
            Long s = this.sizes.get(i);
            if (s == null) {
                io = (IO.Readable.Seekable)this.ios.get(i);
                s = io.seekSync(IO.Seekable.SeekType.FROM_END, 0L);
                this.sizes.set(i, s);
            }
            if (p + s > pos) {
                io = (IO.Readable.Seekable)this.ios.get(i);
                int nb = io.readSync(pos - p, buffer);
                this.ioIndex = i;
                this.posInIO = pos - p + (long)nb;
                this.pos = pos + (long)nb;
                return nb;
            }
            p += s.longValue();
        }
        return -1;
    }

    protected AsyncWork<Integer, IOException> readAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        long p = 0L;
        for (int i = 0; i < this.ios.size(); ++i) {
            IO.Readable.Seekable io;
            Long s = this.sizes.get(i);
            if (s == null) {
                io = (IO.Readable.Seekable)this.ios.get(i);
                AsyncWork<Long, IOException> seek = io.seekAsync(IO.Seekable.SeekType.FROM_END, 0L);
                if (!seek.isUnblocked()) {
                    AsyncWork<Integer, IOException> result = new AsyncWork<Integer, IOException>();
                    int ii = i;
                    seek.listenAsync(new Task.Cpu.FromRunnable("LinkedIO.readAsync", this.getPriority(), () -> {
                        this.sizes.set(ii, (Long)seek.getResult());
                        this.readAsync(pos, buffer, ondone).listenInline(result);
                    }), result);
                    return result;
                }
                s = seek.getResult();
                this.sizes.set(i, s);
            }
            if (p + s > pos) {
                io = (IO.Readable.Seekable)this.ios.get(i);
                this.ioIndex = i;
                this.posInIO = pos - p;
                AsyncWork<Integer, IOException> result = io.readAsync(pos - p, buffer, res -> {
                    if (res.getValue1() != null) {
                        this.posInIO += (long)((Integer)res.getValue1()).intValue();
                        this.pos = pos + (long)((Integer)res.getValue1()).intValue();
                    }
                    if (ondone != null) {
                        ondone.run((Pair<Integer, IOException>)res);
                    }
                });
                return result;
            }
            p += s.longValue();
        }
        if (ondone != null) {
            ondone.run(new Pair<Integer, Object>(-1, null));
        }
        return new AsyncWork<Integer, Object>(-1, null);
    }

    protected int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        return IOUtil.readFullySync((IO.Readable.Seekable)((Object)this), pos, buffer);
    }

    protected AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync((IO.Readable.Seekable)((Object)this), pos, buffer, ondone));
    }

    public static class Readable
    extends LinkedIO
    implements IO.Readable {
        public Readable(String description, IO.Readable ... ios) {
            super(description, ios);
        }

        @Override
        protected void nextIOSync() throws IOException {
            this.nextIOSyncStream();
        }

        @Override
        protected void nextIOAsync(Runnable ondone, ISynchronizationPoint<IOException> onerror, RunnableWithParameter rp) {
            this.nextIOAsyncStream(ondone);
        }

        @Override
        protected void previousIOSync() throws IOException {
            this.previousIOSyncStream();
        }

        @Override
        protected void previousIOAsync(Runnable ondone, ISynchronizationPoint<IOException> onerror, RunnableWithParameter rp) {
            this.previousIOAsyncStream(ondone);
        }

        @Override
        public ISynchronizationPoint<IOException> canStartReading() {
            return super.canStartReading();
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readAsync(buffer, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(buffer, ondone);
        }

        @Override
        public int readSync(ByteBuffer buffer) throws IOException {
            return super.readSync(buffer);
        }

        @Override
        public int readFullySync(ByteBuffer buffer) throws IOException {
            return super.readFullySync(buffer);
        }

        @Override
        public long skipSync(long n) throws IOException {
            return super.skipSync(n);
        }

        @Override
        public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            return super.skipAsync(n, ondone);
        }

        public static class Seekable
        extends Readable
        implements IO.Readable.Seekable {
            public Seekable(String description, IO.Readable.Seekable ... ios) {
                super(description, ios);
            }

            @Override
            protected void nextIOSync() throws IOException {
                this.nextIOSyncSeekable();
            }

            @Override
            protected void nextIOAsync(Runnable ondone, ISynchronizationPoint<IOException> onerror, RunnableWithParameter rp) {
                this.nextIOAsyncSeekable(ondone, onerror, rp);
            }

            @Override
            protected void previousIOSync() throws IOException {
                this.previousIOSyncSeekable();
            }

            @Override
            protected void previousIOAsync(Runnable ondone, ISynchronizationPoint<IOException> onerror, RunnableWithParameter rp) {
                this.previousIOAsyncSeekable(ondone, onerror, rp);
            }

            @Override
            public long getPosition() {
                return super.getPosition();
            }

            @Override
            public long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
                return super.seekSync(type, move);
            }

            @Override
            public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
                return super.seekAsync(type, move, ondone);
            }

            @Override
            public int readSync(long pos, ByteBuffer buffer) throws IOException {
                return super.readSync(pos, buffer);
            }

            @Override
            public AsyncWork<Integer, IOException> readAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
                return super.readAsync(pos, buffer, ondone);
            }

            @Override
            public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
                return super.readFullySync(pos, buffer);
            }

            @Override
            public AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
                return super.readFullyAsync(pos, buffer, ondone);
            }

            public static class DeterminedSize
            extends Seekable
            implements IO.KnownSize {
                public DeterminedSize(String description, IO.Readable.Seekable ... ios) {
                    super(description, ios);
                }

                @Override
                public long getSizeSync() throws IOException {
                    return super.getSizeSync();
                }

                @Override
                public AsyncWork<Long, IOException> getSizeAsync() {
                    return super.getSizeAsync();
                }
            }

            public static class Buffered
            extends Seekable
            implements IO.Readable.Buffered {
                public Buffered(String description, IO.Readable.Seekable ... ios) {
                    super(description, ios);
                }

                @Override
                public int read() throws IOException {
                    return super.read();
                }

                @Override
                public int read(byte[] buf, int off, int len) throws IOException {
                    return super.read(buf, off, len);
                }

                @Override
                public int readFully(byte[] buffer) throws IOException {
                    return super.readFully(buffer);
                }

                @Override
                public int readAsync() throws IOException {
                    return super.readAsync();
                }

                @Override
                public int skip(int n) throws IOException {
                    return super.skip(n);
                }

                @Override
                public ISynchronizationPoint<IOException> canStartReading() {
                    return super.canStartReading();
                }

                @Override
                public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
                    return super.readNextBufferAsync(ondone);
                }

                public static class DeterminedSize
                extends Buffered
                implements IO.KnownSize {
                    public DeterminedSize(String description, IO.Readable.Seekable ... ios) {
                        super(description, ios);
                    }

                    @Override
                    public long getSizeSync() throws IOException {
                        return super.getSizeSync();
                    }

                    @Override
                    public AsyncWork<Long, IOException> getSizeAsync() {
                        return super.getSizeAsync();
                    }
                }
            }
        }

        public static class DeterminedSize
        extends Readable
        implements IO.KnownSize {
            public DeterminedSize(String description, IO.Readable ... ios) {
                super(description, ios);
            }

            @Override
            public long getSizeSync() throws IOException {
                return super.getSizeSync();
            }

            @Override
            public AsyncWork<Long, IOException> getSizeAsync() {
                return super.getSizeAsync();
            }
        }

        public static class Buffered
        extends Readable
        implements IO.Readable.Buffered {
            public Buffered(String description, IO.Readable.Buffered ... ios) {
                super(description, ios);
            }

            @Override
            public int read() throws IOException {
                return super.read();
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                return super.read(buf, off, len);
            }

            @Override
            public int readFully(byte[] buffer) throws IOException {
                return super.readFully(buffer);
            }

            @Override
            public int readAsync() throws IOException {
                return super.readAsync();
            }

            @Override
            public int skip(int n) throws IOException {
                return super.skip(n);
            }

            @Override
            public ISynchronizationPoint<IOException> canStartReading() {
                return super.canStartReading();
            }

            @Override
            public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
                return super.readNextBufferAsync(ondone);
            }

            public static class DeterminedSize
            extends Buffered
            implements IO.KnownSize {
                public DeterminedSize(String description, IO.Readable.Buffered ... ios) {
                    super(description, ios);
                }

                @Override
                public long getSizeSync() throws IOException {
                    return super.getSizeSync();
                }

                @Override
                public AsyncWork<Long, IOException> getSizeAsync() {
                    return super.getSizeAsync();
                }
            }
        }
    }
}

