/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public abstract class SubIO
extends ConcurrentCloseable {

    public static class Readable
    extends SubIO
    implements IO.Readable,
    IO.KnownSize {
        protected IO.Readable io;
        protected long pos;
        protected long size;
        protected String description;
        protected boolean closeContainer;

        public Readable(IO.Readable src, long size, String description, boolean closeSrcOnClose) {
            this.io = src;
            this.pos = 0L;
            this.size = size;
            this.description = description;
            this.closeContainer = closeSrcOnClose;
        }

        @Override
        public IO getWrappedIO() {
            return null;
        }

        @Override
        public String getSourceDescription() {
            return this.description;
        }

        @Override
        public TaskManager getTaskManager() {
            return this.io.getTaskManager();
        }

        @Override
        public byte getPriority() {
            return this.io != null ? this.io.getPriority() : (byte)4;
        }

        @Override
        public void setPriority(byte priority) {
            this.io.setPriority(priority);
        }

        @Override
        protected ISynchronizationPoint<?> closeUnderlyingResources() {
            if (!this.closeContainer) {
                return null;
            }
            return this.io.closeAsync();
        }

        @Override
        protected void closeResources(SynchronizationPoint<Exception> ondone) {
            this.io = null;
            ondone.unblock();
        }

        @Override
        public ISynchronizationPoint<IOException> canStartReading() {
            return this.io.canStartReading();
        }

        @Override
        public long getSizeSync() {
            return this.size;
        }

        @Override
        public AsyncWork<Long, IOException> getSizeAsync() {
            return new AsyncWork<Long, Object>(this.size, null);
        }

        @Override
        public int readSync(ByteBuffer buffer) throws IOException {
            int limit = -1;
            if (this.pos + (long)buffer.remaining() > this.size) {
                limit = buffer.limit();
                buffer.limit((int)((long)buffer.position() + this.size - this.pos));
            }
            int nb = this.io.readSync(buffer);
            this.pos += (long)nb;
            if (limit != -1) {
                buffer.limit(limit);
            }
            return nb;
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            int limit = -1;
            if (this.pos + (long)buffer.remaining() > this.size) {
                limit = buffer.limit();
                buffer.limit((int)((long)buffer.position() + this.size - this.pos));
            }
            int plimit = limit;
            return this.io.readAsync(buffer, result -> {
                if (result.getValue1() != null) {
                    this.pos += (long)((Integer)result.getValue1()).intValue();
                }
                if (plimit != -1) {
                    buffer.limit(plimit);
                }
                if (ondone != null) {
                    ondone.run((Pair<Integer, IOException>)result);
                }
            });
        }

        @Override
        public int readFullySync(ByteBuffer buffer) throws IOException {
            int limit = -1;
            if (this.pos + (long)buffer.remaining() > this.size) {
                limit = buffer.limit();
                buffer.limit((int)((long)buffer.position() + this.size - this.pos));
            }
            int nb = this.io.readFullySync(buffer);
            this.pos += (long)nb;
            if (limit != -1) {
                buffer.limit(limit);
            }
            return nb;
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            int limit = -1;
            if (this.pos + (long)buffer.remaining() > this.size) {
                limit = buffer.limit();
                buffer.limit((int)((long)buffer.position() + this.size - this.pos));
            }
            int plimit = limit;
            return this.io.readAsync(buffer, result -> {
                if (result.getValue1() != null) {
                    this.pos += (long)((Integer)result.getValue1()).intValue();
                }
                if (plimit != -1) {
                    buffer.limit(plimit);
                }
                if (ondone != null) {
                    ondone.run((Pair<Integer, IOException>)result);
                }
            });
        }

        @Override
        public long skipSync(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            if (this.pos + n < 0L) {
                n = -this.pos;
            }
            if (this.pos + n > this.size) {
                n = this.size - this.pos;
            }
            long nb = this.io.skipSync(n);
            this.pos += nb;
            return nb;
        }

        @Override
        public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            if (n <= 0L) {
                if (ondone != null) {
                    ondone.run(new Pair<Long, Object>(0L, null));
                }
                return new AsyncWork<Long, Object>(0L, null);
            }
            if (this.pos + n < 0L) {
                n = -this.pos;
            }
            if (this.pos + n > this.size) {
                n = this.size - this.pos;
            }
            return this.io.skipAsync(n, result -> {
                if (result.getValue1() != null) {
                    this.pos += ((Long)result.getValue1()).longValue();
                }
                if (ondone != null) {
                    ondone.run((Pair<Long, IOException>)result);
                }
            });
        }

        public static class Seekable
        extends Readable
        implements IO.Readable.Seekable {
            protected long start;

            public Seekable(IO.Readable.Seekable src, long start, long size, String description, boolean closeSrcOnClose) {
                super(src, size, description, closeSrcOnClose);
                this.start = start;
                this.io = src;
            }

            @Override
            public long getPosition() {
                return this.pos;
            }

            @Override
            public int readSync(long pos, ByteBuffer buffer) throws IOException {
                if (pos >= this.size) {
                    return -1;
                }
                int limit = -1;
                if (pos + (long)buffer.remaining() > this.size) {
                    limit = buffer.limit();
                    buffer.limit((int)((long)buffer.position() + this.size - pos));
                }
                int nb = ((IO.Readable.Seekable)this.io).readSync(this.start + pos, buffer);
                this.pos = pos + (long)nb;
                if (limit != -1) {
                    buffer.limit(limit);
                }
                return nb;
            }

            @Override
            public int readSync(ByteBuffer buffer) throws IOException {
                return this.readSync(this.pos, buffer);
            }

            @Override
            public AsyncWork<Integer, IOException> readAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
                if (pos > this.size) {
                    if (ondone != null) {
                        ondone.run(new Pair<Integer, Object>(-1, null));
                    }
                    return new AsyncWork<Integer, Object>(-1, null);
                }
                int limit = -1;
                if (pos + (long)buffer.remaining() > this.size) {
                    limit = buffer.limit();
                    buffer.limit((int)((long)buffer.position() + this.size - pos));
                }
                int plimit = limit;
                return ((IO.Readable.Seekable)this.io).readAsync(this.start + pos, buffer, result -> {
                    if (result.getValue1() != null) {
                        this.pos = pos + (long)((Integer)result.getValue1()).intValue();
                    }
                    if (plimit != -1) {
                        buffer.limit(plimit);
                    }
                    if (ondone != null) {
                        ondone.run((Pair<Integer, IOException>)result);
                    }
                });
            }

            @Override
            public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
                return this.readAsync(this.pos, buffer, ondone);
            }

            @Override
            public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
                if (pos > this.size) {
                    return -1;
                }
                int limit = -1;
                if (pos + (long)buffer.remaining() > this.size) {
                    limit = buffer.limit();
                    buffer.limit((int)((long)buffer.position() + this.size - pos));
                }
                int nb = ((IO.Readable.Seekable)this.io).readFullySync(this.start + pos, buffer);
                this.pos = pos + (long)nb;
                if (limit != -1) {
                    buffer.limit(limit);
                }
                return nb;
            }

            @Override
            public int readFullySync(ByteBuffer buffer) throws IOException {
                return this.readFullySync(this.pos, buffer);
            }

            @Override
            public AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
                if (pos > this.size) {
                    return new AsyncWork<Integer, Object>(-1, null);
                }
                int limit = -1;
                if (pos + (long)buffer.remaining() > this.size) {
                    limit = buffer.limit();
                    buffer.limit((int)((long)buffer.position() + this.size - pos));
                }
                int plimit = limit;
                return ((IO.Readable.Seekable)this.io).readFullyAsync(this.start + pos, buffer, result -> {
                    if (result.getValue1() != null) {
                        this.pos = pos + (long)((Integer)result.getValue1()).intValue();
                    }
                    if (plimit != -1) {
                        buffer.limit(plimit);
                    }
                    if (ondone != null) {
                        ondone.run((Pair<Integer, IOException>)result);
                    }
                });
            }

            @Override
            public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
                return this.readFullyAsync(this.pos, buffer, ondone);
            }

            @Override
            public long seekSync(IO.Seekable.SeekType type, long move) {
                switch (type) {
                    default: {
                        if (move < 0L) {
                            move = 0L;
                        }
                        if (move > this.size) {
                            move = this.size;
                        }
                        this.pos = move;
                        return this.pos;
                    }
                    case FROM_END: {
                        if (move < 0L) {
                            move = 0L;
                        }
                        if (this.size - move < 0L) {
                            move = this.size;
                        }
                        this.pos = this.size - move;
                        return this.pos;
                    }
                    case FROM_CURRENT: 
                }
                if (this.pos + move < 0L) {
                    move = -this.pos;
                }
                if (this.pos + move > this.size) {
                    move = this.size - this.pos;
                }
                this.pos += move;
                return this.pos;
            }

            @Override
            public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
                return IOUtil.seekAsyncUsingSync(this, type, move, ondone).getOutput();
            }

            @Override
            public long skipSync(long n) {
                if (this.pos + n < 0L) {
                    n = -this.pos;
                }
                if (this.pos + n > this.size) {
                    n = this.size - this.pos;
                }
                this.pos += n;
                return n;
            }

            @Override
            public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
                long l = this.skipSync(n);
                if (ondone != null) {
                    ondone.run(new Pair<Long, Object>(l, null));
                }
                return new AsyncWork<Long, Object>(l, null);
            }

            public static class Buffered
            extends Seekable
            implements IO.Readable.Buffered {
                public <T extends IO.Readable.Seekable & IO.Readable.Buffered> Buffered(T src, long start, long size, String description, boolean closeSrcOnClose) {
                    super(src, start, size, description, closeSrcOnClose);
                }

                @Override
                public ISynchronizationPoint<IOException> canStartReading() {
                    ISynchronizationPoint<IOException> sp = ((IO.Readable.Buffered)this.io).canStartReading();
                    if (!sp.isUnblocked()) {
                        return sp;
                    }
                    try {
                        if (((IO.Readable.Seekable)this.io).getPosition() == this.start + this.pos) {
                            return sp;
                        }
                    }
                    catch (IOException e) {
                        return new SynchronizationPoint<IOException>(e);
                    }
                    AsyncWork<Long, IOException> seek = ((IO.Readable.Seekable)this.io).seekAsync(IO.Seekable.SeekType.FROM_BEGINNING, this.start + this.pos);
                    return seek;
                }

                @Override
                public int read() throws IOException {
                    if (this.pos == this.size) {
                        return -1;
                    }
                    ByteBuffer b = ByteBuffer.allocate(1);
                    int nb = this.readSync(b);
                    if (nb <= 0) {
                        return -1;
                    }
                    return b.array()[0] & 0xFF;
                }

                @Override
                public int read(byte[] buffer, int offset, int len) throws IOException {
                    if (this.pos + (long)len > this.size) {
                        len = (int)(this.size - this.pos);
                    }
                    ByteBuffer b = ByteBuffer.wrap(buffer, offset, len);
                    int nb = this.readSync(b);
                    return nb;
                }

                @Override
                public int readFully(byte[] buffer) throws IOException {
                    int len = buffer.length;
                    if (this.pos + (long)len > this.size) {
                        len = (int)(this.size - this.pos);
                    }
                    ByteBuffer b = ByteBuffer.wrap(buffer, 0, len);
                    int nb = this.readFullySync(b);
                    return nb;
                }

                @Override
                public int readAsync() throws IOException {
                    int res;
                    if (this.pos == this.size) {
                        return -1;
                    }
                    if (((IO.Readable.Seekable)this.io).getPosition() != this.start + this.pos) {
                        AsyncWork<Long, IOException> seek = ((IO.Readable.Seekable)this.io).seekAsync(IO.Seekable.SeekType.FROM_BEGINNING, this.start + this.pos);
                        if (!seek.isUnblocked()) {
                            return -2;
                        }
                        if (seek.hasError()) {
                            throw seek.getError();
                        }
                    }
                    if ((res = ((IO.Readable.Buffered)this.io).readAsync()) >= 0) {
                        ++this.pos;
                    }
                    return res;
                }

                @Override
                public int skip(int skip) {
                    return (int)this.skipSync(skip);
                }

                @Override
                public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(final RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
                    if (this.pos == this.size) {
                        if (ondone != null) {
                            ondone.run(new Pair<Object, Object>(null, null));
                        }
                        return new AsyncWork<Object, Object>(null, null);
                    }
                    final AsyncWork<ByteBuffer, IOException> result = new AsyncWork<ByteBuffer, IOException>();
                    Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Read next buffer", this.getPriority()){

                        @Override
                        public Void run() {
                            int len = 16384;
                            if ((long)len > size - pos) {
                                len = (int)(size - pos);
                            }
                            ByteBuffer buf = ByteBuffer.allocate(len);
                            AsyncWork<Integer, IOException> read = ((IO.Readable.Seekable)io).readAsync(start + pos, buf);
                            read.listenInline(() -> {
                                if (read.hasError()) {
                                    if (ondone != null) {
                                        ondone.run(new Pair(null, read.getError()));
                                    }
                                    result.error(read.getError());
                                    return;
                                }
                                if ((Integer)read.getResult() > 0) {
                                    pos += (long)((Integer)read.getResult()).intValue();
                                }
                                buf.flip();
                                if (ondone != null) {
                                    ondone.run(new Pair<ByteBuffer, Object>(buf, null));
                                }
                                result.unblockSuccess(buf);
                            });
                            return null;
                        }
                    };
                    task.start();
                    return result;
                }
            }
        }
    }
}

