/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.buffering.BufferingManaged;
import net.lecousin.framework.io.buffering.BufferingManager;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public abstract class BufferedIO
extends BufferingManaged {
    protected BufferingManager manager = BufferingManager.get();
    protected IO.Readable.Seekable io;
    protected List<Buffer> buffers;
    private int firstBufferSize;
    private int bufferSize;
    protected long size;
    protected long pos;
    protected boolean startReadSecondBufferWhenFirstBufferFullyRead = true;

    protected BufferedIO(IO.Readable.Seekable io, int bufferSize, long size) throws IOException {
        this(io, bufferSize, bufferSize, size, true);
    }

    protected BufferedIO(IO.Readable.Seekable io, int firstBufferSize, int bufferSize, long size, boolean startReadSecondBufferWhenFirstBufferFullyRead) throws IOException {
        int nbBuffers;
        this.pos = io.getPosition();
        if (this.pos >= (long)firstBufferSize) {
            firstBufferSize = bufferSize;
        }
        this.io = io;
        this.firstBufferSize = firstBufferSize;
        this.bufferSize = bufferSize;
        this.size = size;
        this.startReadSecondBufferWhenFirstBufferFullyRead = startReadSecondBufferWhenFirstBufferFullyRead;
        int n = nbBuffers = size <= (long)firstBufferSize ? 1 : (int)((size - (long)firstBufferSize) / (long)bufferSize) + 2;
        this.buffers = nbBuffers <= 10 ? new ArrayList<Buffer>(nbBuffers) : (nbBuffers <= 100 ? new LinkedArrayList<Buffer>(10) : (nbBuffers <= 200 ? new LinkedArrayList<Buffer>(20) : (nbBuffers <= 450 ? new LinkedArrayList<Buffer>(30) : (nbBuffers <= 1000 ? new LinkedArrayList<Buffer>(50) : new LinkedArrayList<Buffer>(100)))));
        this.loadBuffer(this.getBufferIndex(this.pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBuffer(int index) {
        Buffer buffer;
        Object object = this.buffers;
        synchronized (object) {
            while (index >= this.buffers.size()) {
                this.buffers.add(new Buffer(this));
            }
            buffer = this.buffers.get(index);
            if (buffer.buffer != null) {
                return;
            }
            if (buffer.loading != null) {
                return;
            }
            buffer.loading = new SynchronizationPoint();
        }
        object = buffer;
        synchronized (object) {
            buffer.buffer = new byte[index == 0 ? this.firstBufferSize : this.bufferSize];
            final AsyncWork<Integer, IOException> loading = this.io.readFullyAsync(index == 0 ? 0L : (long)(this.firstBufferSize + (index - 1) * this.bufferSize), ByteBuffer.wrap(buffer.buffer));
            this.operation(loading).listenInline(new Runnable(){

                @Override
                public void run() {
                    if (!loading.isSuccessful()) {
                        if (loading.isCancelled()) {
                            buffer.loading.cancel(loading.getCancelEvent());
                        } else {
                            buffer.error = (IOException)loading.getError();
                            buffer.loading.unblock();
                        }
                        buffer.buffer = null;
                        return;
                    }
                    buffer.len = (Integer)loading.getResult();
                    if (buffer.len < 0) {
                        buffer.len = 0;
                    }
                    buffer.lastRead = System.currentTimeMillis();
                    BufferedIO.this.manager.newBuffer(buffer);
                    buffer.loading.unblock();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer useBufferAsync(int index) {
        while (true) {
            Buffer b = null;
            try {
                Object object = this.buffers;
                synchronized (object) {
                    if (index < this.buffers.size()) {
                        b = this.buffers.get(index);
                    }
                }
                if (b != null) {
                    object = b;
                    synchronized (object) {
                        ++b.inUse;
                        if (b.buffer == null && (b.loading == null || b.loading.isUnblocked()) && b.error == null) {
                            this.loadBuffer(index);
                        }
                    }
                    return b;
                }
                this.loadBuffer(index);
            }
            catch (Throwable t) {
                if (this.closing) {
                    b = new Buffer(this);
                    b.loading = new SynchronizationPoint(new CancelException("IO closed"));
                    return b;
                }
                if (b == null) {
                    b = new Buffer(this);
                }
                b.error = IO.error(t);
                b.loading = new SynchronizationPoint<boolean>(true);
                return b;
            }
        }
    }

    protected Buffer useBufferSync(int index) throws IOException {
        Buffer b = this.useBufferAsync(index);
        SynchronizationPoint sp = b.loading;
        if (sp != null) {
            sp.block(0L);
        }
        if (b.error != null) {
            throw b.error;
        }
        return b;
    }

    protected int getBufferIndex(long pos) {
        if (pos < (long)this.firstBufferSize) {
            return 0;
        }
        return (int)((pos - (long)this.firstBufferSize) / (long)this.bufferSize) + 1;
    }

    protected int getBufferOffset(long pos) {
        if (pos < (long)this.firstBufferSize) {
            return (int)pos;
        }
        return (int)((pos -= (long)this.firstBufferSize) % (long)this.bufferSize);
    }

    protected long getBufferStart(int index) {
        if (index == 0) {
            return 0L;
        }
        if (index == 1) {
            return this.firstBufferSize;
        }
        return (long)this.firstBufferSize + (long)(index - 1) * (long)this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        List<Buffer> list = this.buffers;
        synchronized (list) {
            for (Buffer b : this.buffers) {
                this.manager.removeBuffer(b);
                b.buffer = null;
                if (b.loading != null) {
                    b.loading.cancel(new CancelException("BufferedIO.cancelAll"));
                }
                b.loading = null;
                if (b.flushing != null) {
                    while (!b.flushing.isEmpty()) {
                        ((AsyncWork)b.flushing.removeFirst()).cancel(new CancelException("BufferedIO.cancelAll"));
                    }
                }
                b.flushing = null;
            }
        }
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return this.manager.close(this);
    }

    @Override
    ISynchronizationPoint<Exception> closed() {
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.io = null;
        this.buffers = null;
        ondone.unblock();
    }

    @Override
    boolean removing(BufferingManager.Buffer buffer) {
        Buffer b = (Buffer)buffer;
        if (b.loading == null) {
            return true;
        }
        if (!b.loading.isUnblocked()) {
            return false;
        }
        b.loading = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    AsyncWork<?, IOException> flushWrite(BufferingManager.Buffer buffer) {
        long pos;
        List<Buffer> list = this.buffers;
        synchronized (list) {
            int i = this.buffers.indexOf(buffer);
            pos = i == 0 ? 0L : (i == 1 ? (long)this.firstBufferSize : (long)this.firstBufferSize + (long)(i - 1) * (long)this.bufferSize);
        }
        return ((IO.Writable.Seekable)((Object)this.io)).writeAsync(pos, ByteBuffer.wrap(buffer.buffer, 0, buffer.len));
    }

    protected ISynchronizationPoint<IOException> flush() {
        return this.manager.fullFlush(this);
    }

    protected ISynchronizationPoint<IOException> canStartReading() {
        int i = this.getBufferIndex(this.pos);
        if (i >= this.buffers.size()) {
            i = 0;
        }
        final Buffer b = this.buffers.get(i);
        final SynchronizationPoint<IOException> sp = new SynchronizationPoint<IOException>();
        SynchronizationPoint l = b.loading;
        if (l != null && !l.isUnblocked()) {
            l.listenInline(new Runnable(){

                @Override
                public void run() {
                    if (b.error != null) {
                        sp.error(b.error);
                    } else {
                        sp.unblock();
                    }
                }
            });
            return sp;
        }
        if (b.error != null) {
            sp.error(b.error);
        } else {
            sp.unblock();
        }
        return sp;
    }

    protected int read() throws IOException {
        int nextIndex;
        if (this.pos == this.size) {
            return -1;
        }
        int bufferIndex = this.getBufferIndex(this.pos);
        Buffer buffer = this.useBufferSync(bufferIndex);
        buffer.lastRead = System.currentTimeMillis();
        byte b = buffer.buffer[this.getBufferOffset(this.pos)];
        ++this.pos;
        if (this.pos < this.size && (bufferIndex != 0 || this.startReadSecondBufferWhenFirstBufferFullyRead) && (nextIndex = this.getBufferIndex(this.pos)) != bufferIndex) {
            this.loadBuffer(nextIndex);
        }
        --buffer.inUse;
        return b & 0xFF;
    }

    protected int read(byte[] buf, int offset, int len) throws IOException {
        int nextIndex;
        if (this.pos == this.size) {
            return -1;
        }
        int bufferIndex = this.getBufferIndex(this.pos);
        Buffer buffer = this.useBufferSync(bufferIndex);
        int start = this.getBufferOffset(this.pos);
        if (len > buffer.len - start) {
            len = buffer.len - start;
        }
        System.arraycopy(buffer.buffer, start, buf, offset, len);
        buffer.lastRead = System.currentTimeMillis();
        --buffer.inUse;
        this.pos += (long)len;
        if (this.pos < this.size && (bufferIndex != 0 || this.startReadSecondBufferWhenFirstBufferFullyRead) && (nextIndex = this.getBufferIndex(this.pos)) != bufferIndex) {
            this.loadBuffer(nextIndex);
        }
        return len;
    }

    protected int readSync(long pos, ByteBuffer buf) throws IOException {
        int nextIndex;
        if (pos >= this.size) {
            return -1;
        }
        int bufferIndex = this.getBufferIndex(pos);
        Buffer buffer = this.useBufferSync(bufferIndex);
        int start = this.getBufferOffset(pos);
        int len = buf.remaining();
        if (len > buffer.len - start) {
            len = buffer.len - start;
        }
        if (len <= 0) {
            return 0;
        }
        buf.put(buffer.buffer, start, len);
        buffer.lastRead = System.currentTimeMillis();
        --buffer.inUse;
        this.pos = pos += (long)len;
        if (pos < this.size && (bufferIndex != 0 || this.startReadSecondBufferWhenFirstBufferFullyRead) && (nextIndex = this.getBufferIndex(pos)) != bufferIndex) {
            this.loadBuffer(nextIndex);
        }
        return len;
    }

    protected int readAsync() throws IOException {
        int nextIndex;
        if (this.pos == this.size) {
            return -1;
        }
        int bufferIndex = this.getBufferIndex(this.pos);
        Buffer buffer = this.useBufferAsync(bufferIndex);
        SynchronizationPoint sp = buffer.loading;
        if (sp != null && !sp.isUnblocked()) {
            buffer.lastRead = System.currentTimeMillis();
            --buffer.inUse;
            return -2;
        }
        if (buffer.error != null) {
            throw buffer.error;
        }
        byte b = buffer.buffer[this.getBufferOffset(this.pos)];
        --buffer.inUse;
        ++this.pos;
        if (this.pos < this.size && (bufferIndex != 0 || this.startReadSecondBufferWhenFirstBufferFullyRead) && (nextIndex = this.getBufferIndex(this.pos)) != bufferIndex) {
            this.loadBuffer(nextIndex);
        }
        return b & 0xFF;
    }

    protected AsyncWork<Integer, IOException> readAsync(final long pos, final ByteBuffer buf, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        if (pos >= this.size) {
            if (ondone != null) {
                ondone.run(new Pair<Integer, Object>(0, null));
            }
            return new AsyncWork<Integer, Object>(0, null);
        }
        final int bufferIndex = this.getBufferIndex(pos);
        final Buffer buffer = this.useBufferAsync(bufferIndex);
        SynchronizationPoint sp = buffer.loading;
        if (sp == null && buffer.error != null) {
            if (ondone != null) {
                ondone.run(new Pair<Object, IOException>(null, buffer.error));
            }
            return new AsyncWork<Object, IOException>(null, buffer.error);
        }
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("Read in BufferedIO", this.getPriority(), ondone){

            @Override
            public Integer run() throws IOException {
                int nextIndex;
                long p;
                if (buffer.error != null) {
                    throw buffer.error;
                }
                int start = BufferedIO.this.getBufferOffset(pos);
                if (start >= buffer.len) {
                    --buffer.inUse;
                    if (pos < BufferedIO.this.size) {
                        throw new IOException("Unexpected buffer size: IO size is " + BufferedIO.this.size + ", length of buffer " + bufferIndex + " is " + buffer.len + ", expected is " + (BufferedIO.this.size - BufferedIO.this.getBufferStart(bufferIndex)));
                    }
                    return 0;
                }
                int len = buf.remaining();
                if (len > buffer.len - start) {
                    len = buffer.len - start;
                }
                buf.put(buffer.buffer, start, len);
                buffer.lastRead = System.currentTimeMillis();
                --buffer.inUse;
                BufferedIO.this.pos = p = pos + (long)len;
                if (p < BufferedIO.this.size && (bufferIndex != 0 || BufferedIO.this.startReadSecondBufferWhenFirstBufferFullyRead) && (nextIndex = BufferedIO.this.getBufferIndex(p)) != bufferIndex) {
                    BufferedIO.this.loadBuffer(nextIndex);
                }
                return len;
            }
        };
        if (sp == null || sp.isUnblocked()) {
            task.start();
        } else {
            task.startOn(sp, true);
        }
        return this.operation(task.getOutput());
    }

    protected AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
        if (this.pos >= this.size) {
            if (ondone != null) {
                ondone.run(new Pair<Object, Object>(null, null));
            }
            return new AsyncWork<Object, Object>(null, null);
        }
        final int bufferIndex = this.getBufferIndex(this.pos);
        final Buffer buffer = this.useBufferAsync(bufferIndex);
        SynchronizationPoint sp = buffer.loading;
        if (sp == null || sp.isUnblocked()) {
            int nextIndex;
            long p;
            if (buffer.error != null) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, IOException>(null, buffer.error));
                }
                return new AsyncWork<Object, IOException>(null, buffer.error);
            }
            int start = this.getBufferOffset(this.pos);
            ByteBuffer buf = ByteBuffer.allocate(buffer.len - start);
            buf.put(buffer.buffer, start, buffer.len - start);
            buffer.lastRead = System.currentTimeMillis();
            --buffer.inUse;
            this.pos = p = this.pos + (long)buffer.len - (long)start;
            if (p < this.size && (bufferIndex != 0 || this.startReadSecondBufferWhenFirstBufferFullyRead) && (nextIndex = this.getBufferIndex(p)) != bufferIndex) {
                this.loadBuffer(nextIndex);
            }
            buf.flip();
            if (ondone != null) {
                ondone.run(new Pair<ByteBuffer, Object>(buf, null));
            }
            return new AsyncWork<ByteBuffer, Object>(buf, null);
        }
        Task.Cpu<ByteBuffer, IOException> task = new Task.Cpu<ByteBuffer, IOException>("Read in BufferedIO", this.getPriority(), ondone){

            @Override
            public ByteBuffer run() throws IOException {
                int nextIndex;
                long p;
                if (buffer.error != null) {
                    throw buffer.error;
                }
                int start = BufferedIO.this.getBufferOffset(BufferedIO.this.pos);
                ByteBuffer buf = ByteBuffer.allocate(buffer.len - start);
                buf.put(buffer.buffer, start, buffer.len - start);
                buffer.lastRead = System.currentTimeMillis();
                --buffer.inUse;
                BufferedIO.this.pos = p = BufferedIO.this.pos + (long)buffer.len - (long)start;
                if (p < BufferedIO.this.size && (bufferIndex != 0 || BufferedIO.this.startReadSecondBufferWhenFirstBufferFullyRead) && (nextIndex = BufferedIO.this.getBufferIndex(p)) != bufferIndex) {
                    BufferedIO.this.loadBuffer(nextIndex);
                }
                buf.flip();
                return buf;
            }
        };
        task.startOn(sp, true);
        return this.operation(task.getOutput());
    }

    protected int readFully(byte[] buf) throws IOException {
        int nb;
        int nextIndex;
        if (this.pos == this.size) {
            return -1;
        }
        int bufferIndex = this.getBufferIndex(this.pos);
        Buffer buffer = this.useBufferSync(bufferIndex);
        int len = buf.length;
        int start = this.getBufferOffset(this.pos);
        if (len > buffer.len - start) {
            len = buffer.len - start;
        }
        System.arraycopy(buffer.buffer, start, buf, 0, len);
        buffer.lastRead = System.currentTimeMillis();
        --buffer.inUse;
        this.pos += (long)len;
        if (this.pos < this.size && (bufferIndex != 0 || this.startReadSecondBufferWhenFirstBufferFullyRead) && (nextIndex = this.getBufferIndex(this.pos)) != bufferIndex) {
            this.loadBuffer(nextIndex);
        }
        if (len == buf.length) {
            return len;
        }
        int bufPos = len;
        for (int remaining = buf.length - bufPos; this.pos < this.size && remaining > 0 && (nb = this.read(buf, bufPos, remaining)) > 0; remaining -= nb) {
            bufPos += nb;
        }
        return bufPos;
    }

    protected int readFullySync(long pos, ByteBuffer buf) throws IOException {
        int nb;
        int nextIndex;
        if (pos >= this.size) {
            return -1;
        }
        int bufferIndex = this.getBufferIndex(pos);
        Buffer buffer = this.useBufferSync(bufferIndex);
        int start = this.getBufferOffset(pos);
        int len = buf.remaining();
        if (len > buffer.len - start) {
            len = buffer.len - start;
        }
        buf.put(buffer.buffer, start, len);
        buffer.lastRead = System.currentTimeMillis();
        --buffer.inUse;
        this.pos = pos += (long)len;
        if (pos < this.size && (bufferIndex != 0 || this.startReadSecondBufferWhenFirstBufferFullyRead) && (nextIndex = this.getBufferIndex(pos)) != bufferIndex) {
            this.loadBuffer(nextIndex);
        }
        if (buf.remaining() == 0) {
            return len;
        }
        int bufPos = len;
        while (pos < this.size && buf.remaining() > 0 && (nb = this.readSync(pos, buf)) > 0) {
            bufPos += nb;
            pos += (long)nb;
        }
        return bufPos;
    }

    protected AsyncWork<Integer, IOException> readFullyAsync(final long pos, final ByteBuffer buf, final int alreadyDone, final RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        if (pos >= this.size) {
            if (ondone != null) {
                ondone.run(new Pair<Integer, Object>(alreadyDone > 0 ? alreadyDone : -1, null));
            }
            return new AsyncWork<Integer, Object>(alreadyDone > 0 ? alreadyDone : -1, null);
        }
        final int bufferIndex = this.getBufferIndex(pos);
        final Buffer buffer = this.useBufferAsync(bufferIndex);
        SynchronizationPoint sp = buffer.loading;
        if (sp == null && buffer.error != null) {
            if (ondone != null) {
                ondone.run(new Pair<Object, IOException>(null, buffer.error));
            }
            return new AsyncWork<Object, IOException>(null, buffer.error);
        }
        final AsyncWork done = new AsyncWork();
        Task.Cpu<Void, IOException> task = new Task.Cpu<Void, IOException>("Read in BufferedIO at " + pos, this.getPriority()){

            @Override
            public Void run() throws IOException {
                int nextIndex;
                long p;
                if (buffer.error != null) {
                    if (ondone != null) {
                        ondone.run(new Pair<Object, IOException>(null, buffer.error));
                    }
                    done.unblockError(buffer.error);
                    throw buffer.error;
                }
                int start = BufferedIO.this.getBufferOffset(pos);
                if (start >= buffer.len) {
                    --buffer.inUse;
                    if (pos < BufferedIO.this.size) {
                        IOException err = new IOException("Unexpected buffer size: IO size is " + BufferedIO.this.size + ", and length of buffer " + bufferIndex + " is " + buffer.len);
                        if (ondone != null) {
                            ondone.run(new Pair<Object, IOException>(null, err));
                        }
                        done.error(err);
                    } else {
                        if (ondone != null) {
                            ondone.run(new Pair<Integer, Object>(alreadyDone > 0 ? alreadyDone : -1, null));
                        }
                        done.unblockSuccess(alreadyDone > 0 ? alreadyDone : -1);
                    }
                    return null;
                }
                int len = buf.remaining();
                if (len > buffer.len - start) {
                    len = buffer.len - start;
                }
                buf.put(buffer.buffer, start, len);
                buffer.lastRead = System.currentTimeMillis();
                --buffer.inUse;
                BufferedIO.this.pos = p = pos + (long)len;
                if (p < BufferedIO.this.size && (bufferIndex != 0 || BufferedIO.this.startReadSecondBufferWhenFirstBufferFullyRead) && (nextIndex = BufferedIO.this.getBufferIndex(p)) != bufferIndex) {
                    BufferedIO.this.loadBuffer(nextIndex);
                }
                if (buf.remaining() == 0) {
                    if (ondone != null) {
                        ondone.run(new Pair<Integer, Object>(alreadyDone + len, null));
                    }
                    done.unblockSuccess(alreadyDone + len);
                    return null;
                }
                final int previous = alreadyDone + len;
                final AsyncWork<Integer, IOException> next = BufferedIO.this.readFullyAsync(p, buf, 0, null);
                next.listenInline(new Runnable(){

                    @Override
                    public void run() {
                        if (next.isSuccessful()) {
                            int result = previous;
                            if ((Integer)next.getResult() > 0) {
                                result += ((Integer)next.getResult()).intValue();
                            }
                            if (ondone != null) {
                                ondone.run(new Pair<Integer, Object>(result, null));
                            }
                            done.unblockSuccess(result);
                            return;
                        }
                        if (next.isCancelled()) {
                            done.unblockCancel(next.getCancelEvent());
                            return;
                        }
                        if (ondone != null) {
                            ondone.run(new Pair(null, next.getError()));
                        }
                        done.unblockError(next.getError());
                    }
                });
                return null;
            }
        };
        if (sp == null || sp.isUnblocked()) {
            task.start();
        } else {
            task.startOn(sp, true);
        }
        done.forwardCancel(task.getOutput());
        task.getOutput().forwardCancel(done);
        return this.operation(done);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AsyncWork<Void, IOException> increaseSize(final long newSize) {
        AsyncWork<Void, IOException> resize = ((IO.Resizable)((Object)this.io)).setSizeAsync(newSize);
        SynchronizationPoint lastBuffer = null;
        final int prevIndex = this.size > 0L ? this.getBufferIndex(this.size - 1L) : 0;
        int firstIndex = this.getBufferIndex(this.size);
        final int lastIndex = this.getBufferIndex(newSize - 1L);
        if (prevIndex == firstIndex && this.size > 0L) {
            final Buffer buffer = this.useBufferAsync(prevIndex);
            lastBuffer = buffer.loading;
            if (lastBuffer == null || lastBuffer.isUnblocked()) {
                buffer.len = lastIndex > prevIndex ? buffer.buffer.length : (int)(newSize - this.getBufferStart(prevIndex));
                buffer.lastRead = System.currentTimeMillis();
                --buffer.inUse;
            } else {
                lastBuffer.listenInline(new Runnable(){

                    @Override
                    public void run() {
                        buffer.len = lastIndex > prevIndex ? buffer.buffer.length : (int)(newSize - BufferedIO.this.getBufferStart(prevIndex));
                        buffer.lastRead = System.currentTimeMillis();
                        --buffer.inUse;
                    }
                });
            }
            ++firstIndex;
        }
        JoinPoint jp = new JoinPoint();
        LinkedList<Buffer> newBuffers = new LinkedList<Buffer>();
        List<Buffer> list = this.buffers;
        synchronized (list) {
            while (firstIndex > this.buffers.size()) {
                this.buffers.add(new Buffer(this));
            }
            while (firstIndex <= lastIndex) {
                Buffer b;
                if (firstIndex == this.buffers.size()) {
                    b = new Buffer(this);
                    this.buffers.add(b);
                } else {
                    b = this.buffers.get(firstIndex);
                }
                if (b.buffer == null && (b.loading == null || b.loading.isUnblocked())) {
                    b.buffer = new byte[firstIndex > 0 ? this.bufferSize : this.firstBufferSize];
                    newBuffers.add(b);
                }
                if (b.loading != null && !b.loading.isUnblocked()) {
                    int i = firstIndex;
                    Buffer buf = b;
                    b.loading.listenInline(() -> {
                        buf.len = i < lastIndex ? buf.buffer.length : (int)(newSize - this.getBufferStart(i));
                        buf.lastRead = System.currentTimeMillis();
                    });
                    jp.addToJoin(b.loading);
                } else {
                    b.len = firstIndex < lastIndex ? b.buffer.length : (int)(newSize - this.getBufferStart(firstIndex));
                    b.lastRead = System.currentTimeMillis();
                }
                ++firstIndex;
            }
        }
        while (!newBuffers.isEmpty()) {
            this.manager.newBuffer((BufferingManager.Buffer)newBuffers.removeFirst());
        }
        final AsyncWork<Void, IOException> sp = new AsyncWork<Void, IOException>();
        if (lastBuffer != null) {
            jp.addToJoin(lastBuffer);
        }
        jp.start();
        resize.listenInline(() -> {
            if (jp.isUnblocked()) {
                this.size = newSize;
                sp.unblockSuccess(null);
            } else {
                jp.listenInline(new Runnable(){

                    @Override
                    public void run() {
                        BufferedIO.this.size = newSize;
                        sp.unblockSuccess(null);
                    }
                });
            }
        }, sp);
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AsyncWork<Void, IOException> decreaseSize(long newSize) {
        final AsyncWork<Void, IOException> result = new AsyncWork<Void, IOException>();
        if (newSize < 0L) {
            newSize = 0L;
        }
        final int lastBufferIndex = newSize == 0L ? -1 : this.getBufferIndex(newSize - 1L);
        JoinPoint jp = new JoinPoint();
        List<Buffer> list = this.buffers;
        synchronized (list) {
            for (int i = this.buffers.size() - 1; i >= lastBufferIndex && i >= 0; --i) {
                Buffer buffer;
                Buffer buffer2 = buffer = this.buffers.get(i);
                synchronized (buffer2) {
                    if (buffer.loading != null && !buffer.loading.isUnblocked()) {
                        jp.addToJoin(buffer.loading);
                    }
                    if (buffer.flushing != null) {
                        for (AsyncWork f : buffer.flushing) {
                            jp.addToJoin(f);
                        }
                    }
                    if (i != lastBufferIndex) {
                        buffer.lastRead = System.currentTimeMillis();
                        buffer.lastWrite = 0L;
                    }
                    continue;
                }
            }
        }
        jp.start();
        final long ns = newSize;
        jp.listenAsync(new Task.Cpu<Void, NoException>("Decrease size of BufferedIO", this.getPriority()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                Buffer lastBuffer = null;
                LinkedList<Buffer> removed = new LinkedList<Buffer>();
                List<Buffer> list = BufferedIO.this.buffers;
                synchronized (list) {
                    while (BufferedIO.this.buffers.size() > lastBufferIndex + 1) {
                        Buffer buffer = BufferedIO.this.buffers.remove(BufferedIO.this.buffers.size() - 1);
                        if (buffer.buffer == null) continue;
                        removed.add(buffer);
                    }
                    if (ns > 0L) {
                        lastBuffer = BufferedIO.this.buffers.get(lastBufferIndex);
                    }
                }
                while (!removed.isEmpty()) {
                    BufferedIO.this.manager.removeBuffer((BufferingManager.Buffer)removed.removeFirst());
                }
                if (lastBuffer != null) {
                    int lastBufferSize = ns <= (long)BufferedIO.this.firstBufferSize ? (int)ns : (int)((ns - (long)BufferedIO.this.firstBufferSize) % (long)BufferedIO.this.bufferSize);
                    lastBuffer.len = lastBufferSize;
                    lastBuffer.lastRead = System.currentTimeMillis();
                }
                AsyncWork<Void, IOException> resize = ((IO.Resizable)((Object)BufferedIO.this.io)).setSizeAsync(ns);
                resize.listenInline(() -> {
                    BufferedIO.this.size = ns;
                    if (BufferedIO.this.pos > BufferedIO.this.size) {
                        BufferedIO.this.pos = BufferedIO.this.size;
                    }
                    result.unblockSuccess(null);
                }, (ISynchronizationPoint<IOException>)result);
                return null;
            }
        }, true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AsyncWork<Integer, IOException> writeAsync(final long pos, final ByteBuffer buf, final int alreadyDone, final RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        Buffer buffer;
        if (this.closing) {
            return new AsyncWork<Object, Object>(null, null, new CancelException("IO closed"));
        }
        if (pos > this.size) {
            AsyncWork<Void, IOException> resize = this.increaseSize(pos);
            this.size = pos;
            AsyncWork sp = new AsyncWork();
            IOUtil.listenOnDone(resize, result -> {
                AsyncWork<Integer, IOException> write = this.writeAsync(pos, buf, alreadyDone, null);
                IOUtil.listenOnDone(write, sp, ondone);
            }, sp, ondone);
            return this.operation(sp);
        }
        final int bufferIndex = this.getBufferIndex(pos);
        if (pos < this.size || this.size > 0L && this.getBufferIndex(this.size - 1L) == bufferIndex) {
            buffer = this.useBufferAsync(bufferIndex);
        } else {
            List<Buffer> buffers = this.buffers;
            if (this.closing || buffers == null) {
                return new AsyncWork<Object, Object>(null, null, new CancelException("IO closed"));
            }
            boolean isNew = false;
            List<Buffer> list = buffers;
            synchronized (list) {
                if (bufferIndex == buffers.size()) {
                    buffer = new Buffer(this);
                    buffer.buffer = new byte[bufferIndex == 0 ? this.firstBufferSize : this.bufferSize];
                    buffer.len = 0;
                    buffer.inUse = 1;
                    buffers.add(buffer);
                    isNew = true;
                } else {
                    buffer = buffers.get(bufferIndex);
                    if (buffer.buffer == null && (buffer.loading == null || buffer.loading.isUnblocked())) {
                        buffer.buffer = new byte[bufferIndex == 0 ? this.firstBufferSize : this.bufferSize];
                        buffer.len = 0;
                        isNew = true;
                    }
                    ++buffer.inUse;
                }
            }
            if (isNew) {
                this.manager.newBuffer(buffer);
            }
        }
        SynchronizationPoint sp = buffer.loading;
        final AsyncWork done = new AsyncWork();
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Writting to BufferedIO", this.getPriority()){

            @Override
            public Void run() {
                long p;
                if (buffer.error != null) {
                    if (ondone != null) {
                        ondone.run(new Pair<Object, IOException>(null, buffer.error));
                    }
                    done.unblockError(buffer.error);
                    return null;
                }
                if (BufferedIO.this.closing) {
                    done.cancel(new CancelException("IO closed"));
                    return null;
                }
                int start = BufferedIO.this.getBufferOffset(pos);
                int len = buf.remaining();
                if (len > buffer.buffer.length - start) {
                    len = buffer.buffer.length - start;
                }
                buf.get(buffer.buffer, start, len);
                if (start + len > buffer.len) {
                    buffer.len = start + len;
                }
                BufferedIO.this.manager.toBeWritten(buffer);
                --buffer.inUse;
                BufferedIO.this.pos = p = pos + (long)len;
                if (p < BufferedIO.this.size && (bufferIndex != 0 || BufferedIO.this.startReadSecondBufferWhenFirstBufferFullyRead)) {
                    int nextIndex = BufferedIO.this.getBufferIndex(p);
                    if (nextIndex != bufferIndex) {
                        BufferedIO.this.loadBuffer(nextIndex);
                    }
                } else if (p > BufferedIO.this.size) {
                    BufferedIO.this.size = p;
                }
                if (buf.remaining() == 0) {
                    if (ondone != null) {
                        ondone.run(new Pair<Integer, Object>(len + alreadyDone, null));
                    }
                    done.unblockSuccess(len + alreadyDone);
                    return null;
                }
                AsyncWork<Integer, IOException> next = BufferedIO.this.writeAsync(p, buf, len + alreadyDone, null);
                IOUtil.listenOnDone(next, done, ondone);
                return null;
            }
        };
        task.getOutput().forwardCancel(done);
        if (sp == null || sp.isUnblocked()) {
            task.start();
        } else {
            sp.listenAsync(task, true);
        }
        return this.operation(done);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeSync(long pos, ByteBuffer buf, int alreadyDone) throws IOException {
        long p;
        Buffer buffer;
        if (pos > this.size) {
            AsyncWork<Void, IOException> resize = this.increaseSize(pos);
            this.size = pos;
            try {
                resize.blockResult(0L);
            }
            catch (CancelException e) {
                throw new IOException("Cancelled", e);
            }
        }
        int bufferIndex = this.getBufferIndex(pos);
        if (pos < this.size || this.size > 0L && this.getBufferIndex(this.size - 1L) == bufferIndex) {
            buffer = this.useBufferAsync(bufferIndex);
        } else {
            boolean isNew = false;
            List<Buffer> list = this.buffers;
            synchronized (list) {
                if (bufferIndex == this.buffers.size()) {
                    buffer = new Buffer(this);
                    buffer.buffer = new byte[bufferIndex == 0 ? this.firstBufferSize : this.bufferSize];
                    buffer.len = 0;
                    buffer.inUse = 1;
                    this.buffers.add(buffer);
                    isNew = true;
                } else {
                    buffer = this.buffers.get(bufferIndex);
                    if (buffer.buffer == null && (buffer.loading == null || buffer.loading.isUnblocked())) {
                        buffer.buffer = new byte[bufferIndex == 0 ? this.firstBufferSize : this.bufferSize];
                        buffer.len = 0;
                        isNew = true;
                    }
                    ++buffer.inUse;
                }
            }
            if (isNew) {
                this.manager.newBuffer(buffer);
            }
        }
        SynchronizationPoint sp = buffer.loading;
        if (sp != null && !sp.isUnblocked()) {
            sp.block(0L);
        }
        if (buffer.error != null) {
            throw buffer.error;
        }
        int start = this.getBufferOffset(pos);
        int len = buf.remaining();
        if (len > buffer.buffer.length - start) {
            len = buffer.buffer.length - start;
        }
        buf.get(buffer.buffer, start, len);
        if (start + len > buffer.len) {
            buffer.len = start + len;
        }
        this.manager.toBeWritten(buffer);
        --buffer.inUse;
        this.pos = p = pos + (long)len;
        if (p < this.size && (bufferIndex != 0 || this.startReadSecondBufferWhenFirstBufferFullyRead)) {
            int nextIndex = this.getBufferIndex(p);
            if (nextIndex != bufferIndex) {
                this.loadBuffer(nextIndex);
            }
        } else if (p > this.size) {
            this.size = p;
        }
        if (buf.remaining() == 0) {
            return alreadyDone + len;
        }
        return this.writeSync(p, buf, alreadyDone + len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(byte[] buf, int offset, int length) throws IOException {
        do {
            Buffer buffer;
            int bufferIndex = this.getBufferIndex(this.pos);
            if (this.pos < this.size || this.size > 0L && this.getBufferIndex(this.size - 1L) == bufferIndex) {
                buffer = this.useBufferAsync(bufferIndex);
            } else {
                boolean isNew = false;
                List<Buffer> list = this.buffers;
                synchronized (list) {
                    if (bufferIndex == this.buffers.size()) {
                        buffer = new Buffer(this);
                        buffer.buffer = new byte[bufferIndex == 0 ? this.firstBufferSize : this.bufferSize];
                        buffer.len = 0;
                        buffer.inUse = 1;
                        this.buffers.add(buffer);
                        isNew = true;
                    } else {
                        buffer = this.buffers.get(bufferIndex);
                        if (buffer.buffer == null && (buffer.loading == null || buffer.loading.isUnblocked())) {
                            buffer.buffer = new byte[bufferIndex == 0 ? this.firstBufferSize : this.bufferSize];
                            buffer.len = 0;
                            isNew = true;
                        }
                        ++buffer.inUse;
                    }
                }
                if (isNew) {
                    this.manager.newBuffer(buffer);
                }
            }
            SynchronizationPoint sp = buffer.loading;
            if (sp != null && !sp.isUnblocked()) {
                sp.block(0L);
            }
            if (buffer.error != null) {
                throw buffer.error;
            }
            int len = length;
            int start = this.getBufferOffset(this.pos);
            if (len > buffer.buffer.length - start) {
                len = buffer.buffer.length - start;
            }
            System.arraycopy(buf, offset, buffer.buffer, start, len);
            if (start + len > buffer.len) {
                buffer.len = start + len;
            }
            this.manager.toBeWritten(buffer);
            --buffer.inUse;
            this.pos += (long)len;
            offset += len;
            length -= len;
            if (this.pos < this.size && (bufferIndex != 0 || this.startReadSecondBufferWhenFirstBufferFullyRead)) {
                int nextIndex = this.getBufferIndex(this.pos);
                if (nextIndex == bufferIndex) continue;
                this.loadBuffer(nextIndex);
                continue;
            }
            if (this.pos <= this.size) continue;
            this.size = this.pos;
        } while (length > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(byte b) throws IOException {
        Buffer buffer;
        int bufferIndex = this.getBufferIndex(this.pos);
        if (this.pos < this.size || this.size > 0L && this.getBufferIndex(this.size - 1L) == bufferIndex) {
            buffer = this.useBufferAsync(bufferIndex);
        } else {
            boolean isNew = false;
            List<Buffer> list = this.buffers;
            synchronized (list) {
                if (bufferIndex == this.buffers.size()) {
                    buffer = new Buffer(this);
                    buffer.buffer = new byte[bufferIndex == 0 ? this.firstBufferSize : this.bufferSize];
                    buffer.len = 0;
                    buffer.inUse = 1;
                    this.buffers.add(buffer);
                    isNew = true;
                } else {
                    buffer = this.buffers.get(bufferIndex);
                    if (buffer.buffer == null && (buffer.loading == null || buffer.loading.isUnblocked())) {
                        buffer.buffer = new byte[bufferIndex == 0 ? this.firstBufferSize : this.bufferSize];
                        buffer.len = 0;
                        isNew = true;
                    }
                    ++buffer.inUse;
                }
            }
            if (isNew) {
                this.manager.newBuffer(buffer);
            }
        }
        SynchronizationPoint sp = buffer.loading;
        if (sp != null && !sp.isUnblocked()) {
            sp.block(0L);
        }
        if (buffer.error != null) {
            throw buffer.error;
        }
        int start = this.getBufferOffset(this.pos);
        buffer.buffer[start] = b;
        if (start + 1 > buffer.len) {
            buffer.len = start + 1;
        }
        this.manager.toBeWritten(buffer);
        --buffer.inUse;
        ++this.pos;
        if (this.pos < this.size && (bufferIndex != 0 || this.startReadSecondBufferWhenFirstBufferFullyRead)) {
            int nextIndex = this.getBufferIndex(this.pos);
            if (nextIndex != bufferIndex) {
                this.loadBuffer(nextIndex);
            }
        } else if (this.pos > this.size) {
            this.size = this.pos;
        }
    }

    public static class ReadWrite
    extends BufferedIO
    implements IO.Readable.Seekable,
    IO.Readable.Buffered,
    IO.Writable.Seekable,
    IO.Writable.Buffered,
    IO.KnownSize,
    IO.Resizable {
        public <T extends IO.Readable.Seekable & IO.Writable.Seekable> ReadWrite(T io, int bufferSize, long size) throws IOException {
            super(io, bufferSize, size);
        }

        public <T extends IO.Readable.Seekable & IO.Writable.Seekable> ReadWrite(T io, int firstBufferSize, int bufferSize, long size, boolean startReadSecondBufferWhenFirstBufferFullyRead) throws IOException {
            super(io, firstBufferSize, bufferSize, size, startReadSecondBufferWhenFirstBufferFullyRead);
        }

        @Override
        public ISynchronizationPoint<IOException> canStartReading() {
            return super.canStartReading();
        }

        @Override
        public ISynchronizationPoint<IOException> canStartWriting() {
            return this.canStartReading();
        }

        @Override
        public IO getWrappedIO() {
            return this.io;
        }

        @Override
        public String getSourceDescription() {
            if (this.io == null) {
                return "";
            }
            return this.io.getSourceDescription();
        }

        @Override
        public byte getPriority() {
            if (this.io == null) {
                return 4;
            }
            return this.io.getPriority();
        }

        @Override
        public void setPriority(byte priority) {
            this.io.setPriority(priority);
        }

        @Override
        public TaskManager getTaskManager() {
            return Threading.getCPUTaskManager();
        }

        @Override
        public long getPosition() {
            return this.pos;
        }

        @Override
        public long getSizeSync() {
            return this.size;
        }

        @Override
        public AsyncWork<Long, IOException> getSizeAsync() {
            AsyncWork<Long, IOException> sp = new AsyncWork<Long, IOException>();
            sp.unblockSuccess(this.size);
            return sp;
        }

        @Override
        public int skip(int skip) {
            return (int)this.skipSync(skip);
        }

        @Override
        public long skipSync(long skip) {
            if (this.pos + skip > this.size) {
                skip = this.size - this.pos;
            }
            if (this.pos + skip < 0L) {
                skip = -this.pos;
            }
            this.pos += skip;
            if (this.pos < this.size) {
                this.loadBuffer(this.getBufferIndex(this.pos));
            }
            return skip;
        }

        @Override
        public long seekSync(IO.Seekable.SeekType type, long move) {
            switch (type) {
                case FROM_BEGINNING: {
                    this.pos = move;
                    break;
                }
                case FROM_END: {
                    this.pos = this.size - move;
                    break;
                }
                case FROM_CURRENT: {
                    this.pos += move;
                    break;
                }
            }
            if (this.pos < 0L) {
                this.pos = 0L;
            }
            if (this.pos > this.size) {
                this.pos = this.size;
            }
            return this.pos;
        }

        @Override
        public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            this.seekSync(type, move);
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(this.pos, null));
            }
            return new AsyncWork<Long, Object>(this.pos, null);
        }

        @Override
        public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move) {
            return IO.Writable.Seekable.super.seekAsync(type, move);
        }

        @Override
        public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            long skipped = this.skipSync(n);
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(skipped, null));
            }
            return new AsyncWork<Long, Object>(skipped, null);
        }

        @Override
        public int read() throws IOException {
            return super.read();
        }

        @Override
        public int read(byte[] buf, int offset, int len) throws IOException {
            return super.read(buf, offset, len);
        }

        @Override
        public int readFully(byte[] buf) throws IOException {
            return super.readFully(buf);
        }

        @Override
        public int readSync(long pos, ByteBuffer buf) throws IOException {
            return super.readSync(pos, buf);
        }

        @Override
        public int readSync(ByteBuffer buf) throws IOException {
            return super.readSync(this.pos, buf);
        }

        @Override
        public int readAsync() throws IOException {
            return super.readAsync();
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(long pos, ByteBuffer buf, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readAsync(pos, buf, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(ByteBuffer buf, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readAsync(this.pos, buf, ondone);
        }

        @Override
        public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
            return super.readNextBufferAsync(ondone);
        }

        @Override
        public int readFullySync(long pos, ByteBuffer buf) throws IOException {
            return super.readFullySync(pos, buf);
        }

        @Override
        public int readFullySync(ByteBuffer buf) throws IOException {
            return super.readFullySync(this.pos, buf);
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buf, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(pos, buf, 0, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buf, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(this.pos, buf, 0, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(pos, buffer, 0, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> writeAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(this.pos, buffer, 0, ondone);
        }

        @Override
        public int writeSync(long pos, ByteBuffer buffer) throws IOException {
            return super.writeSync(pos, buffer, 0);
        }

        @Override
        public int writeSync(ByteBuffer buffer) throws IOException {
            return super.writeSync(this.pos, buffer, 0);
        }

        @Override
        public void setSizeSync(long newSize) throws IOException {
            if (newSize == this.size) {
                return;
            }
            try {
                if (newSize > this.size) {
                    this.operation(this.increaseSize(newSize)).blockResult(0L);
                } else {
                    this.operation(this.decreaseSize(newSize)).blockResult(0L);
                }
            }
            catch (CancelException e) {
                throw new IOException("Cancelled", e);
            }
        }

        @Override
        public AsyncWork<Void, IOException> setSizeAsync(long newSize) {
            if (newSize == this.size) {
                return new AsyncWork<Object, Object>(null, null);
            }
            if (newSize > this.size) {
                return this.operation(this.increaseSize(newSize));
            }
            return this.operation(this.decreaseSize(newSize));
        }

        @Override
        public void write(byte b) throws IOException {
            super.write(b);
        }

        @Override
        public void write(byte[] buf, int offset, int length) throws IOException {
            super.write(buf, offset, length);
        }

        @Override
        public ISynchronizationPoint<IOException> flush() {
            return super.flush();
        }
    }

    public static class ReadOnly
    extends BufferedIO
    implements IO.Readable.Seekable,
    IO.Readable.Buffered,
    IO.KnownSize {
        public ReadOnly(IO.Readable.Seekable io, int bufferSize, long size) throws IOException {
            super(io, bufferSize, size);
        }

        public ReadOnly(IO.Readable.Seekable io, int firstBufferSize, int bufferSize, long size, boolean startReadSecondBufferWhenFirstBufferFullyRead) throws IOException {
            super(io, firstBufferSize, bufferSize, size, startReadSecondBufferWhenFirstBufferFullyRead);
        }

        @Override
        public ISynchronizationPoint<IOException> canStartReading() {
            return super.canStartReading();
        }

        @Override
        public IO getWrappedIO() {
            return this.io;
        }

        @Override
        public String getSourceDescription() {
            if (this.io == null) {
                return "";
            }
            return this.io.getSourceDescription();
        }

        @Override
        public byte getPriority() {
            if (this.io == null) {
                return 4;
            }
            return this.io.getPriority();
        }

        @Override
        public void setPriority(byte priority) {
            this.io.setPriority(priority);
        }

        @Override
        public TaskManager getTaskManager() {
            return Threading.getCPUTaskManager();
        }

        @Override
        public long getPosition() {
            return this.pos;
        }

        @Override
        public long getSizeSync() {
            return this.size;
        }

        @Override
        public AsyncWork<Long, IOException> getSizeAsync() {
            AsyncWork<Long, IOException> sp = new AsyncWork<Long, IOException>();
            sp.unblockSuccess(this.size);
            return sp;
        }

        @Override
        public int skip(int skip) {
            return (int)this.skipSync(skip);
        }

        @Override
        public long skipSync(long skip) {
            if (this.pos + skip > this.size) {
                skip = this.size - this.pos;
            }
            if (this.pos + skip < 0L) {
                skip = -this.pos;
            }
            this.pos += skip;
            if (this.pos < this.size) {
                this.loadBuffer(this.getBufferIndex(this.pos));
            }
            return skip;
        }

        @Override
        public long seekSync(IO.Seekable.SeekType type, long move) {
            switch (type) {
                case FROM_BEGINNING: {
                    this.pos = move;
                    break;
                }
                case FROM_END: {
                    this.pos = this.size - move;
                    break;
                }
                case FROM_CURRENT: {
                    this.pos += move;
                    break;
                }
            }
            if (this.pos < 0L) {
                this.pos = 0L;
            }
            if (this.pos > this.size) {
                this.pos = this.size;
            }
            return this.pos;
        }

        @Override
        public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            this.seekSync(type, move);
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(this.pos, null));
            }
            return new AsyncWork<Long, Object>(this.pos, null);
        }

        @Override
        public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            long skipped = this.skipSync(n);
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(skipped, null));
            }
            return new AsyncWork<Long, Object>(skipped, null);
        }

        @Override
        public int read() throws IOException {
            return super.read();
        }

        @Override
        public int read(byte[] buf, int offset, int len) throws IOException {
            return super.read(buf, offset, len);
        }

        @Override
        public int readFully(byte[] buf) throws IOException {
            return super.readFully(buf);
        }

        @Override
        public int readSync(long pos, ByteBuffer buf) throws IOException {
            return super.readSync(pos, buf);
        }

        @Override
        public int readSync(ByteBuffer buf) throws IOException {
            return super.readSync(this.pos, buf);
        }

        @Override
        public int readAsync() throws IOException {
            return super.readAsync();
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(long pos, ByteBuffer buf, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readAsync(pos, buf, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(ByteBuffer buf, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readAsync(this.pos, buf, ondone);
        }

        @Override
        public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
            return super.readNextBufferAsync(ondone);
        }

        @Override
        public int readFullySync(long pos, ByteBuffer buf) throws IOException {
            return super.readFullySync(pos, buf);
        }

        @Override
        public int readFullySync(ByteBuffer buf) throws IOException {
            return super.readFullySync(this.pos, buf);
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buf, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(pos, buf, 0, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buf, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(this.pos, buf, 0, ondone);
        }
    }

    protected static class Buffer
    extends BufferingManager.Buffer {
        private SynchronizationPoint<NoException> loading;
        private IOException error;

        private Buffer(BufferedIO owner) {
            this.owner = owner;
        }
    }
}

