/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.collections.sort.OldestList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.buffering.BufferingManaged;
import net.lecousin.framework.memory.IMemoryManageable;
import net.lecousin.framework.util.StringUtil;

public class BufferingManager
implements Closeable,
IMemoryManageable {
    public static final int DEFAULT_MEMORY_THRESHOLD = 0x3700000;
    public static final int DEFAULT_MAX_MEMORY = 0x4000000;
    public static final int DEFAULT_TO_BE_WRITTEN_THRESHOLD = 0xC00000;
    private Background background;
    private LinkedArrayList<Buffer> buffers = new LinkedArrayList(25);
    private long totalMemory = 0L;
    private long maxMemory = 0x4000000L;
    private long memoryThreshold = 0x3700000L;
    private long lastFree = 0L;
    private long toBeWritten = 0L;
    private long toBeWrittenThreshold = 0xC00000L;

    private BufferingManager() {
        this.background = new Background();
        this.background.start();
    }

    public static synchronized BufferingManager get() {
        Application app = LCCore.getApplication();
        BufferingManager bm = app.getInstance(BufferingManager.class);
        if (bm == null) {
            bm = new BufferingManager();
            app.setInstance(BufferingManager.class, bm);
            app.toClose(bm);
        }
        return bm;
    }

    public long getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getToBeWrittenThreshold() {
        return this.toBeWrittenThreshold;
    }

    public void setMemoryLimits(long memoryThreshold, long maxMemory, long toBeWrittenThreshold) {
        this.maxMemory = maxMemory;
        this.memoryThreshold = memoryThreshold;
        this.toBeWrittenThreshold = toBeWrittenThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newBuffer(Buffer buffer) {
        LinkedArrayList<Buffer> linkedArrayList = this.buffers;
        synchronized (linkedArrayList) {
            if (buffer.owner.closing) {
                return;
            }
            this.buffers.add(buffer);
            this.totalMemory += (long)buffer.buffer.length;
        }
        if (this.totalMemory > this.maxMemory) {
            long now = System.currentTimeMillis();
            if (now - this.lastFree < 5000L) {
                this.freeBuffers(50);
            } else if (now - this.lastFree < 15000L) {
                this.freeBuffers(25);
            } else {
                this.freeBuffers(10);
            }
            this.background.executeNextOccurenceNow((byte)3);
        } else if (this.totalMemory > this.memoryThreshold) {
            this.background.executeNextOccurenceNow((byte)4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBuffer(Buffer buffer) {
        LinkedArrayList<Buffer> linkedArrayList = this.buffers;
        synchronized (linkedArrayList) {
            if (!this.buffers.remove(buffer)) {
                return;
            }
            if (buffer.buffer != null) {
                this.totalMemory -= (long)buffer.buffer.length;
                this.toBeWritten -= (long)buffer.markedAsToBeWritten;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void toBeWritten(Buffer buffer) {
        LinkedArrayList<Buffer> linkedArrayList = this.buffers;
        synchronized (linkedArrayList) {
            if (buffer.markedAsToBeWritten != buffer.buffer.length) {
                this.toBeWritten += (long)(buffer.buffer.length - buffer.markedAsToBeWritten);
                buffer.markedAsToBeWritten = buffer.buffer.length;
            }
            buffer.lastWrite = System.currentTimeMillis();
            if (this.toBeWritten > this.toBeWrittenThreshold) {
                this.background.executeNextOccurenceNow((byte)3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ISynchronizationPoint<Exception> close(final BufferingManaged owner) {
        owner.closing = true;
        ArrayList tasks = new ArrayList();
        LinkedArrayList<Buffer> linkedArrayList = this.buffers;
        synchronized (linkedArrayList) {
            Iterator<Buffer> it = this.buffers.iterator();
            while (it.hasNext()) {
                Buffer b = it.next();
                if (b.owner != owner) continue;
                if (b.lastWrite > 0L) {
                    tasks.add(b.owner.flushWrite(b));
                    this.toBeWritten -= (long)b.buffer.length;
                }
                Buffer buffer = b;
                synchronized (buffer) {
                    if (b.flushing != null) {
                        tasks.addAll(b.flushing);
                    }
                }
                it.remove();
                if (b.buffer == null) continue;
                this.totalMemory -= (long)b.buffer.length;
            }
        }
        final SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        JoinPoint.fromSynchronizationPoints(tasks).listenInline(new Runnable(){

            @Override
            public void run() {
                owner.closed().listenInline(sp);
            }
        });
        return sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ISynchronizationPoint<IOException> fullFlush(BufferingManaged owner) {
        JoinPoint<IOException> jp = new JoinPoint<IOException>();
        LinkedArrayList<Buffer> linkedArrayList = this.buffers;
        synchronized (linkedArrayList) {
            for (Buffer b : this.buffers) {
                if (b.owner != owner) continue;
                Buffer buffer = b;
                synchronized (buffer) {
                    if (b.lastWrite > 0L) {
                        jp.addToJoin(b.owner.flushWrite(b));
                        b.lastWrite = 0L;
                        this.toBeWritten -= (long)b.markedAsToBeWritten;
                        b.markedAsToBeWritten = 0;
                    }
                    if (b.flushing != null) {
                        while (!b.flushing.isEmpty() && b.flushing.getFirst().isUnblocked()) {
                            b.flushing.removeFirst();
                        }
                        if (b.flushing.isEmpty()) {
                            b.flushing = null;
                        } else {
                            for (AsyncWork asyncWork : b.flushing) {
                                jp.addToJoin(asyncWork);
                            }
                        }
                    }
                }
            }
        }
        jp.start();
        return jp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeBuffers(int nb) {
        OldestList<Buffer> oldest = new OldestList<Buffer>(nb);
        LinkedArrayList<Buffer> linkedArrayList = this.buffers;
        synchronized (linkedArrayList) {
            Buffer buffer;
            for (Buffer b : this.buffers) {
                if (b.inUse > 0 || b.lastWrite > 0L) continue;
                buffer = b;
                synchronized (buffer) {
                    if (b.flushing != null) {
                        while (!b.flushing.isEmpty() && b.flushing.getFirst().isUnblocked()) {
                            b.flushing.removeFirst();
                        }
                        if (b.flushing.isEmpty()) {
                            b.flushing = null;
                        } else {
                            continue;
                        }
                    }
                }
                oldest.add(b.lastRead, b);
            }
            Iterator<Buffer> iterator = oldest.iterator();
            while (iterator.hasNext()) {
                Buffer b;
                buffer = b = iterator.next();
                synchronized (buffer) {
                    if (b.inUse > 0) {
                        continue;
                    }
                    if (b.lastWrite > 0L) {
                        continue;
                    }
                    if (!b.owner.removing(b)) {
                        continue;
                    }
                    this.buffers.remove(b);
                    this.totalMemory -= (long)b.buffer.length;
                    b.buffer = null;
                }
            }
            this.lastFree = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList tasks = new ArrayList();
        LinkedArrayList<Buffer> linkedArrayList = this.buffers;
        synchronized (linkedArrayList) {
            for (Buffer b : this.buffers) {
                if (b.lastWrite > 0L) {
                    tasks.add(b.owner.flushWrite(b));
                }
                if (b.flushing == null) continue;
                tasks.addAll(b.flushing);
            }
            this.buffers.clear();
        }
        try {
            Threading.waitUnblockedWithError(tasks);
        }
        catch (Throwable t) {
            this.background.getApplication().getDefaultLogger().error("Error flushing remaining buffers", t);
        }
    }

    @Override
    public String getDescription() {
        return "BufferingManager";
    }

    @Override
    public List<String> getItemsDescription() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("" + this.buffers.size() + " buffers: " + StringUtil.size(this.totalMemory));
        return list;
    }

    @Override
    public void freeMemory(IMemoryManageable.FreeMemoryLevel level) {
        this.background.executeNextOccurenceNow((byte)3);
        switch (level) {
            default: {
                this.freeBuffers(5);
                break;
            }
            case LOW: {
                this.freeBuffers(10);
                break;
            }
            case MEDIUM: {
                this.freeBuffers(25);
                break;
            }
            case URGENT: {
                this.freeBuffers(200);
            }
        }
    }

    private class Background
    extends Task.Cpu<Void, NoException> {
        public Background() {
            super("Buffering Manager", (byte)6);
            this.executeEvery(30000L, 45000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run() {
            Buffer buffer;
            Buffer b;
            this.setPriority((byte)6);
            long now = System.currentTimeMillis();
            int old = 0;
            OldestList<Buffer> oldestToBeWritten = null;
            if (BufferingManager.this.toBeWritten >= BufferingManager.this.toBeWrittenThreshold) {
                oldestToBeWritten = new OldestList<Buffer>(10);
            }
            LinkedArrayList linkedArrayList = BufferingManager.this.buffers;
            synchronized (linkedArrayList) {
                Iterator it = BufferingManager.this.buffers.iterator();
                while (it.hasNext()) {
                    buffer = b = (Buffer)it.next();
                    synchronized (buffer) {
                        if (b.owner.closing) {
                            continue;
                        }
                        if (b.flushing != null) {
                            while (!b.flushing.isEmpty() && b.flushing.getFirst().isUnblocked()) {
                                b.flushing.removeFirst();
                            }
                            if (b.flushing.isEmpty()) {
                                b.flushing = null;
                            }
                        }
                        if (b.inUse > 0) {
                            continue;
                        }
                        if (b.lastWrite > 0L) {
                            if (now - b.lastWrite >= 30000L) {
                                if (b.flushing == null) {
                                    b.flushing = new LinkedList();
                                }
                                b.flushing.add(b.owner.flushWrite(b));
                                if (b.lastRead < b.lastWrite) {
                                    b.lastRead = b.lastWrite;
                                }
                                b.lastWrite = 0L;
                                BufferingManager.this.toBeWritten = BufferingManager.this.toBeWritten - (long)b.markedAsToBeWritten;
                                b.markedAsToBeWritten = 0;
                            } else if (oldestToBeWritten != null) {
                                oldestToBeWritten.add(b.lastWrite, b);
                            }
                        } else if (now - b.lastRead > 900000L) {
                            ++old;
                        }
                    }
                }
            }
            if (oldestToBeWritten != null) {
                linkedArrayList = BufferingManager.this.buffers;
                synchronized (linkedArrayList) {
                    Iterator iterator = oldestToBeWritten.iterator();
                    while (iterator.hasNext()) {
                        buffer = b = (Buffer)iterator.next();
                        synchronized (buffer) {
                            if (b.owner.closing) {
                                continue;
                            }
                            if (b.inUse > 0) {
                                continue;
                            }
                            if (b.lastWrite <= 0L) {
                                continue;
                            }
                            if (b.flushing == null) {
                                b.flushing = new LinkedList();
                            }
                            b.flushing.add(b.owner.flushWrite(b));
                            if (b.lastRead < b.lastWrite) {
                                b.lastRead = b.lastWrite;
                            }
                            b.lastWrite = 0L;
                            BufferingManager.this.toBeWritten = BufferingManager.this.toBeWritten - (long)b.markedAsToBeWritten;
                            b.markedAsToBeWritten = 0;
                        }
                    }
                }
            }
            if (now - BufferingManager.this.lastFree > 300000L) {
                BufferingManager.this.freeBuffers(10);
            } else if (old > 0) {
                BufferingManager.this.freeBuffers(5);
            }
            return null;
        }
    }

    static class Buffer {
        BufferingManaged owner;
        byte[] buffer;
        int len;
        long lastRead;
        long lastWrite;
        int inUse = 0;
        int markedAsToBeWritten = 0;
        LinkedList<AsyncWork<?, IOException>> flushing = null;

        Buffer() {
        }
    }
}

