/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;
import net.lecousin.framework.util.Triple;

public class ByteBuffersIO
extends ConcurrentCloseable
implements IO.Readable.Buffered,
IO.Readable.Seekable,
IO.KnownSize,
IO.Writable {
    private boolean copyBuffers;
    private String description;
    private byte priority;
    private LinkedArrayList<Triple<byte[], Integer, Integer>> buffers = new LinkedArrayList(10);
    private int pos = 0;
    private int bufferIndex = 0;
    private int bufferPos = 0;
    private int totalSize = 0;

    public ByteBuffersIO(boolean copyBuffers, String description, byte priority) {
        this.copyBuffers = copyBuffers;
        this.description = description;
        this.priority = priority;
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public LinkedArrayList<Triple<byte[], Integer, Integer>> getBuffers() {
        return this.buffers;
    }

    public byte[] createSingleByteArray() {
        byte[] buf = new byte[this.totalSize];
        int pos = 0;
        for (Triple<byte[], Integer, Integer> t : this.buffers) {
            System.arraycopy(t.getValue1(), t.getValue2(), buf, pos, t.getValue3());
            pos += t.getValue3().intValue();
        }
        return buf;
    }

    public synchronized void addBuffer(byte[] buf, int off, int len) {
        if (this.copyBuffers) {
            byte[] b = new byte[len];
            System.arraycopy(buf, off, b, 0, len);
            buf = b;
            off = 0;
        }
        this.buffers.add(new Triple<byte[], Integer, Integer>(buf, off, len));
        this.totalSize += len;
    }

    @Override
    public synchronized int readSync(ByteBuffer buffer) {
        if (this.bufferIndex == this.buffers.size()) {
            return -1;
        }
        int done = 0;
        while (this.bufferIndex < this.buffers.size() && buffer.hasRemaining()) {
            Triple<byte[], Integer, Integer> b = this.buffers.get(this.bufferIndex);
            int len = buffer.remaining();
            if (len > b.getValue3() - this.bufferPos) {
                len = b.getValue3() - this.bufferPos;
            }
            buffer.put(b.getValue1(), b.getValue2() + this.bufferPos, len);
            this.bufferPos += len;
            this.pos += len;
            done += len;
            if (this.bufferPos != b.getValue3()) continue;
            ++this.bufferIndex;
            this.bufferPos = 0;
        }
        return done;
    }

    @Override
    public synchronized int readSync(long pos, ByteBuffer buffer) {
        if (pos != (long)this.pos) {
            this.skipSync(pos - (long)this.pos);
        }
        return this.readSync(buffer);
    }

    @Override
    public int readAsync() {
        return this.read();
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readAsyncUsingSync(this, buffer, ondone).getOutput());
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(final long pos, final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("readAsync on ByteBuffersIO", this.getPriority(), ondone){

            @Override
            public Integer run() {
                return ByteBuffersIO.this.readSync(pos, buffer);
            }
        };
        task.start();
        return this.operation(task.getOutput());
    }

    @Override
    public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
        Task.Cpu<ByteBuffer, IOException> task = new Task.Cpu<ByteBuffer, IOException>("Read next buffer", this.getPriority(), ondone){

            @Override
            public ByteBuffer run() {
                if (ByteBuffersIO.this.bufferIndex == ByteBuffersIO.this.buffers.size()) {
                    return null;
                }
                Triple b = (Triple)ByteBuffersIO.this.buffers.get(ByteBuffersIO.this.bufferIndex);
                int len = (Integer)b.getValue3() - ByteBuffersIO.this.bufferPos;
                ByteBuffer buf = ByteBuffer.wrap((byte[])b.getValue1(), (Integer)b.getValue2() + ByteBuffersIO.this.bufferPos, len);
                ByteBuffersIO.this.pos = ByteBuffersIO.this.pos + len;
                ByteBuffersIO.this.bufferIndex++;
                ByteBuffersIO.this.bufferPos = 0;
                return buf;
            }
        };
        task.start();
        return this.operation(task.getOutput());
    }

    @Override
    public int readFullySync(ByteBuffer buffer) {
        return this.readSync(buffer);
    }

    @Override
    public int readFullySync(long pos, ByteBuffer buffer) {
        return this.readSync(pos, buffer);
    }

    @Override
    public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.readAsync(buffer, ondone);
    }

    @Override
    public AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.readAsync(pos, buffer, ondone);
    }

    @Override
    public synchronized long skipSync(long n) {
        if (n == 0L) {
            return 0L;
        }
        if (n > 0L) {
            long rem = n;
            while (this.bufferIndex < this.buffers.size() && rem > 0L) {
                int l = this.buffers.get(this.bufferIndex).getValue3() - this.bufferPos;
                if ((long)l > rem) {
                    this.bufferPos = (int)((long)this.bufferPos + rem);
                    rem = 0L;
                    break;
                }
                rem -= (long)l;
                this.bufferPos = 0;
                ++this.bufferIndex;
            }
            this.pos = (int)((long)this.pos + (n - rem));
            return n - rem;
        }
        if ((long)this.pos + n < 0L) {
            n = -this.pos;
        }
        long rem = -n;
        while (rem > 0L) {
            if ((long)this.bufferPos >= rem) {
                this.bufferPos = (int)((long)this.bufferPos - rem);
                break;
            }
            rem -= (long)this.bufferPos;
            if (this.bufferIndex == 0) {
                this.bufferPos = 0;
                n += rem;
                break;
            }
            --this.bufferIndex;
            this.bufferPos = this.buffers.get(this.bufferIndex).getValue3();
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        Long r = this.skipSync(n);
        if (ondone != null) {
            ondone.run(new Pair<Long, Object>(r, null));
        }
        return new AsyncWork<Long, Object>(r, null);
    }

    @Override
    public String getSourceDescription() {
        return this.description;
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(byte priority) {
        this.priority = priority;
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public synchronized int read() {
        if (this.bufferIndex == this.buffers.size()) {
            return -1;
        }
        Triple<byte[], Integer, Integer> buf = this.buffers.get(this.bufferIndex);
        byte b = buf.getValue1()[buf.getValue2() + this.bufferPos];
        if (++this.bufferPos == buf.getValue3()) {
            ++this.bufferIndex;
            this.bufferPos = 0;
        }
        ++this.pos;
        return b & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) {
        return this.readSync(ByteBuffer.wrap(buffer, offset, len));
    }

    @Override
    public ISynchronizationPoint<IOException> canStartReading() {
        return new SynchronizationPoint<boolean>(true);
    }

    @Override
    public ISynchronizationPoint<IOException> canStartWriting() {
        return new SynchronizationPoint<boolean>(true);
    }

    @Override
    public long getSizeSync() {
        return this.totalSize;
    }

    @Override
    public AsyncWork<Long, IOException> getSizeAsync() {
        return new AsyncWork<Long, Object>(Long.valueOf(this.totalSize), null);
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) {
        switch (type) {
            case FROM_BEGINNING: {
                this.skipSync(move - (long)this.pos);
                break;
            }
            case FROM_CURRENT: {
                this.skipSync(move);
                break;
            }
            case FROM_END: {
                this.skipSync((long)this.totalSize - move - (long)this.pos);
                break;
            }
        }
        return this.pos;
    }

    @Override
    public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        Long r = this.seekSync(type, move);
        if (ondone != null) {
            ondone.run(new Pair<Long, Object>(r, null));
        }
        return new AsyncWork<Long, Object>(r, null);
    }

    @Override
    public int readFully(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int skip(int skip) {
        return (int)this.skipSync(skip);
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return null;
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.buffers = null;
        ondone.unblock();
    }

    @Override
    public int writeSync(ByteBuffer buffer) {
        this.addBuffer(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        this.pos = this.totalSize;
        this.bufferIndex = this.buffers.size();
        this.bufferPos = 0;
        int len = buffer.remaining();
        buffer.position(buffer.position() + len);
        return len;
    }

    @Override
    public AsyncWork<Integer, IOException> writeAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        if (!this.copyBuffers) {
            Integer r = this.writeSync(buffer);
            if (ondone != null) {
                ondone.run(new Pair<Integer, Object>(r, null));
            }
            return new AsyncWork<Integer, Object>(r, null);
        }
        return this.operation(IOUtil.writeAsyncUsingSync(this, buffer, ondone).getOutput());
    }
}

