/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class PreBufferedReadable
extends ConcurrentCloseable
implements IO.Readable.Buffered {
    private IO.Readable src;
    private byte priority;
    private IOException error = null;
    private long size = -1L;
    private long read = 0L;
    private boolean endReached = false;
    private boolean stopReading = false;
    private ByteBuffer current = null;
    private boolean currentIsFirst = true;
    private SynchronizationPoint<NoException> dataReady = null;
    private TurnArray<ByteBuffer> buffersReady;
    private TurnArray<ByteBuffer> reusableBuffers;
    private AsyncWork<?, ?> nextReadTask = null;
    private int maxBufferedSize;

    public PreBufferedReadable(IO.Readable src, final int firstBuffer, final byte firstBufferPriority, final int nextBuffer, final byte nextBufferPriority, final int maxNbNextBuffersReady) {
        this.src = src;
        this.priority = firstBufferPriority;
        if (src instanceof IO.KnownSize) {
            final AsyncWork<Long, IOException> getSize = ((IO.KnownSize)((Object)src)).getSizeAsync();
            Task.Cpu<Void, NoException> start = new Task.Cpu<Void, NoException>("Start PreBufferedReadable after size is known", firstBufferPriority){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() {
                    if (getSize.hasError()) {
                        PreBufferedReadable.this.error = (IOException)getSize.getError();
                        PreBufferedReadable preBufferedReadable = PreBufferedReadable.this;
                        synchronized (preBufferedReadable) {
                            if (PreBufferedReadable.this.dataReady != null) {
                                PreBufferedReadable.this.dataReady.unblock();
                                PreBufferedReadable.this.dataReady = null;
                            }
                        }
                        return null;
                    }
                    if (getSize.isCancelled()) {
                        return null;
                    }
                    PreBufferedReadable.this.size = (Long)getSize.getResult();
                    PreBufferedReadable.this.startWithKnownSize(firstBuffer, firstBufferPriority, nextBuffer, nextBufferPriority, maxNbNextBuffersReady);
                    return null;
                }
            };
            this.operation(start).startOn(getSize, true);
        } else {
            this.start(firstBuffer, firstBufferPriority, nextBuffer, nextBufferPriority, maxNbNextBuffersReady);
        }
    }

    public <T extends IO.Readable.Seekable & IO.KnownSize> PreBufferedReadable(T src, int firstBuffer, byte firstBufferPriority, int nextBuffer, byte nextBufferPriority, int maxNbNextBuffersReady) throws IOException {
        this.src = src;
        this.priority = firstBufferPriority;
        this.read = src.getPosition();
        this.size = ((IO.KnownSize)src).getSizeSync();
        this.startWithKnownSize(firstBuffer, firstBufferPriority, nextBuffer, nextBufferPriority, maxNbNextBuffersReady);
    }

    public PreBufferedReadable(IO.Readable src, long size, int firstBuffer, byte firstBufferPriority, int nextBuffer, byte nextBufferPriority, int maxNbNextBuffersReady) {
        this.src = src;
        this.priority = firstBufferPriority;
        this.size = size;
        this.startWithKnownSize(firstBuffer, firstBufferPriority, nextBuffer, nextBufferPriority, maxNbNextBuffersReady);
    }

    public <T extends IO.Readable.Seekable & IO.KnownSize> PreBufferedReadable(T src, long size, int firstBuffer, byte firstBufferPriority, int nextBuffer, byte nextBufferPriority, int maxNbNextBuffersReady) throws IOException {
        this.src = src;
        this.priority = firstBufferPriority;
        this.read = src.getPosition();
        this.size = size;
        this.startWithKnownSize(firstBuffer, firstBufferPriority, nextBuffer, nextBufferPriority, maxNbNextBuffersReady);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWithKnownSize(int firstBuffer, byte firstBufferPriority, int nextBuffer, byte nextBufferPriority, int maxNbNextBuffersReady) {
        if (this.size == this.read) {
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                this.endReached = true;
                if (this.dataReady != null) {
                    this.dataReady.unblock();
                    this.dataReady = null;
                }
            }
        } else if (this.size - this.read <= (long)firstBuffer) {
            this.start((int)(this.size - this.read), firstBufferPriority, 0, (byte)0, 0);
        } else if (this.size - this.read <= (long)(firstBuffer + nextBuffer)) {
            this.start(firstBuffer, firstBufferPriority, (int)(this.size - this.read - (long)firstBuffer), nextBufferPriority, 1);
        } else {
            this.start(firstBuffer, firstBufferPriority, nextBuffer, nextBufferPriority, maxNbNextBuffersReady);
        }
    }

    @Override
    public String getSourceDescription() {
        return this.src != null ? this.src.getSourceDescription() : "closed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizationPoint<IOException> getDataReadySynchronization() {
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            final SynchronizationPoint<IOException> sp = new SynchronizationPoint<IOException>();
            if (this.error != null) {
                sp.error(this.error);
                return sp;
            }
            if (this.current != null || this.endReached) {
                sp.unblock();
                return sp;
            }
            if (this.isClosing() || this.isClosed()) {
                sp.cancel(new CancelException("IO closed"));
                return sp;
            }
            if (this.dataReady == null) {
                this.dataReady = new SynchronizationPoint();
            }
            this.dataReady.listenInline(new Runnable(){

                @Override
                public void run() {
                    if (PreBufferedReadable.this.error != null) {
                        sp.error(PreBufferedReadable.this.error);
                    } else {
                        sp.unblock();
                    }
                }
            });
            return sp;
        }
    }

    @Override
    public ISynchronizationPoint<IOException> canStartReading() {
        return this.getDataReadySynchronization();
    }

    @Override
    public IO getWrappedIO() {
        return this.src;
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        AsyncWork<?, ?> nextRead;
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            nextRead = this.nextReadTask;
        }
        if (nextRead != null && !nextRead.isUnblocked()) {
            nextRead.cancel(new CancelException("IO closed"));
        }
        while (this.dataReady != null) {
            SynchronizationPoint<NoException> dr;
            PreBufferedReadable preBufferedReadable2 = this;
            synchronized (preBufferedReadable2) {
                dr = this.dataReady;
                this.dataReady = null;
            }
            if (dr == null) continue;
            dr.unblock();
        }
        return this.src.closeAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        SynchronizationPoint<NoException> dr = null;
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            this.endReached = true;
            if (this.dataReady != null) {
                dr = this.dataReady;
                this.dataReady = null;
            }
            this.buffersReady = null;
            this.reusableBuffers = null;
            this.nextReadTask = null;
        }
        if (dr != null) {
            dr.unblock();
        }
        this.src = null;
        ondone.unblock();
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(byte priority) {
        this.priority = priority;
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    private void start(int firstBuffer, byte firstBufferPriority, int nextBuffer, final byte nextBufferPriority, int maxNbNextBuffersReady) {
        if (nextBuffer < 0) {
            throw new IllegalArgumentException("next buffer size must be positive, or zero to disable it, given: " + nextBuffer);
        }
        if (maxNbNextBuffersReady < 0) {
            throw new IllegalArgumentException("maximum number of next buffers must be positive, or zero to disable it, given: " + maxNbNextBuffersReady);
        }
        if (nextBuffer == 0) {
            maxNbNextBuffersReady = 0;
        }
        if (maxNbNextBuffersReady == 0) {
            nextBuffer = 0;
        }
        this.maxBufferedSize = maxNbNextBuffersReady * nextBuffer;
        if (this.maxBufferedSize == 0) {
            this.maxBufferedSize = firstBuffer;
        }
        this.buffersReady = new TurnArray(maxNbNextBuffersReady + 1);
        if (maxNbNextBuffersReady > 0) {
            this.reusableBuffers = new TurnArray(maxNbNextBuffersReady);
        }
        final ByteBuffer buffer = ByteBuffer.allocate(firstBuffer);
        this.src.setPriority(firstBufferPriority);
        final JoinPoint jpNextRead = new JoinPoint();
        jpNextRead.addToJoin(1);
        final AsyncWork<Integer, IOException> firstReadTask = nextBuffer > 0 ? this.operation(this.src.readAsync(buffer)) : this.operation(this.src.readFullyAsync(buffer));
        Task.Cpu<Void, NoException> firstNextReadTask = null;
        if (nextBuffer > 0) {
            firstNextReadTask = new Task.Cpu<Void, NoException>("First next read of pre-buffered IO " + this.getSourceDescription(), nextBufferPriority){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() {
                    SynchronizationPoint dr = null;
                    PreBufferedReadable preBufferedReadable = PreBufferedReadable.this;
                    synchronized (preBufferedReadable) {
                        PreBufferedReadable.this.nextReadTask = null;
                        if (!(PreBufferedReadable.this.error != null || PreBufferedReadable.this.endReached || PreBufferedReadable.this.stopReading || PreBufferedReadable.this.isClosing() || PreBufferedReadable.this.isClosed())) {
                            PreBufferedReadable.this.nextRead();
                        } else if (PreBufferedReadable.this.dataReady != null) {
                            dr = PreBufferedReadable.this.dataReady;
                            PreBufferedReadable.this.dataReady = null;
                        }
                    }
                    if (dr != null) {
                        dr.unblock();
                    }
                    return null;
                }
            };
            this.nextReadTask = firstNextReadTask.getOutput();
        }
        final boolean singleRead = nextBuffer <= 0;
        firstReadTask.listenInline(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (PreBufferedReadable.this.buffersReady == null) {
                    jpNextRead.joined();
                    return;
                }
                buffer.flip();
                PreBufferedReadable preBufferedReadable = PreBufferedReadable.this;
                synchronized (preBufferedReadable) {
                    if (firstReadTask.isCancelled()) {
                        if (PreBufferedReadable.this.dataReady != null) {
                            SynchronizationPoint dr = PreBufferedReadable.this.dataReady;
                            PreBufferedReadable.this.dataReady = null;
                            dr.unblock();
                        }
                        jpNextRead.joined();
                        return;
                    }
                    Object e = firstReadTask.getError();
                    if (singleRead && e == null && (long)((Integer)firstReadTask.getResult()).intValue() < PreBufferedReadable.this.size) {
                        e = new IOException("Only " + (Integer)firstReadTask.getResult() + " bytes read, expected is " + PreBufferedReadable.this.size);
                    }
                    if (e != null) {
                        if (e instanceof IOException) {
                            PreBufferedReadable.this.error = (IOException)e;
                        } else {
                            PreBufferedReadable.this.error = new IOException("Read failed", (Throwable)e);
                        }
                        if (PreBufferedReadable.this.dataReady != null) {
                            SynchronizationPoint dr = PreBufferedReadable.this.dataReady;
                            PreBufferedReadable.this.dataReady = null;
                            dr.unblock();
                        }
                    } else {
                        if (buffer.remaining() == 0) {
                            PreBufferedReadable.this.endReached = true;
                        } else {
                            PreBufferedReadable.this.current = buffer;
                        }
                        PreBufferedReadable.this.read = PreBufferedReadable.this.read + (long)buffer.remaining();
                        if (PreBufferedReadable.this.size > 0L && PreBufferedReadable.this.read == PreBufferedReadable.this.size) {
                            PreBufferedReadable.this.endReached = true;
                        }
                        if (PreBufferedReadable.this.endReached && PreBufferedReadable.this.size > 0L && PreBufferedReadable.this.read < PreBufferedReadable.this.size) {
                            PreBufferedReadable.this.error = new IOException("Unexpected end after " + PreBufferedReadable.this.read + " bytes read, known size is " + PreBufferedReadable.this.size);
                        }
                        if (PreBufferedReadable.this.dataReady != null) {
                            SynchronizationPoint dr = PreBufferedReadable.this.dataReady;
                            PreBufferedReadable.this.dataReady = null;
                            dr.unblock();
                        }
                    }
                }
                if (PreBufferedReadable.this.buffersReady == null) {
                    jpNextRead.joined();
                    return;
                }
                PreBufferedReadable.this.src.setPriority(nextBufferPriority);
                jpNextRead.joined();
            }
        });
        if (nextBuffer > 0) {
            final int nextBufferSize = nextBuffer;
            final int nbNext = maxNbNextBuffersReady;
            jpNextRead.addToJoin(1);
            Task.Cpu<Void, NoException> prepare = new Task.Cpu<Void, NoException>("Allocate buffers for pre-buffered IO " + this.getSourceDescription(), nextBufferPriority){

                @Override
                public Void run() {
                    TurnArray buffers = PreBufferedReadable.this.reusableBuffers;
                    if (buffers == null) {
                        jpNextRead.joined();
                        return null;
                    }
                    for (int i = 0; i < nbNext; ++i) {
                        ByteBuffer b = ByteBuffer.allocate(nextBufferSize);
                        buffers.addLast(b);
                    }
                    jpNextRead.joined();
                    return null;
                }
            };
            this.operation(prepare).start();
            this.operation(firstNextReadTask.getOutput());
            jpNextRead.start();
            jpNextRead.listenAsync(firstNextReadTask, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        while (true) {
            SynchronizationPoint<NoException> sp;
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.current != null) {
                    break;
                }
                if (this.endReached) {
                    return -1;
                }
                if (this.isClosing() || this.isClosed()) {
                    return -1;
                }
                if (this.dataReady == null) {
                    this.dataReady = new SynchronizationPoint();
                }
                sp = this.dataReady;
            }
            sp.block(0L);
        }
        if (this.buffersReady == null) {
            throw new IOException("IO Closed");
        }
        int nb = buffer.remaining();
        if (this.current.remaining() > nb) {
            int limit = this.current.limit();
            this.current.limit(limit - (this.current.remaining() - nb));
            buffer.put(this.current);
            this.current.limit(limit);
            return nb;
        }
        nb = this.current.remaining();
        buffer.put(this.current);
        this.moveNextBuffer(true);
        return nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readAsync() throws IOException {
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            if (this.error != null) {
                throw this.error;
            }
            if (this.current != null) {
                if (!this.current.hasRemaining() && this.endReached) {
                    return -1;
                }
            } else {
                if (this.endReached) {
                    return -1;
                }
                if (this.isClosing() || this.isClosed()) {
                    return -1;
                }
                if (this.dataReady == null) {
                    this.dataReady = new SynchronizationPoint();
                }
                if (!this.dataReady.isUnblocked()) {
                    return -2;
                }
            }
        }
        int res = this.current.get() & 0xFF;
        if (!this.current.hasRemaining()) {
            this.moveNextBuffer(true);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncWork<Integer, IOException> readAsync(final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        SynchronizationPoint<NoException> sp = null;
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            if (this.error != null) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, IOException>(null, this.error));
                }
                return new AsyncWork<Object, IOException>(null, this.error);
            }
            if (this.current == null) {
                if (this.endReached) {
                    if (ondone != null) {
                        ondone.run(new Pair<Integer, Object>(-1, null));
                    }
                    return new AsyncWork<Integer, Object>(-1, null);
                }
                if (this.isClosing() || this.isClosed()) {
                    return new AsyncWork<Object, Object>(null, null, new CancelException("IO closed"));
                }
                if (this.dataReady == null) {
                    this.dataReady = new SynchronizationPoint();
                }
                sp = this.dataReady;
            }
        }
        Task.Cpu<Integer, IOException> t = new Task.Cpu<Integer, IOException>("Async read on pre-buffered IO " + this.getSourceDescription(), this.getPriority(), ondone){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer run() throws IOException, CancelException {
                PreBufferedReadable preBufferedReadable = PreBufferedReadable.this;
                synchronized (preBufferedReadable) {
                    if (PreBufferedReadable.this.error != null) {
                        throw PreBufferedReadable.this.error;
                    }
                    if (PreBufferedReadable.this.buffersReady == null) {
                        if (PreBufferedReadable.this.endReached) {
                            return -1;
                        }
                        throw new CancelException("IO Closed");
                    }
                    if (PreBufferedReadable.this.current == null) {
                        if (PreBufferedReadable.this.endReached) {
                            return -1;
                        }
                        if (PreBufferedReadable.this.isClosing() || PreBufferedReadable.this.isClosed()) {
                            throw new CancelException("IO Closed");
                        }
                        throw new IOException("Unexpected error: current buffer is null but end is not reached");
                    }
                }
                int nb = buffer.remaining();
                if (PreBufferedReadable.this.current.remaining() > nb) {
                    int limit = PreBufferedReadable.this.current.limit();
                    PreBufferedReadable.this.current.limit(limit - (PreBufferedReadable.this.current.remaining() - nb));
                    buffer.put(PreBufferedReadable.this.current);
                    PreBufferedReadable.this.current.limit(limit);
                    return nb;
                }
                nb = PreBufferedReadable.this.current.remaining();
                buffer.put(PreBufferedReadable.this.current);
                PreBufferedReadable.this.moveNextBuffer(true);
                return nb;
            }
        };
        this.operation(t);
        if (sp == null) {
            t.start();
            return t.getOutput();
        }
        t.startOn(sp, false);
        return t.getOutput();
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        return IOUtil.readFully(this, buffer);
    }

    @Override
    public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync(this, buffer, ondone));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skipSync(long n) throws IOException {
        long skipped = 0L;
        while (true) {
            SynchronizationPoint<NoException> sp = null;
            long remaining = -1L;
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                if (this.error != null) {
                    throw this.error;
                }
                if (n <= 0L) {
                    this.stopReading = false;
                    return 0L;
                }
                if (this.current != null) {
                    int nb = this.current.remaining();
                    if ((long)nb > n) {
                        this.stopReading = false;
                        this.current.position(this.current.position() + (int)n);
                        return n + skipped;
                    }
                    if ((long)nb == n) {
                        this.stopReading = false;
                        this.moveNextBuffer(true);
                        return n + skipped;
                    }
                    skipped += (long)nb;
                    if (this.reusableBuffers == null) {
                        this.endReached = true;
                        if (this.size > 0L && this.read < this.size) {
                            this.error = new IOException("Unexpected end after " + this.read + " bytes read, known size is " + this.size);
                        }
                        if (this.dataReady != null) {
                            this.dataReady.unblock();
                        }
                        return skipped;
                    }
                    this.stopReading = true;
                    this.moveNextBuffer(false);
                    remaining = n - (long)nb;
                } else {
                    if (this.endReached) {
                        return skipped;
                    }
                    if (this.nextReadTask == null && this.reusableBuffers != null) {
                        long n2 = this.src.skipSync(n);
                        this.read += n2;
                        this.stopReading = false;
                        this.moveNextBuffer(true);
                        return skipped += n2;
                    }
                    if (this.isClosing() || this.isClosed()) {
                        return skipped;
                    }
                    if (this.dataReady == null) {
                        this.dataReady = new SynchronizationPoint();
                    }
                    sp = this.dataReady;
                }
            }
            if (remaining > 0L) {
                n = remaining;
                continue;
            }
            if (sp == null) continue;
            sp.block(0L);
        }
    }

    @Override
    public int skip(int skip) throws IOException {
        return (int)this.skipSync(skip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncWork<Long, IOException> skipAsync(final long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            if (this.error != null) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, IOException>(null, this.error));
                }
                return new AsyncWork<Object, IOException>(null, this.error);
            }
            if (n <= 0L) {
                if (ondone != null) {
                    ondone.run(new Pair<Long, Object>(0L, null));
                }
                return new AsyncWork<Long, Object>(0L, null);
            }
            Task.Cpu<Long, IOException> t = new Task.Cpu<Long, IOException>("Skipping data from pre-buffered IO " + this.getSourceDescription(), this.priority, ondone){

                @Override
                public Long run() throws IOException {
                    return PreBufferedReadable.this.skipSync(n);
                }
            };
            this.operation(t.start());
            return t.getOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveNextBuffer(boolean startNextRead) {
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            if (!this.currentIsFirst && this.current != null) {
                this.reusableBuffers.addLast(this.current);
            }
            this.current = this.buffersReady.pollFirst();
            this.currentIsFirst = false;
            if (!this.endReached && this.error == null && this.nextReadTask == null && this.reusableBuffers != null && !this.reusableBuffers.isEmpty() && startNextRead && !this.stopReading) {
                this.nextRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextRead() {
        if (this.isClosing() || this.isClosed()) {
            SynchronizationPoint<NoException> dr;
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                dr = this.dataReady;
                this.dataReady = null;
            }
            if (dr != null) {
                dr.unblock();
            }
            return;
        }
        final ByteBuffer buffer = this.reusableBuffers.removeFirst();
        buffer.clear();
        this.nextReadTask = this.operation(this.src.readFullyAsync(buffer));
        this.nextReadTask.listenInline(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int nb;
                Object e;
                if (PreBufferedReadable.this.nextReadTask == null) {
                    return;
                }
                try {
                    e = PreBufferedReadable.this.nextReadTask.getError();
                }
                catch (NullPointerException ex) {
                    return;
                }
                if (e != null) {
                    if (e instanceof IOException) {
                        PreBufferedReadable.this.error = (IOException)e;
                    } else {
                        PreBufferedReadable.this.error = new IOException("Read failed", (Throwable)e);
                    }
                    PreBufferedReadable.this.nextReadTask = null;
                    PreBufferedReadable ex = PreBufferedReadable.this;
                    synchronized (ex) {
                        if (PreBufferedReadable.this.dataReady != null) {
                            SynchronizationPoint dr = PreBufferedReadable.this.dataReady;
                            PreBufferedReadable.this.dataReady = null;
                            dr.unblock();
                        }
                    }
                }
                try {
                    nb = (Integer)PreBufferedReadable.this.nextReadTask.getResult();
                }
                catch (NullPointerException ex) {
                    nb = 0;
                }
                SynchronizationPoint sp = null;
                PreBufferedReadable preBufferedReadable = PreBufferedReadable.this;
                synchronized (preBufferedReadable) {
                    PreBufferedReadable.this.nextReadTask = null;
                    if (PreBufferedReadable.this.buffersReady == null) {
                        return;
                    }
                    if (nb <= 0) {
                        PreBufferedReadable.this.endReached = true;
                    } else {
                        PreBufferedReadable.this.read = PreBufferedReadable.this.read + (long)nb;
                        if (nb < buffer.limit() || PreBufferedReadable.this.size > 0L && PreBufferedReadable.this.read == PreBufferedReadable.this.size) {
                            PreBufferedReadable.this.endReached = true;
                        }
                        buffer.flip();
                        if (PreBufferedReadable.this.current == null) {
                            PreBufferedReadable.this.current = buffer;
                        } else {
                            PreBufferedReadable.this.buffersReady.addLast(buffer);
                        }
                        if (!(PreBufferedReadable.this.endReached || PreBufferedReadable.this.reusableBuffers.isEmpty() || PreBufferedReadable.this.stopReading)) {
                            PreBufferedReadable.this.nextRead();
                        }
                    }
                    if (PreBufferedReadable.this.endReached && PreBufferedReadable.this.size > 0L && PreBufferedReadable.this.read < PreBufferedReadable.this.size && PreBufferedReadable.this.buffersReady != null && !PreBufferedReadable.this.isClosing()) {
                        PreBufferedReadable.this.error = new IOException("Unexpected end after " + PreBufferedReadable.this.read + " bytes read, known size is " + PreBufferedReadable.this.size);
                    }
                    if (PreBufferedReadable.this.dataReady != null) {
                        sp = PreBufferedReadable.this.dataReady;
                        PreBufferedReadable.this.dataReady = null;
                    }
                }
                if (sp != null) {
                    sp.unblock();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        while (true) {
            SynchronizationPoint<NoException> sp;
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.current != null) {
                    if (!this.current.hasRemaining() && this.endReached) {
                        return -1;
                    }
                    break;
                }
                if (this.endReached) {
                    return -1;
                }
                if (this.isClosing() || this.isClosed()) {
                    return -1;
                }
                if (this.dataReady == null) {
                    this.dataReady = new SynchronizationPoint();
                }
                sp = this.dataReady;
            }
            sp.block(0L);
        }
        int res = this.current.get() & 0xFF;
        if (!this.current.hasRemaining()) {
            this.moveNextBuffer(true);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        while (true) {
            SynchronizationPoint<NoException> sp;
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.current != null) {
                    if (!this.current.hasRemaining() && this.endReached) {
                        return -1;
                    }
                    break;
                }
                if (this.endReached) {
                    return -1;
                }
                if (this.isClosing() || this.isClosed()) {
                    return -1;
                }
                if (this.dataReady == null) {
                    this.dataReady = new SynchronizationPoint();
                }
                sp = this.dataReady;
            }
            sp.block(0L);
        }
        if (this.current.remaining() > len) {
            this.current.get(buffer, offset, len);
            return len;
        }
        len = this.current.remaining();
        this.current.get(buffer, offset, len);
        this.moveNextBuffer(true);
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFully(byte[] buffer) throws IOException {
        int pos;
        while (true) {
            SynchronizationPoint<NoException> sp;
            PreBufferedReadable preBufferedReadable = this;
            synchronized (preBufferedReadable) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.current != null) {
                    if (!this.current.hasRemaining() && this.endReached) {
                        return -1;
                    }
                    break;
                }
                if (this.endReached) {
                    return -1;
                }
                if (this.isClosing() || this.isClosed()) {
                    return -1;
                }
                if (this.dataReady == null) {
                    this.dataReady = new SynchronizationPoint();
                }
                sp = this.dataReady;
            }
            sp.block(0L);
        }
        if (this.current.remaining() > buffer.length) {
            this.current.get(buffer);
            return buffer.length;
        }
        int len = this.current.remaining();
        this.current.get(buffer, 0, len);
        this.moveNextBuffer(true);
        for (pos = len; pos < buffer.length && (len = this.read(buffer, pos, buffer.length - pos)) >= 0; pos += len) {
        }
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(final RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
        SynchronizationPoint<NoException> sp;
        PreBufferedReadable preBufferedReadable = this;
        synchronized (preBufferedReadable) {
            if (this.error != null) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, Object>(null, null));
                }
                return new AsyncWork<Object, IOException>(null, this.error);
            }
            if (this.current != null) {
                if (!this.current.hasRemaining() && this.endReached) {
                    if (ondone != null) {
                        ondone.run(new Pair<Object, Object>(null, null));
                    }
                    return new AsyncWork<Object, Object>(null, null);
                }
                Task.Cpu<ByteBuffer, IOException> task = new Task.Cpu<ByteBuffer, IOException>("Read next buffer", this.getPriority(), ondone){

                    @Override
                    public ByteBuffer run() {
                        ByteBuffer buf = ByteBuffer.allocate(PreBufferedReadable.this.current.remaining());
                        buf.put(PreBufferedReadable.this.current);
                        PreBufferedReadable.this.moveNextBuffer(true);
                        buf.flip();
                        return buf;
                    }
                };
                this.operation(task.start());
                return task.getOutput();
            }
            if (this.endReached) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, Object>(null, null));
                }
                return new AsyncWork<Object, Object>(null, null);
            }
            if (this.isClosing() || this.isClosed()) {
                return new AsyncWork<Object, Object>(null, null, new CancelException("IO closed"));
            }
            if (this.dataReady == null) {
                this.dataReady = new SynchronizationPoint();
            }
            sp = this.dataReady;
        }
        final AsyncWork result = new AsyncWork();
        sp.listenInline(new Runnable(){

            @Override
            public void run() {
                PreBufferedReadable.this.readNextBufferAsync(ondone).listenInline(result);
            }
        });
        return this.operation(result);
    }
}

