/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class SimpleBufferedWritable
extends ConcurrentCloseable
implements IO.Writable.Buffered {
    private IO.Writable out;
    private byte[] buffer;
    private byte[] buffer2;
    private ByteBuffer bb;
    private ByteBuffer bb2;
    private int pos = 0;
    private AsyncWork<Integer, IOException> writing = null;

    public SimpleBufferedWritable(IO.Writable out, int bufferSize) {
        this.out = out;
        this.buffer = new byte[bufferSize];
        this.buffer2 = new byte[bufferSize];
        this.bb = ByteBuffer.wrap(this.buffer);
        this.bb2 = ByteBuffer.wrap(this.buffer2);
    }

    @Override
    public ISynchronizationPoint<IOException> canStartWriting() {
        return new SynchronizationPoint<boolean>(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        while (true) {
            AsyncWork<Integer, IOException> sp;
            IO.Writable writable = this.out;
            synchronized (writable) {
                if (this.writing != null && this.writing.isUnblocked()) {
                    if (this.writing.hasError()) {
                        throw this.writing.getError();
                    }
                    this.writing = null;
                }
                if (this.writing == null) {
                    byte[] tmp1 = this.buffer2;
                    this.buffer2 = this.buffer;
                    this.buffer = tmp1;
                    ByteBuffer tmp2 = this.bb2;
                    this.bb2 = this.bb;
                    this.bb = tmp2;
                    this.bb.clear();
                    this.writing = this.out.writeAsync(this.bb2);
                    this.pos = 0;
                    return;
                }
                sp = this.writing;
            }
            sp.block(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncWork<Integer, IOException> flushBufferAsync() throws IOException {
        IO.Writable writable = this.out;
        synchronized (writable) {
            if (this.writing != null && this.writing.isUnblocked()) {
                if (this.writing.hasError()) {
                    throw this.writing.getError();
                }
                this.writing = null;
            }
            if (this.writing == null) {
                byte[] tmp1 = this.buffer2;
                this.buffer2 = this.buffer;
                this.buffer = tmp1;
                ByteBuffer tmp2 = this.bb2;
                this.bb2 = this.bb;
                this.bb = tmp2;
                this.bb.clear();
                this.writing = this.out.writeAsync(this.bb2);
                this.pos = 0;
                return null;
            }
            return this.writing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISynchronizationPoint<IOException> flush() {
        AsyncWork<Integer, IOException> w;
        if (this.pos == 0) {
            if (this.writing == null) {
                return new SynchronizationPoint<boolean>(true);
            }
            return this.writing;
        }
        IO.Writable writable = this.out;
        synchronized (writable) {
            if (this.writing != null && this.writing.isUnblocked()) {
                if (this.writing.hasError()) {
                    return this.writing;
                }
                this.writing = null;
            }
            if (this.writing == null) {
                byte[] tmp1 = this.buffer2;
                this.buffer2 = this.buffer;
                this.buffer = tmp1;
                ByteBuffer tmp2 = this.bb2;
                this.bb2 = this.bb;
                this.bb = tmp2;
                this.bb.clear();
                this.bb2.limit(this.pos);
                this.writing = this.out.writeAsync(this.bb2);
                this.pos = 0;
                return this.writing;
            }
            w = this.writing;
        }
        SynchronizationPoint sp = new SynchronizationPoint();
        w.listenInline(() -> this.flush().listenInline(sp), sp);
        return this.operation(sp);
    }

    @Override
    public void write(byte b) throws IOException {
        this.buffer[this.pos++] = b;
        if (this.pos == this.buffer.length) {
            this.flushBuffer();
        }
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        while (true) {
            int len = length > this.buffer.length - this.pos ? this.buffer.length - this.pos : length;
            System.arraycopy(buf, offset, this.buffer, this.pos, len);
            this.pos += len;
            if (this.pos == this.buffer.length) {
                this.flushBuffer();
            }
            if (len == length) {
                return;
            }
            length -= len;
            offset += len;
        }
    }

    @Override
    public int writeSync(ByteBuffer buf) throws IOException {
        int done = 0;
        do {
            int len;
            if ((len = buf.remaining()) > this.buffer.length - this.pos) {
                len = this.buffer.length - this.pos;
            }
            buf.get(this.buffer, this.pos, len);
            this.pos += len;
            done += len;
            if (this.pos != this.buffer.length) continue;
            this.flushBuffer();
        } while (buf.remaining() != 0);
        return done;
    }

    @Override
    public AsyncWork<Integer, IOException> writeAsync(ByteBuffer buf, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        AsyncWork<Integer, IOException> result = new AsyncWork<Integer, IOException>();
        this.writeAsync(buf, 0, result, ondone);
        return result;
    }

    private void writeAsync(final ByteBuffer buf, final int done, final AsyncWork<Integer, IOException> result, final RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Write async to SimpleBufferedWritable", this.out.getPriority()){

            @Override
            public Void run() {
                int d = done;
                do {
                    AsyncWork flush;
                    int len;
                    if ((len = buf.remaining()) > SimpleBufferedWritable.this.buffer.length - SimpleBufferedWritable.this.pos) {
                        len = SimpleBufferedWritable.this.buffer.length - SimpleBufferedWritable.this.pos;
                    }
                    buf.get(SimpleBufferedWritable.this.buffer, SimpleBufferedWritable.this.pos, len);
                    SimpleBufferedWritable.this.pos = SimpleBufferedWritable.this.pos + len;
                    d += len;
                    if (SimpleBufferedWritable.this.pos != SimpleBufferedWritable.this.buffer.length) continue;
                    try {
                        flush = SimpleBufferedWritable.this.flushBufferAsync();
                    }
                    catch (IOException e) {
                        if (ondone != null) {
                            ondone.run(new Pair<Object, IOException>(null, e));
                        }
                        result.unblockError(e);
                        return null;
                    }
                    if (flush == null) continue;
                    final int dd = d;
                    flush.listenInline(new Runnable(){

                        @Override
                        public void run() {
                            if (!flush.isSuccessful()) {
                                if (ondone != null) {
                                    ondone.run(new Pair(null, flush.getError()));
                                }
                                result.unblockError(flush.getError());
                                return;
                            }
                            SimpleBufferedWritable.this.writeAsync(buf, dd, result, ondone);
                        }
                    });
                    return null;
                } while (buf.remaining() != 0);
                if (ondone != null) {
                    ondone.run(new Pair<Integer, Object>(d, null));
                }
                result.unblockSuccess(d);
                return null;
            }
        };
        this.operation(task.start());
    }

    @Override
    public String getSourceDescription() {
        return this.out.getSourceDescription();
    }

    @Override
    public IO getWrappedIO() {
        return this.out;
    }

    @Override
    public byte getPriority() {
        return this.out.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.out.setPriority(priority);
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        final SynchronizationPoint sp = new SynchronizationPoint();
        final ISynchronizationPoint<IOException> flush = this.flush();
        flush.listenInline(new Runnable(){

            @Override
            public void run() {
                ISynchronizationPoint close = SimpleBufferedWritable.this.out.closeAsync();
                if (flush.hasError()) {
                    sp.error(flush.getError());
                } else {
                    close.listenInline(sp);
                }
            }
        });
        return sp;
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.out = null;
        this.buffer = null;
        this.buffer2 = null;
        this.bb = null;
        this.bb2 = null;
        ondone.unblock();
    }
}

