/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.io.serialization.annotations.TypeAnnotationToRule;
import net.lecousin.framework.io.serialization.rules.SerializationRule;
import net.lecousin.framework.io.serialization.rules.TypeFactory;
import net.lecousin.framework.util.Provider;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface TypeInstantiation {
    public Class<? extends Provider> factory();

    public static class ToRule
    implements TypeAnnotationToRule<TypeInstantiation> {
        @Override
        public SerializationRule createRule(TypeInstantiation annotation, Class<?> type) {
            try {
                return new TypeFactory(type, annotation.factory().newInstance());
            }
            catch (Throwable t) {
                LCCore.getApplication().getDefaultLogger().error("Unable to instantiate factory " + annotation.factory().getName(), t);
                return null;
            }
        }
    }
}

