/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization.rules;

import java.util.List;
import net.lecousin.framework.io.serialization.SerializationClass;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.SerializationContextPattern;
import net.lecousin.framework.io.serialization.rules.SerializationRule;

public class RenameAttribute
implements SerializationRule {
    private SerializationContextPattern.OnClassAttribute contextPattern;
    private String newName;

    public RenameAttribute(SerializationContextPattern.OnClassAttribute contextPattern, String newName) {
        this.contextPattern = contextPattern;
        this.newName = newName;
    }

    public RenameAttribute(Class<?> type, String originalName, String newName) {
        this(new SerializationContextPattern.OnClassAttribute(type, originalName), newName);
    }

    @Override
    public boolean apply(SerializationClass type, SerializationContext context, List<SerializationRule> rules, boolean serializing) {
        SerializationClass.Attribute a = this.contextPattern.getAttribute(type, context);
        if (a != null) {
            a.renameTo(this.newName);
        }
        return false;
    }

    @Override
    public boolean isEquivalent(SerializationRule rule) {
        if (!(rule instanceof RenameAttribute)) {
            return false;
        }
        RenameAttribute r = (RenameAttribute)rule;
        return this.contextPattern.isEquivalent(r.contextPattern);
    }
}

