/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class LimitWriteOperations {
    private IO.Writable io;
    private TurnArray<Pair<ByteBuffer, AsyncWork<Integer, IOException>>> waiting;
    private SynchronizationPoint<NoException> lock = null;
    private AsyncWork<Integer, IOException> lastWrite = new AsyncWork<Integer, Object>(0, null);

    public LimitWriteOperations(IO.Writable io, int maxOperations) {
        this.io = io;
        this.waiting = new TurnArray(maxOperations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncWork<Integer, IOException> write(final ByteBuffer buffer) throws IOException {
        while (true) {
            SynchronizationPoint<NoException> lk;
            TurnArray<Pair<ByteBuffer, AsyncWork<Integer, IOException>>> turnArray = this.waiting;
            synchronized (turnArray) {
                if (this.lastWrite.isCancelled()) {
                    return this.lastWrite;
                }
                if (this.waiting.isEmpty() && this.lastWrite.isUnblocked()) {
                    this.lastWrite = this.io.writeAsync(buffer, new RunnableWithParameter<Pair<Integer, IOException>>(){

                        @Override
                        public void run(Pair<Integer, IOException> param) {
                            LimitWriteOperations.this.writeDone(buffer);
                        }
                    });
                    this.lastWrite.onCancel(cancel -> this.writeDone(buffer));
                    return this.lastWrite;
                }
                if (!this.waiting.isFull()) {
                    AsyncWork<Integer, IOException> res = new AsyncWork<Integer, IOException>();
                    this.waiting.addLast(new Pair(buffer, res));
                    return res;
                }
                if (this.lock != null) {
                    throw new IOException("Concurrent write");
                }
                lk = this.lock = new SynchronizationPoint();
            }
            lk.block(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDone(ByteBuffer buffer) {
        SynchronizationPoint<NoException> sp = null;
        TurnArray<Pair<ByteBuffer, AsyncWork<Integer, IOException>>> turnArray = this.waiting;
        synchronized (turnArray) {
            Pair<ByteBuffer, AsyncWork<Integer, IOException>> b = this.waiting.pollFirst();
            if (b != null) {
                if (this.lock != null) {
                    sp = this.lock;
                    this.lock = null;
                }
                if (this.lastWrite.isCancelled()) {
                    while (b != null) {
                        b.getValue2().cancel(this.lastWrite.getCancelEvent());
                        b = this.waiting.pollFirst();
                    }
                } else {
                    final ByteBuffer buf = b.getValue1();
                    this.lastWrite = this.io.writeAsync(buf, new RunnableWithParameter<Pair<Integer, IOException>>(){

                        @Override
                        public void run(Pair<Integer, IOException> param) {
                            LimitWriteOperations.this.writeDone(buf);
                        }
                    });
                    this.lastWrite.onCancel(cancel -> this.writeDone(buf));
                    this.lastWrite.listenInline(b.getValue2());
                }
            }
        }
        if (sp != null) {
            sp.unblock();
        }
    }

    public AsyncWork<Integer, IOException> getLastPendingOperation() {
        Pair<ByteBuffer, AsyncWork<Integer, IOException>> b = this.waiting.peekLast();
        if (b == null) {
            return this.lastWrite.isUnblocked() ? null : this.lastWrite;
        }
        return b.getValue2();
    }

    public ISynchronizationPoint<IOException> flush() {
        ISynchronizationPoint<Object> sp = this.getLastPendingOperation();
        if (sp == null) {
            sp = new SynchronizationPoint<boolean>(true);
        }
        return sp;
    }
}

