/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.log.appenders;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.log.LogPattern;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.log.LoggerFactory;
import net.lecousin.framework.log.appenders.Appender;
import net.lecousin.framework.util.StringUtil;

public class RollingFileAppender
implements Appender,
Closeable {
    private LoggerFactory factory;
    private File file;
    private FileIO.WriteOnly output = null;
    private long maxSize;
    private int maxFiles;
    private LogPattern pattern;
    private Logger.Level level;
    private boolean closed = false;

    public RollingFileAppender(LoggerFactory factory, String path, Logger.Level level, LogPattern pattern, long maxSize, int maxFiles) {
        this.factory = factory;
        this.file = new File(path);
        this.level = level;
        this.pattern = pattern;
        this.maxSize = maxSize;
        this.maxFiles = maxFiles;
        factory.getApplication().toClose(this);
    }

    public RollingFileAppender(LoggerFactory factory, XMLStreamReader reader, Map<String, Appender> appenders) throws Exception {
        this.factory = factory;
        String level = null;
        String pattern = null;
        String path = null;
        String size = null;
        String files = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrValue = reader.getAttributeValue(i);
            if ("level".equals(attrName)) {
                level = attrValue;
                continue;
            }
            if ("pattern".equals(attrName)) {
                pattern = attrValue;
                continue;
            }
            if ("path".equals(attrName)) {
                path = attrValue;
                continue;
            }
            if ("size".equals(attrName)) {
                size = attrValue;
                continue;
            }
            if ("files".equals(attrName)) {
                files = attrValue;
                continue;
            }
            if ("name".equals(attrName) || "class".equals(attrName)) continue;
            throw new Exception("Unknown attribute " + attrName);
        }
        if (level == null) {
            throw new Exception("Missing attribute level on rolling file Appender");
        }
        try {
            this.level = Logger.Level.valueOf(level);
        }
        catch (Throwable t) {
            throw new Exception("Invalid level " + level);
        }
        if (pattern == null) {
            throw new Exception("Missing attribute pattern on rolling file Appender");
        }
        this.pattern = new LogPattern(pattern);
        if (path == null) {
            throw new Exception("Missing attribute path on rolling file Appender");
        }
        this.file = new File(path);
        if (size == null) {
            throw new Exception("Missing attribute size on rolling file Appender");
        }
        try {
            this.maxSize = StringUtil.parseSize(size);
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid rolling file size: " + size);
        }
        if (this.maxSize <= 0L) {
            throw new Exception("Invalid rolling file size: " + size);
        }
        if (files == null) {
            throw new Exception("Missing attribute files on rolling file Appender");
        }
        try {
            this.maxFiles = Integer.parseInt(files);
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid maximum number of rolling files: " + files);
        }
        if (this.maxFiles <= 0) {
            throw new Exception("Invalid maximum number of rolling files: " + files);
        }
        reader.next();
        while (reader.getEventType() != 2) {
            if (reader.getEventType() == 1) {
                throw new Exception("Unexpected inner element " + reader.getLocalName());
            }
            reader.next();
            if (reader.hasNext()) continue;
        }
        factory.getApplication().toClose(this);
    }

    @Override
    public synchronized void append(LogPattern.Log log) {
        if (this.closed) {
            return;
        }
        try {
            File dir;
            if (this.output == null) {
                if (!this.file.exists()) {
                    dir = this.file.getParentFile();
                    if (!dir.exists() && !dir.mkdirs()) {
                        this.factory.getApplication().getConsole().err("Cannot create log directory: " + dir.getAbsolutePath());
                        return;
                    }
                    if (!this.file.createNewFile()) {
                        this.factory.getApplication().getConsole().err("Cannot create log file: " + this.file.getAbsolutePath());
                        return;
                    }
                }
                this.output = new FileIO.WriteOnly(this.file, 5);
                this.output.seekSync(IO.Seekable.SeekType.FROM_END, 0L);
                this.output.writeSync(ByteBuffer.wrap(("\nStart logging with max size = " + this.maxSize + " and max files = " + this.maxFiles + "\n\n").getBytes(StandardCharsets.UTF_8)));
            }
            if (this.output.getSizeSync() >= this.maxSize) {
                this.output.close();
                dir = this.file.getParentFile();
                File f = new File(dir, this.file.getName() + '.' + this.maxFiles);
                if (f.exists() && !f.delete()) {
                    return;
                }
                for (int i = this.maxFiles - 1; i >= 1; --i) {
                    f = new File(dir, this.file.getName() + '.' + i);
                    if (!f.exists() || f.renameTo(new File(dir, this.file.getName() + '.' + (i + 1)))) continue;
                    return;
                }
                f = new File(dir, this.file.getName() + ".1");
                if (!this.file.renameTo(f)) {
                    this.factory.getApplication().getConsole().err("Cannot rename log file from " + this.file.getAbsolutePath() + " to " + f.getAbsolutePath());
                    return;
                }
                if (!this.file.createNewFile()) {
                    this.factory.getApplication().getConsole().err("Cannot create log file: " + this.file.getAbsolutePath());
                    return;
                }
                this.output = new FileIO.WriteOnly(this.file, 5);
            }
            StringBuilder msg = this.pattern.generate(log);
            msg.append('\n');
            this.output.writeSync(ByteBuffer.wrap(msg.toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            this.factory.getApplication().getConsole().err("Error logging in file " + this.file.getAbsolutePath() + ": " + e.getMessage());
            this.factory.getApplication().getConsole().err(e);
            try {
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.output = null;
        }
    }

    @Override
    public int level() {
        return this.level.ordinal();
    }

    @Override
    public boolean needsThreadName() {
        return this.pattern.needsThreadName();
    }

    @Override
    public boolean needsLocation() {
        return this.pattern.needsLocation();
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (Exception e) {
                throw IO.error(e);
            }
            this.output = null;
        }
    }
}

