/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.math;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.lecousin.framework.math.RangeInteger;

public class FragmentedRangeInteger
extends LinkedList<RangeInteger> {
    private static final long serialVersionUID = -2633315842445860994L;

    public FragmentedRangeInteger() {
    }

    public FragmentedRangeInteger(RangeInteger r) {
        this.add(r);
    }

    public static FragmentedRangeInteger intersect(FragmentedRangeInteger list1, FragmentedRangeInteger list2) {
        FragmentedRangeInteger result = new FragmentedRangeInteger();
        if (list1.isEmpty() || list2.isEmpty()) {
            return result;
        }
        block0: for (RangeInteger r1 : list1) {
            for (RangeInteger r2 : list2) {
                if (r2.max < r1.min) continue;
                if (r2.min > r1.max) continue block0;
                int min = r1.min < r2.min ? r2.min : r1.min;
                int max = r1.max > r2.max ? r2.max : r1.max;
                result.addRange(min, max);
            }
        }
        return result;
    }

    public FragmentedRangeInteger copy() {
        FragmentedRangeInteger c = new FragmentedRangeInteger();
        for (RangeInteger r : this) {
            c.add(r.copy());
        }
        return c;
    }

    public void addRange(RangeInteger r) {
        this.addRange(r.min, r.max);
    }

    public void addRange(int start, int end) {
        if (this.isEmpty()) {
            this.add(new RangeInteger(start, end));
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            RangeInteger r = (RangeInteger)this.get(i);
            if (end < r.min) {
                if (end == r.min - 1) {
                    r.min = start;
                } else {
                    this.add(i, new RangeInteger(start, end));
                }
                return;
            }
            if (start == r.max + 1) {
                r.max = end;
                int j = i + 1;
                while (j < this.size()) {
                    RangeInteger r2 = (RangeInteger)this.get(j);
                    if (end < r2.min - 1) break;
                    if (end == r2.min - 1) {
                        r.max = r2.max;
                        this.remove(j);
                        break;
                    }
                    if (end >= r2.max) {
                        this.remove(j);
                        continue;
                    }
                    r.max = r2.max;
                    this.remove(j);
                    break;
                }
                return;
            }
            if (start > r.max) continue;
            if (start < r.min) {
                r.min = start;
            }
            if (end <= r.max) {
                return;
            }
            r.max = end;
            int j = i + 1;
            while (j < this.size()) {
                RangeInteger r2 = (RangeInteger)this.get(j);
                if (end >= r2.max) {
                    this.remove(j);
                    continue;
                }
                if (end < r2.min - 1) break;
                r.max = r2.max;
                this.remove(j);
                break;
            }
            return;
        }
        this.add(new RangeInteger(start, end));
    }

    public void addRanges(Collection<RangeInteger> ranges) {
        for (RangeInteger r : ranges) {
            this.addRange(r);
        }
    }

    public void addValue(int value) {
        if (this.isEmpty()) {
            this.add(new RangeInteger(value, value));
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            RangeInteger r = (RangeInteger)this.get(i);
            if (value < r.min) {
                if (value == r.min - 1) {
                    r.min = value;
                } else {
                    this.add(i, new RangeInteger(value, value));
                }
                return;
            }
            if (value == r.max + 1) {
                r.max = value;
                if (i < this.size() - 1) {
                    RangeInteger r2 = (RangeInteger)this.get(i + 1);
                    if (r2.min == value + 1) {
                        r.max = r2.max;
                        this.remove(i + 1);
                    }
                }
                return;
            }
            if (value > r.max) continue;
            return;
        }
        this.add(new RangeInteger(value, value));
    }

    public boolean containsValue(int val) {
        for (RangeInteger r : this) {
            if (val >= r.min && val <= r.max) {
                return true;
            }
            if (val >= r.min) continue;
            return false;
        }
        return false;
    }

    public boolean containsRange(int start, int end) {
        if (start > end) {
            return true;
        }
        for (RangeInteger r : this) {
            if (r.min > start) {
                return false;
            }
            if (r.max < start) continue;
            return r.max >= end;
        }
        return false;
    }

    public int getMin() {
        if (this.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        return ((RangeInteger)this.getFirst()).min;
    }

    public int getMax() {
        if (this.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        return ((RangeInteger)this.getLast()).max;
    }

    public RangeInteger removeBestRangeForSize(int size) {
        RangeInteger best = null;
        int bestSize = Integer.MAX_VALUE;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            int s;
            RangeInteger r = (RangeInteger)it.next();
            if (r.max - r.min + 1 == size) {
                it.remove();
                return r;
            }
            if (r.max - r.min + 1 < size || (s = r.max - r.min + 1) >= bestSize) continue;
            best = r;
            bestSize = s;
        }
        if (best == null) {
            return null;
        }
        RangeInteger res = new RangeInteger(best.min, best.min + size - 1);
        best.min += size;
        return res;
    }

    public RangeInteger removeBiggestRange() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.size() == 1) {
            return (RangeInteger)this.remove(0);
        }
        int biggestIndex = 0;
        RangeInteger r = (RangeInteger)this.get(0);
        int biggestSize = r.max - r.min + 1;
        for (int i = 1; i < this.size(); ++i) {
            r = (RangeInteger)this.get(i);
            if (r.max - r.min + 1 <= biggestSize) continue;
            biggestSize = r.max - r.min + 1;
            biggestIndex = i;
        }
        return (RangeInteger)this.remove(biggestIndex);
    }

    public Integer removeFirstValue() {
        if (this.isEmpty()) {
            return null;
        }
        RangeInteger r = (RangeInteger)this.getFirst();
        int value = r.min;
        if (r.min == r.max) {
            this.removeFirst();
        } else {
            ++r.min;
        }
        return value;
    }

    public void remove(int start, int end) {
        for (int i = 0; i < this.size(); ++i) {
            RangeInteger r = (RangeInteger)this.get(i);
            if (r.min > end) {
                return;
            }
            if (r.max < start) continue;
            if (r.min < start) {
                if (r.max == end) {
                    r.max = start - 1;
                    return;
                }
                if (r.max < end) {
                    int j = r.max;
                    r.max = start - 1;
                    start = j + 1;
                    continue;
                }
                RangeInteger nr = new RangeInteger(end + 1, r.max);
                r.max = start - 1;
                this.add(i + 1, nr);
                return;
            }
            if (r.min == start) {
                if (r.max == end) {
                    this.remove(i);
                    return;
                }
                if (r.max < end) {
                    this.remove(i);
                    start = r.max + 1;
                    --i;
                    continue;
                }
                r.min = end + 1;
                return;
            }
            if (r.max == end) {
                this.remove(i);
                return;
            }
            if (r.max < end) {
                this.remove(i);
                start = r.max + 1;
                --i;
                continue;
            }
            r.min = end + 1;
            return;
        }
    }

    public void removeValue(int value) {
        this.remove(value, value);
    }

    public int getTotalSize() {
        int total = 0;
        for (RangeInteger r : this) {
            total += r.max - r.min + 1;
        }
        return total;
    }

    public void addCopy(Collection<RangeInteger> col) {
        for (RangeInteger r : col) {
            this.addRange(r.min, r.max);
        }
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("{");
        boolean first = true;
        for (RangeInteger r : this) {
            if (first) {
                first = false;
            } else {
                s.append(",");
            }
            s.append("[").append(r.min).append("-").append(r.max).append("]");
        }
        s.append("}");
        return s.toString();
    }
}

