/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.math;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.lecousin.framework.math.TimeUnit;
import net.lecousin.framework.plugins.ExtensionPoint;
import net.lecousin.framework.plugins.Plugin;

public interface IntegerUnit {

    public static class ParserRegistry {
        private static final Map<String, Class<? extends IntegerUnit>> units = new HashMap<String, Class<? extends IntegerUnit>>();

        public static void register(String text, Class<? extends IntegerUnit> unit) {
            units.put(text, unit);
        }

        public static Class<? extends IntegerUnit> get(String text) {
            return units.get(text);
        }

        static {
            ParserRegistry.register("ms", TimeUnit.Millisecond.class);
            ParserRegistry.register("millisecond", TimeUnit.Millisecond.class);
            ParserRegistry.register("milliseconds", TimeUnit.Millisecond.class);
            ParserRegistry.register("millis", TimeUnit.Millisecond.class);
            ParserRegistry.register("second", TimeUnit.Second.class);
            ParserRegistry.register("seconds", TimeUnit.Second.class);
            ParserRegistry.register("minute", TimeUnit.Minute.class);
            ParserRegistry.register("minutes", TimeUnit.Minute.class);
            ParserRegistry.register("h", TimeUnit.Hour.class);
            ParserRegistry.register("hour", TimeUnit.Hour.class);
            ParserRegistry.register("hours", TimeUnit.Hour.class);
            ParserRegistry.register("day", TimeUnit.Day.class);
            ParserRegistry.register("days", TimeUnit.Day.class);
        }
    }

    public static class ConverterRegistry
    implements ExtensionPoint<Converter> {
        private static ConverterRegistry instance;
        private ArrayList<Converter> converters = new ArrayList();

        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
        public ConverterRegistry() {
            instance = this;
            this.converters.add(new TimeUnit.Converter());
        }

        @Override
        public Class<Converter> getPluginClass() {
            return Converter.class;
        }

        @Override
        public void addPlugin(Converter plugin) {
            this.converters.add(plugin);
        }

        @Override
        public Collection<Converter> getPlugins() {
            return this.converters;
        }

        @Override
        public void allPluginsLoaded() {
        }

        public static long convert(long value, Class<? extends IntegerUnit> from, Class<? extends IntegerUnit> to) throws UnitConversionException {
            for (Converter c : ConverterRegistry.instance.converters) {
                if (!c.supportConversion(from, to)) continue;
                return c.convert(value, from, to);
            }
            throw new UnitConversionException(from, to, value);
        }
    }

    public static interface Converter
    extends Plugin {
        public boolean supportConversion(Class<? extends IntegerUnit> var1, Class<? extends IntegerUnit> var2);

        public long convert(long var1, Class<? extends IntegerUnit> var3, Class<? extends IntegerUnit> var4) throws UnitConversionException;
    }

    public static class UnitConversionException
    extends Exception {
        private static final long serialVersionUID = -4651595394407140514L;

        public UnitConversionException(Class<? extends IntegerUnit> from, Class<? extends IntegerUnit> to, long value) {
            super("Cannot convert value " + value + " from " + from.getSimpleName() + " to " + to.getSimpleName());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Unit {
        public Class<? extends IntegerUnit> value();
    }
}

