/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.math;

import net.lecousin.framework.util.Pair;

public class RangeLong {
    public long min;
    public long max;

    public RangeLong(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public RangeLong copy() {
        return new RangeLong(this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RangeLong)) {
            return false;
        }
        RangeLong r = (RangeLong)obj;
        return r.min == this.min && r.max == this.max;
    }

    public int hashCode() {
        return (int)(this.min + this.max);
    }

    public String toString() {
        return "[" + this.min + "-" + this.max + "]";
    }

    public boolean contains(long value) {
        return value >= this.min && value <= this.max;
    }

    public long getLength() {
        return this.max - this.min + 1L;
    }

    public RangeLong intersect(RangeLong o) {
        if (o.min < this.min) {
            if (o.max < this.min) {
                return null;
            }
            return new RangeLong(this.min, o.max > this.max ? this.max : o.max);
        }
        if (this.max < o.min) {
            return null;
        }
        return new RangeLong(o.min, o.max > this.max ? this.max : o.max);
    }

    public Pair<RangeLong, RangeLong> removeIntersect(RangeLong o) {
        RangeLong after;
        RangeLong before;
        if (this.min < o.min) {
            if (this.max < o.min) {
                before = this.copy();
                after = null;
            } else {
                before = new RangeLong(this.min, o.min);
                after = o.max >= this.max ? null : new RangeLong(this.max + 1L, o.max);
            }
        } else {
            before = null;
            after = this.max <= o.max ? null : new RangeLong(this.max + 1L, o.max);
        }
        return new Pair<RangeLong, Object>(before, after);
    }
}

