/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.memory.CacheManager;
import net.lecousin.framework.memory.MemoryManager;
import net.lecousin.framework.util.CloseableListenable;

public class Cache<Key, Value>
implements CacheManager {
    private String description;
    private Listener<Value> freer;
    private HashMap<Key, Data<Value>> map = new HashMap();
    private HashMap<Value, Data<Value>> values = new HashMap();

    public Cache(String description, Listener<Value> freer) {
        this.description = description;
        this.freer = freer;
        MemoryManager.register(this);
    }

    public synchronized Value get(Key key, CloseableListenable user) {
        final Data<Value> data = this.map.get(key);
        if (data == null) {
            return null;
        }
        data.users.add(user);
        if (user != null) {
            user.addCloseListener(new Listener<CloseableListenable>(){

                @Override
                public void fire(CloseableListenable event) {
                    event.removeCloseListener(this);
                    Cache.this.free(data.value, event);
                }
            });
        }
        return data.value;
    }

    public synchronized void free(Value value, CloseableListenable user) {
        Data<Value> data = this.values.get(value);
        if (data == null) {
            return;
        }
        data.lastUsage = System.currentTimeMillis();
        data.users.remove(user);
    }

    public synchronized void put(Key key, Value value, CloseableListenable firstUser) {
        if (this.map.containsKey(key)) {
            throw new IllegalStateException("Cannot put a value in Cache with an existing key: " + key);
        }
        if (this.values.containsKey(value)) {
            throw new IllegalStateException("Cannot put 2 times the same value in Cache: " + value);
        }
        Data data = new Data();
        data.value = value;
        data.lastUsage = System.currentTimeMillis();
        data.users.add(firstUser);
        this.map.put(key, data);
        this.values.put(value, data);
    }

    @Override
    public Collection<? extends CacheManager.CachedData> getCachedData() {
        return this.map.values();
    }

    @Override
    public synchronized boolean free(CacheManager.CachedData data) {
        Object value = ((Data)data).value;
        this.values.remove(value);
        Object key = null;
        for (Map.Entry<Key, Data<Value>> e : this.map.entrySet()) {
            if (e.getValue() != data) continue;
            key = e.getKey();
            break;
        }
        this.map.remove(key);
        if (this.freer != null) {
            this.freer.fire(value);
        }
        return true;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public synchronized List<String> getItemsDescription() {
        ArrayList<String> list = new ArrayList<String>(this.values.size());
        for (Data<Value> d : this.values.values()) {
            StringBuilder s = new StringBuilder();
            s.append(d.value.toString());
            s.append(" (last used ").append(System.currentTimeMillis() - d.lastUsage).append("ms. ago)");
            s.append(" ").append(d.cachedDataCurrentUsage()).append(" users:");
            for (CloseableListenable user : d.users) {
                s.append("\r\n    => " + user);
            }
            list.add(s.toString());
        }
        return list;
    }

    public synchronized void close() {
        for (Data<Value> d : this.map.values()) {
            this.freer.fire(d.value);
        }
        this.map.clear();
        this.values.clear();
        MemoryManager.unregister(this);
    }

    private static class Data<Value>
    implements CacheManager.CachedData {
        public ArrayList<CloseableListenable> users = new ArrayList();
        public Value value;
        public long lastUsage = 0L;

        private Data() {
        }

        @Override
        public int cachedDataCurrentUsage() {
            return this.users.size();
        }

        @Override
        public long cachedDataLastUsage() {
            return this.lastUsage;
        }
    }
}

