/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.lecousin.framework.adapter.AdapterRegistry;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.locale.LocaleExtensionPoint;
import net.lecousin.framework.math.IntegerUnit;
import net.lecousin.framework.plugins.CustomExtensionPoint;
import net.lecousin.framework.plugins.ExtensionPoint;
import net.lecousin.framework.plugins.Plugin;

public final class ExtensionPoints {
    private static ArrayList<ExtensionPoint<?>> points = new ArrayList();
    private static ArrayList<Plugin> waitingPlugins = new ArrayList();
    private static ArrayList<CustomExtensionPoint> customs = new ArrayList();

    private ExtensionPoints() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Plugin> void add(ExtensionPoint<T> point) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        ArrayList<ExtensionPoint<?>> arrayList = points;
        synchronized (arrayList) {
            points.add(point);
            Iterator<Plugin> it = waitingPlugins.iterator();
            while (it.hasNext()) {
                Plugin pi = it.next();
                if (!point.getPluginClass().isAssignableFrom(pi.getClass())) continue;
                plugins.add(pi);
                it.remove();
            }
        }
        for (Plugin pi : plugins) {
            point.addPlugin(pi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(CustomExtensionPoint custom) {
        ArrayList<CustomExtensionPoint> arrayList = customs;
        synchronized (arrayList) {
            customs.add(custom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(String epClassName, Plugin pi) {
        ExtensionPoint<?> ep = null;
        ArrayList<ExtensionPoint<?>> arrayList = points;
        synchronized (arrayList) {
            for (ExtensionPoint<?> point : points) {
                if (!point.getClass().getName().equals(epClassName)) continue;
                ep = point;
                break;
            }
            if (ep == null) {
                waitingPlugins.add(pi);
                return;
            }
        }
        ep.addPlugin(pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ExtensionPoint<?>> T getExtensionPoint(Class<T> clazz) {
        ArrayList<ExtensionPoint<?>> arrayList = points;
        synchronized (arrayList) {
            for (ExtensionPoint<?> ep : points) {
                if (!clazz.isAssignableFrom(ep.getClass())) continue;
                return (T)ep;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends CustomExtensionPoint> T getCustomExtensionPoint(Class<T> clazz) {
        ArrayList<CustomExtensionPoint> arrayList = customs;
        synchronized (arrayList) {
            for (CustomExtensionPoint ep : customs) {
                if (!clazz.isAssignableFrom(ep.getClass())) continue;
                return (T)ep;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ExtensionPoint<?>> getExtensionPoints() {
        ArrayList<ExtensionPoint<?>> arrayList = points;
        synchronized (arrayList) {
            return new ArrayList(points);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allPluginsLoaded() {
        StringBuilder s = new StringBuilder(1024);
        s.append("Extension points:");
        ArrayList<Object> arrayList = points;
        synchronized (arrayList) {
            for (ExtensionPoint<?> extensionPoint : points) {
                extensionPoint.allPluginsLoaded();
            }
            for (ExtensionPoint<?> extensionPoint : points) {
                s.append("\r\n- ");
                extensionPoint.printInfo(s);
            }
            points.trimToSize();
        }
        arrayList = customs;
        synchronized (arrayList) {
            Iterator<CustomExtensionPoint> it = customs.iterator();
            while (it.hasNext()) {
                CustomExtensionPoint customExtensionPoint = it.next();
                s.append("\r\n- ");
                customExtensionPoint.printInfo(s);
                if (customExtensionPoint.keepAfterInit()) continue;
                it.remove();
            }
            customs.trimToSize();
        }
        LCCore.getApplication().getDefaultLogger().info(s.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CustomExtensionPoint> getCustomExtensionPoints() {
        ArrayList<CustomExtensionPoint> arrayList = customs;
        synchronized (arrayList) {
            return new ArrayList<CustomExtensionPoint>(customs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logRemainingPlugins() {
        ArrayList<ExtensionPoint<?>> arrayList = points;
        synchronized (arrayList) {
            for (Plugin pi : waitingPlugins) {
                System.err.println("Plugin ignored because extension point is not loaded: " + pi.getClass().getName());
            }
        }
    }

    static {
        points.add(new AdapterRegistry());
        points.add(new IntegerUnit.ConverterRegistry());
        customs.add(new LocaleExtensionPoint());
    }
}

