/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.progress;

import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.event.AsyncEvent;
import net.lecousin.framework.progress.WorkProgress;

public class WorkProgressImpl
implements WorkProgress {
    protected long amount;
    protected long position = 0L;
    protected String text;
    protected String subText;
    protected SynchronizationPoint<Exception> synch = new SynchronizationPoint();
    protected AsyncEvent event = null;

    public WorkProgressImpl(long amount, String text, String subText) {
        this.amount = amount;
        this.text = text;
        this.subText = subText;
    }

    public WorkProgressImpl(long amount, String text) {
        this(amount, text, "");
    }

    public WorkProgressImpl(long amount) {
        this(amount, "", "");
    }

    @Override
    public void setAmount(long work) {
        if (work == this.amount) {
            return;
        }
        this.amount = work;
        if (this.position > work) {
            this.position = work;
        }
        this.changed();
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public void setPosition(long position) {
        if (position == this.position) {
            return;
        }
        this.position = position;
        this.changed();
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void progress(long amountDone) {
        if (amountDone == 0L) {
            return;
        }
        this.position += amountDone;
        this.changed();
    }

    @Override
    public void done() {
        this.position = this.amount;
        this.synch.unblock();
        this.changed();
    }

    @Override
    public void error(Exception error) {
        this.synch.error(error);
        this.changed();
    }

    @Override
    public void cancel(CancelException reason) {
        this.synch.cancel(reason);
        this.changed();
    }

    @Override
    public ISynchronizationPoint<Exception> getSynch() {
        return this.synch;
    }

    @Override
    public long getRemainingWork() {
        return this.amount - this.position;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.changed();
    }

    @Override
    public String getSubText() {
        return this.subText;
    }

    @Override
    public void setSubText(String text) {
        this.subText = text;
        this.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listen(Runnable onchange) {
        WorkProgressImpl workProgressImpl = this;
        synchronized (workProgressImpl) {
            if (this.event == null) {
                this.event = new AsyncEvent();
            }
            this.event.addListener(onchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlisten(Runnable onchange) {
        WorkProgressImpl workProgressImpl = this;
        synchronized (workProgressImpl) {
            if (this.event == null) {
                return;
            }
            this.event.removeListener(onchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changed() {
        WorkProgressImpl workProgressImpl = this;
        synchronized (workProgressImpl) {
            if (this.event != null) {
                this.event.fire();
            }
        }
    }
}

