/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.lecousin.framework.event.Listener;

public class ProcessUtil {
    public static void onProcessExited(final Process process, final Listener<Integer> exitValueListener) {
        new Thread("Waiting for process to exit"){

            @Override
            public void run() {
                try {
                    exitValueListener.fire(process.waitFor());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    public static void consumeProcessConsole(Process process, Listener<String> outputListener, Listener<String> errorListener) {
        new ConsoleConsumer(process.getInputStream(), outputListener).start();
        new ConsoleConsumer(process.getErrorStream(), errorListener).start();
    }

    public static class ConsoleConsumer
    extends Thread {
        private InputStream input;
        private Listener<String> listener;

        public ConsoleConsumer(InputStream input, Listener<String> listener) {
            super("Console consumer");
            this.input = input;
            this.listener = listener;
        }

        @Override
        public void run() {
            StringBuilder line = new StringBuilder();
            byte[] buffer = new byte[1024];
            block4: while (true) {
                int nb;
                try {
                    nb = this.input.read(buffer);
                }
                catch (Exception e) {
                    break;
                }
                if (nb < 0) break;
                if (nb == 0) continue;
                String s = new String(buffer, 0, nb, StandardCharsets.ISO_8859_1);
                while (true) {
                    if (s.length() <= 0) continue block4;
                    int i = s.indexOf(13);
                    int j = s.indexOf(10);
                    if (i < 0 && j < 0) {
                        line.append(s);
                        continue block4;
                    }
                    if (i < 0) {
                        line.append(s.substring(0, j));
                        this.listener.fire(line.toString());
                        line = new StringBuilder();
                        s = s.substring(j + 1);
                        continue;
                    }
                    if (j < 0) {
                        line.append(s.substring(0, i));
                        this.listener.fire(line.toString());
                        line = new StringBuilder();
                        s = s.substring(i + 1);
                        continue;
                    }
                    if (i == j - 1) {
                        line.append(s.substring(0, i));
                        this.listener.fire(line.toString());
                        line = new StringBuilder();
                        s = s.substring(j + 1);
                        continue;
                    }
                    if (j < i) {
                        i = j;
                    }
                    line.append(s.substring(0, i));
                    this.listener.fire(line.toString());
                    line = new StringBuilder();
                    s = s.substring(i + 1);
                }
                break;
            }
            if (line.length() > 0) {
                this.listener.fire(line.toString());
            }
            try {
                this.input.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

