/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.math.BigInteger;

public class StringUtil {
    private static final char[] hexaChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static StringBuilder paddingLeft(StringBuilder s, int length, char padding) {
        while (s.length() < length) {
            s.insert(0, padding);
        }
        return s;
    }

    public static StringBuilder paddingLeft(StringBuilder to, String s, int length, char padding) {
        for (int i = s.length(); i < length; ++i) {
            to.append(padding);
        }
        to.append(s);
        return to;
    }

    public static StringBuilder paddingLeft(StringBuilder s, long value, int fixedSize) {
        String str = Long.toString(value);
        return StringUtil.paddingLeft(s, str, fixedSize, ' ');
    }

    public static StringBuilder paddingRight(StringBuilder s, int length, char padding) {
        while (s.length() < length) {
            s.append(padding);
        }
        return s;
    }

    public static StringBuilder paddingRight(StringBuilder to, String s, int nb, char padding) {
        to.append(s);
        for (int i = s.length(); i < nb; ++i) {
            to.append(padding);
        }
        return to;
    }

    public static StringBuilder paddingRight(StringBuilder s, long value, int fixedSize) {
        String str = Long.toString(value);
        return StringUtil.paddingRight(s, str, fixedSize, ' ');
    }

    public static char encodeHexaDigit(int value) {
        return hexaChar[value];
    }

    public static String encodeHexa(byte[] data) {
        return StringUtil.encodeHexa(data, 0, data.length);
    }

    public static String encodeHexa(byte[] data, int off, int len) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            str.append(hexaChar[data[i + off] >>> 4 & 0xF]).append(hexaChar[data[i + off] & 0xF]);
        }
        return str.toString();
    }

    public static String encodeHexa(byte b) {
        return "" + hexaChar[b >>> 4 & 0xF] + hexaChar[b & 0xF];
    }

    public static String encodeHexaPadding(long value) {
        char[] s = new char[]{StringUtil.encodeHexaDigit((int)(value >> 60 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 56 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 52 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 48 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 44 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 40 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 36 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 32 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 28 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 24 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 20 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 16 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 12 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 8 & 0xFL)), StringUtil.encodeHexaDigit((int)(value >> 4 & 0xFL)), StringUtil.encodeHexaDigit((int)(value & 0xFL))};
        return new String(s);
    }

    public static byte[] decodeHexa(String s) {
        byte[] data = new byte[s.length() / 2];
        StringUtil.decodeHexa(s, data);
        return data;
    }

    public static void decodeHexa(String s, byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)((StringUtil.decodeHexa(s.charAt(i * 2)) << 4) + StringUtil.decodeHexa(s.charAt(i * 2 + 1)));
        }
    }

    public static int decodeHexa(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    public static byte decodeHexaByte(String hexa) {
        int i = StringUtil.decodeHexa(hexa.charAt(0));
        if (hexa.length() > 1) {
            i = i << 4 | StringUtil.decodeHexa(hexa.charAt(1));
        }
        return (byte)i;
    }

    public static long decodeHexaLong(String hexa) {
        long l = StringUtil.decodeHexa(hexa.charAt(0));
        for (int i = 1; i < hexa.length(); ++i) {
            l <<= 4;
            l |= (long)StringUtil.decodeHexa(hexa.charAt(i));
        }
        return l;
    }

    public static boolean isHexa(char c) {
        return StringUtil.decodeHexa(c) != -1;
    }

    public static String possibleValues(Class<? extends Enum<?>> e) {
        StringBuilder s = new StringBuilder();
        try {
            Enum[] values = (Enum[])e.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(values[i].name());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return s.toString();
    }

    public static String size(long size) {
        if (size < 1024L) {
            return Long.toString(size);
        }
        if (size < 0x100000L) {
            return String.format("%.2f KB", new Double((double)size / 1024.0));
        }
        if (size < 0x40000000L) {
            return String.format("%.2f MB", new Double((double)size / 1048576.0));
        }
        if (size < 0x10000000000L) {
            return String.format("%.2f GB", new Double((double)size / 1.073741824E9));
        }
        return String.format("%.2f TB", new Double((double)size / 1.099511627776E12));
    }

    public static String size(Number size) {
        return StringUtil.size(size.longValue());
    }

    public static String size(BigInteger s) {
        if (s.compareTo(new BigInteger(Long.toString(Long.MAX_VALUE))) <= 0) {
            return StringUtil.size(s.longValue());
        }
        BigInteger tera = s.divide(new BigInteger(Long.toString(0x10000000000L)));
        return tera.toString() + " TB";
    }

    public static long parseSize(String s) throws NumberFormatException {
        int pos;
        int len = s.length();
        char c = s.charAt(0);
        if (c < '0' || c > '9') {
            throw new NumberFormatException("A size must start with a digit: " + s);
        }
        long value = c - 48;
        for (pos = 1; pos < len && (c = s.charAt(pos)) >= '0' && c <= '9'; ++pos) {
            value = value * 10L + (long)(c - 48);
        }
        if (pos == len) {
            return value;
        }
        while (pos < len && s.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos == len) {
            return value;
        }
        c = s.charAt(pos);
        if (c == 'B') {
            return value;
        }
        if (c == 'K') {
            return value * 1024L;
        }
        if (c == 'M') {
            return value * 1024L * 1024L;
        }
        if (c == 'G') {
            return value * 1024L * 1024L * 1024L;
        }
        if (c == 'T') {
            return value * 1024L * 1024L * 1024L * 1024L;
        }
        throw new NumberFormatException("Invalid size unit: " + s);
    }

    public static int count(String string, String toSearch) {
        int i;
        int pos = 0;
        int count = 0;
        while ((i = string.indexOf(toSearch, pos)) != -1) {
            ++count;
            pos = i + toSearch.length();
        }
        return count;
    }
}

