/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.util.Locale;

public class SystemEnvironment {
    public static OSFamily getOSFamily() {
        String name = System.getProperty("os.name").toLowerCase(Locale.US);
        if (name.contains("windows")) {
            if (name.contains("95") || name.contains("98") || name.contains("me") || name.contains("ce")) {
                return OSFamily.win9x;
            }
            return OSFamily.windows;
        }
        if (name.contains("os/2")) {
            return OSFamily.os2;
        }
        if (name.contains("netware")) {
            return OSFamily.netware;
        }
        String sep = System.getProperty("path.separator");
        if (sep.equals(";")) {
            return OSFamily.dos;
        }
        if (name.contains("nonstop_kernel")) {
            return OSFamily.tandem;
        }
        if (name.contains("openvms")) {
            return OSFamily.openvms;
        }
        if (sep.equals(":") && (!name.contains("mac") || name.endsWith("x"))) {
            return OSFamily.unix;
        }
        if (name.contains("mac")) {
            return OSFamily.mac;
        }
        if (name.contains("z/os") || name.contains("os/390")) {
            return OSFamily.zos;
        }
        if (name.contains("os/400")) {
            return OSFamily.os400;
        }
        return null;
    }

    public static enum OSFamily {
        dos("dos"),
        mac("mac"),
        netware("netware"),
        os2("os/2"),
        tandem("tandem"),
        unix("unix"),
        windows("windows"),
        win9x("win9x"),
        zos("z/os"),
        os400("os/400"),
        openvms("openvms");

        private String name;

        private OSFamily(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

