/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.io.text.BufferedReadableCharacterStreamLocation;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.UnprotectedStringBuffer;
import net.lecousin.framework.xml.XMLException;

public abstract class XMLStreamEvents {
    public Event event = new Event();
    private static boolean[] isSpace = new boolean[]{true, true, false, false, true};

    public UnprotectedStringBuffer getNamespaceURI(CharSequence namespacePrefix) {
        for (ElementContext ctx : this.event.context) {
            for (Pair<UnprotectedStringBuffer, UnprotectedStringBuffer> ns : ctx.namespaces) {
                if (!ns.getValue1().equals(namespacePrefix)) continue;
                return ns.getValue2();
            }
        }
        return new UnprotectedStringBuffer();
    }

    public Attribute getAttributeByFullName(CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.text.equals(name)) continue;
            return attr;
        }
        return null;
    }

    public Attribute getAttributeByLocalName(CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.localName.equals(name)) continue;
            return attr;
        }
        return null;
    }

    public Attribute getAttributeWithPrefix(CharSequence prefix, CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.localName.equals(name) || !attr.namespacePrefix.equals(prefix)) continue;
            return attr;
        }
        return null;
    }

    public Attribute getAttributeWithNamespaceURI(CharSequence uri, CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.localName.equals(name) || !this.getNamespaceURI(attr.namespacePrefix).equals(uri)) continue;
            return attr;
        }
        return null;
    }

    public UnprotectedStringBuffer getAttributeValueByFullName(CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.text.equals(name)) continue;
            return attr.value;
        }
        return null;
    }

    public UnprotectedStringBuffer getAttributeValueByLocalName(CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.localName.equals(name)) continue;
            return attr.value;
        }
        return null;
    }

    public UnprotectedStringBuffer getAttributeValueWithPrefix(CharSequence prefix, CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.localName.equals(name) || !attr.namespacePrefix.equals(prefix)) continue;
            return attr.value;
        }
        return null;
    }

    public UnprotectedStringBuffer getAttributeValueWithNamespaceURI(CharSequence uri, CharSequence name) {
        for (Attribute attr : this.event.attributes) {
            if (!attr.localName.equals(name) || !this.getNamespaceURI(attr.namespacePrefix).equals(uri)) continue;
            return attr.value;
        }
        return null;
    }

    public Attribute removeAttributeByFullName(CharSequence name) {
        Iterator it = this.event.attributes.iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            if (!attr.text.equals(name)) continue;
            it.remove();
            return attr;
        }
        return null;
    }

    public Attribute removeAttributeByLocalName(CharSequence name) {
        Iterator it = this.event.attributes.iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            if (!attr.localName.equals(name)) continue;
            it.remove();
            return attr;
        }
        return null;
    }

    public Attribute removeAttributeWithPrefix(CharSequence prefix, CharSequence name) {
        Iterator it = this.event.attributes.iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            if (!attr.localName.equals(name) || !attr.namespacePrefix.equals(prefix)) continue;
            it.remove();
            return attr;
        }
        return null;
    }

    public Attribute removeAttributeWithNamespaceURI(CharSequence uri, CharSequence name) {
        Iterator it = this.event.attributes.iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            if (!attr.localName.equals(name) || !this.getNamespaceURI(attr.namespacePrefix).equals(uri)) continue;
            it.remove();
            return attr;
        }
        return null;
    }

    protected void reset() {
        if (Event.Type.START_ELEMENT.equals((Object)this.event.type) && this.event.isClosed) {
            this.event.context.removeFirst();
        } else if (Event.Type.END_ELEMENT.equals((Object)this.event.type)) {
            this.event.context.removeFirst();
        }
        this.event.type = null;
        this.event.text = null;
        this.event.namespacePrefix = null;
        this.event.localName = null;
        this.event.isClosed = false;
        this.event.attributes = null;
        this.event.system = null;
        this.event.publicId = null;
    }

    protected void onStartElement() {
        int i = this.event.text.indexOf(':');
        if (i < 0) {
            this.event.namespacePrefix = new UnprotectedStringBuffer();
            this.event.localName = this.event.text;
        } else {
            this.event.namespacePrefix = this.event.text.substring(0, i);
            this.event.localName = this.event.text.substring(i + 1);
        }
        ElementContext ctx = new ElementContext();
        ctx.text = this.event.text;
        ctx.namespacePrefix = this.event.namespacePrefix;
        ctx.localName = this.event.localName;
        ctx.namespaces = this.readNamespaces();
        this.event.context.addFirst(ctx);
        this.event.namespaceURI = this.getNamespaceURI(this.event.namespacePrefix);
    }

    protected List<Pair<UnprotectedStringBuffer, UnprotectedStringBuffer>> readNamespaces() {
        LinkedList<Pair<UnprotectedStringBuffer, UnprotectedStringBuffer>> list = new LinkedList<Pair<UnprotectedStringBuffer, UnprotectedStringBuffer>>();
        Iterator it = this.event.attributes.iterator();
        while (it.hasNext()) {
            Attribute a = (Attribute)it.next();
            if (a.namespacePrefix.length() == 0) {
                if (!a.localName.equals("xmlns")) continue;
                list.add(new Pair<UnprotectedStringBuffer, UnprotectedStringBuffer>(a.namespacePrefix, a.value));
                it.remove();
                continue;
            }
            if (!a.namespacePrefix.equals("xmlns")) continue;
            list.add(new Pair<UnprotectedStringBuffer, UnprotectedStringBuffer>(a.localName, a.value));
            it.remove();
        }
        return list;
    }

    public static boolean isSpaceChar(char c) {
        if (c == ' ') {
            return true;
        }
        if (c > '\r') {
            return false;
        }
        if (c < '\t') {
            return false;
        }
        return isSpace[c - 9];
    }

    protected static class Starter {
        protected IO.Readable.Buffered io;
        protected int bufferSize;
        protected Charset givenEncoding;
        protected Charset bomEncoding;
        protected byte[] bytes = new byte[20];
        protected int bytesStart = 0;
        protected int bytesEnd = 0;
        protected CharsetDecoder tmpDecoder;
        protected CharBuffer oneChar = CharBuffer.allocate(1);
        protected int line = 1;
        protected int posInLine = 1;
        protected UnprotectedStringBuffer xmlVersion = null;
        protected UnprotectedStringBuffer xmlEncoding = null;
        protected UnprotectedStringBuffer xmlStandalone = null;

        public Starter(IO.Readable.Buffered io, Charset givenEncoding, int bufferSize) {
            this.io = io;
            this.givenEncoding = givenEncoding;
            this.bufferSize = bufferSize;
        }

        public BufferedReadableCharacterStreamLocation start() throws IOException, XMLException {
            this.readBOM();
            this.tmpDecoder = this.givenEncoding != null ? this.givenEncoding.newDecoder() : (this.bomEncoding != null ? this.bomEncoding.newDecoder() : StandardCharsets.UTF_8.newDecoder());
            this.tmpDecoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.tmpDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            BufferedReadableCharacterStream stream = this.readXMLDeclaration();
            if (stream == null) {
                Charset encoding;
                if (this.xmlEncoding != null && !(encoding = Charset.forName(this.xmlEncoding.asString())).equals(this.tmpDecoder.charset())) {
                    this.tmpDecoder = encoding.newDecoder();
                    this.tmpDecoder.onMalformedInput(CodingErrorAction.REPLACE);
                    this.tmpDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
                }
                stream = new BufferedReadableCharacterStream((IO.Readable)this.io, this.tmpDecoder, this.bufferSize, 8, this.bytesEnd == this.bytesStart ? null : ByteBuffer.wrap(this.bytes, this.bytesStart, this.bytesEnd - this.bytesStart), null);
            }
            return new BufferedReadableCharacterStreamLocation(stream, this.line, this.posInLine);
        }

        private char nextChar() throws IOException {
            if (this.bytesEnd == this.bytesStart) {
                this.addByte();
            }
            this.oneChar.clear();
            while (true) {
                ByteBuffer b = ByteBuffer.wrap(this.bytes, this.bytesStart, this.bytesEnd - this.bytesStart);
                this.tmpDecoder.decode(b, this.oneChar, false);
                this.bytesStart = b.position();
                if (this.oneChar.position() != 0) break;
                this.addByte();
            }
            char c = this.oneChar.array()[0];
            if (c == '\n') {
                ++this.line;
                this.posInLine = 0;
            } else {
                ++this.posInLine;
            }
            return c;
        }

        private void addByte() throws IOException {
            if (this.bytesEnd == this.bytes.length) {
                System.arraycopy(this.bytes, this.bytesStart, this.bytes, 0, this.bytesEnd - this.bytesStart);
                this.bytesEnd -= this.bytesStart;
                this.bytesStart = 0;
            }
            this.bytes[this.bytesEnd++] = this.io.readByte();
        }

        public void readBOM() throws IOException, XMLException {
            int b1 = this.io.read();
            if (b1 < 0) {
                throw new XMLException(null, "File is empty", new Object[0]);
            }
            switch (b1) {
                case 239: {
                    int b2 = this.io.read();
                    if (b2 < 0) {
                        throw new XMLException(null, "Not an XML file", new Object[0]);
                    }
                    if (b2 == 187) {
                        int b3 = this.io.read();
                        if (b3 < 0) {
                            throw new XMLException(null, "Not an XML file", new Object[0]);
                        }
                        if (b3 == 191) {
                            this.bomEncoding = StandardCharsets.UTF_8;
                            break;
                        }
                        this.bytes[this.bytesEnd++] = (byte)b1;
                        this.bytes[this.bytesEnd++] = (byte)b2;
                        this.bytes[this.bytesEnd++] = (byte)b3;
                        break;
                    }
                    this.bytes[this.bytesEnd++] = (byte)b1;
                    this.bytes[this.bytesEnd++] = (byte)b2;
                    break;
                }
                case 254: {
                    int b2 = this.io.read();
                    if (b2 < 0) {
                        throw new XMLException(null, "Not an XML file", new Object[0]);
                    }
                    if (b2 == 255) {
                        this.bomEncoding = StandardCharsets.UTF_16BE;
                        break;
                    }
                    this.bytes[this.bytesEnd++] = (byte)b1;
                    this.bytes[this.bytesEnd++] = (byte)b2;
                    break;
                }
                case 255: {
                    int b2 = this.io.read();
                    if (b2 < 0) {
                        throw new XMLException(null, "Not an XML file", new Object[0]);
                    }
                    if (b2 == 254) {
                        int b3 = this.io.read();
                        if (b3 < 0) {
                            throw new XMLException(null, "Not an XML file", new Object[0]);
                        }
                        if (b3 == 0) {
                            int b4 = this.io.read();
                            if (b4 < 0) {
                                throw new XMLException(null, "Not an XML file", new Object[0]);
                            }
                            if (b4 == 0) {
                                this.bomEncoding = Charset.forName("UTF-32LE");
                                break;
                            }
                            this.bytes[this.bytesEnd++] = (byte)b1;
                            this.bytes[this.bytesEnd++] = (byte)b2;
                            this.bytes[this.bytesEnd++] = (byte)b3;
                            this.bytes[this.bytesEnd++] = (byte)b4;
                            break;
                        }
                        this.bomEncoding = StandardCharsets.UTF_16LE;
                        this.bytes[this.bytesEnd++] = (byte)b3;
                        break;
                    }
                    this.bytes[this.bytesEnd++] = (byte)b1;
                    this.bytes[this.bytesEnd++] = (byte)b2;
                    break;
                }
                case 0: {
                    int b2 = this.io.read();
                    if (b2 < 0) {
                        throw new XMLException(null, "Not an XML file", new Object[0]);
                    }
                    if (b2 == 0) {
                        int b3 = this.io.read();
                        if (b3 < 0) {
                            throw new XMLException(null, "Not an XML file", new Object[0]);
                        }
                        if (b3 == 254) {
                            int b4 = this.io.read();
                            if (b4 < 0) {
                                throw new XMLException(null, "Not an XML file", new Object[0]);
                            }
                            if (b4 == 255) {
                                this.bomEncoding = Charset.forName("UTF-32BE");
                                break;
                            }
                            this.bytes[this.bytesEnd++] = (byte)b1;
                            this.bytes[this.bytesEnd++] = (byte)b2;
                            this.bytes[this.bytesEnd++] = (byte)b3;
                            this.bytes[this.bytesEnd++] = (byte)b4;
                            break;
                        }
                        this.bomEncoding = StandardCharsets.UTF_16BE;
                        this.bytes[this.bytesEnd++] = (byte)b3;
                        break;
                    }
                    this.bytes[this.bytesEnd++] = (byte)b1;
                    this.bytes[this.bytesEnd++] = (byte)b2;
                    break;
                }
                default: {
                    this.bytes[this.bytesEnd++] = (byte)b1;
                }
            }
        }

        protected BufferedReadableCharacterStream readXMLDeclaration() throws IOException {
            char c;
            while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
            }
            if (c != '<') {
                return this.end(new char[]{c});
            }
            c = this.nextChar();
            if (c != '?') {
                return this.end(new char[]{'<', c});
            }
            c = this.nextChar();
            if (c != 'x' && c != 'X') {
                return this.end(new char[]{'<', '?', c});
            }
            char c2 = this.nextChar();
            if (c2 != 'm' && c2 != 'M') {
                return this.end(new char[]{'<', '?', c, c2});
            }
            char c3 = this.nextChar();
            if (c3 != 'l' && c3 != 'L') {
                return this.end(new char[]{'<', '?', c, c2, c3});
            }
            char c4 = this.nextChar();
            if (!XMLStreamEvents.isSpaceChar(c4)) {
                return this.end(new char[]{'<', '?', c, c2, c3, c4});
            }
            while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
            }
            if (c != 'v' && c != 'V') {
                throw new IOException("Invalid XML Declaration: first attribute must be 'version'");
            }
            c = this.nextChar();
            if (c != 'e' && c != 'E') {
                throw new IOException("Invalid XML Declaration: first attribute must be 'version'");
            }
            c = this.nextChar();
            if (c != 'r' && c != 'R') {
                throw new IOException("Invalid XML Declaration: first attribute must be 'version'");
            }
            c = this.nextChar();
            if (c != 's' && c != 'S') {
                throw new IOException("Invalid XML Declaration: first attribute must be 'version'");
            }
            c = this.nextChar();
            if (c != 'i' && c != 'I') {
                throw new IOException("Invalid XML Declaration: first attribute must be 'version'");
            }
            c = this.nextChar();
            if (c != 'o' && c != 'O') {
                throw new IOException("Invalid XML Declaration: first attribute must be 'version'");
            }
            c = this.nextChar();
            if (c != 'n' && c != 'N') {
                throw new IOException("Invalid XML Declaration: first attribute must be 'version'");
            }
            while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
            }
            if (c != '=') {
                throw new IOException("Invalid XML Declaration: character '=' expected after attribute name 'version'");
            }
            while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
            }
            if (c != '\'' && c != '\"') {
                throw new IOException("Invalid XML Declaration: character ' or \" expected after 'version='");
            }
            c2 = c;
            this.xmlVersion = new UnprotectedStringBuffer();
            while ((c = this.nextChar()) != c2) {
                this.xmlVersion.append(c);
            }
            while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
            }
            if (c == 'e' || c == 'E') {
                c = this.nextChar();
                if (c != 'n' && c != 'N') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'e" + c + "'");
                }
                c = this.nextChar();
                if (c != 'c' && c != 'C') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'en" + c + "'");
                }
                c = this.nextChar();
                if (c != 'o' && c != 'O') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'enc" + c + "'");
                }
                c = this.nextChar();
                if (c != 'd' && c != 'D') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'enco" + c + "'");
                }
                c = this.nextChar();
                if (c != 'i' && c != 'I') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'encod" + c + "'");
                }
                c = this.nextChar();
                if (c != 'n' && c != 'N') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'encodi" + c + "'");
                }
                c = this.nextChar();
                if (c != 'g' && c != 'G') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'encodin" + c + "'");
                }
                while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
                }
                if (c != '=') {
                    throw new IOException("Invalid XML Declaration: character '=' expected after attribute name 'encoding'");
                }
                while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
                }
                if (c != '\'' && c != '\"') {
                    throw new IOException("Invalid XML Declaration: character ' or \" expected after 'encoding='");
                }
                c2 = c;
                this.xmlEncoding = new UnprotectedStringBuffer();
                while ((c = this.nextChar()) != c2) {
                    this.xmlEncoding.append(c);
                }
                while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
                }
            }
            if (c == 's' || c == 'S') {
                c = this.nextChar();
                if (c != 't' && c != 'T') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 's" + c + "'");
                }
                c = this.nextChar();
                if (c != 'a' && c != 'A') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'st" + c + "'");
                }
                c = this.nextChar();
                if (c != 'n' && c != 'N') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'sta" + c + "'");
                }
                c = this.nextChar();
                if (c != 'd' && c != 'D') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'stan" + c + "'");
                }
                c = this.nextChar();
                if (c != 'a' && c != 'A') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'stand" + c + "'");
                }
                c = this.nextChar();
                if (c != 'l' && c != 'L') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'standa" + c + "'");
                }
                c = this.nextChar();
                if (c != 'o' && c != 'O') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'standal" + c + "'");
                }
                c = this.nextChar();
                if (c != 'n' && c != 'N') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'standalo" + c + "'");
                }
                c = this.nextChar();
                if (c != 'e' && c != 'E') {
                    throw new IOException("Invalid XML Declaration: unknown attribute starting with 'standalon" + c + "'");
                }
                while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
                }
                if (c != '=') {
                    throw new IOException("Invalid XML Declaration: character '=' expected after attribute name 'standalone'");
                }
                while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
                }
                if (c != '\'' && c != '\"') {
                    throw new IOException("Invalid XML Declaration: character ' or \" expected after 'standalone='");
                }
                c2 = c;
                this.xmlStandalone = new UnprotectedStringBuffer();
                while ((c = this.nextChar()) != c2) {
                    this.xmlStandalone.append(c);
                }
                while (XMLStreamEvents.isSpaceChar(c = this.nextChar())) {
                }
            }
            if (c != '?') {
                throw new IOException("Unexpected character '" + c + "' in XML declaration tag");
            }
            if (this.nextChar() != '>') {
                throw new IOException("Unexpected character '" + c + "' in XML declaration tag");
            }
            return null;
        }

        protected BufferedReadableCharacterStream end(char[] chars) {
            return new BufferedReadableCharacterStream((IO.Readable)this.io, this.tmpDecoder, this.bufferSize, 8, this.bytesEnd == this.bytesStart ? null : ByteBuffer.wrap(this.bytes, this.bytesStart, this.bytesEnd - this.bytesStart), CharBuffer.wrap(chars));
        }
    }

    public static class Attribute {
        public UnprotectedStringBuffer text;
        public UnprotectedStringBuffer namespacePrefix;
        public UnprotectedStringBuffer localName;
        public UnprotectedStringBuffer value;
    }

    public static class ElementContext {
        public UnprotectedStringBuffer text;
        public UnprotectedStringBuffer namespacePrefix;
        public UnprotectedStringBuffer localName;
        public List<Pair<UnprotectedStringBuffer, UnprotectedStringBuffer>> namespaces = new LinkedList<Pair<UnprotectedStringBuffer, UnprotectedStringBuffer>>();
    }

    public static class Event {
        public Type type = null;
        public UnprotectedStringBuffer text = null;
        public UnprotectedStringBuffer namespacePrefix = null;
        public UnprotectedStringBuffer namespaceURI = null;
        public UnprotectedStringBuffer localName = null;
        public boolean isClosed = false;
        public LinkedList<Attribute> attributes = null;
        public UnprotectedStringBuffer system = null;
        public UnprotectedStringBuffer publicId = null;
        public LinkedList<ElementContext> context = new LinkedList();

        public Event copy() {
            Event event = new Event();
            event.type = this.type;
            event.text = this.text;
            event.namespacePrefix = this.namespacePrefix;
            event.localName = this.localName;
            event.namespaceURI = this.namespaceURI;
            event.isClosed = this.isClosed;
            if (this.attributes != null) {
                event.attributes = new LinkedList<Attribute>(this.attributes);
            }
            event.system = this.system;
            event.publicId = this.publicId;
            event.context.addAll(this.context);
            return event;
        }

        public static enum Type {
            PROCESSING_INSTRUCTION,
            DOCTYPE,
            COMMENT,
            TEXT,
            START_ELEMENT,
            END_ELEMENT,
            CDATA;

        }
    }
}

