/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml;

import java.util.HashMap;
import java.util.Map;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.util.UnprotectedStringBuffer;
import net.lecousin.framework.xml.XMLStreamEvents;

public abstract class XMLStreamEventsAsync
extends XMLStreamEvents {
    public abstract ISynchronizationPoint<Exception> start();

    public abstract byte getPriority();

    public abstract SynchronizationPoint<Exception> next();

    public ISynchronizationPoint<Exception> nextStartElement() {
        SynchronizationPoint<Exception> next = this.next();
        if (next.isUnblocked()) {
            if (next.hasError()) {
                return next;
            }
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
                return next;
            }
            return this.nextStartElement();
        }
        SynchronizationPoint<Exception> sp = new SynchronizationPoint<Exception>();
        next.listenInline(() -> {
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
                sp.unblock();
                return;
            }
            new Next((SynchronizationPoint)sp){

                @Override
                protected void onNext() {
                    if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)XMLStreamEventsAsync.this.event.type)) {
                        this.sp.unblock();
                    } else {
                        XMLStreamEventsAsync.this.nextStartElement().listenInline(this.sp);
                    }
                }
            }.start();
        }, sp);
        return sp;
    }

    public AsyncWork<Boolean, Exception> nextInnerElement(XMLStreamEvents.ElementContext parent) {
        if (this.event.context.isEmpty()) {
            return new AsyncWork<Boolean, Object>(Boolean.FALSE, null);
        }
        if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type) && this.event.context.getFirst() == parent && this.event.isClosed) {
            return new AsyncWork<Boolean, Object>(Boolean.FALSE, null);
        }
        if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type) && this.event.context.getFirst() == parent) {
            return new AsyncWork<Boolean, Object>(Boolean.FALSE, null);
        }
        boolean parentPresent = false;
        for (XMLStreamEvents.ElementContext ctx : this.event.context) {
            if (ctx != parent) continue;
            parentPresent = true;
            break;
        }
        if (!parentPresent) {
            return new AsyncWork<Object, Exception>(null, new Exception("Invalid context: parent element " + parent.localName + " is not in the current context"));
        }
        SynchronizationPoint<Exception> next = this.next();
        while (next.isUnblocked()) {
            if (next.hasError()) {
                return new AsyncWork(null, next.getError());
            }
            if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type)) {
                if (this.event.context.getFirst() == parent) {
                    return new AsyncWork<Boolean, Object>(Boolean.FALSE, null);
                }
            } else if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type) && this.event.context.size() > 1 && this.event.context.get(1) == parent) {
                return new AsyncWork<Boolean, Object>(Boolean.TRUE, null);
            }
            next = this.next();
        }
        AsyncWork<Boolean, Exception> result = new AsyncWork<Boolean, Exception>();
        SynchronizationPoint<Exception> n = next;
        next.listenInline(() -> {
            if (n.hasError()) {
                result.error((Exception)n.getError());
            } else if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type)) {
                if (this.event.context.getFirst() == parent) {
                    result.unblockSuccess(Boolean.FALSE);
                }
            } else if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
                if (this.event.context.size() > 1 && this.event.context.get(1) == parent) {
                    result.unblockSuccess(Boolean.TRUE);
                }
            } else {
                new ParsingTask(() -> this.nextInnerElement(parent).listenInline(result)).start();
            }
        }, result);
        return result;
    }

    public AsyncWork<Boolean, Exception> nextInnerElement(XMLStreamEvents.ElementContext parent, String childName) {
        AsyncWork<Boolean, Exception> next = this.nextInnerElement(parent);
        while (next.isUnblocked()) {
            if (next.hasError()) {
                return next;
            }
            if (!next.getResult().booleanValue()) {
                return next;
            }
            if (this.event.text.equals(childName)) {
                return next;
            }
            next = this.nextInnerElement(parent);
        }
        AsyncWork<Boolean, Exception> result = new AsyncWork<Boolean, Exception>();
        AsyncWork<Boolean, Exception> n = next;
        next.listenInline(() -> {
            if (n.hasError()) {
                result.error((Exception)n.getError());
            } else if (!((Boolean)n.getResult()).booleanValue()) {
                result.unblockSuccess(Boolean.FALSE);
            } else if (this.event.text.equals(childName)) {
                result.unblockSuccess(Boolean.TRUE);
            } else {
                new ParsingTask(() -> this.nextInnerElement(parent, childName).listenInline(result)).start();
            }
        }, result);
        return result;
    }

    public AsyncWork<UnprotectedStringBuffer, Exception> readInnerText() {
        if (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
            return new AsyncWork<Object, Exception>(null, new Exception("Invalid call of readInnerText: it must be called on a start element"));
        }
        if (this.event.isClosed) {
            return new AsyncWork<UnprotectedStringBuffer, Object>(new UnprotectedStringBuffer(), null);
        }
        UnprotectedStringBuffer innerText = new UnprotectedStringBuffer();
        AsyncWork<UnprotectedStringBuffer, Exception> result = new AsyncWork<UnprotectedStringBuffer, Exception>();
        this.readInnerText(innerText, result);
        return result;
    }

    private void readInnerText(UnprotectedStringBuffer innerText, AsyncWork<UnprotectedStringBuffer, Exception> result) {
        SynchronizationPoint<Exception> next = this.next();
        while (next.isUnblocked()) {
            if (next.hasError()) {
                result.error((Exception)next.getError());
                return;
            }
            if (XMLStreamEvents.Event.Type.COMMENT.equals((Object)this.event.type)) {
                next = this.next();
                continue;
            }
            if (XMLStreamEvents.Event.Type.TEXT.equals((Object)this.event.type)) {
                innerText.append(this.event.text);
                next = this.next();
                continue;
            }
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
                if (this.event.isClosed) {
                    next = this.next();
                    continue;
                }
                this.closeElement().listenAsync(new ParsingTask(() -> this.readInnerText(innerText, result)), result);
                return;
            }
            if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type)) {
                result.unblockSuccess(innerText);
                return;
            }
            next = this.next();
        }
        next.listenInline(() -> {
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
                if (this.event.isClosed) {
                    new ParsingTask(() -> this.readInnerText(innerText, result)).start();
                    return;
                }
                this.closeElement().listenAsync(new ParsingTask(() -> this.readInnerText(innerText, result)), result);
                return;
            }
            if (XMLStreamEvents.Event.Type.COMMENT.equals((Object)this.event.type)) {
                new ParsingTask(() -> this.readInnerText(innerText, result)).start();
                return;
            }
            if (XMLStreamEvents.Event.Type.TEXT.equals((Object)this.event.type)) {
                innerText.append(this.event.text);
                new ParsingTask(() -> this.readInnerText(innerText, result)).start();
                return;
            }
            if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type)) {
                result.unblockSuccess(innerText);
                return;
            }
            new ParsingTask(() -> this.readInnerText(innerText, result)).start();
        }, result);
    }

    public ISynchronizationPoint<Exception> closeElement() {
        if (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
            return new SynchronizationPoint<Exception>(new Exception("Invalid call of closeElement: it must be called on a start element"));
        }
        if (this.event.isClosed) {
            return new SynchronizationPoint<boolean>(true);
        }
        XMLStreamEvents.ElementContext ctx = this.event.context.getFirst();
        return this.closeElement(ctx);
    }

    public ISynchronizationPoint<Exception> closeElement(XMLStreamEvents.ElementContext ctx) {
        SynchronizationPoint<Exception> next = this.next();
        while (next.isUnblocked()) {
            if (next.hasError()) {
                return next;
            }
            if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type) && this.event.context.getFirst() == ctx) {
                return next;
            }
            next = this.next();
        }
        SynchronizationPoint<Exception> result = new SynchronizationPoint<Exception>();
        SynchronizationPoint<Exception> n = next;
        next.listenInline(() -> {
            if (n.hasError()) {
                result.error((Exception)n.getError());
                return;
            }
            if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type) && this.event.context.getFirst() == ctx) {
                result.unblock();
                return;
            }
            new ParsingTask(() -> this.closeElement(ctx).listenInline(result)).start();
        }, result);
        return result;
    }

    public ISynchronizationPoint<Exception> searchElement(String elementName) {
        SynchronizationPoint<Exception> next = this.next();
        while (next.isUnblocked()) {
            if (next.hasError()) {
                return next;
            }
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type) && this.event.text.equals(elementName)) {
                return next;
            }
            next = this.next();
        }
        SynchronizationPoint<Exception> result = new SynchronizationPoint<Exception>();
        SynchronizationPoint<Exception> n = next;
        next.listenInline(() -> {
            if (n.hasError()) {
                result.error((Exception)n.getError());
            } else if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type) && this.event.text.equals(elementName)) {
                result.unblock();
            } else {
                new ParsingTask(() -> this.searchElement(elementName).listenInline(result)).start();
            }
        }, result);
        return result;
    }

    public AsyncWork<Boolean, Exception> goInto(XMLStreamEvents.ElementContext rootContext, String ... innerElements) {
        return this.goInto(rootContext, 0, innerElements);
    }

    private AsyncWork<Boolean, Exception> goInto(XMLStreamEvents.ElementContext parent, int i, String ... innerElements) {
        AsyncWork<Boolean, Exception> next = this.nextInnerElement(parent, innerElements[i]);
        while (next.isUnblocked()) {
            if (next.hasError()) {
                return next;
            }
            if (!next.getResult().booleanValue()) {
                return next;
            }
            if (++i == innerElements.length) {
                return next;
            }
            parent = this.event.context.getFirst();
            next = this.nextInnerElement(parent, innerElements[i]);
        }
        AsyncWork<Boolean, Exception> result = new AsyncWork<Boolean, Exception>();
        AsyncWork<Boolean, Exception> n = next;
        int ii = i;
        next.listenInline(() -> {
            if (n.hasError()) {
                result.error((Exception)n.getError());
            } else if (!((Boolean)n.getResult()).booleanValue()) {
                result.unblockSuccess(Boolean.FALSE);
            } else if (ii == innerElements.length - 1) {
                result.unblockSuccess(Boolean.TRUE);
            } else {
                new ParsingTask(() -> this.goInto(this.event.context.getFirst(), ii + 1, innerElements).listenInline(result)).start();
            }
        }, result);
        return result;
    }

    public AsyncWork<Map<String, String>, Exception> readInnerElementsText() {
        AsyncWork<Map<String, String>, Exception> result = new AsyncWork<Map<String, String>, Exception>();
        HashMap<String, String> texts = new HashMap<String, String>();
        this.readInnerElementsText(this.event.context.getFirst(), texts, result);
        return result;
    }

    private void readInnerElementsText(XMLStreamEvents.ElementContext parent, Map<String, String> texts, AsyncWork<Map<String, String>, Exception> result) {
        AsyncWork<Boolean, Exception> next = this.nextInnerElement(parent);
        while (next.isUnblocked()) {
            if (next.hasError()) {
                result.error(next.getError());
                return;
            }
            if (!next.getResult().booleanValue()) {
                result.unblockSuccess(texts);
                return;
            }
            String name = this.event.text.asString();
            AsyncWork<UnprotectedStringBuffer, Exception> read = this.readInnerText();
            if (read.isUnblocked()) {
                if (read.hasError()) {
                    result.error(read.getError());
                    return;
                }
                texts.put(name, read.getResult().asString());
                next = this.nextInnerElement(parent);
                continue;
            }
            read.listenInline(value -> {
                texts.put(name, value.asString());
                new ParsingTask(() -> this.readInnerElementsText(parent, texts, result)).start();
            }, result);
            return;
        }
        next.listenInline(() -> {
            String name = this.event.text.asString();
            new ParsingTask(() -> {
                AsyncWork<UnprotectedStringBuffer, Exception> read = this.readInnerText();
                if (read.isUnblocked()) {
                    if (read.hasError()) {
                        result.error(read.getError());
                        return;
                    }
                    texts.put(name, read.getResult().asString());
                    this.readInnerElementsText(parent, texts, result);
                    return;
                }
                read.listenInline(value -> {
                    texts.put(name, value.asString());
                    new ParsingTask(() -> this.readInnerElementsText(parent, texts, result)).start();
                }, (ISynchronizationPoint<Exception>)result);
            }).start();
        }, result);
    }

    protected class Next
    extends ParsingTask {
        protected SynchronizationPoint<Exception> sp;

        public Next(SynchronizationPoint<Exception> sp) {
            super(null);
            this.sp = sp;
        }

        @Override
        public Void run() {
            SynchronizationPoint<Exception> next = XMLStreamEventsAsync.this.next();
            if (next.isUnblocked()) {
                if (next.hasError()) {
                    this.sp.error((Exception)next.getError());
                } else {
                    this.onNext();
                }
                return null;
            }
            next.listenAsync(new Task.Cpu<Void, NoException>("Parse XML", XMLStreamEventsAsync.this.getPriority()){

                @Override
                public Void run() {
                    Next.this.onNext();
                    return null;
                }
            }, this.sp);
            return null;
        }

        protected void onNext() {
            this.sp.unblock();
        }
    }

    protected class ParsingTask
    extends Task.Cpu<Void, NoException> {
        private Runnable r;

        public ParsingTask(Runnable r) {
            super("Parse XML", XMLStreamEventsAsync.this.getPriority());
            this.r = r;
        }

        @Override
        public Void run() {
            this.r.run();
            return null;
        }
    }
}

