/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml;

import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.UnprotectedStringBuffer;
import net.lecousin.framework.xml.XMLException;
import net.lecousin.framework.xml.XMLStreamEvents;

public abstract class XMLStreamEventsSync
extends XMLStreamEvents {
    public abstract void start() throws XMLException, IOException;

    public abstract void next() throws XMLException, IOException;

    public abstract Pair<Integer, Integer> getPosition();

    public boolean nextStartElement() throws XMLException, IOException {
        try {
            do {
                this.next();
            } while (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type));
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    public boolean nextInnerElement(XMLStreamEvents.ElementContext parent) throws XMLException, IOException {
        if (this.event.context.isEmpty()) {
            return false;
        }
        if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type) && this.event.context.getFirst() == parent && this.event.isClosed) {
            return false;
        }
        if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type) && this.event.context.getFirst() == parent) {
            return false;
        }
        try {
            do {
                this.next();
                if (!XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type) || this.event.context.getFirst() != parent) continue;
                return false;
            } while (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type) || this.event.context.size() <= 1 || this.event.context.get(1) != parent);
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    public boolean nextInnerElement(XMLStreamEvents.ElementContext parent, String childName) throws XMLException, IOException {
        while (this.nextInnerElement(parent)) {
            if (!this.event.text.equals(childName)) continue;
            return true;
        }
        return false;
    }

    public UnprotectedStringBuffer readInnerText() throws XMLException, IOException {
        if (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
            throw new IOException("Invalid call of readInnerText: it must be called on a start element");
        }
        if (this.event.isClosed) {
            return new UnprotectedStringBuffer();
        }
        UnprotectedStringBuffer elementName = this.event.text;
        UnprotectedStringBuffer innerText = new UnprotectedStringBuffer();
        while (true) {
            try {
                this.next();
            }
            catch (EOFException e) {
                throw new XMLException(this.getPosition(), "Unexpected end", "readInnerText(" + elementName.toString() + ")");
            }
            if (XMLStreamEvents.Event.Type.COMMENT.equals((Object)this.event.type)) continue;
            if (XMLStreamEvents.Event.Type.TEXT.equals((Object)this.event.type)) {
                innerText.append(this.event.text);
                continue;
            }
            if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
                this.closeElement();
                continue;
            }
            if (XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type)) break;
        }
        if (!this.event.text.equals(elementName)) {
            throw new XMLException(this.getPosition(), "Unexpected end element", this.event.text.asString());
        }
        return innerText;
    }

    public void closeElement() throws XMLException, IOException {
        if (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type)) {
            throw new IOException("Invalid call of closeElement: it must be called on a start element");
        }
        if (this.event.isClosed) {
            return;
        }
        XMLStreamEvents.ElementContext ctx = this.event.context.getFirst();
        do {
            try {
                this.next();
            }
            catch (EOFException e) {
                throw new XMLException(this.getPosition(), "Unexpected end", "closeElement(" + ctx.text.asString() + ")");
            }
        } while (!XMLStreamEvents.Event.Type.END_ELEMENT.equals((Object)this.event.type) || this.event.context.getFirst() != ctx);
    }

    public boolean searchElement(String elementName) throws XMLException, IOException {
        try {
            while (true) {
                if (XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)this.event.type) && this.event.text.equals(elementName)) {
                    return true;
                }
                this.next();
            }
        }
        catch (EOFException e) {
            return false;
        }
    }

    public boolean goInto(XMLStreamEvents.ElementContext rootContext, String ... innerElements) throws IOException, XMLException {
        XMLStreamEvents.ElementContext parent = rootContext;
        for (int i = 0; i < innerElements.length; ++i) {
            if (!this.nextInnerElement(parent, innerElements[i])) {
                return false;
            }
            parent = this.event.context.getFirst();
        }
        return true;
    }

    public Map<String, String> readInnerElementsText(XMLStreamEvents.ElementContext parent) throws IOException, XMLException {
        HashMap<String, String> texts = new HashMap<String, String>();
        while (this.nextInnerElement(parent)) {
            String name = this.event.text.toString();
            texts.put(name, this.readInnerText().asString());
        }
        return texts;
    }
}

