/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.BufferedWritableCharacterStream;
import net.lecousin.framework.io.text.CharacterStreamWritePool;
import net.lecousin.framework.io.text.ICharacterStream;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLWriter {
    private ICharacterStream.Writable.Buffered output;
    private CharacterStreamWritePool writer;
    private boolean includeXMLDeclaration;
    private LinkedList<Context> context = new LinkedList();
    private static final char[] XML_DECLARATION_START = new char[]{'<', '?', 'x', 'm', 'l', ' ', 'v', 'e', 'r', 's', 'i', 'o', 'n', '=', '\"', '1', '.', '1', '\"', ' ', 'e', 'n', 'c', 'o', 'd', 'i', 'n', 'g', '=', '\"'};
    private static final char[] XML_DECLARATION_END = new char[]{'\"', '?', '>', '\n'};
    private static final char[] XMLNS = new char[]{' ', 'x', 'm', 'l', 'n', 's'};
    private static final char[] ATTRIBUTE_EQUALS = new char[]{'=', '\"'};
    private static final char[] CLOSE_EMPTY_TAG = new char[]{'/', '>'};
    private static final char[] START_CLOSE = new char[]{'<', '/'};
    private static final char[] START_CDATA = new char[]{'[', 'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] END_CDATA = new char[]{']', ']'};
    private static final char[] START_COMMENT = new char[]{'<', '!', '-', '-', ' '};
    private static final char[] END_COMMENT = new char[]{' ', '-', '-', '>'};

    public XMLWriter(IO.Writable.Buffered output, Charset encoding, boolean includeXMLDeclaration) {
        this(new BufferedWritableCharacterStream((IO.Writable)output, encoding != null ? encoding : StandardCharsets.UTF_8, 4096), includeXMLDeclaration);
    }

    public XMLWriter(ICharacterStream.Writable.Buffered output, boolean includeXMLDeclaration) {
        this.output = output;
        this.writer = new CharacterStreamWritePool(output);
        this.includeXMLDeclaration = includeXMLDeclaration;
    }

    private String getNamespace(String uri) {
        for (Context ctx : this.context) {
            String ns;
            if (ctx.namespaces == null || (ns = (String)ctx.namespaces.get(uri)) == null) continue;
            return ns;
        }
        return null;
    }

    public static String escape(CharSequence s) {
        StringBuilder str = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                str.append("&amp;");
                continue;
            }
            if (c == '\"') {
                str.append("&quot;");
                continue;
            }
            if (c == '\'') {
                str.append("&apos;");
                continue;
            }
            if (c == '>') {
                str.append("&gt;");
                continue;
            }
            if (c == '<') {
                str.append("&lt;");
                continue;
            }
            if (c < ' ') {
                str.append("&#").append((int)c).append(';');
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }

    public ISynchronizationPoint<IOException> start(String rootNamespaceURI, String rootLocalName, Map<String, String> namespaces) {
        String ns;
        if (this.includeXMLDeclaration) {
            this.writer.write(XML_DECLARATION_START);
            this.writer.write(this.output.getEncoding().name());
            this.writer.write(XML_DECLARATION_END);
        }
        this.writer.write('<');
        if (rootNamespaceURI != null && (ns = namespaces.get(rootNamespaceURI)) != null && ns.length() > 0) {
            this.writer.write(ns);
            this.writer.write(':');
        }
        ISynchronizationPoint<IOException> result = this.writer.write(rootLocalName);
        if (namespaces != null && !namespaces.isEmpty()) {
            for (Map.Entry<String, String> ns2 : namespaces.entrySet()) {
                this.writer.write(XMLNS);
                if (ns2.getValue().length() > 0) {
                    this.writer.write(':');
                    this.writer.write(ns2.getValue());
                }
                this.writer.write(ATTRIBUTE_EQUALS);
                this.writer.write(XMLWriter.escape(ns2.getKey()));
                result = this.writer.write('\"');
            }
        }
        Context ctx = new Context();
        ctx.namespaces = new HashMap();
        if (namespaces != null) {
            ctx.namespaces.putAll(namespaces);
        }
        ctx.namespaceURI = rootNamespaceURI;
        ctx.localName = rootLocalName;
        ctx.open = true;
        this.context.addFirst(ctx);
        return result;
    }

    public ISynchronizationPoint<IOException> end() {
        while (!this.context.isEmpty()) {
            this.closeElement();
        }
        ISynchronizationPoint<IOException> write = this.writer.flush();
        if (!write.isUnblocked()) {
            SynchronizationPoint<IOException> sp = new SynchronizationPoint<IOException>();
            write.listenInline(() -> this.output.flush().listenInline(sp), sp);
            return sp;
        }
        if (write.hasError()) {
            return write;
        }
        return this.output.flush();
    }

    public ISynchronizationPoint<IOException> addAttribute(CharSequence name, CharSequence value) {
        Context ctx = this.context.peekFirst();
        if (ctx == null) {
            return new SynchronizationPoint<IOException>(new IOException("XML document closed"));
        }
        if (!ctx.open) {
            return new SynchronizationPoint<IOException>(new IOException("Cannot add attribute to XML element when the opening tag is closed"));
        }
        this.writer.write(' ');
        this.writer.write(name);
        this.writer.write(ATTRIBUTE_EQUALS);
        this.writer.write(XMLWriter.escape(value));
        return this.writer.write('\"');
    }

    public ISynchronizationPoint<IOException> endOfAttributes() {
        Context ctx = this.context.peekFirst();
        if (ctx == null) {
            return new SynchronizationPoint<IOException>(new IOException("XML document closed"));
        }
        if (!ctx.open) {
            return new SynchronizationPoint<IOException>(new IOException("Opening tag already closed"));
        }
        ctx.open = false;
        return this.writer.write('>');
    }

    public ISynchronizationPoint<IOException> openElement(String namespaceURI, String localName, Map<String, String> namespaces) {
        Context ctx = this.context.peekFirst();
        if (ctx == null) {
            return new SynchronizationPoint<IOException>(new IOException("XML document closed"));
        }
        if (ctx.open) {
            ctx.open = false;
            this.writer.write('>');
        }
        ctx = new Context();
        ctx.namespaces = namespaces != null && !namespaces.isEmpty() ? new HashMap<String, String>(namespaces) : null;
        ctx.namespaceURI = namespaceURI;
        ctx.localName = localName;
        ctx.open = true;
        this.context.addFirst(ctx);
        String ns = this.getNamespace(namespaceURI);
        this.writer.write('<');
        if (ns != null && ns.length() > 0) {
            this.writer.write(ns);
            this.writer.write(':');
        }
        if (namespaces == null || namespaces.isEmpty()) {
            return this.writer.write(localName);
        }
        this.writer.write(localName);
        Iterator<Map.Entry<String, String>> it = namespaces.entrySet().iterator();
        while (true) {
            Map.Entry<String, String> e = it.next();
            String name = "xmlns";
            if (!e.getValue().isEmpty()) {
                name = name + ':' + e.getValue();
            }
            if (!it.hasNext()) {
                return this.addAttribute(name, e.getKey());
            }
            this.addAttribute(name, e.getKey());
        }
    }

    public ISynchronizationPoint<IOException> closeElement() {
        Context ctx = this.context.peekFirst();
        if (ctx == null) {
            return new SynchronizationPoint<IOException>(new IOException("XML document closed"));
        }
        if (ctx.open) {
            this.context.removeFirst();
            return this.writer.write(CLOSE_EMPTY_TAG);
        }
        String ns = this.getNamespace(ctx.namespaceURI);
        this.context.removeFirst();
        this.writer.write(START_CLOSE);
        if (ns != null && ns.length() > 0) {
            this.writer.write(ns);
            this.writer.write(':');
        }
        this.writer.write(ctx.localName);
        return this.writer.write('>');
    }

    public ISynchronizationPoint<IOException> addText(CharSequence text) {
        Context ctx = this.context.peekFirst();
        if (ctx == null) {
            return new SynchronizationPoint<IOException>(new IOException("XML document closed"));
        }
        if (ctx.open) {
            ctx.open = false;
            this.writer.write('>');
        }
        return this.writer.write(XMLWriter.escape(text));
    }

    public ISynchronizationPoint<IOException> addCData(CharSequence data) {
        Context ctx = this.context.peekFirst();
        if (ctx == null) {
            return new SynchronizationPoint<IOException>(new IOException("XML document closed"));
        }
        if (ctx.open) {
            ctx.open = false;
            this.writer.write('>');
        }
        this.writer.write(START_CDATA);
        this.writer.write(data);
        return this.writer.write(END_CDATA);
    }

    public ISynchronizationPoint<IOException> addComment(CharSequence comment) {
        Context ctx = this.context.peekFirst();
        if (ctx != null && ctx.open) {
            ctx.open = false;
            this.writer.write('>');
        }
        this.writer.write(START_COMMENT);
        this.writer.write(comment);
        return this.writer.write(END_COMMENT);
    }

    public ISynchronizationPoint<IOException> write(Element element) {
        NodeList children;
        String name = element.getLocalName();
        if (name == null) {
            name = element.getNodeName();
        }
        String uri = element.getNamespaceURI();
        String prefix = element.getPrefix();
        HashMap<String, String> namespaces = null;
        if (uri != null) {
            namespaces = new HashMap<String, String>(5);
            namespaces.put(uri, prefix);
        }
        this.openElement(uri, name, namespaces);
        NamedNodeMap attrs = element.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node a = attrs.item(i);
                this.addAttribute(a.getNodeName(), a.getNodeValue());
            }
        }
        if ((children = element.getChildNodes()).getLength() == 0) {
            return this.closeElement();
        }
        ISynchronizationPoint<IOException> open = this.endOfAttributes();
        if (open.isUnblocked()) {
            if (open.hasError()) {
                return open;
            }
            return this.writeChild(children, 0);
        }
        SynchronizationPoint<IOException> sp = new SynchronizationPoint<IOException>();
        open.listenAsync(new Task.Cpu.FromRunnable("Write DOM", this.output.getPriority(), () -> this.writeChild(children, 0).listenInline(sp)), sp);
        return sp;
    }

    private ISynchronizationPoint<IOException> writeChild(NodeList children, int childIndex) {
        Node child;
        ISynchronizationPoint<Object> sp;
        while ((sp = (child = children.item(childIndex)) instanceof Element ? this.write((Element)child) : (child instanceof Comment ? this.addComment(((Comment)child).getData()) : (child instanceof CDATASection ? this.addCData(((CDATASection)child).getData()) : (child instanceof Text ? this.addText(((Text)child).getData()) : new SynchronizationPoint<boolean>(true))))).isUnblocked()) {
            if (sp.hasError()) {
                return sp;
            }
            if (++childIndex != children.getLength()) continue;
            return sp;
        }
        SynchronizationPoint<IOException> result = new SynchronizationPoint<IOException>();
        int nextIndex = childIndex + 1;
        sp.listenAsync(new Task.Cpu.FromRunnable("Write DOM", this.output.getPriority(), () -> {
            if (nextIndex == children.getLength()) {
                result.unblock();
                return;
            }
            this.writeChild(children, nextIndex).listenInline(result);
        }), result);
        return result;
    }

    private static final class Context {
        private String namespaceURI = null;
        private String localName;
        private Map<String, String> namespaces = null;
        private boolean open = true;

        private Context() {
        }
    }
}

