/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.dom;

import net.lecousin.framework.xml.dom.XMLDocument;
import net.lecousin.framework.xml.dom.XMLNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public abstract class XMLCharacterData
extends XMLNode
implements CharacterData {
    protected String text;

    public XMLCharacterData(XMLDocument doc, String text) {
        super(doc);
        this.text = text;
    }

    @Override
    public String getNodeValue() {
        return this.text;
    }

    @Override
    public void setNodeValue(String nodeValue) {
        this.text = nodeValue;
    }

    @Override
    public String getData() {
        return this.text;
    }

    @Override
    public void setData(String data) {
        this.text = data;
    }

    @Override
    public int getLength() {
        return this.text.length();
    }

    @Override
    public String substringData(int offset, int count) {
        return this.text.substring(offset, offset + count - 1);
    }

    @Override
    public void appendData(String arg) {
        this.text = this.text + arg;
    }

    @Override
    public void insertData(int offset, String arg) throws DOMException {
        StringBuilder s = new StringBuilder(this.text.length() + arg.length());
        s.append(this.text.substring(0, offset));
        s.append(arg);
        s.append(this.text.substring(offset));
        this.text = s.toString();
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        StringBuilder s = new StringBuilder(this.text.length() - count);
        if (offset > 0) {
            s.append(this.text.substring(0, offset));
        }
        if (this.text.length() > offset + count) {
            s.append(this.text.substring(offset + count));
        }
        this.text = s.toString();
    }

    @Override
    public void replaceData(int offset, int count, String arg) {
        this.deleteData(offset, count);
        this.insertData(offset, arg);
    }

    @Override
    public String getTextContent() {
        return this.getNodeValue();
    }

    @Override
    public void setTextContent(String textContent) {
        this.setData(textContent);
    }
}

