/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.dom;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.xml.XMLException;
import net.lecousin.framework.xml.XMLStreamEventsAsync;
import net.lecousin.framework.xml.XMLStreamEventsSync;
import net.lecousin.framework.xml.dom.XMLAttribute;
import net.lecousin.framework.xml.dom.XMLCData;
import net.lecousin.framework.xml.dom.XMLComment;
import net.lecousin.framework.xml.dom.XMLDocumentType;
import net.lecousin.framework.xml.dom.XMLDomImplementation;
import net.lecousin.framework.xml.dom.XMLElement;
import net.lecousin.framework.xml.dom.XMLNode;
import net.lecousin.framework.xml.dom.XMLNodeList;
import net.lecousin.framework.xml.dom.XMLText;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class XMLDocument
extends XMLNode
implements Document {
    protected XMLDocumentType docType = null;
    protected XMLElement root = null;

    public XMLDocument() {
        super(null);
        this.doc = this;
    }

    public void setDocumentType(XMLDocumentType docType) {
        docType.doc = this;
        this.docType = docType;
    }

    public void setDocumentElement(XMLElement root) {
        root.doc = this;
        this.root = root;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild instanceof XMLElement) {
            if (this.root == null) {
                this.root = (XMLElement)newChild;
                return this.root;
            }
            throw new DOMException(3, "Root element already present on document");
        }
        if (newChild instanceof XMLDocumentType) {
            if (this.docType == null) {
                this.docType = (XMLDocumentType)newChild;
                return this.docType;
            }
            throw new DOMException(3, "Document type already present on document");
        }
        throw new DOMException(3, "Cannot append a node " + newChild.getClass().getName() + " on XMLDocument");
    }

    @Override
    public XMLNode getFirstChild() {
        return this.docType != null ? this.docType : this.root;
    }

    @Override
    public XMLNode getLastChild() {
        return this.root != null ? this.root : this.docType;
    }

    @Override
    public boolean hasChildNodes() {
        return this.docType != null || this.root != null;
    }

    @Override
    public NodeList getChildNodes() {
        ArrayList<XMLNode> list = new ArrayList<XMLNode>(2);
        if (this.docType != null) {
            list.add(this.docType);
        }
        if (this.root != null) {
            list.add(this.root);
        }
        return new XMLNodeList(list);
    }

    public static XMLDocument create(XMLStreamEventsSync stream) throws XMLException, IOException {
        XMLDocument doc = new XMLDocument();
        while (true) {
            switch (stream.event.type) {
                case DOCTYPE: {
                    if (doc.docType != null) {
                        throw new XMLException(stream.getPosition(), "Unexpected element ", "DOCTYPE");
                    }
                    doc.docType = new XMLDocumentType(doc, stream.event.text.asString(), stream.event.publicId != null ? stream.event.publicId.asString() : null, stream.event.system != null ? stream.event.system.asString() : null);
                    break;
                }
                case START_ELEMENT: {
                    if (doc.root != null) {
                        throw new XMLException(stream.getPosition(), "Unexpected element ", stream.event.text.asString());
                    }
                    doc.root = XMLElement.create(doc, stream);
                    break;
                }
            }
            try {
                stream.next();
            }
            catch (EOFException e) {
                return doc;
            }
        }
    }

    public static AsyncWork<XMLDocument, Exception> create(XMLStreamEventsAsync stream) {
        XMLDocument doc = new XMLDocument();
        AsyncWork<XMLDocument, Exception> result = new AsyncWork<XMLDocument, Exception>();
        XMLDocument.create(doc, stream, result, new SynchronizationPoint<boolean>(true));
        return result;
    }

    private static void create(final XMLDocument doc, final XMLStreamEventsAsync stream, final AsyncWork<XMLDocument, Exception> result, ISynchronizationPoint<Exception> n) {
        ISynchronizationPoint<Exception> next;
        block4: while (true) {
            next = n != null ? n : stream.next();
            n = null;
            if (!next.isUnblocked()) break;
            if (next.hasError()) {
                if (next.getError() instanceof EOFException) {
                    result.unblockSuccess(doc);
                    return;
                }
                result.error(next.getError());
                return;
            }
            switch (stream.event.type) {
                case DOCTYPE: {
                    if (doc.docType != null) {
                        result.error(new IOException("Unexpected element DOCTYPE"));
                        return;
                    }
                    doc.docType = new XMLDocumentType(doc, stream.event.text.asString(), stream.event.publicId != null ? stream.event.publicId.asString() : null, stream.event.system != null ? stream.event.system.asString() : null);
                    continue block4;
                }
                case START_ELEMENT: {
                    if (doc.root != null) {
                        result.error(new IOException("Unexpected element " + stream.event.text.asString()));
                        return;
                    }
                    final AsyncWork<XMLElement, Exception> root = XMLElement.create(doc, stream);
                    if (root.isUnblocked()) {
                        if (root.hasError()) {
                            result.error(root.getError());
                            return;
                        }
                        doc.root = root.getResult();
                        continue block4;
                    }
                    root.listenAsync(new Task.Cpu<Void, NoException>("Parsing XML root element", stream.getPriority()){

                        @Override
                        public Void run() {
                            doc.root = (XMLElement)root.getResult();
                            XMLDocument.create(doc, stream, result, null);
                            return null;
                        }
                    }, result);
                    return;
                }
            }
        }
        next.listenAsync(new Task.Cpu<Void, NoException>("Parsing XML", stream.getPriority()){

            @Override
            public Void run() {
                XMLDocument.create(doc, stream, result, next);
                return null;
            }
        }, result);
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public XMLDocument cloneNode(boolean deep) {
        return null;
    }

    @Override
    public DocumentType getDoctype() {
        return this.docType;
    }

    @Override
    public XMLDomImplementation getImplementation() {
        return XMLDomImplementation.getInstance();
    }

    @Override
    public XMLElement getDocumentElement() {
        return this.root;
    }

    @Override
    public XMLElement createElement(String tagName) {
        String localName;
        String prefix;
        int i = tagName.indexOf(58);
        if (i < 0) {
            prefix = "";
            localName = tagName;
        } else {
            prefix = tagName.substring(0, i);
            localName = tagName.substring(i + 1);
        }
        return new XMLElement(this, prefix, localName);
    }

    @Override
    public XMLElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName;
        String prefix;
        int i = qualifiedName.indexOf(58);
        if (i < 0) {
            prefix = "";
            localName = qualifiedName;
        } else {
            prefix = qualifiedName.substring(0, i);
            localName = qualifiedName.substring(i + 1);
        }
        XMLElement e = new XMLElement(this, prefix, localName);
        if (namespaceURI != null) {
            e.declareNamespace(namespaceURI, prefix);
        }
        return e;
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        throw new DOMException(9, "Not supported");
    }

    @Override
    public XMLText createTextNode(String data) {
        return new XMLText(this, data);
    }

    @Override
    public XMLComment createComment(String data) {
        return new XMLComment(this, data);
    }

    @Override
    public XMLCData createCDATASection(String data) {
        return new XMLCData(this, data);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    @Override
    public String getTextContent() {
        return null;
    }

    @Override
    public void setTextContent(String textContent) {
    }

    @Override
    public void normalize() {
        if (this.root != null) {
            this.root.normalize();
        }
    }

    @Override
    public XMLAttribute createAttribute(String name) {
        return new XMLAttribute(this, "", name, null);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        throw new DOMException(9, "Not supported");
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new DOMException(9, "Not supported");
    }

    @Override
    public XMLElement getElementById(String elementId) {
        if (this.root == null) {
            return null;
        }
        return this.getElementById(elementId, this.root);
    }

    protected XMLElement getElementById(String id, XMLElement e) {
        for (XMLAttribute a : e.attributes) {
            if (!a.isId || !id.equals(a.getNodeValue())) continue;
            return e;
        }
        for (XMLNode child : e.children) {
            XMLElement el;
            if (!(child instanceof XMLElement) || (el = this.getElementById(id, (XMLElement)child)) == null) continue;
            return el;
        }
        return null;
    }

    @Override
    public String getInputEncoding() {
        return "UTF-8";
    }

    @Override
    public String getXmlEncoding() {
        return "UTF-8";
    }

    @Override
    public boolean getXmlStandalone() {
        return true;
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    @Override
    public String getXmlVersion() {
        return "1.0";
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    @Override
    public boolean getStrictErrorChecking() {
        return false;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    @Override
    public String getDocumentURI() {
        return null;
    }

    @Override
    public void setDocumentURI(String documentURI) {
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public void normalizeDocument() {
        if (this.root != null) {
            this.root.normalize();
        }
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "Not supported");
    }
}

