/*
 * Decompiled with CFR 0.152.
 */
package brennus.asm;

import brennus.ImmutableList;
import brennus.MethodContext;
import brennus.asm.MethodByteCodeContext;
import brennus.model.BinaryExpression;
import brennus.model.CallConstructorExpression;
import brennus.model.CallMethodExpression;
import brennus.model.CastExpression;
import brennus.model.ExistingType;
import brennus.model.Expression;
import brennus.model.ExpressionVisitor;
import brennus.model.Field;
import brennus.model.FieldAccessType;
import brennus.model.GetExpression;
import brennus.model.InstanceOfExpression;
import brennus.model.InstantiationExpression;
import brennus.model.LiteralExpression;
import brennus.model.LocalVariableAccessType;
import brennus.model.Method;
import brennus.model.NewArrayExpression;
import brennus.model.Parameter;
import brennus.model.ParameterAccessType;
import brennus.model.Protection;
import brennus.model.Type;
import brennus.model.UnaryExpression;
import brennus.model.VarAccessType;
import brennus.model.VarAccessTypeVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

class ASMExpressionVisitor
implements Opcodes,
ExpressionVisitor {
    private final MethodContext methodContext;
    private final MethodByteCodeContext methodByteCodeContext;
    private Type lastExpressionType;

    ASMExpressionVisitor(MethodContext methodContext, MethodByteCodeContext methodByteCodeContext) {
        this.methodContext = methodContext;
        this.methodByteCodeContext = methodByteCodeContext;
    }

    public void visit(final GetExpression getExpression) {
        this.methodByteCodeContext.incIndent("get", getExpression.getFieldName());
        VarAccessType varAccessType = this.methodContext.getVarAccessType(getExpression.getFieldName());
        varAccessType.accept(new VarAccessTypeVisitor(){

            public void visit(FieldAccessType fieldAccessType) {
                Field field = fieldAccessType.getField();
                if (field.isStatic()) {
                    ASMExpressionVisitor.this.methodByteCodeContext.addInstruction((AbstractInsnNode)new FieldInsnNode(178, ASMExpressionVisitor.this.methodContext.getType().getClassIdentifier(), getExpression.getFieldName(), field.getSignature()), "get static field", getExpression.getFieldName());
                } else {
                    ASMExpressionVisitor.this.methodByteCodeContext.loadThis("get field", getExpression.getFieldName(), "on this");
                    ASMExpressionVisitor.this.methodByteCodeContext.addInstruction((AbstractInsnNode)new FieldInsnNode(180, ASMExpressionVisitor.this.methodContext.getType().getClassIdentifier(), getExpression.getFieldName(), field.getSignature()), "get field", getExpression.getFieldName());
                }
                ASMExpressionVisitor.this.lastExpressionType = field.getType();
            }

            public void visit(ParameterAccessType parameterAccessType) {
                Parameter param = parameterAccessType.getParam();
                ASMExpressionVisitor.this.methodByteCodeContext.load(param.getType(), ASMExpressionVisitor.this.methodByteCodeContext.getParamByteCodeIndex(param.getIndex()), "get param", getExpression.getFieldName());
                ASMExpressionVisitor.this.lastExpressionType = param.getType();
            }

            public void visit(LocalVariableAccessType localVariableAccessType) {
                ASMExpressionVisitor.this.methodByteCodeContext.load(localVariableAccessType.getType(), ASMExpressionVisitor.this.methodByteCodeContext.getLocalVariableByteCodeIndex(localVariableAccessType.getVarIndex()), "get local variable", getExpression.getFieldName());
                ASMExpressionVisitor.this.lastExpressionType = localVariableAccessType.getType();
            }
        });
        this.methodByteCodeContext.decIndent();
    }

    public void visit(CallMethodExpression callMethodExpression) {
        Method method;
        String methodName = callMethodExpression.getMethodName();
        this.methodByteCodeContext.incIndent("call method", methodName);
        int parameterCount = callMethodExpression.getParameters().size();
        if (callMethodExpression.getCallee() == null) {
            this.methodByteCodeContext.loadThis("calling on this", methodName);
            method = this.methodContext.getType().getMethod(methodName, parameterCount);
            if (method == null) {
                throw new RuntimeException("can't find method " + methodName + " in hierarchy of " + this.methodContext.getType());
            }
        } else {
            callMethodExpression.getCallee().accept((ExpressionVisitor)this);
            method = this.lastExpressionType.getMethod(methodName, parameterCount);
            if (method == null) {
                throw new RuntimeException("can't find method " + methodName + " with " + parameterCount + " parameters in hierarchy of " + this.lastExpressionType);
            }
        }
        if (method.getFlags().isStatic()) {
            throw new UnsupportedOperationException();
        }
        ImmutableList parameters = callMethodExpression.getParameters();
        this.loadParameters(methodName, method, (ImmutableList<Expression>)parameters);
        this.methodByteCodeContext.addInstruction((AbstractInsnNode)new MethodInsnNode(method.isInterfaceMethod() ? 185 : (method.getFlags().getProtection() == Protection.PRIVATE || method.getFlags().isFinal() ? 183 : 182), method.getTypeName(), methodName, method.getSignature()), "call", methodName);
        this.lastExpressionType = method.getReturnType();
        this.methodByteCodeContext.decIndent();
    }

    public void visit(CallConstructorExpression callConstructorExpression) {
        this.methodByteCodeContext.incIndent("call super constructor");
        this.methodByteCodeContext.loadThis(new Object[0]);
        Method constructor = this.methodContext.getType().getSuperConstructor(callConstructorExpression.getParameters().size());
        if (constructor == null) {
            throw new RuntimeException("can't find constructor with " + callConstructorExpression.getParameters().size() + " parameters in " + this.methodContext.getType().getExtending() + " parent of " + this.methodContext.getType());
        }
        this.loadParameters("<init>", constructor, (ImmutableList<Expression>)callConstructorExpression.getParameters());
        this.methodByteCodeContext.addInstruction((AbstractInsnNode)new MethodInsnNode(183, this.methodContext.getType().getExtending().getClassIdentifier(), "<init>", constructor.getSignature()), "super(...)");
        this.methodByteCodeContext.decIndent();
    }

    private void loadParameters(String methodName, Method method, ImmutableList<Expression> parameters) {
        this.methodByteCodeContext.incIndent("pass", parameters.size(), "params to", methodName);
        ImmutableList<Expression> parameterValues = parameters;
        ImmutableList parameterTypes = method.getParameters();
        if (parameterTypes.size() != parameterValues.size()) {
            throw new RuntimeException("parameters passed do not match, parameters declared in " + method);
        }
        for (int i = 0; i < parameterValues.size(); ++i) {
            this.methodByteCodeContext.incIndent("param", i);
            Expression expression = (Expression)parameterValues.get(i);
            Type expected = ((Parameter)parameterTypes.get(i)).getType();
            expression.accept((ExpressionVisitor)this);
            this.methodByteCodeContext.handleConversion(this.lastExpressionType, expected, "param", i, "for", methodName);
            this.methodByteCodeContext.decIndent();
        }
        this.methodByteCodeContext.decIndent();
    }

    public void visit(LiteralExpression literalExpression) {
        this.lastExpressionType = literalExpression.getType();
        if (literalExpression.getType().getExisting().equals(Integer.TYPE)) {
            int intValue = (Integer)literalExpression.getValue();
            if (intValue >= -128 && intValue <= 127) {
                this.methodByteCodeContext.push(16, intValue, "int literal", literalExpression.getValue());
            } else {
                this.methodByteCodeContext.ldc((Integer)literalExpression.getValue(), "int literal", literalExpression.getValue());
            }
        } else if (literalExpression.getType().getExisting().equals(Long.TYPE)) {
            this.methodByteCodeContext.ldc((Long)literalExpression.getValue(), "long literal", literalExpression.getValue());
        } else if (literalExpression.getType().getExisting().equals(Float.TYPE)) {
            this.methodByteCodeContext.ldc((Float)literalExpression.getValue(), "float literal", literalExpression.getValue());
        } else if (literalExpression.getType().getExisting().equals(Double.TYPE)) {
            this.methodByteCodeContext.ldc((Double)literalExpression.getValue(), "double literal", literalExpression.getValue());
        } else if (literalExpression.getType().getExisting().equals(String.class)) {
            this.methodByteCodeContext.ldc((String)literalExpression.getValue(), "String literal", literalExpression.getValue());
        } else if (literalExpression.getType().getExisting().equals(Boolean.TYPE)) {
            boolean b = (Boolean)literalExpression.getValue();
            this.methodByteCodeContext.addBool(b, "bool literal");
        } else {
            throw new UnsupportedOperationException(literalExpression.toString());
        }
    }

    public void visit(BinaryExpression binaryExpression) {
        this.methodByteCodeContext.incIndent(binaryExpression.getOperator().getRepresentation());
        switch (binaryExpression.getOperator()) {
            case PLUS: {
                this.methodByteCodeContext.incIndent("left +");
                binaryExpression.getLeftExpression().accept((ExpressionVisitor)this);
                this.methodByteCodeContext.decIndent();
                this.methodByteCodeContext.incIndent("+ right");
                binaryExpression.getRightExpression().accept((ExpressionVisitor)this);
                this.methodByteCodeContext.decIndent();
                this.lastExpressionType = ExistingType.INT;
                this.methodByteCodeContext.addInstruction((AbstractInsnNode)new InsnNode(96), "+");
                break;
            }
            case AND: {
                this.methodByteCodeContext.incIndent("left &&");
                binaryExpression.getLeftExpression().accept((ExpressionVisitor)this);
                this.methodByteCodeContext.decIndent();
                new LiteralExpression(false).accept((ExpressionVisitor)this);
                LabelNode falseLabel = new LabelNode();
                LabelNode endLabel = new LabelNode();
                this.methodByteCodeContext.addInstruction((AbstractInsnNode)new JumpInsnNode(159, falseLabel), "AND: IF left is false => false");
                this.methodByteCodeContext.incIndent("&& right");
                binaryExpression.getRightExpression().accept((ExpressionVisitor)this);
                this.methodByteCodeContext.decIndent();
                new LiteralExpression(false).accept((ExpressionVisitor)this);
                this.methodByteCodeContext.addInstruction((AbstractInsnNode)new JumpInsnNode(159, falseLabel), "AND: IF right is false => false");
                new LiteralExpression(true).accept((ExpressionVisitor)this);
                this.methodByteCodeContext.addInstruction((AbstractInsnNode)new JumpInsnNode(167, endLabel), "AND: all true => skip false");
                this.methodByteCodeContext.addLabel(falseLabel, "AND: false");
                new LiteralExpression(false).accept((ExpressionVisitor)this);
                this.methodByteCodeContext.addLabel(endLabel, "AND: end");
                this.lastExpressionType = ExistingType.BOOLEAN;
                break;
            }
            case GETARRAYATINDEX: {
                this.methodByteCodeContext.incIndent("array");
                binaryExpression.getLeftExpression().accept((ExpressionVisitor)this);
                Type arrayType = this.lastExpressionType;
                this.methodByteCodeContext.decIndent();
                this.methodByteCodeContext.incIndent("[");
                binaryExpression.getRightExpression().accept((ExpressionVisitor)this);
                this.methodByteCodeContext.decIndent();
                this.lastExpressionType = arrayType.unNestArray();
                this.methodByteCodeContext.aload(this.lastExpressionType, "[]");
                break;
            }
            default: {
                throw new UnsupportedOperationException("op: " + binaryExpression.getOperator());
            }
        }
        this.methodByteCodeContext.decIndent();
    }

    public Type getExpressionType() {
        return this.lastExpressionType;
    }

    public void visit(UnaryExpression unaryExpression) {
        this.methodByteCodeContext.incIndent(unaryExpression.getOperator().getRepresentation());
        this.methodByteCodeContext.incIndent("unary exp");
        unaryExpression.getExpression().accept((ExpressionVisitor)this);
        this.methodByteCodeContext.decIndent();
        switch (unaryExpression.getOperator()) {
            case NOT: {
                ((MethodByteCodeContext.Then)((MethodByteCodeContext.Else)this.methodByteCodeContext.ifCondElse(153, "NOT: IF true => false").addBool(false, "NOT true: result false")).thenCase().addBool(true, "NOT false: result true")).endIf();
                this.lastExpressionType = ExistingType.BOOLEAN;
                break;
            }
            case ISNULL: {
                ((MethodByteCodeContext.Then)((MethodByteCodeContext.Else)this.methodByteCodeContext.ifCondElse(199, "ISNULL: IF NULL => true").addBool(true, "NOT NULL: result true")).thenCase().addBool(false, "NULL: result false")).endIf();
                this.lastExpressionType = ExistingType.BOOLEAN;
                break;
            }
            case ISNOTNULL: {
                ((MethodByteCodeContext.Then)((MethodByteCodeContext.Else)this.methodByteCodeContext.ifCondElse(198, "ISNONNULL: IF NON NULL => true").addBool(true, "NULL: result true")).thenCase().addBool(false, "NOT NULL: result false")).endIf();
                this.lastExpressionType = ExistingType.BOOLEAN;
                break;
            }
            case ARRAYSIZE: {
                this.methodByteCodeContext.addInstruction((AbstractInsnNode)new InsnNode(190), ".length");
                this.lastExpressionType = ExistingType.INT;
                break;
            }
            default: {
                throw new UnsupportedOperationException("op: " + unaryExpression.getOperator());
            }
        }
        this.methodByteCodeContext.decIndent();
    }

    public void visit(InstanceOfExpression instanceOfExpression) {
        this.methodByteCodeContext.incIndent("instanceOF");
        instanceOfExpression.getExpression().accept((ExpressionVisitor)this);
        this.methodByteCodeContext.addInstruction((AbstractInsnNode)new TypeInsnNode(193, instanceOfExpression.getType().getClassIdentifier()), new Object[0]);
        this.lastExpressionType = ExistingType.BOOLEAN;
        this.methodByteCodeContext.decIndent();
    }

    public void visit(CastExpression castExpression) {
        this.methodByteCodeContext.incIndent("cast (", castExpression.getType(), ")");
        castExpression.getExpression().accept((ExpressionVisitor)this);
        this.methodByteCodeContext.cast(castExpression.getType(), "cast to", castExpression.getType());
        this.lastExpressionType = castExpression.getType();
        this.methodByteCodeContext.decIndent();
    }

    public void visit(InstantiationExpression instantiationExpression) {
        Type type = instantiationExpression.getType();
        this.methodByteCodeContext.incIndent("new ", type.getName(), "()");
        this.methodByteCodeContext.addInstruction((AbstractInsnNode)new TypeInsnNode(187, type.getClassIdentifier()), "new ", type.getName(), "()");
        this.methodByteCodeContext.dup("for constructor call");
        Method constructor = type.getConstructor(instantiationExpression.getParameters().size());
        if (constructor == null) {
            throw new RuntimeException("can't find constructor with " + instantiationExpression.getParameters().size() + " parameters in " + type);
        }
        this.loadParameters("<init>", constructor, (ImmutableList<Expression>)instantiationExpression.getParameters());
        this.methodByteCodeContext.addInstruction((AbstractInsnNode)new MethodInsnNode(183, type.getClassIdentifier(), "<init>", constructor.getSignature()), "new ", type.getName(), "(...)");
        this.lastExpressionType = type;
        this.methodByteCodeContext.decIndent();
    }

    public void visit(NewArrayExpression e) {
        this.methodByteCodeContext.incIndent("new ", e.getType(), "[]");
        e.getSize().accept((ExpressionVisitor)this);
        this.methodByteCodeContext.newArray(e.getType(), "new ", e.getType(), "[]");
        this.lastExpressionType = e.getType().nestArray();
        this.methodByteCodeContext.decIndent();
    }
}

