/*
 * Decompiled with CFR 0.152.
 */
package brennus.asm;

import brennus.ImmutableList;
import brennus.LocalVarContext;
import brennus.MethodContext;
import brennus.asm.ASMExpressionVisitor;
import brennus.asm.MethodByteCodeContext;
import brennus.model.BinaryExpression;
import brennus.model.CallConstructorExpression;
import brennus.model.CallConstructorStatement;
import brennus.model.CallMethodExpression;
import brennus.model.CaseBlockStatement;
import brennus.model.CaseStatement;
import brennus.model.CaseStatementVisitor;
import brennus.model.CastExpression;
import brennus.model.DefineVarStatement;
import brennus.model.ExistingType;
import brennus.model.Expression;
import brennus.model.ExpressionStatement;
import brennus.model.ExpressionVisitor;
import brennus.model.Field;
import brennus.model.FieldAccessType;
import brennus.model.GetExpression;
import brennus.model.GotoCaseStatement;
import brennus.model.GotoStatement;
import brennus.model.IfStatement;
import brennus.model.InstanceOfExpression;
import brennus.model.InstantiationExpression;
import brennus.model.LabelStatement;
import brennus.model.LiteralExpression;
import brennus.model.LocalVariableAccessType;
import brennus.model.NewArrayExpression;
import brennus.model.Parameter;
import brennus.model.ParameterAccessType;
import brennus.model.ReturnStatement;
import brennus.model.SetStatement;
import brennus.model.Statement;
import brennus.model.StatementVisitor;
import brennus.model.SwitchStatement;
import brennus.model.ThrowStatement;
import brennus.model.Type;
import brennus.model.UnaryExpression;
import brennus.model.VarAccessTypeVisitor;
import java.util.Arrays;
import java.util.HashMap;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

class ASMMethodGenerator
implements Opcodes,
StatementVisitor {
    private final MethodContext methodContext;
    private final MethodByteCodeContext methodByteCodeContext;
    private LabelNode currentLabel;
    private LabelNode endLabel;

    public ASMMethodGenerator(MethodContext methodContext) {
        this.methodContext = methodContext;
        this.methodByteCodeContext = new MethodByteCodeContext(methodContext);
    }

    private Type visit(Expression expression) {
        this.methodByteCodeContext.incIndent(new Object[0]);
        ASMExpressionVisitor expressionVisitor = new ASMExpressionVisitor(this.methodContext, this.methodByteCodeContext);
        expression.accept((ExpressionVisitor)expressionVisitor);
        this.methodByteCodeContext.decIndent();
        return expressionVisitor.getExpressionType();
    }

    public void visit(ReturnStatement returnStatement) {
        this.methodByteCodeContext.incIndent("return exp");
        Type expressionType = this.visit(returnStatement.getExpression());
        this.methodByteCodeContext.decIndent();
        Type returnType = this.methodContext.getReturnType();
        this.methodByteCodeContext.handleConversion(expressionType, returnType, new Object[0]);
        this.methodByteCodeContext.addReturn(returnType, new Object[0]);
    }

    public void visit(ExpressionStatement methodCallStatement) {
        this.visit(methodCallStatement.getExpression());
    }

    public void visit(SwitchStatement switchStatement) {
        int i;
        this.methodByteCodeContext.incIndent("switch exp");
        Type expressionType = this.visit(switchStatement.getExpression());
        this.methodByteCodeContext.handleConversion(expressionType, (Type)ExistingType.INT, "switch(exp): convert exp to int");
        this.methodByteCodeContext.decIndent();
        ImmutableList caseStatements = switchStatement.getCaseStatements();
        int minCase = Integer.MAX_VALUE;
        int maxCase = Integer.MIN_VALUE;
        HashMap<Integer, CaseStatement> cases = new HashMap<Integer, CaseStatement>();
        int[] values = new int[caseStatements.size()];
        final LabelNode[] labels = new LabelNode[caseStatements.size()];
        for (i = 0; i < caseStatements.size(); ++i) {
            int caseValue;
            CaseStatement caseStatement = (CaseStatement)caseStatements.get(i);
            values[i] = caseValue = ((Integer)((LiteralExpression)caseStatement.getExpression()).getValue()).intValue();
            minCase = Math.min(minCase, caseValue);
            maxCase = Math.max(caseValue, maxCase);
            cases.put(caseValue, caseStatement);
        }
        Arrays.sort(values);
        for (i = 0; i < values.length; ++i) {
            final int index = i;
            ((CaseStatement)cases.get(values[i])).accept(new CaseStatementVisitor(){

                public void visit(GotoCaseStatement gotoCaseStatement) {
                    labels[index] = ASMMethodGenerator.this.methodByteCodeContext.getLabelForSwitchGotoCase(gotoCaseStatement.getLabel());
                }

                public void visit(CaseBlockStatement caseBlockStatement) {
                    labels[index] = new LabelNode();
                }
            });
        }
        LabelNode defaultLabel = new LabelNode();
        this.endLabel = new LabelNode();
        if (maxCase - minCase == values.length - 1) {
            this.methodByteCodeContext.addInstruction((AbstractInsnNode)new TableSwitchInsnNode(minCase, maxCase, defaultLabel, labels), "switch(", switchStatement.getExpression(), ")");
        } else {
            this.methodByteCodeContext.addInstruction((AbstractInsnNode)new LookupSwitchInsnNode(defaultLabel, values, labels), "switch(", switchStatement.getExpression(), ")");
        }
        this.methodByteCodeContext.incIndent("switch");
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.currentLabel = labels[i2];
            ((CaseStatement)cases.get(values[i2])).accept((StatementVisitor)this);
            this.currentLabel = null;
        }
        if (switchStatement.getDefaultCaseStatement() != null) {
            this.currentLabel = defaultLabel;
            switchStatement.getDefaultCaseStatement().accept((StatementVisitor)this);
            this.currentLabel = null;
        } else {
            this.methodByteCodeContext.addInstruction((AbstractInsnNode)defaultLabel, new Object[0]);
        }
        this.methodByteCodeContext.decIndent();
        this.methodByteCodeContext.addInstruction((AbstractInsnNode)this.endLabel, "switch end");
        this.endLabel = null;
    }

    public void visit(CaseBlockStatement caseStatement) {
        String value = caseStatement.getExpression() == null ? "default" : caseStatement.getliteralExpression().getValue();
        this.methodByteCodeContext.addLabel(caseStatement.getLine(), this.currentLabel, "case", value);
        this.methodByteCodeContext.incIndent("case", value);
        for (Statement statement : caseStatement.getStatements()) {
            this.visit(statement);
        }
        if (caseStatement.isBreakCase()) {
            this.methodByteCodeContext.addInstruction((AbstractInsnNode)new JumpInsnNode(167, this.endLabel), "break case");
        }
        this.methodByteCodeContext.decIndent();
    }

    public void visit(GotoCaseStatement gotoCaseStatement) {
    }

    public void visit(ThrowStatement throwStatement) {
        this.methodByteCodeContext.incIndent("throw exp");
        Type expressionType = this.visit(throwStatement.getExpression());
        this.methodByteCodeContext.decIndent();
        this.methodByteCodeContext.addInstruction((AbstractInsnNode)new InsnNode(191), new Object[0]);
    }

    public void visit(final SetStatement setStatement) {
        this.methodContext.getVarAccessType(setStatement.getTo()).accept(new VarAccessTypeVisitor(){

            private Type evalExp() {
                ASMMethodGenerator.this.methodByteCodeContext.incIndent("set exp", setStatement.getTo());
                Type expressionType = ASMMethodGenerator.this.visit(setStatement.getExpression());
                ASMMethodGenerator.this.methodByteCodeContext.decIndent();
                return expressionType;
            }

            public void visit(ParameterAccessType parameterAccessType) {
                Type expressionType = this.evalExp();
                Parameter param = parameterAccessType.getParam();
                ASMMethodGenerator.this.methodByteCodeContext.store(param.getType(), ASMMethodGenerator.this.methodByteCodeContext.getParamByteCodeIndex(param.getIndex()), "set param", setStatement.getTo());
            }

            public void visit(FieldAccessType fieldAccessType) {
                Field field = fieldAccessType.getField();
                if (field.isStatic()) {
                    Type expressionType = this.evalExp();
                    ASMMethodGenerator.this.methodByteCodeContext.handleConversion(expressionType, field.getType(), new Object[0]);
                    ASMMethodGenerator.this.methodByteCodeContext.addInstruction((AbstractInsnNode)new FieldInsnNode(179, ASMMethodGenerator.this.methodContext.getClassIdentifier(), field.getName(), field.getSignature()), "set static", setStatement.getTo());
                } else {
                    ASMMethodGenerator.this.methodByteCodeContext.loadThis("set", setStatement.getTo());
                    Type expressionType = this.evalExp();
                    ASMMethodGenerator.this.methodByteCodeContext.handleConversion(expressionType, field.getType(), new Object[0]);
                    ASMMethodGenerator.this.methodByteCodeContext.addInstruction((AbstractInsnNode)new FieldInsnNode(181, ASMMethodGenerator.this.methodContext.getClassIdentifier(), field.getName(), field.getSignature()), "set", setStatement.getTo());
                }
            }

            public void visit(LocalVariableAccessType localVariableAccessType) {
                Type expressionType = this.evalExp();
                ASMMethodGenerator.this.methodByteCodeContext.store(expressionType, ASMMethodGenerator.this.methodByteCodeContext.getLocalVariableByteCodeIndex(localVariableAccessType.getVarIndex()), "set local var", setStatement.getTo());
            }
        });
    }

    public MethodNode getMethodNode() {
        return this.methodByteCodeContext.getMethodNode();
    }

    public void visit(Statement statement) {
        this.methodByteCodeContext.addLineNumber(statement.getLine(), new Object[0]);
        this.methodByteCodeContext.incIndent(statement.getClass().getSimpleName());
        statement.accept((StatementVisitor)this);
        this.methodByteCodeContext.decIndent();
    }

    public void visit(final IfStatement ifStatement) {
        this.methodByteCodeContext.incIndent("if");
        ifStatement.getExpression().accept(new ExpressionVisitor(){

            public void visit(BinaryExpression binaryExpression) {
                ASMMethodGenerator.this.methodByteCodeContext.incIndent("if left");
                ASMMethodGenerator.this.visit(binaryExpression.getLeftExpression());
                ASMMethodGenerator.this.methodByteCodeContext.decIndent();
                ASMMethodGenerator.this.methodByteCodeContext.incIndent("if right");
                ASMMethodGenerator.this.visit(binaryExpression.getRightExpression());
                ASMMethodGenerator.this.methodByteCodeContext.decIndent();
                ASMMethodGenerator.this.methodByteCodeContext.incIndent(binaryExpression.getOperator().getRepresentation());
                switch (binaryExpression.getOperator()) {
                    case EQUALS: {
                        ASMMethodGenerator.this.generateThenElse(160, (ImmutableList<Statement>)ifStatement.getElseStatements(), (ImmutableList<Statement>)ifStatement.getThenStatements());
                        break;
                    }
                    case GREATER_THAN: {
                        ASMMethodGenerator.this.generateThenElse(163, (ImmutableList<Statement>)ifStatement.getThenStatements(), (ImmutableList<Statement>)ifStatement.getElseStatements());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("op: " + binaryExpression.getOperator());
                    }
                }
                ASMMethodGenerator.this.methodByteCodeContext.decIndent();
            }

            public void visit(LiteralExpression literalExpression) {
                throw new UnsupportedOperationException();
            }

            public void visit(CallMethodExpression callMethodExpression) {
                ASMMethodGenerator.this.methodByteCodeContext.incIndent("if call", callMethodExpression.getMethodName());
                ASMMethodGenerator.this.visit((Expression)callMethodExpression);
                ASMMethodGenerator.this.generateThenElse(153, (ImmutableList<Statement>)ifStatement.getElseStatements(), (ImmutableList<Statement>)ifStatement.getThenStatements());
                ASMMethodGenerator.this.methodByteCodeContext.decIndent();
            }

            public void visit(GetExpression getFieldExpression) {
                ASMMethodGenerator.this.methodByteCodeContext.incIndent("if get", getFieldExpression.getFieldName());
                ASMMethodGenerator.this.visit((Expression)getFieldExpression);
                ASMMethodGenerator.this.generateThenElse(153, (ImmutableList<Statement>)ifStatement.getElseStatements(), (ImmutableList<Statement>)ifStatement.getThenStatements());
                ASMMethodGenerator.this.methodByteCodeContext.decIndent();
            }

            public void visit(UnaryExpression unaryExpression) {
                throw new UnsupportedOperationException();
            }

            public void visit(InstanceOfExpression instanceOfExpression) {
                ASMMethodGenerator.this.methodByteCodeContext.incIndent("if instanceof", instanceOfExpression.getType());
                ASMMethodGenerator.this.visit(instanceOfExpression.getExpression());
                ASMMethodGenerator.this.methodByteCodeContext.addInstruction((AbstractInsnNode)new TypeInsnNode(193, instanceOfExpression.getType().getClassIdentifier()), "if");
                ASMMethodGenerator.this.generateThenElse(153, (ImmutableList<Statement>)ifStatement.getElseStatements(), (ImmutableList<Statement>)ifStatement.getThenStatements());
                ASMMethodGenerator.this.methodByteCodeContext.decIndent();
            }

            public void visit(CastExpression castExpression) {
                throw new UnsupportedOperationException();
            }

            public void visit(CallConstructorExpression callConstructorExpression) {
                throw new UnsupportedOperationException();
            }

            public void visit(InstantiationExpression instantiationExpression) {
                throw new UnsupportedOperationException("NYI");
            }

            public void visit(NewArrayExpression e) {
                throw new UnsupportedOperationException("NYI");
            }
        });
        this.methodByteCodeContext.decIndent();
    }

    private void generateThenElse(int jumpInst, ImmutableList<Statement> thenStatements, ImmutableList<Statement> elseStatements) {
        LabelNode thenNode = new LabelNode();
        LabelNode endNode = new LabelNode();
        this.methodByteCodeContext.addInstruction((AbstractInsnNode)new JumpInsnNode(jumpInst, thenNode), "IF exp GOTO label else keep going");
        this.methodByteCodeContext.incIndent(new Object[0]);
        for (Statement statement : elseStatements) {
            this.visit(statement);
        }
        this.methodByteCodeContext.decIndent();
        this.methodByteCodeContext.addInstruction((AbstractInsnNode)new JumpInsnNode(167, endNode), "endElse now Then");
        this.methodByteCodeContext.addLabel(thenNode, "then");
        this.methodByteCodeContext.incIndent(new Object[0]);
        for (Statement statement : thenStatements) {
            this.visit(statement);
        }
        this.methodByteCodeContext.decIndent();
        this.methodByteCodeContext.addLabel(endNode, "endThen");
    }

    public void visit(LabelStatement labelStatement) {
        this.methodByteCodeContext.addNamedLabel(labelStatement.getLine(), labelStatement.getName());
    }

    public void visit(GotoStatement gotoStatement) {
        this.methodByteCodeContext.gotoLabel(gotoStatement.getName());
    }

    public void visit(CallConstructorStatement callConstructorStatement) {
        this.visit(callConstructorStatement.getExpression());
    }

    public void visit(DefineVarStatement defineVarStatement) {
        LocalVarContext context = this.methodContext.defineLocalVar(defineVarStatement.getType(), defineVarStatement.getVarName());
        this.methodByteCodeContext.defineLocalVar(context.getType(), context.getName(), context.getIndex());
    }
}

